/*=============================================================================
	CAReferenceCounted.h
	
	$Log: CAReferenceCounted.h,v $
	Revision 1.6  2004/08/23 19:22:44  bills
	fix warning
	
	Revision 1.5  2004/02/18 02:43:44  bills
	fix release semantics
	
	Revision 1.4  2003/12/19 00:12:02  dwyatt
	IncrementAtomic / DecrementAtomic are more portable than AddAtomic
	
	Revision 1.3  2003/12/16 22:57:08  dwyatt
	Windows compile
	
	Revision 1.2  2003/12/01 23:40:55  bills
	make ref counting thread safe [3495104]
	
	Revision 1.1  2003/07/07 19:37:38  dwyatt
	initial checin
	
	created Mon Jul 07 2003, Doug Wyatt
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CAReferenceCounted_h__
#define __CAReferenceCounted_h__

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreServices/CoreServices.h>
#else
	#include <CoreServices.h>
#endif

#if TARGET_OS_WIN32
	#include "CAWindows.h"
#endif

// base class for reference-counted objects
class CAReferenceCounted {
public:
	CAReferenceCounted() : mRefCount(1) {}
	
	void	retain() { IncrementAtomic(&mRefCount); }
	
	void	release() 
			{ 
					// this returns the ORIGINAL value, not the new one.
				SInt32 rc = DecrementAtomic(&mRefCount);
				if (rc == 1) {
					delete this;
				}
			}

protected:
    virtual	~CAReferenceCounted() { }
	
private:
	SInt32		mRefCount;

	CAReferenceCounted(const CAReferenceCounted &a) : mRefCount(0) { }
	CAReferenceCounted operator=(const CAReferenceCounted &a) { return *this; }
};


#endif // __CAReferenceCounted_h__
