/*==================================================================================================
	CAStreamRangedDescription.cpp

	$Log: CAStreamRangedDescription.cpp,v $
	Revision 1.3  2004/08/26 19:55:59  jcm10
	add PrintToLog
	
	Revision 1.2  2004/06/07 18:55:43  jcm10
	provide an implementation
	
	Revision 1.1  2004/05/27 21:50:01  jcm10
	first checked in
	
	Revision 0.0  Mon May 24 2004 18:21:31 US/Pacific  moorf
	Created
		
	$NoKeywords: $
==================================================================================================*/

//==================================================================================================
//	Includes
//==================================================================================================

//	Self Include
#include "CAStreamRangedDescription.h"

//==================================================================================================
//	CAStreamRangedDescription
//==================================================================================================

const AudioStreamRangedDescription	CAStreamRangedDescription::sEmpty = { { 0.0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 0.0, 0.0 } };

#if CoreAudio_Debug
#include "CALogMacros.h"

void	CAStreamRangedDescription::PrintToLog(const AudioStreamRangedDescription& inDesc)
{
	PrintFloat		("  Sample Rate:        ", inDesc.mFormat.mSampleRate);
	PrintFloat		("  Max Sample Rate:    ", inDesc.mSampleRateRange.mMaximum);
	PrintFloat		("  Min Sample Rate:    ", inDesc.mSampleRateRange.mMinimum);
	Print4CharCode	("  Format ID:          ", inDesc.mFormat.mFormatID);
	PrintHex		("  Format Flags:       ", inDesc.mFormat.mFormatFlags);
	PrintInt		("  Bytes per Packet:   ", inDesc.mFormat.mBytesPerPacket);
	PrintInt		("  Frames per Packet:  ", inDesc.mFormat.mFramesPerPacket);
	PrintInt		("  Bytes per Frame:    ", inDesc.mFormat.mBytesPerFrame);
	PrintInt		("  Channels per Frame: ", inDesc.mFormat.mChannelsPerFrame);
	PrintInt		("  Bits per Channel:   ", inDesc.mFormat.mBitsPerChannel);
}
#endif
