/*==================================================================================================
	CAStreamRangedDescription.h

	$Log: CAStreamRangedDescription.h,v $
	Revision 1.5  2004/11/12 20:37:55  jcm10
	improve the IsMixable() test
	
	Revision 1.4  2004/10/08 16:43:10  jcm10
	add IsMixable()
	
	Revision 1.3  2004/08/26 19:55:59  jcm10
	add PrintToLog
	
	Revision 1.2  2004/06/07 18:55:43  jcm10
	provide an implementation
	
	Revision 1.1  2004/05/27 21:50:01  jcm10
	first checked in
	
	Revision 0.0  Mon May 24 2004 18:21:31 US/Pacific  moorf
	Created
		
	$NoKeywords: $
==================================================================================================*/
#if !defined(__CAStreamRangedDescription_h__)
#define __CAStreamRangedDescription_h__

//==================================================================================================
//	Includes
//==================================================================================================

//  Super Class Includes
#include <CoreAudio/AudioHardware.h>

//  PublicUtility Includes
#include "CAAudioValueRange.h"
#include "CAStreamBasicDescription.h"

//==================================================================================================
//	CAStreamRangedDescription
//==================================================================================================

class CAStreamRangedDescription
:
	public AudioStreamRangedDescription
{

//	Constants
public:
	static const AudioStreamRangedDescription	sEmpty;

//	Construction/Destruction
public:
								CAStreamRangedDescription()																							{ memset(this, 0, sizeof(AudioStreamRangedDescription)); }
								CAStreamRangedDescription(const CAStreamRangedDescription& inFormat)												{ mFormat = inFormat.mFormat; mSampleRateRange = inFormat.mSampleRateRange; }
								CAStreamRangedDescription(const AudioStreamRangedDescription& inFormat)												{ mFormat = inFormat.mFormat; mSampleRateRange = inFormat.mSampleRateRange; }
								CAStreamRangedDescription(const AudioStreamBasicDescription& inFormat)												{ mFormat = inFormat; mSampleRateRange.mMinimum = inFormat.mSampleRate; mSampleRateRange.mMaximum = inFormat.mSampleRate; }
								CAStreamRangedDescription(const AudioStreamBasicDescription& inFormat, const AudioValueRange& inSampleRateRange)	{ mFormat = inFormat; mSampleRateRange = inSampleRateRange; }
	CAStreamRangedDescription&  operator=(const CAStreamRangedDescription& inFormat)																{ mFormat = inFormat.mFormat; mSampleRateRange = inFormat.mSampleRateRange; return *this; }
	CAStreamRangedDescription&  operator=(const AudioStreamRangedDescription& inFormat)																{ mFormat = inFormat.mFormat; mSampleRateRange = inFormat.mSampleRateRange; return *this; }

	static bool					IsMixable(const AudioStreamRangedDescription& inDescription) { return (inDescription.mFormat.mFormatID == kAudioFormatLinearPCM) && ((inDescription.mFormat.mFormatFlags & kIsNonMixableFlag) == 0); }
#if CoreAudio_Debug
	static void					PrintToLog(const AudioStreamRangedDescription& inDesc);
#endif
};

inline bool operator<(const AudioStreamRangedDescription& x, const AudioStreamRangedDescription& y)													{ return (x.mFormat < y.mFormat) && (x.mSampleRateRange < y.mSampleRateRange); }
inline bool operator==(const AudioStreamRangedDescription& x, const AudioStreamRangedDescription& y)												{ return (x.mFormat == y.mFormat) && (x.mSampleRateRange == y.mSampleRateRange); }
#if TARGET_OS_MAC || (TARGET_OS_WIN32 && (_MSC_VER > 600))
inline bool	operator!=(const AudioStreamRangedDescription& x, const AudioStreamRangedDescription& y)												{ return !(x == y); }
inline bool	operator<=(const AudioStreamRangedDescription& x, const AudioStreamRangedDescription& y)												{ return (x < y) || (x == y); }
inline bool	operator>=(const AudioStreamRangedDescription& x, const AudioStreamRangedDescription& y)												{ return !(x < y); }
inline bool	operator>(const AudioStreamRangedDescription& x, const AudioStreamRangedDescription& y)													{ return !((x < y) || (x == y)); }
#endif

#endif
