#ifndef __DebuggingPP_h__
#define __DebuggingPP_h__

// versions of macros in Debugging.h that throw exceptions instead of gotos

#include <CoreServices/CoreServices.h>

#if DEBUGLEVEL == DEBUG_LEVEL_PRODUCTION
	
	#define Require(assertion, exception)	do { if( !(assertion) ) throw exception; } while (false)
	#define RequireNoErr(error)	do { if( (error) != noErr ) throw OSStatus(error); } while (false)
	#define RequireNoErrString(error, message)	do { if( (error) != noErr ) throw OSStatus(error); } while (false)

#else

	#define Require(assertion, exception) \
	do {                                                                \
		if (!(assertion))                                               \
		{                                                               \
			DEBUGASSERTMSG(COMPONENT_SIGNATURE, DEBUG_NO_OPTIONS,       \
						QuoteExceptionString(assertion),                \
						QuoteExceptionString(exception),                \
						NULL, __FILE__, __LINE__, 0);                   \
			throw exception;                                            \
		}                                                               \
	} while (false)
	
	#define RequireNoErr(error)                                         \
	do {                                                                \
		OSStatus localError = error;                                    \
		if (localError != noErr)                                        \
		{                                                               \
			DEBUGASSERTMSG(COMPONENT_SIGNATURE, DEBUG_NO_OPTIONS,       \
						QuoteExceptionString(error) "== noErr",         \
						QuoteExceptionString(exception),                \
						NULL, __FILE__, __LINE__, (void *)localError ); \
			throw localError;                                           \
		}                                                               \
	} while (false)

	#define	RequireNoErrString(error, message)							  \
	do {                                                                \
		OSStatus localError = error;                                    \
		if (localError != noErr)                                        \
		{                                                               \
			DEBUGASSERTMSG(COMPONENT_SIGNATURE, DEBUG_NO_OPTIONS,       \
						QuoteExceptionString(error) "== noErr",         \
						message,                                        \
						NULL, __FILE__, __LINE__, (void *)localError ); \
			throw localError;                                           \
		}                                                               \
	} while (false)
#endif

#endif // __DebuggingPP_h__
