
#ifndef __MatchAudioChannelLayoutTagWithChannels_h__
#define __MatchAudioChannelLayoutTagWithChannels_h__

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

/*
MatchAudioChannelLayoutTagWithChannels determines whether an AudioChannelLayoutTag 
matches the channel descriptions in an AudioChannelLayout.
*/

Boolean MatchAudioChannelLayoutTagWithChannels(
		AudioChannelLayoutTag 	inTag, 
		AudioChannelLayout		*inLayout);

/*
FindTagForMatchAudioChannelLayoutInAnyOrder determines whether there is any AudioChannelLayoutTag that contains the same
channel labels as inLayout. If there is the first one that matches is returned in outTag and the function returns true.
Otherwise the function returns false.
*/

Boolean FindTagForMatchAudioChannelLayoutInAnyOrder(
		AudioChannelLayout		*inLayout, 
		AudioChannelLayoutTag 	&outTag);


#endif