/*=============================================================================
	MatrixMixerVolumes.h
 
	$Log: MatrixMixerVolumes.h,v $
	Revision 1.4  2005/01/12 20:30:00  luke
	add newlines to make gcc 4.0 happy
	
	Revision 1.3  2004/09/30 21:04:00  jcm10
	flat headers
	
	Revision 1.2  2003/10/26 20:59:09  bills
	consistent spelling of the plural of Bus (Buses)
	
	Revision 1.1  2003/08/01 20:08:43  mhopkins
	New files for printing information about matrix mixers
	
	
	Copyright (c) 2003 Apple Computer. All rights reserved.

=============================================================================*/


#ifndef __MatrixMixerVolumes_h__
#define __MatrixMixerVolumes_h__

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
//#include <CoreServices/CoreServices.h>
//#include <CoreAudio/CoreAudio.h>
	#include <AudioUnit/AudioUnit.h>
#else
	#include <AudioUnit.h>
#endif

#if defined(__cplusplus)
extern "C"
{
#endif

// prints the matrix mixer volumes of a specific audio unit to the given file
void	 PrintMatrixMixerVolumes (FILE* file, AudioUnit au);				

// prints the mixer volumes for the specific scope of the audio unit
// results will be printed to the speficied file "file" with identifiying string tag "str"		
OSStatus PrintBuses (FILE* file, char* str, AudioUnit au, AudioUnitScope inScope);
#if defined(__cplusplus)
}
#endif

#endif
