/*=============================================================================
	AUParamInfo.h
	
	$Log: AUParamInfo.h,v $
	Revision 1.7  2005/02/10 20:46:44  luke
	support arbitrary elements
	
	Revision 1.6  2004/11/19 03:20:45  cbruyns
	adding scope  into constructor
	
	Revision 1.5  2004/11/16 18:33:10  bills
	don't throw out of constructor (and add scope argument)
	
	Revision 1.4  2004/11/12 04:49:49  cbruyns
	keep list of parameterID's [bills]
	
	Revision 1.3  2004/08/20 22:58:51  bills
	add a GetParamInfo call
	
	Revision 1.2  2004/07/10 01:51:17  luke
	code cleanup (bills)
	
	Revision 1.1  2004/07/10 01:42:27  bills
	some re-factoring
	

	created 9 July 2004, William Stewart
	Copyright (c) 2004 Apple Computer, Inc.  All Rights Reserved
	
	$NoKeywords: $
=============================================================================*/
#include <map>
#include <vector>
#include <AudioUnit/AudioUnit.h>
#include "CAAUParameter.h"

/*
	The ParameterMap returned by the Map() method is a map where 
		- the key is the clumpID
		- the value is a ParameterList (vector<CAAUParameter>)
		
	If you have parameters on multiple scopes (or elements within a scope), then you should create one of these 
	for each scope-element pair
*/

class AUParamInfo {

public:
	typedef std::vector <CAAUParameter> ParameterList;
	typedef std::map <UInt32, ParameterList, std::less<UInt32> > ParameterMap;



							AUParamInfo (AudioUnit		inAU, 
									bool				inIncludeExpert, 
									bool				inIncludeReadOnly, 
									AudioUnitScope		inScope = kAudioUnitScope_Global,
									AudioUnitElement	inElement = 0);
									
							~AUParamInfo();
							
	const ParameterMap&		Map () const { return mParams; }
	
	// some convenience methods
	UInt32					NumParams () const { return mNumParams; }
	
	AudioUnitParameterID	ParamID (UInt32 inIndex) const 
							{ 
								if (inIndex < mNumParams) return mParamListID[inIndex]; 
								return 0xFFFFFFFF; 
							}
							 
	UInt32					NumClumps () const { return mParams.size(); }

	UInt32					NumParamsForClump (UInt32 inClump) const;
	
			// returns NULL if there's no info for the parameter
	const CAAUParameter*	GetParamInfo (AudioUnitParameterID inParamID) const;
	
	AudioUnitScope			GetScope () const { return mScope; }
	AudioUnitElement		GetElement () const { return mElement; }
	
private:

	AudioUnit				mAU;
	UInt32					mNumParams;
	AudioUnitParameterID *	mParamListID;
	
	ParameterMap			mParams;
	AudioUnitScope			mScope;
	AudioUnitElement		mElement;
		
		// disallow
	AUParamInfo () {}
	AUParamInfo (const AUParamInfo &c) {}
	AUParamInfo& operator= (const AUParamInfo& c) { return *this; }
};
