/*=============================================================================
	CAAudioFileRecorder.h
	
	$Log: CAAudioFileRecorder.h,v $
	Revision 1.4  2004/10/15 17:10:34  dwyatt
	CAAudioFile rewrite to use ExtAudioFile (changeable via compile flag in CAAudioFile.h)
	
	Revision 1.3  2004/05/27 19:51:54  dwyatt
	reinstate SetFile methods which allowed wrapping an existing CAAudioFile
	
	Revision 1.2  2004/05/26 00:36:02  dwyatt
	track change to CABufferQueue; writer/recorder now create their own CAAudioFile's from scratch instead of wrapping the client's [3666988]
	
	Revision 1.1  2004/01/14 00:08:09  dwyatt
	moved from Source/Tests/AudioFileUtility/Utility
	
	Revision 1.2  2003/10/15 00:27:30  dwyatt
	refactor on top of CABufferQueue
	
	Revision 1.1  2003/10/09 23:19:37  dwyatt
	initial checkin
	
	created Tue Sep 30 2003, Doug Wyatt
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CAAudioFileRecorder_h__
#define __CAAudioFileRecorder_h__

#include "CAAudioFileStreamer.h"
#include <AudioUnit/AudioUnit.h>

// Simple file recorder using the HAL audio "output" unit as an input unit.
class CAAudioFileRecorder : public CAAudioFileWriter {
public:
	CAAudioFileRecorder(int nBuffers, UInt32 bufferSizeFrames);
	~CAAudioFileRecorder();
	
	void	Start();
	void	Stop();	

	void	SetFile(AudioFileID fileID);
	void	SetFile(const FSRef &parentFSRef, CFStringRef filename, AudioFileTypeID filetype, const CAStreamBasicDescription &dataFormat, const CAAudioChannelLayout *layout);

	const CAStreamBasicDescription &	IODataFormat() { return mInputDataFormat; }

protected:
	static OSStatus	InputProc(
							void *						inRefCon,
							AudioUnitRenderActionFlags *ioActionFlags,
							const AudioTimeStamp *		inTimeStamp,
							UInt32 						inBusNumber,
							UInt32 						inNumberFrames,
							AudioBufferList *			ioData);
	
	AudioUnit					mInputUnit;
	CABufferList *				mAudioInputPtrs;
	CAStreamBasicDescription	mInputDataFormat;
};

#endif // __CAAudioFileRecorder_h__
