/*=============================================================================
	CAChannelMapper.h
	
	$Log: CAChannelMapper.h,v $
	Revision 1.2  2004/09/30 21:07:42  jcm10
	flat includes
	
	Revision 1.1  2004/01/14 00:08:09  dwyatt
	moved from Source/Tests/AudioFileUtility/Utility
	
	Revision 1.1  2003/08/04 23:40:00  dwyatt
	initial checkin
	
	created Mon Jul 28 2003, Doug Wyatt
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CAChannelMapper_h__
#define __CAChannelMapper_h__

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <AudioUnit/AudioUnit.h>
#else
	#include <AudioUnit.h>
#endif
#include "CAAudioChannelLayout.h"
#include "CAStreamBasicDescription.h"
#include "CAAudioUnit.h"
#include "MatrixMixerVolumes.h"

class CAChannelMapper {
public:
	CAChannelMapper(const CAStreamBasicDescription &srcFormat, 
					const CAStreamBasicDescription &destFormat,
					const CAAudioChannelLayout *	srcLayout = NULL,
					const CAAudioChannelLayout *	destLayout = NULL);
	~CAChannelMapper();
	
	UInt32			NumSourceChannels() { return mSrcNChannels; }
	UInt32			NumDestChannels() { return mDestNChannels; }
	const CAAudioChannelLayout	&SourceLayout() { return mSrcLayout; }
	const CAAudioChannelLayout	&DestLayout() { return mDestLayout; }
	AudioUnit		GetMixer() { return mMatrixMixer.AU(); }
	
	bool			CanDownmix() { return mSrcLayout.IsValid() && mDestLayout.IsValid(); }
	OSStatus		OpenMixer(double sampleRate);
	OSStatus		ResetMixer();		// enables all ins/outs, zeroes all crosspoints
	OSStatus		ConfigureDownmix();
	OSStatus		ConnectChannelToChannel(UInt32 inChannel, UInt32 outChannel);
	OSStatus		Mix(const AudioBufferList *src, AudioBufferList *dest, UInt32 nFrames);
	void			PrintMatrixMixerVolumes(FILE *f) { ::PrintMatrixMixerVolumes(f, mMatrixMixer.AU()); }
	
private:
	static OSStatus	MixerInputProc(
							void *						inRefCon,
							AudioUnitRenderActionFlags *ioActionFlags,
							const AudioTimeStamp *		inTimeStamp,
							UInt32 						inBusNumber,
							UInt32 						inNumberFrames,
							AudioBufferList *			ioData);

	UInt32					mSrcNChannels, mDestNChannels;
	CAAudioChannelLayout	mSrcLayout, mDestLayout;
	CAAudioUnit				mMatrixMixer;
	const AudioBufferList *	mMixInputBufferList;
};

#endif // __CAChannelMapper_h__
