/*=============================================================================
	CAChannelMappingPlayer.h
	
	$Log: CAChannelMappingPlayer.h,v $
	Revision 1.1  2004/01/14 00:08:09  dwyatt
	moved from Source/Tests/AudioFileUtility/Utility
	
	Revision 1.1  2003/08/04 23:40:00  dwyatt
	initial checkin
	
	created Thu Jul 31 2003, Doug Wyatt
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CAChannelMappingPlayer_h__
#define __CAChannelMappingPlayer_h__

#include "CAAudioFilePlayer.h"
#include "CAChannelMapper.h"

// Specialization of CAAudioFilePlayer to perform channel remapping or downmixing.
class CAChannelMappingPlayer : public CAAudioFilePlayer {
public:
	CAChannelMappingPlayer(int nBuffers, UInt32 ioBufferSizeBytes);
	~CAChannelMappingPlayer();

	// CAAudioFilePlayer overrides:
	virtual void		SetupChannelMapping();

	CAChannelMapper *		GetMapper() { return mMapper; }

private:
	CAChannelMapper *		mMapper;
};


#endif // __CAChannelMappingPlayer_h__
