//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	AudioFilePlayer.h
//
//	$Log: AudioFilePlay.h,v $
//	Revision 1.7  2003/03/13 22:11:38  baron
//	Remove V1 code. Replace usage of AudioFile Read/WriteByte APIs with the Read/WritePacket versions.
//	
//	Revision 1.6  2002/06/29 06:06:28  bills
//	make the v2 flag the default
//	
//	Revision 1.5  2002/06/09 22:25:27  bills
//	cleanup use of v2 flags
//	
//	Revision 1.4  2002/05/19 23:23:24  bills
//	cleanup header
//	
//	Revision 1.3  2002/05/18 05:59:49  bills
//	fix error handling
//	
//	Revision 1.2  2002/05/18 03:46:21  bills
//	add some additional API
//	
//	Revision 1.1  2002/05/18 01:20:16  bills
//	new location
//	
//	Revision 1.3  2002/05/17 07:59:42  bills
//	readd
//	
//	Revision 1.1  2002/05/17 07:48:05  bills
//	Add FilePlay "C" API
//	
//	Revision 1.5  2002/05/16 09:22:09  bills
//	add notifications for file underruns
//	
//	Revision 1.4  2002/05/16 09:07:13  bills
//	use a single read thread for files
//	
//	Revision 1.3  2002/05/15 07:31:08  bills
//	add GetFileFormat call
//	
//	Revision 1.2  2002/05/15 06:21:59  bills
//	now use AudioConverter to do file reading
//	
//	Revision 1.1  2002/05/14 08:12:23  bills
//	initial checkin
//	
//
//	General class for playing back a file
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifndef __AudioFilePlay_H__
#define __AudioFilePlay_H__

#include <CoreServices/CoreServices.h>
#include <AudioToolbox/AudioToolbox.h>
#include <AudioUnit/AudioUnit.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*AudioFilePlayNotifier)(void 			*inRefCon,
									OSStatus		inStatus);
enum {
	kAudioFilePlayErr_FilePlayUnderrun = -10000,
	kAudioFilePlay_FileIsFinished = -10001,
	kAudioFilePlay_PlayerIsUninitialized = -10002
};

typedef	struct OpaqueFilePlayObj* AudioFilePlayID;

extern OSStatus NewAudioFilePlayID (const FSRef	*inFileRef, AudioFilePlayID	*outFilePlayID);

extern OSStatus DisposeAudioFilePlayID (AudioFilePlayID 	inFilePlayID);

// this assumes that the input format of the AudioUnit's bus is SET correctly!!!
// if you change this after you've set the destination, you should disconnect and reset the destination
extern OSStatus AFP_SetDestination (AudioFilePlayID 		inFilePlayID,
									AudioUnit 				inDestUnit, 
									UInt32					inDestBusNumber);

extern OSStatus AFP_SetLooping (AudioFilePlayID 			inFilePlayID,
									Boolean 				inShouldLoop);

extern OSStatus AFP_SetNotifier (AudioFilePlayID		 		inFilePlayID,
									AudioFilePlayNotifier	 	inNotifier, 
									void*						inUserData);

extern OSStatus AFP_Connect (AudioFilePlayID 		inFilePlayID);

extern OSStatus AFP_Disconnect (AudioFilePlayID 	inFilePlayID);

extern OSStatus AFP_IsConnected (AudioFilePlayID 	inFilePlayID,
									Boolean			*outIsConnected);

	// Any of the args can be null if you're not interested in result
	// ONLY valid if the playID is connected
extern OSStatus AFP_GetInfo (AudioFilePlayID 	inFilePlayID,
							AudioUnit			*outDestUnit,
							UInt32				*outBusNumber,
							AudioConverterRef 	*outConverter);

extern OSStatus AFP_Print (AudioFilePlayID 			inFilePlayID);

extern void PrintStreamDesc (AudioStreamBasicDescription* 	inDesc);

#ifdef __cplusplus
}
#endif

#endif
