//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	AudioFilePlayer.h
//
//	$Log: AudioFilePlay.cpp,v $
//	Revision 1.4  2002/05/19 23:23:23  bills
//	cleanup header
//	
//	Revision 1.3  2002/05/18 05:59:49  bills
//	fix error handling
//	
//	Revision 1.2  2002/05/18 03:46:21  bills
//	add some additional API
//	
//	Revision 1.1  2002/05/18 01:19:47  bills
//	new location
//	
//	Revision 1.1  2002/05/17 07:56:45  bills
//	new dir loc
//	
//	Revision 1.1  2002/05/17 07:48:05  bills
//	Add FilePlay "C" API
//	
//
//	General class for playing back a file
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include "AudioFilePlayer.h"

#define TRY		try {

#define CATCH				\
	}						\
	catch (OSStatus stat) 	\
	{						\
		return stat;		\
	}						\
	catch (...) 			\
	{						\
		return -1;			\
	}						\
	return noErr;

OSStatus NewAudioFilePlayID (const FSRef	*inFileRef, AudioFilePlayID* outFilePlayID)
{
	TRY
	
	if (!inFileRef || !outFilePlayID) return paramErr;
	
	AudioFilePlayer* player = new AudioFilePlayer (*inFileRef);
	*outFilePlayID = reinterpret_cast<OpaqueFilePlayObj*>(player);
	
	CATCH
}

OSStatus DisposeAudioFilePlayID (AudioFilePlayID 	inFilePlayID)
{
	TRY
	
	delete reinterpret_cast<AudioFilePlayer*>(inFilePlayID);
	
	CATCH
}

OSStatus AFP_SetDestination (AudioFilePlayID 		inFilePlayID,
									AudioUnit 				inDestUnit, 
									UInt32					inDestBusNumber)
{
	TRY
	
	if (!inFilePlayID || !inDestUnit) return paramErr;

	reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->SetDestination (inDestUnit, 
															inDestBusNumber);
	CATCH
}

OSStatus AFP_SetLooping (AudioFilePlayID 			inFilePlayID,
									Boolean 				inShouldLoop)
{
	TRY

	if (!inFilePlayID) return paramErr;
	
	reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->SetLooping (inShouldLoop ? true : false);
	
	CATCH
}
	
OSStatus AFP_SetNotifier (AudioFilePlayID 			inFilePlayID,
									AudioFilePlayNotifier 	inNotifier, 
									void*					inUserData)
{
	TRY

	if (!inFilePlayID) return paramErr;
	
	reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->SetNotifier (inNotifier, inUserData);
	
	CATCH
}
	
OSStatus AFP_Connect (AudioFilePlayID 		inFilePlayID)
{
	TRY

	if (!inFilePlayID) return paramErr;
	
	reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->Connect();
	
	CATCH
}

OSStatus AFP_Disconnect (AudioFilePlayID 	inFilePlayID)
{
	TRY

	if (!inFilePlayID) return paramErr;
	
	reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->Disconnect();
	
	CATCH
}

OSStatus AFP_IsConnected (AudioFilePlayID 	inFilePlayID, Boolean	*outIsConnected)
{
	TRY

	if (!inFilePlayID || !outIsConnected) return paramErr;
	
	*outIsConnected = reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->IsConnected();
	
	CATCH
}

OSStatus AFP_GetInfo (AudioFilePlayID 	inFilePlayID,
							AudioUnit			*outDestUnit,
							UInt32				*outBusNumber,
							AudioConverterRef 	*outConverter)
{
	TRY

	if (!inFilePlayID) return paramErr;
	
	AudioFilePlayer* player = reinterpret_cast<AudioFilePlayer*>(inFilePlayID);
	
	if (player->GetDestUnit() == 0)
		return kAudioFilePlay_PlayerIsUninitialized;
		
	if (outDestUnit)
		*outDestUnit = player->GetDestUnit();

	if (outBusNumber)
		*outBusNumber = player->GetBusNumber();

	if (outConverter)
		*outConverter = player->GetAudioConverter();
	
	CATCH
}

OSStatus AFP_Print (AudioFilePlayID 			inFilePlayID)
{
	TRY

	if (!inFilePlayID) return paramErr;
	
	reinterpret_cast<AudioFilePlayer*>(inFilePlayID)->Print();
	
	CATCH
}


void PrintStreamDesc (AudioStreamBasicDescription *inDesc)
{
	if (!inDesc) {
		printf ("Can't print a NULL desc!\n");
		return;
	}
	
	printf ("- - - - - - - - - - - - - - - - - - - -\n");
	printf ("  Sample Rate:%f\n", inDesc->mSampleRate);
	printf ("  Format ID:%s\n", (char*)&inDesc->mFormatID);
	printf ("  Format Flags:%lX\n", inDesc->mFormatFlags);
	printf ("  Bytes per Packet:%ld\n", inDesc->mBytesPerPacket);
	printf ("  Frames per Packet:%ld\n", inDesc->mFramesPerPacket);
	printf ("  Bytes per Frame:%ld\n", inDesc->mBytesPerFrame);
	printf ("  Channels per Frame:%ld\n", inDesc->mChannelsPerFrame);
	printf ("  Bits per Channel:%ld\n", inDesc->mBitsPerChannel);
	printf ("- - - - - - - - - - - - - - - - - - - -\n");
}
