/*=============================================================================
	CAAUConnections.h
	
	$Log: CAAUConnections.h,v $
	Revision 1.2  2004/10/15 20:44:35  bills
	add an IsMember call
	
	Revision 1.1  2004/07/26 19:27:52  bills
	initial
	
	
	created Mon Jul 26, 2004 William Stewart
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/
#ifndef __CAAUConnections_h__
#define __CAAUConnections_h__

#include <AudioToolbox/AudioToolbox.h>
#include "CAAudioUnit.h"

class CAAUConnections {
public:
						
	OSStatus			Find (const AUGraph &inGraph, const CAAudioUnit &inAU, AudioUnitScope inScope);
	
	UInt32				Size () const { return mConns.size(); }
	bool				IsEmpty () const { return mConns.empty(); }
							// does the connection object contain a connection to/from this element 
	bool				IsMember (AudioUnitElement inMyEl) const;
	
	bool				Connection (UInt32 inIndex, AudioUnitElement &outMyAUEl, CAAudioUnit &outAU, AudioUnitElement &outOtherAUEl);

	void				Print () const { Print (stdout); }
	void				Print (FILE* file) const;
	
private:
	struct AUConn {
		AudioUnitElement	mMyEl; 
		CAAudioUnit			mOtherAU;
		AudioUnitElement	mOtherEl; 
		
		AUConn (AudioUnitElement el, AudioUnit otherAU, AUNode otherNode, AudioUnitElement otherEl)
			: mMyEl (el),
			  mOtherAU (otherNode, otherAU),
			  mOtherEl (otherEl) 
			{}
	};
	typedef std::vector<AUConn> AUConns;
	AUConns						mConns;
};

#endif