/*
 *  CAAUMIDIMapManager.h
 *
 *	$Log: CAAUMIDIMapManager.h,v $
 *	Revision 1.14  2005/01/06 01:57:19  dwyatt
 *	gcc4 / newline at EOF
 *	
 *	Revision 1.13  2004/12/09 03:07:27  bills
 *	some changes to API (including publish in C++ style)
 *	
 *	Revision 1.12  2004/11/13 02:17:09  bills
 *	add ReplaceAllMaps
 *	
 *	Revision 1.11  2004/11/12 02:49:00  cbruyns
 *	include AudioUnit/AudioUnitUtilities for AudioEvent
 *	
 *	Revision 1.10  2004/11/04 21:50:22  cbruyns
 *	moved save and restore out of map manager.  also ignore previous CVS notes, those were for the CAServices project not these source files.
 *	
 *	Revision 1.9  2004/11/04 19:56:00  cbruyns
 *	moved the midi map files to the Components target
 *	removed AudioToolbox from AudioUnit target
 *	
 *	Revision 1.8  2004/11/02 23:45:30  cbruyns
 *	notes added for save & restore maps
 *	
 *	Revision 1.7  2004/10/27 08:20:10  cbruyns
 *	start of save restore
 *	
 *	Revision 1.6  2004/10/26 20:56:28  cbruyns
 *	updated mapping passing
 *	
 *	Revision 1.5  2004/10/22 00:23:20  cbruyns
 *	changed get all midi maps - again
 *	
 *	Revision 1.4  2004/10/21 23:27:45  cbruyns
 *	new remove and return all
 *	
 *	Revision 1.3  2004/10/19 22:17:33  cbruyns
 *	map manager with vector
 *	
 *	Revision 1.2  2004/10/19 22:04:27  cbruyns
 *	map manager with vector
 *	
 *	Revision 1.1  2004/10/15 02:03:48  cbruyns
 *	first checkin
 *	
 *
 *  Created by cynthia on 10/14/04.
 *  Copyright 2004 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef __CAAUMIDIMapManager_h_
#define __CAAUMIDIMapManager_h_

#include <AUBase.h> 
#include <CAAUMIDIMap.h>
#include <vector>
#include <AudioToolbox/AudioUnitUtilities.h>

class CAAUMIDIMapManager {
		
protected:
	
	typedef std::vector<CAAUMIDIMap>	ParameterMaps;
	ParameterMaps						mParameterMaps;
	
	bool								hotMapping;
	AUParameterMIDIMapping				mHotMap;
	
public:
					
							CAAUMIDIMapManager();
	
	UInt32					NumMaps(){return mParameterMaps.size();}
	void					GetMaps(AUParameterMIDIMapping* maps);
	
	int						FindParameterIndex(AUParameterMIDIMapping &map);
	
	void					GetHotParameterMap(AUParameterMIDIMapping &outMap);
		
	void					SortedRemoveFromParameterMaps	(AUParameterMIDIMapping *maps, UInt32 inNumMaps, bool &outMapDidChange);
	OSStatus				SortedInsertToParamaterMaps	(AUParameterMIDIMapping *maps, UInt32 inNumMaps, AUBase &That);
	
	void					ReplaceAllMaps (AUParameterMIDIMapping* inMappings, UInt32 inNumMaps, AUBase &That);
	
	bool					IsHotMapping(){return hotMapping;}
	void					SetHotMapping (AUParameterMIDIMapping &inMap){hotMapping = true; mHotMap = inMap; }
	
	bool					HandleHotMapping(	UInt8 	inStatus,
												UInt8 	inChannel,
												UInt8 	inData1,
												AUBase	&That);
	
		
	bool					FindParameterMapEventMatch(UInt8 	inStatus,
													   UInt8 	inChannel,
													   UInt8 	inData1,
													   UInt8 	inData2,
													   UInt32	inBufferOffset,
													   AUBase&	inAUBase);	
#if DEBUG
	void					Print();
#endif
};


#endif
