/*=============================================================================
 *  CAAUPresetFile.h
 
	$Log: CAAUPresetFile.h,v $
	Revision 1.4  2004/06/24 23:15:39  mhopkins
	Added name and data keys
	
	Revision 1.3  2004/06/02 19:59:32  bills
	CreateTrees Needs to know if it should search for Network Dir
	
	Revision 1.2  2004/05/26 17:21:01  luke
	[3656248] allow constructor option to search Network
	
	Revision 1.1  2003/12/02 01:09:53  luke
	broke CAAUPresetFile out of CAFileHandling
	
    
 *  Created by William Stewart on Thu Oct 02 2003.
 *  Copyright (c) 2003 Apple Computer. All rights reserved.
==============================================================================*/

#ifndef __CAAUPresetFile_h__
#define __CAAUPresetFile_h__

#include "CAFileHandling.h"

class CAAUPresetFile : public CAFileHandling {
public:
	static const CFStringRef	kAUPresetFileDirName;
	static const CFStringRef  	kAUPresetFileExtension;
	static const CFStringRef  	kAUPresetNameKeyString;
	static const CFStringRef  	kAUPresetDataKeyString;

								CAAUPresetFile (CAComponent inComp, bool inShouldSearchNetwork);
								virtual ~CAAUPresetFile();
	
	bool						IsPartPreset (CFTreeRef inTree) const;

protected:
	virtual	const CFStringRef			GetExtension () const { return kAUPresetFileExtension; }
	virtual bool						ValidPropertyList (CFPropertyListRef inData);
	virtual OSStatus					CreateSubDirectories (FSRef &inParentRef, SInt16 inDomain);

private:
	OSStatus				GetRootDir (const FSRef &inRef, CFStringRef manuName, CFStringRef compName, FSRef &outRef, bool inCreateDir = false);


	CAComponent				mComp;
};

#endif
