/*=============================================================================
	CAAudioBufferList.h

	$Log: CAAudioBufferList.h,v $
	Revision 1.10  2004/07/03 01:17:07  jcm10
	add HasData()
	
	Revision 1.9  2004/05/19 18:59:35  jcm10
	add definition of AudioBufferListPtr to make references to pointers easier to work with
	
	Revision 1.8  2004/05/15 00:15:46  jcm10
	add sEmptyBufferList
	
	Revision 1.7  2004/02/11 23:39:33  jcm10
	improve the Copy() method to support varying forms of ABL's
	
	Revision 1.6  2003/12/19 01:12:14  jcm10
	add missing includes
	
	Revision 1.5  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.4  2003/03/12 01:58:48  jcm10
	add CalculateByteSize()
	
	Revision 1.3  2002/09/27 22:16:22  jcm10
	add Clear() and Sum()
	
	Revision 1.2  2002/04/18 02:20:11  jcm10
	clean up the header inclusion
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.1  2001/04/05 01:36:12  jcm10
	first checked in
	
	Revision 0.0  2001/04/03 16:55:43  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAAudioBufferList_h__)
#define __CAAudioBufferList_h__

//=============================================================================
//	Includes
//=============================================================================

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

//=============================================================================
//	Types
//=============================================================================

typedef AudioBufferList*	AudioBufferListPtr;

//=============================================================================
//	CAAudioBufferList
//=============================================================================

struct	CAAudioBufferList
{

//	Construction/Destruction
public:
	static AudioBufferList*	Create(UInt32 inNumberBuffers);
	static void				Destroy(AudioBufferList* inBufferList);
	static UInt32			CalculateByteSize(UInt32 inNumberBuffers);

//	Operations
public:
	static UInt32			GetTotalNumberChannels(const AudioBufferList& inBufferList);
	static bool				GetBufferForChannel(const AudioBufferList& inBufferList, UInt32 inChannel, UInt32& outBufferNumber, UInt32& outBufferChannel);
	static void				Clear(AudioBufferList& outBufferList);
	static void				Copy(const AudioBufferList& inSource, UInt32 inStartingSourceChannel, AudioBufferList& outDestination, UInt32 inStartingDestinationChannel);
	static void				CopyChannel(const AudioBuffer& inSource, UInt32 inSourceChannel, AudioBuffer& outDestination, UInt32 inDestinationChannel);
	static void				Sum(const AudioBufferList& inSourceBufferList, AudioBufferList& ioSummedBufferList);
	static bool				HasData(AudioBufferList& inBufferList);
#if	CoreAudio_Debug
	static void				PrintToLog(const AudioBufferList& inBufferList);
#endif

//  Constants
public:
	static AudioBufferList  sEmptyBufferList;

};

#endif
