/*=============================================================================
	CAAudioHardwareStream.h

	$Log: CAAudioHardwareStream.h,v $
	Revision 1.2  2003/06/18 22:09:20  jcm10
	add IsControlEnabled methods
	
	Revision 1.1  2003/05/23 19:06:50  jcm10
	first checked in
	
	Revision 1.3  2003/05/06 18:42:40  jcm10
	add support for displaying/manipulating the IOProc format
	
	Revision 1.2  2003/01/30 22:31:31  jcm10
	make the Streams tab of the Device window work
	
	Revision 1.1  2003/01/24 03:24:57  jcm10
	first checked in
	
	Revision 0.0  Wed Jan 15 2003 12:52:54 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAAudioHardwareStream_h__)
#define __CAAudioHardwareStream_h__

//=============================================================================
//	Includes
//=============================================================================

//	Local Includes
#include "CAAudioHardwareDevice.h"

//=============================================================================
//	CAAudioHardwareStream
//=============================================================================

class CAAudioHardwareStream
{

//	Construction/Destruction
public:
									CAAudioHardwareStream(AudioStreamID inAudioStreamID);
									~CAAudioHardwareStream();

//	General Operations
public:
	AudioStreamID					GetAudioStreamID() const { return mAudioStreamID; }
	CFStringRef						CopyName() const;
	AudioDeviceID					GetOwningDevice() const;
	CAAudioHardwareDeviceSectionID	GetSection() const;
	UInt32							GetTerminalType() const;
	UInt32							GetStartingDeviceChannel() const;

	bool							HasIsConnectedStatus() const;
	bool							GetIsConnectedStatus() const;
	
	bool							HasDataSourceControl() const;
	bool							DataSourceControlIsSettable() const;
	UInt32							GetCurrentDataSourceID() const;
	void							SetCurrentDataSourceByID(UInt32 inID);
	UInt32							GetNumberAvailableDataSources() const;
	UInt32							GetAvailableDataSourceByIndex(UInt32 inIndex) const;
	void							GetAvailableDataSources(UInt32& ioNumberSources, UInt32* outSources) const;
	CFStringRef						CopyDataSourceNameForID(UInt32 inID) const;

//	Format Operations
public:
	void							GetCurrentIOProcFormat(AudioStreamBasicDescription& outFormat) const;
	void							SetCurrentIOProcFormat(const AudioStreamBasicDescription& inFormat);
	UInt32							GetNumberAvailableIOProcFormats() const;
	void							GetAvailableIOProcFormats(UInt32& ioNumberFormats, AudioStreamBasicDescription* outFormats) const;
	void							GetAvailableIOProcFormatByIndex(UInt32 inIndex, AudioStreamBasicDescription& outFormat) const;
	
	void							GetCurrentPhysicalFormat(AudioStreamBasicDescription& outFormat) const;
	void							SetCurrentPhysicalFormat(const AudioStreamBasicDescription& inFormat);
	UInt32							GetNumberAvailablePhysicalFormats() const;
	void							GetAvailablePhysicalFormats(UInt32& ioNumberFormats, AudioStreamBasicDescription* outFormats) const;
	void							GetAvailablePhysicalFormatByIndex(UInt32 inIndex, AudioStreamBasicDescription& outFormat) const;
	
//	Property Operations
public:
	bool							HasProperty(UInt32 inChannel, AudioHardwarePropertyID inPropertyID) const;
	bool							PropertyIsSettable(UInt32 inChannel, AudioHardwarePropertyID inPropertyID) const;
	
	UInt32							GetPropertyDataSize(UInt32 inChannel, AudioHardwarePropertyID inPropertyID) const;
	void							GetPropertyData(UInt32 inChannel, AudioHardwarePropertyID inPropertyID, UInt32& ioDataSize, void* outData) const;
	void							SetPropertyData(UInt32 inChannel, AudioHardwarePropertyID inPropertyID, UInt32 inDataSize, const void* inData, const AudioTimeStamp* inWhen = NULL);
	
	void							AddPropertyListener(UInt32 inChannel, AudioHardwarePropertyID inPropertyID, AudioStreamPropertyListenerProc inListenerProc, void* inClientData);
	void							RemovePropertyListener(UInt32 inChannel, AudioHardwarePropertyID inPropertyID, AudioStreamPropertyListenerProc inListenerProc);
	
//	Utility Operations
public:
	static void						GetNameForTerminalType(UInt32 inTerminalType, char* outName);

//	Implementation
private:
	AudioStreamID					mAudioStreamID;

};

#endif
