/*=============================================================================
	CAAudioHardwareSystem.h

	$Log: CAAudioHardwareSystem.h,v $
	Revision 1.4  2004/02/24 02:27:06  jcm10
	make it compile without a prefix header
	
	Revision 1.3  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.2  2003/05/29 23:05:17  jcm10
	add GetDeviceForUID()
	
	Revision 1.1  2003/05/23 19:06:50  jcm10
	first checked in
	
	Revision 1.3  2003/01/24 03:25:43  jcm10
	add file player window
	
	Revision 1.2  2002/12/17 20:24:49  jcm10
	tweak the System window
	
	Revision 1.1  2002/11/27 22:33:09  jcm10
	first checked in
	
	Revision 0.0  Mon Nov 25 2002 22:17:56 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAAudioHardwareSystem_h__)
#define __CAAudioHardwareSystem_h__

//=============================================================================
//	Includes
//=============================================================================

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudio.h>
	#include <CoreFoundation/CoreFoundation.h>
#else
	#include <CoreAudio.h>
	#include <CoreFoundation.h>
#endif

//=============================================================================
//	CAAudioHardwareSystem
//=============================================================================

class CAAudioHardwareSystem
{

//	Operations
public:
	static UInt32			GetNumberDevices();
	static AudioDeviceID	GetDeviceAtIndex(UInt32 inIndex);
	static UInt32			GetIndexForDevice(const AudioDeviceID inDevice);
	static AudioDeviceID	GetDeviceForUID(CFStringRef inUID);
	
	static AudioDeviceID	GetDefaultDevice(bool inIsInput, bool inIsSystem);
	static void				SetDefaultDevice(bool inIsInput, bool inIsSystem, AudioDeviceID inDevice);

	static bool				HasBootChimeVolumeControl();
	static Float32			GetBootChimeVolumeControlValueAsScalar();
	static Float32			GetBootChimeVolumeControlValueAsDB();
	static void				GetBootChimeVolumeControlDBRange(Float32& outMinimum, Float32& outMaximum);
	static void				SetBootChimeVolumeControlValueAsScalar(Float32 inScalarValue);
	static void				SetBootChimeVolumeControlValueAsDB(Float32 inDBValue);
	static Float32			ConvertBootChimeVolumeControlScalarValueToDB(Float32 inScalarValue);
	static Float32			ConvertBootChimeVolumeControlDBValueToScalar(Float32 inDBValue);
	
	static bool				AllowsIdleSleepDuringIO();
	static void				SetAllowsIdleSleepDuringIO(bool inAllowIdleSleep);
	
//	Property Operations
public:
	static bool				HasProperty(AudioHardwarePropertyID inPropertyID);
	static bool				PropertyIsSettable(AudioHardwarePropertyID inPropertyID);
	
	static UInt32			GetPropertyDataSize(AudioHardwarePropertyID inPropertyID);
	static void				GetPropertyData(AudioHardwarePropertyID inPropertyID, UInt32& ioDataSize, void* outData);
	static void				SetPropertyData(AudioHardwarePropertyID inPropertyID, UInt32 inDataSize, const void* inData);
	
	static void				AddPropertyListener(AudioHardwarePropertyID inPropertyID, AudioHardwarePropertyListenerProc inListenerProc, void* inClientData);
	static void				RemovePropertyListener(AudioHardwarePropertyID inPropertyID, AudioHardwarePropertyListenerProc inListenerProc);
	
};

#endif
