/*=============================================================================
	CAAudioTimeStamp.cp

	$Log: CAAudioTimeStamp.cpp,v $
	Revision 1.1  2004/08/23 06:22:35  jcm10
	first checked in
	
	Revision 1.2  2002/05/16 21:19:06  jcm10
	add sorting functionality
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.3  2001/01/04 22:16:32  jcm10
	oops
	
	Revision 1.1  2000/09/06 22:50:54  jcm10
	Added a "zero" constant
	
	Revision 0.0  2000/01/01 12:34:56  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CAAudioTimeStamp.h"

//=============================================================================
//	CAAudioTimeStamp
//=============================================================================

const AudioTimeStamp	CAAudioTimeStamp::kZero = { 0.0, 0, 0.0, 0, { 0, 0, 0, 0, 0, 0, 0 }, 0 };

bool	operator<(const AudioTimeStamp& x, const AudioTimeStamp& y)
{
	bool	isLessThan = false;
	bool	isDone = false;
	
	//	check the sample time
	if(!isDone)
	{
		if((x.mFlags & kAudioTimeStampSampleTimeValid) && (y.mFlags & kAudioTimeStampSampleTimeValid))
		{
			isLessThan = x.mSampleTime < y.mSampleTime;
			isDone = true;
		}
	}
	
	//	check the host time
	if(!isDone)
	{
		if((x.mFlags & kAudioTimeStampHostTimeValid) && (y.mFlags & kAudioTimeStampHostTimeValid))
		{
			isLessThan = x.mHostTime < y.mHostTime;
			isDone = true;
		}
	}
	
	//	check the word clock time
	if(!isDone)
	{
		if((x.mFlags & kAudioTimeStampWordClockTimeValid) && (y.mFlags & kAudioTimeStampWordClockTimeValid))
		{
			isLessThan = x.mWordClockTime < y.mWordClockTime;
			isDone = true;
		}
	}
	
	return isLessThan;
}

bool	operator==(const AudioTimeStamp& x, const AudioTimeStamp& y)
{
	bool	isEqual = false;
	bool	isDone = false;
	
	//	check the sample time
	if(!isDone)
	{
		if((x.mFlags & kAudioTimeStampSampleTimeValid) && (y.mFlags & kAudioTimeStampSampleTimeValid))
		{
			isEqual = x.mSampleTime == y.mSampleTime;
			isDone = true;
		}
	}
	
	//	check the host time
	if(!isDone)
	{
		if((x.mFlags & kAudioTimeStampHostTimeValid) && (y.mFlags & kAudioTimeStampHostTimeValid))
		{
			isEqual = x.mHostTime == y.mHostTime;
			isDone = true;
		}
	}
	
	//	check the word clock time
	if(!isDone)
	{
		if((x.mFlags & kAudioTimeStampWordClockTimeValid) && (y.mFlags & kAudioTimeStampWordClockTimeValid))
		{
			isEqual = x.mWordClockTime == y.mWordClockTime;
			isDone = true;
		}
	}
	
	return isEqual;
}
