/*=============================================================================
	CAAudioTimeStamp.h

	$Log: CAAudioTimeStamp.h,v $
	Revision 1.5  2004/01/08 05:53:33  jcm10
	add another constructor
	
	Revision 1.4  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.3  2002/05/16 21:19:06  jcm10
	add sorting functionality
	
	Revision 1.2  2002/04/18 02:20:12  jcm10
	clean up the header inclusion
	
	Revision 1.1  2002/03/01 01:53:26  jcm10
	moved here from ../Utility
	
	Revision 1.9  2001/11/15 02:20:25  jcm10
	call standard C library fucntions without the namespace to
	make cpp-precomp happy
	
	Revision 1.8  2001/01/08 23:51:04  jcm10
	remove #pragma once, since gcc claims it to be obsolete and issues an annoying warning to that effect when all warnings are enabled
	
	Revision 1.7  2001/01/04 22:16:32  jcm10
	oops
	
	Revision 1.5  2000/11/20 20:13:13  jcm10
	explicitly do all the work here
	
	Revision 1.4  2000/09/23 22:55:15  jcm10
	XFiles works, almost
	
	Revision 1.3  2000/09/12 23:15:56  jcm10
	fix the sample time only constructor
	
	Revision 1.2  2000/09/06 22:50:27  jcm10
	added a "zero" constant and a few new constructors
	
	Revision 1.1  2000/07/06 04:13:50  jcm10
	New IOAudio support, Phase 1
	
	Revision 0.0  2000/01/01 12:34:56  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAAudioTimeStamp_h__)
#define __CAAudioTimeStamp_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

#include <string.h>

//=============================================================================
//	CAAudioTimeStamp
//=============================================================================

struct CAAudioTimeStamp
:
	public AudioTimeStamp
{

//	Construction/Destruction
public:
						CAAudioTimeStamp()											{ memset(this, 0, sizeof(AudioTimeStamp)); }
						CAAudioTimeStamp(const AudioTimeStamp& v)					{ memcpy(this, &v, sizeof(AudioTimeStamp)); }
						CAAudioTimeStamp(Float64 inSampleTime)						{ memset(this, 0, sizeof(AudioTimeStamp)); mSampleTime = inSampleTime; mFlags = kAudioTimeStampSampleTimeValid; }
						CAAudioTimeStamp(UInt64 inHostTime)							{ memset(this, 0, sizeof(AudioTimeStamp)); mHostTime = inHostTime; mFlags = kAudioTimeStampHostTimeValid; }
						CAAudioTimeStamp(Float64 inSampleTime, UInt64 inHostTime)	{ memset(this, 0, sizeof(AudioTimeStamp)); mSampleTime = inSampleTime; mHostTime = inHostTime; mFlags = kAudioTimeStampSampleTimeValid | kAudioTimeStampHostTimeValid; }

//	Assignment
public:
	CAAudioTimeStamp&	operator=(const AudioTimeStamp& v) { memcpy(this, &v, sizeof(AudioTimeStamp)); return *this; }

//	Constants
public:
	static const AudioTimeStamp	kZero;

};

bool		operator<(const AudioTimeStamp& x, const AudioTimeStamp& y);
bool		operator==(const AudioTimeStamp& x, const AudioTimeStamp& y);
inline bool	operator!=(const AudioTimeStamp& x, const AudioTimeStamp& y) { return !(x == y); }
inline bool	operator<=(const AudioTimeStamp& x, const AudioTimeStamp& y) { return (x < y) || (x == y); }
inline bool	operator>=(const AudioTimeStamp& x, const AudioTimeStamp& y) { return !(x < y); }
inline bool	operator>(const AudioTimeStamp& x, const AudioTimeStamp& y) { return !((x < y) || (x == y)); }

#endif
