/*==================================================================================================
	CAAudioValueRange.cpp

	$Log: CAAudioValueRange.cpp,v $
	Revision 1.3  2004/11/17 23:14:33  jcm10
	add Union()
	
	Revision 1.2  2004/08/19 09:33:42  jcm10
	add Intersection
	
	Revision 1.1  2004/06/07 18:53:57  jcm10
	first checked in
	
	Revision 0.0  Fri Jun 04 2004 17:05:19 US/Pacific  moorf
	Created
		
	$NoKeywords: $
==================================================================================================*/

//==================================================================================================
//	Includes
//==================================================================================================

//	Self Include
#include "CAAudioValueRange.h"

//	Standard Library
#include <algorithm>

//==================================================================================================
//	CAAudioValueRange
//==================================================================================================

Float64 CAAudioValueRange::PickCommonSampleRate(const AudioValueRange& inRange)
{
	//  This routine will pick a "common" sample rate from the give range of rates or the maximum
	//  if no common rates can be found. It assumes that inRange contains a continuous range of
	//  sample rates.
	Float64 theAnswer = inRange.mMaximum;
	
	if(ContainsValue(inRange, 44100.0))
	{
		theAnswer = 44100.0;
	}
	else if(ContainsValue(inRange, 48000.0))
	{
		theAnswer = 48000.0;
	}
	else if(ContainsValue(inRange, 96000.0))
	{
		theAnswer = 96000.0;
	}
	else if(ContainsValue(inRange, 88200.0))
	{
		theAnswer = 88200.0;
	}
	else if(ContainsValue(inRange, 64000.0))
	{
		theAnswer = 64000.0;
	}
	else if(ContainsValue(inRange, 32000.0))
	{
		theAnswer = 32000.0;
	}
	else if(ContainsValue(inRange, 24000.0))
	{
		theAnswer = 24000.0;
	}
	else if(ContainsValue(inRange, 22050.0))
	{
		theAnswer = 22050.0;
	}
	else if(ContainsValue(inRange, 16000.0))
	{
		theAnswer = 16000.0;
	}
	else if(ContainsValue(inRange, 12000.0))
	{
		theAnswer = 12000.0;
	}
	else if(ContainsValue(inRange, 11025.0))
	{
		theAnswer = 11025.0;
	}
	else if(ContainsValue(inRange, 8000.0))
	{
		theAnswer = 8000.0;
	}
	
	return theAnswer;
}

bool	CAAudioValueRange::Intersection(const AudioValueRange& x, const AudioValueRange& y, AudioValueRange& outRange)
{
	bool isNonEmpty;
	if(!IsStrictlyLessThan(x, y) && !IsStrictlyGreaterThan(x, y))
	{
		outRange.mMinimum = std::max(x.mMinimum, y.mMinimum);
		outRange.mMaximum = std::min(x.mMaximum, y.mMaximum);
		isNonEmpty = true;
	}
	else
	{
		outRange.mMinimum = 0;
		outRange.mMaximum = 0;
		isNonEmpty = false;
	}
	return isNonEmpty;
}

bool	CAAudioValueRange::Union(const AudioValueRange& x, const AudioValueRange& y, AudioValueRange& outRange)
{
	bool isDisjoint;
	if(!IsStrictlyLessThan(x, y) && !IsStrictlyGreaterThan(x, y))
	{
		outRange.mMinimum = std::min(x.mMinimum, y.mMinimum);
		outRange.mMaximum = std::max(x.mMaximum, y.mMaximum);
		isDisjoint = false;
	}
	else
	{
		outRange.mMinimum = 0;
		outRange.mMaximum = 0;
		isDisjoint = true;
	}
	return isDisjoint;
}
