/*=============================================================================
	CACFMachPort.h

	$Log: CACFMachPort.h,v $
	Revision 1.3  2002/05/30 21:21:31  jcm10
	clean up some stuff
	
	Revision 1.2  2002/04/18 02:20:12  jcm10
	clean up the header inclusion
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.2  2001/03/21 19:48:28  jcm10
	hook up control value notifications
	
	Revision 1.1  2001/03/21 03:15:51  jcm10
	make setting the format work
	
	Revision 0.0  2000/01/01 16:20:00  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CACFMachPort_h__)
#define __CACFMachPort_h__

//=============================================================================
//	Includes
//=============================================================================

#include <CoreFoundation/CFMachPort.h>

//=============================================================================
//	CACFMachPort
//
//	This class wraps a CFMachPort.
//=============================================================================

class	CACFMachPort
{

//	Construction/Destruction
public:
						CACFMachPort(CFMachPortCallBack inCallBack, void* inUserData = NULL);
	virtual				~CACFMachPort();

//	Attributes
public:
	CFMachPortRef		GetMachPortRef() const { return mMachPort; }
	mach_port_t			GetMachPort() const { return CFMachPortGetPort(mMachPort); }
	CFRunLoopSourceRef	GetRunLoopSource() const { return mRunLoopSource; }

//	Implementation
protected:
	CFMachPortRef		mMachPort;
	CFRunLoopSourceRef	mRunLoopSource;
};

#endif
