/*=============================================================================
	CACFNumber.cp

	$Log: CACFNumber.cpp,v $
	Revision 1.1  2004/08/23 06:22:35  jcm10
	first checked in
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.1  2001/03/14 23:48:38  jcm10
	Lots of changes to support the new driver API
	
	Revision 0.0  2001/03/12 14:12:32  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CACFNumber.h"

//=============================================================================
//	CACFNumber
//=============================================================================

Float32	CACFNumber::GetFixed32() const
{
	SInt32 theFixedValue = GetSInt32();
	
	//	this is a 16.16 value so convert it to a float
	Float32 theSign = theFixedValue < 0 ? -1.0 : 1.0;
	theFixedValue *= (SInt32)theSign;
	Float32 theWholePart = (theFixedValue & 0x7FFF0000) >> 16;
	Float32 theFractPart = theFixedValue & 0x0000FFFF;
	theFractPart /= 65536.0;
	
	return theSign * (theWholePart + theFractPart);
}
