/*=============================================================================
	CAComponent.h
 
	$Log: CAComponent.h,v $
	Revision 1.13  2005/01/12 20:30:00  luke
	add newlines to make gcc 4.0 happy
	
	Revision 1.12  2004/09/28 23:15:30  jcm10
	add missing include
	
	Revision 1.11  2004/08/23 19:39:27  bills
	fix warning
	
	Revision 1.10  2004/06/05 00:34:20  mhopkins
	AUName should always return a valid string
	
	Revision 1.9  2004/04/21 20:08:34  bills
	better variable name
	
	Revision 1.8  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.7  2003/10/20 19:27:09  bills
	don't copy Desc()
	
	Revision 1.6  2003/08/09 01:01:09  bills
	check res version details
	
	Revision 1.5  2003/07/05 20:13:26  bills
	add a constructor
	
	Revision 1.4  2003/06/15 23:58:15  bills
	fix (Component) const
	
	Revision 1.3  2003/03/13 18:18:58  bills
	get rid of the non-const Comp() method
	
	Revision 1.2  2003/03/11 20:57:30  bills
	first pass at save/restore state
	
	Revision 1.1  2003/03/11 00:38:21  bills
	initial checkin
	

	Created by William Stewart on Sat Mar 08 2003.
	Copyright (c) 2003 Apple Computer. All rights reserved.

=============================================================================*/

#ifndef __CAComponent_h__
#define __CAComponent_h__

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreServices/CoreServices.h>
#else
	#include <ConditionalMacros.h>
	#include <CoreServices.h>
#endif

#include "CAComponentDescription.h"

class CAComponent 
{
public:
	CAComponent ()
		: mComp (0), mDesc(), mManuName(0), mAUName(0), mCompName(0), mCompInfo (0) {}
		
		// if next is specifed that is used to find the next component after that one
	CAComponent (const ComponentDescription& inDesc, CAComponent* next = 0);
	
	CAComponent (const CAComponent& y) 
		: mComp (0), mDesc(), mManuName(0), mAUName(0), mCompName(0), mCompInfo (0) { *this = y; }

	CAComponent (const Component& comp);
	
	CAComponent (const ComponentInstance& compInst);

	CAComponent (OSType inType, OSType inSubtype = 0, OSType inManu = 0);
	
	~CAComponent ();
	
	CAComponent&	operator= (const CAComponent& y);
	
		// returns true if this object references a valid component
	bool			IsValid () const { return Comp() != 0; }
	
	bool			HasAUStrings() const { 	SetCompNames (); return mManuName != 0; }

		// CFStringRef should be retained by caller if needed beyond lifetime of this object
		
		// Can return NULL if component doesn't follow AU naming conventions
	CFStringRef		GetAUManu () const { SetCompNames (); return mManuName; }
	CFStringRef		GetAUName () const { SetCompNames (); return mAUName ? mAUName : mCompName; }
		
		// Return value of NULL indicates a problem getting that information from the component
	CFStringRef		GetCompName () const { SetCompNames(); return mCompName; }
	CFStringRef		GetCompInfo () const { SetCompInfo(); return mCompInfo; }
	
	const CAComponentDescription&	Desc () const { return mDesc; }
			
	OSStatus		Open (ComponentInstance& outInst) const 
	{
		return OpenAComponent (Comp(), &outInst);
  	}

	OSStatus			GetResourceVersion (UInt32 &outVersion) const;
	
	const Component&		Comp() const { return mComp; }
	
	void			Print(FILE* file = stdout) const;

	OSStatus			Save (CFPropertyListRef *outData) const;
		
	OSStatus			Restore (CFPropertyListRef &inData);
	
private:
	Component mComp;
	CAComponentDescription mDesc;
	
	CFStringRef mManuName, mAUName, mCompName, mCompInfo;

	void	SetCompNames () const;
	void	SetCompInfo () const;
	void	Clear ();
};

#endif
