/*=============================================================================
	CADebugMacros.cp

	$Log: CADebugMacros.cpp,v $
	Revision 1.1  2004/08/23 06:22:35  jcm10
	first checked in
	
	Revision 1.2  2004/08/02 18:45:35  dwyatt
	add LogWarning
	
	Revision 1.1  2002/03/01 01:53:26  jcm10
	moved here from ../Utility
	
	Revision 1.1  2002/02/28 23:33:30  jcm10
	renamed from DebugMacros.h for consistency
	
	Revision 1.3  2001/07/26 21:36:28  dwyatt
	AudioConverter for SRC munges
	
	Revision 1.2  2001/07/24 22:51:25  jcm10
	always include stdio.h here
	
	Revision 1.1  2000/12/01 18:11:06  dwyatt
	initial checkin
	
		
	$NoKeywords: $
=============================================================================*/

#include "CADebugMacros.h"
#include <stdio.h>
#include <stdarg.h>
#if TARGET_API_MAC_OSX
	#include <syslog.h>
#endif

#if DEBUG
#include <stdio.h>

void	DebugPrint(const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
	vprintf(fmt, args);
	va_end(args);
}
#endif // DEBUG

#if TARGET_API_MAC_OSX
void	LogError(const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
#if DEBUG
	vprintf(fmt, args);
#endif
	vsyslog(LOG_ERR, fmt, args);
	va_end(args);
}

void	LogWarning(const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
#if DEBUG
	vprintf(fmt, args);
#endif
	vsyslog(LOG_WARNING, fmt, args);
	va_end(args);
}
#endif
