/*=============================================================================
	CADebugPrintf.h

	$Log: CADebugPrintf.h,v $
	Revision 1.2.4.1  2005/04/21 21:25:35  dwyatt
	CA_Tiger branch wasn't laid down in the right place for a few files
	
	Revision 1.4  2005/03/16 02:05:02  jcm10
	give DebugPrintfLineEnding a proper definition everywhere
	
	Revision 1.3  2005/03/15 22:49:48  jcm10
	add DebugPrintfLineEnding
	
	Revision 1.2  2004/08/25 02:26:47  jcm10
	add support for logging to a side file
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.1  2002/02/28 23:18:53  jcm10
	added the CA prefix to the files for more consistency
	
	Revision 0.0  Thu Feb 28 2002 14:51:10 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CADebugPrintf_h__)
#define __CADebugPrintf_h__

//=============================================================================
//	Macros to redirect debugging output to various logging services
//=============================================================================

//#define	CoreAudio_UseSysLog		1
//#define	CoreAudio_UseSideFile	"/CoreAudio-%d.txt"

#if	DEBUG || CoreAudio_Debug
	
	#if	CoreAudio_UseSysLog
		#include <sys/syslog.h>
		#define	DebugPrintfRtn	syslog
		#define	DebugPrintfFile	LOG_ERR
		#define	DebugPrintfLineEnding	""
	#elif defined(CoreAudio_UseSideFile)
		#include <stdio.h>
		#if defined(__cplusplus)
		extern "C"
		#endif
		void OpenDebugPrintfSideFile();
		extern FILE* sDebugPrintfSideFile;
		#define	DebugPrintfRtn	fprintf
		#define	DebugPrintfFile	((sDebugPrintfSideFile != NULL) ? sDebugPrintfSideFile : stderr)
		#define	DebugPrintfLineEnding	"\n"
	#else
		#include <stdio.h>
		#define	DebugPrintfRtn	fprintf
		#define	DebugPrintfFile	stderr
		#define	DebugPrintfLineEnding	"\n"
	#endif

#else
		#define	DebugPrintfRtn	
		#define	DebugPrintfFile	
		#define	DebugPrintfLineEnding	
#endif


#endif
