/*=============================================================================
	CADebugger.cp

	$Log: CADebugger.cpp,v $
	Revision 1.1  2004/08/23 06:22:35  jcm10
	first checked in
	
	Revision 1.3  2002/12/16 20:33:57  jcm10
	on X, use signal() directly rather than calling Debugger()
	
	Revision 1.2  2002/12/14 23:59:27  jcm10
	make this stuff C-compatible so it can be in a pre-compiled header
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.4  2002/02/11 17:27:45  dwyatt
	include CoreServices.h to get 'pascal' defined
	
	Revision 1.3  2001/12/14 00:02:00  jcm10
	make the look up of DebugStr only for the HAL
	
	Revision 1.2  2001/04/10 18:59:53  jcm10
	rename a few things for consistancy
	
	Revision 1.1  2001/04/10 02:25:44  jcm10
	first checked in
	
	Revision 0.0  2001/04/09 16:12:43  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CADebugger.h"
#include "CAConditionalMacros.h"

//	on X, use the Unix routine, otherwise use Debugger()
#if TARGET_API_MAC_OSX
	#include <signal.h>
#else
	#include <MacTypes.h>
#endif

//=============================================================================
//	CADebugger
//=============================================================================

void	CADebuggerStop()
{
	#if	CoreAudio_Debug
		#if	TARGET_API_MAC_OSX
			raise(SIGINT);
		#else
			Debugger();
		#endif
	#endif
}
