/*=============================================================================
	CAException.h

	$Log: CAException.h,v $
	Revision 1.5  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.4  2003/05/21 00:50:14  asynth
	un-break PlayAudioFile.
	
	Revision 1.3  2003/05/20 00:25:58  ealdrich
	Qualify include of CoreAudioTypes.h so it works on Windows.
	
	Revision 1.2  2002/11/27 22:31:58  jcm10
	add CATry and CACatch macros to make my ObjC life a little easier
	
	Revision 1.1  2002/05/18 01:06:09  bills
	moved files to public utils
	
	Revision 1.7  2002/04/18 02:19:52  jcm10
	clean up the header inclusion
	
	Revision 1.6  2001/01/08 23:51:04  jcm10
	remove #pragma once, since gcc claims it to be obsolete and issues an annoying warning to that effect when all warnings are enabled
	
	Revision 1.5  2000/09/12 23:15:26  jcm10
	use CoreAudioTypes.h
	
	Revision 1.4  2000/08/08 22:31:52  jcm10
	back out OS9 stuff
	
	Revision 1.3  2000/08/08 18:25:04  jcm10
	make it compile on 9
	
	Revision 1.2  2000/08/01 19:24:53  jcm10
	remove dependancies on CarbonCore from CoreAudio
	
	Revision 1.1  2000/03/29 20:14:22  jcm10
	rename AHException to CAException
	
	Revision 1.1  2000/03/22 20:54:12  jacklin
	First checked in...
	
		
		0     1/1/00 8:42 PM Jeff Moore
		created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAException_h__)
#define __CAException_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include "CoreAudioTypes.h"
#endif

//=============================================================================
//	CAException
//=============================================================================

class CAException
{

public:
					CAException(OSStatus inError) : mError(inError) {}
					CAException(const CAException& inException) : mError(inException.mError) {}
	CAException&	operator=(const CAException& inException) { mError = inException.mError; return *this; }
					~CAException() {}

	OSStatus		GetError() const { return mError; }
	
protected:
	OSStatus		mError;
};

#define	CATry		try{
#define CACatch		}catch(const CAException& inException) {} catch(...) {}

#endif
