/*==================================================================================================
	CAHALAudioObject.h

	$Log: CAHALAudioObject.h,v $
	Revision 1.1  2005/02/14 05:38:13  jcm10
	first checked in
	
	Revision 0.0  2/12/05 11:26:51 PM  moorf
	Created
		
	$NoKeywords: $
==================================================================================================*/
#if !defined(__CAHALAudioObject_h__)
#define __CAHALAudioObject_h__

//==================================================================================================
//	Includes
//==================================================================================================

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudio.h>
	#include <CoreFoundation/CoreFoundation.h>
#else
	#include <CoreAudio.h>
	#include <CoreFoundation.h>
#endif

//==================================================================================================
//	CAHALAudioObject
//==================================================================================================

class CAHALAudioObject
{

//	Construction/Destruction
public:
					CAHALAudioObject(AudioObjectID inObjectID);
	virtual			~CAHALAudioObject();

//	Attributes
public:
	AudioObjectID	GetObjectID() const;
	AudioClassID	GetClassID() const;
	AudioObjectID	GetOwnerObjectID() const;
	CFStringRef		CopyOwningPlugInBundleID() const;
	CFStringRef		CopyName() const;
	CFStringRef		CopyManufacturer() const;
	CFStringRef		CopyNameForElement(AudioObjectPropertyScope inScope, AudioObjectPropertyElement inElement) const;
	CFStringRef		CopyCategoryNameForElement(AudioObjectPropertyScope inScope, AudioObjectPropertyElement inElement) const;
	CFStringRef		CopyNumberNameForElement(AudioObjectPropertyScope inScope, AudioObjectPropertyElement inElement) const;

//	Owned Objects
public:
	UInt32			GetNumberOwnedObjects(AudioClassID inClass) const;
	void			GetAllOwnedObjects(AudioClassID inClass, UInt32& ioNumberObjects, AudioObjectID* ioObjectIDs) const;
	AudioObjectID	GetOwnedObjectByIndex(AudioClassID inClass, UInt32 inIndex);
	
//	Property Operations
public:
	bool			HasProperty(AudioObjectPropertyAddress& inAddress) const;
	bool			IsPropertySettable(AudioObjectPropertyAddress& inAddress) const;
	
	UInt32			GetPropertyDataSize(AudioObjectPropertyAddress& inAddress, UInt32 inQualifierDataSize, const void* inQualifierData) const;
	void			GetPropertyData(AudioObjectPropertyAddress& inAddress, UInt32 inQualifierDataSize, const void* inQualifierData, UInt32& ioDataSize, void* outData) const;
	void			SetPropertyData(AudioObjectPropertyAddress& inAddress, UInt32 inQualifierDataSize, const void* inQualifierData, UInt32 inDataSize, const void* inData);
	
	void			AddPropertyListener(AudioObjectPropertyAddress& inAddress, AudioObjectPropertyListenerProc inListenerProc, void* inClientData);
	void			RemovePropertyListener(AudioObjectPropertyAddress& inAddress, AudioObjectPropertyListenerProc inListenerProc, void* inClientData);

//	Implementation
private:
	AudioObjectID	mObjectID;

};

#endif
