/*=============================================================================
	CAHostTimeBase.cp

	$Log: CAHostTimeBase.cpp,v $
	Revision 1.22  2004/09/09 22:08:50  dwyatt
	fix typos
	
	Revision 1.21  2004/08/26 23:35:42  jcm10
	more windows cleanup
	
	Revision 1.20  2003/12/17 18:52:54  dwyatt
	renamed from CAHostTimeBase.cp
	
	Revision 1.1  2002/05/18 01:06:09  bills
	moved files to public utils
	
	Revision 1.18  2002/03/04 23:50:48  jcm10
	make GetCurrentTime be inlined too
	
	Revision 1.17  2002/03/04 20:57:41  bills
	fixes for platform, inlining and lazy init
	
	Revision 1.16  2002/03/02 20:48:37  bills
	actually "add" the DeltaHostToMics method!
	
	Revision 1.15  2002/03/02 20:46:37  bills
	add DeltaHostToMics conversion and do initialization at load:)
	
	Revision 1.14  2002/02/28 23:24:29  jcm10
	added the CA prefix to DebugMacros and LogMacros for more consistency
	
	Revision 1.13  2001/11/15 02:05:18  jcm10
	add an extern "C" around mach includes to make cpp-precomp happy
	
	Revision 1.12  2001/03/14 23:48:38  jcm10
	Lots of changes to support the new driver API
	
	Revision 1.11  2001/03/08 00:10:14  jcm10
	Select the right time base in the initialize routine for X
	
	Revision 1.10  2001/03/01 03:07:37  jcm10
	make the code fully cross-platform and use the mach routines for getting the timebase on X
	
	Revision 1.9  2001/01/19 00:49:28  jcm10
	do the coversion between Host Time and Nanoseconds without rolling over
	
	Revision 1.8  2001/01/18 02:50:51  jcm10
	use CoreAudio_Debug instead of DEBUG
	
	Revision 1.7  2000/12/10 22:20:08  jcm10
	more fixes for new driver model
	
	Revision 1.6  2000/11/22 01:29:25  jcm10
	don't use any headers from a sub-framework, like CarbonCore. Use the umbrella's header instead.
	
	Revision 1.5  2000/11/21 19:48:17  jcm10
	turn off the logging
	
	Revision 1.4  2000/10/12 00:17:10  jcm10
	do it in the conversion routine too
	
	Revision 1.3  2000/10/11 22:40:03  jcm10
	calculate the frequency using the From values because the To values don't seem to be getting set
	
	Revision 1.2  2000/10/04 19:58:55  jcm10
	Add conversion routines to CAHostTimeBase
	
	Revision 1.1  2000/09/24 01:12:11  jcm10
	first checked in
	
	Revision 0.0  2000/01/01 12:34:56  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CAHostTimeBase.h"

Float64	CAHostTimeBase::sFrequency = 0;
UInt32	CAHostTimeBase::sMinDelta = 0;
UInt32	CAHostTimeBase::sToNanosNumerator = 0;
UInt32	CAHostTimeBase::sToNanosDenominator = 0;
UInt32	CAHostTimeBase::sFromNanosNumerator = 0;
UInt32	CAHostTimeBase::sFromNanosDenominator = 0;
bool	CAHostTimeBase::sUseMicroseconds = false;
bool	CAHostTimeBase::sIsInited = false;
#if Track_Host_TimeBase
UInt64	CAHostTimeBase::sLastTime = 0;
#endif

//=============================================================================
//	CAHostTimeBase
//
//	This class provides platform independent access to the host's time base.
//=============================================================================

void	CAHostTimeBase::Initialize()
{
	//	get the info about Absolute time
	#if TARGET_OS_MAC
		struct mach_timebase_info	theTimeBaseInfo;
		mach_timebase_info(&theTimeBaseInfo);
		sMinDelta = 1;
		sToNanosNumerator = theTimeBaseInfo.numer;
		sToNanosDenominator = theTimeBaseInfo.denom;
		sFromNanosNumerator = sToNanosDenominator;
		sFromNanosDenominator = sToNanosNumerator;

		//	the frequency of that clock is: (sToNanosDenominator / sToNanosNumerator) * 10^9
		sFrequency = static_cast<Float64>(sToNanosDenominator) / static_cast<Float64>(sToNanosNumerator);
		sFrequency *= 1000000000.0;
	#elif TARGET_OS_WIN32
		LARGE_INTEGER theFrequency;
		QueryPerformanceFrequency(&theFrequency);
		sMinDelta = 1;
		sToNanosNumerator = 1000000000ULL;
		sToNanosDenominator = *((UInt64*)&theFrequency);
		sFromNanosNumerator = sToNanosDenominator;
		sFromNanosDenominator = sToNanosNumerator;
		sFrequency = static_cast<Float64>(*((UInt64*)&theFrequency));
	#endif

	
	#if	Log_Host_Time_Base_Parameters
		DebugMessage(  "Host Time Base Parameters");
		DebugMessageN1(" Minimum Delta:          %lu", sMinDelta);
		DebugMessageN1(" Frequency:              %f", sFrequency);
		DebugMessageN1(" To Nanos Numerator:     %lu", sToNanosNumerator);
		DebugMessageN1(" To Nanos Denominator:   %lu", sToNanosDenominator);
		DebugMessageN1(" From Nanos Numerator:   %lu", sFromNanosNumerator);
		DebugMessageN1(" From Nanos Denominator: %lu", sFromNanosDenominator);
	#endif

	sIsInited = true;
}
