/*=============================================================================
	CALatencyLog.h

	$Log: CALatencyLog.h,v $
	Revision 1.5  2004/12/12 22:32:18  jcm10
	update to Tiger latency code
	
	Revision 1.4  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.3  2003/10/23 00:03:25  bills
	some tweaks
	
	Revision 1.2  2002/07/13 01:42:31  jcm10
	make the latency logs available via properties
	
	Revision 1.1  2002/07/11 23:36:21  jcm10
	first checked in
	
	Revision 0.0  Thu Jul 11 2002 15:13:52 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CALatencyLog_h__)
#define __CALatencyLog_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif
#include <limits.h>
#include <unistd.h>

//=============================================================================
//	CALatencyLog
//=============================================================================

class CALatencyLog
{

//	Construction/Destruction
public:
					CALatencyLog(const char* inLogFileName, const char* inLogFileExtension);
	virtual			~CALatencyLog();

//	Operations
public:
	void			Capture(UInt64 inStartTime, UInt64 inEndTime, bool inWriteToFile, const char* header = 0);
#if Panther_LatencyLog
	void			GetLog(char* outLog, UInt32& ioLogSize) const;
	UInt32			GetLogSize() const;
#endif
	static bool		CanUse() { return geteuid() == 0; }

//	Implementation
private:
	static void		BuildFileName(const char* inRoot, const char* inExtension, char* outFileName);

#if Panther_LatencyLog
	enum {			kLatencyBufferSize = 512 * 1024 };

	char			mBuffer[kLatencyBufferSize];
#endif
	char			mLogFileName[PATH_MAX];
#if Panther_LatencyLog
	char			mLogFileExtension[PATH_MAX];
#endif
	bool			mIsRoot;

};

#endif
