/*=============================================================================
	CALogMacros.h

	$Log: CALogMacros.h,v $
	Revision 1.4  2004/10/28 18:41:19  baron
	Make it build <jcm10>
	
	Revision 1.3  2002/09/11 19:18:42  jcm10
	make the four char code printing not call memcpy
	
	Revision 1.2  2002/04/05 23:11:08  jcm10
	print more digits in floating point numbers
	
	Revision 1.1  2002/03/01 01:53:27  jcm10
	moved here from ../Utility
	
	Revision 1.1  2002/02/28 23:18:54  jcm10
	added the CA prefix to the files for more consistency
	
	Revision 0.0  Thu Feb 28 2002 14:53:07 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CALogMacros_h__)
#define __CALogMacros_h__

//=============================================================================
//	Log Macros
//=============================================================================

#if	CoreAudio_Debug

	#include "CADebugPrintf.h"
	#include <stdio.h>
	#include <string.h>
	
	#define	PrintLine(msg)						DebugPrintfRtn(DebugPrintfFile, "%s\n", (msg))
	
	#define PrintBool(msg, b)					DebugPrintfRtn(DebugPrintfFile, "%s%s\n", (msg), (b) ? "true" : "false")
	#define PrintIndexedBool(msg, i, b)			DebugPrintfRtn(DebugPrintfFile, "  %s %ld: %s\n", (msg), (long)(i), (b) ? "true" : "false")
	
	#define PrintToggle(msg, b)					DebugPrintfRtn(DebugPrintfFile, "%s%s\n", (msg), (b) ? "on" : "off")
	#define PrintIndexedToggle(msg, i, b)		DebugPrintfRtn(DebugPrintfFile, "  %s %ld: %s\n", (msg), (long)(i), (b) ? "on" : "off")
	
	#define PrintInt(msg, n)					DebugPrintfRtn(DebugPrintfFile, "%s%ld\n", (msg), (long)(n))
	#define PrintIndexedInt(msg, i, n)			DebugPrintfRtn(DebugPrintfFile, "  %s %ld: %ld\n", (msg), (long)(i), (long)(n))
	
	#define PrintHex(msg, n)					DebugPrintfRtn(DebugPrintfFile, "%s0x%lX\n", (msg), (unsigned long)(n))
	#define PrintIndexedHex(msg, i, n)			DebugPrintfRtn(DebugPrintfFile, "  %s %ld: 0x%lX\n", (msg), (long)(i), (unsigned long)(n))
	
	#define PrintFloat(msg, f)					DebugPrintfRtn(DebugPrintfFile, "%s%.6f\n", (msg), (f))
	#define PrintIndexedFloat(msg, i, f)		DebugPrintfRtn(DebugPrintfFile, "  %s %ld: %.6f\n", (msg), (long)(i), (f))
	#define PrintFloatIndexedFloat(msg, i, f)	DebugPrintfRtn(DebugPrintfFile, "  %s %.6f: %.6f\n", (msg), (i), (f))
	
	#define	PrintString(msg, s)					DebugPrintfRtn(DebugPrintfFile, "%s%s\n", (msg), (s))
	#define PrintIndexedString(msg, i, s)		DebugPrintfRtn(DebugPrintfFile, "  %s %ld: %s\n", (msg), (long)(i), (s))
	
	#define PrintPointer(msg, p)				DebugPrintfRtn(DebugPrintfFile, "%s%p\n", (msg), (p))
	#define PrintIndexedPointer(msg, i, p)		DebugPrintfRtn(DebugPrintfFile, "  %s %ld: %p\n", (msg), (long)(i), (p))
	
	#define	Print4CharCode(msg, c)				{																								\
													UInt32 __4CC_number = (c);																	\
													char __4CC_string[5];																		\
													*((SInt32*)__4CC_string) = __4CC_number;													\
													__4CC_string[4] = 0;																		\
													DebugPrintfRtn(DebugPrintfFile, "%s'%s'\n", (msg), __4CC_string);							\
												}
	#define PrintIndexed4CharCode(msg, i, c)	{																								\
													UInt32 __4CC_number = (c);																	\
													char __4CC_string[5];																		\
													*((SInt32*)__4CC_string) = __4CC_number;													\
													__4CC_string[4] = 0;																		\
													DebugPrintfRtn(DebugPrintfFile, "  %s %ld: '%s'\n", (msg), (long)(i), __4CC_string);		\
												}
	
	#define	ErrorLine(s)						DebugPrintfRtn(DebugPrintfFile, "%s\n", (s))
	#define	OSErrorLine(s, e)					{																								\
													OSStatus __err_number = (e);																\
													char __err_string[5];																		\
													memcpy(__err_string, &__err_number, 4);														\
													__err_string[4] = 0;																		\
													DebugPrintfRtn(DebugPrintfFile, "%s, OSStatus code: %s\n", (s), __err_string);				\
												}
	
	#define	MessageIfOSError(e, s)				if((e) != 0) { OSErrorLine(s, e); }
	#define	MessageIfNULL(p, s)					if((p) == 0) { ErrorLine(s); }

#else

	#define	PrintLine(msg)					
	
	#define PrintBool(msg, b)					(b)
	#define PrintIndexedBool(msg, i, b)			(b)
	
	#define PrintInt(msg, n)					(n)
	#define PrintIndexedInt(msg, i, n)			(n)
	
	#define PrintHex(msg, n)					(n)
	#define PrintIndexedHex(msg, i, n)			(n)
	
	#define PrintFloat(msg, f)					(f)
	#define PrintIndexedFloat(msg, i, f)		(f)
	#define PrintFloatIndexedFloat(msg, i, f)	(f)
	
	#define	PrintString(msg, s)					(s)
	#define PrintIndexedString(msg, i, s)		(s)
	
	#define PrintPointer(msg, p)				(p)
	#define PrintIndexedPointer(msg, i, p)		(p)
	
	#define	Print4CharCode(msg, c)				(c)
	#define PrintIndexed4CharCode(msg, i, c)	(c)
	
	#define	ErrorLine(s)						(s)
	#define	OSErrorLine(s, e)					(e)
	
	#define	MessageIfOSError(e, s)				(e)
	#define	MessageIfNULL(p, s)					(p)

#endif	//	CoreAudio_Debug

#endif
