/*=============================================================================
	CAMIDIEndpointMenu2.h
	
	$Log: CAMIDIEndpointMenu2.h,v $
	Revision 1.1  2004/10/04 23:11:12  dwyatt
	initial checkin
	
	created 10/3/04, Doug Wyatt
	Copyright (c) 2004 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#import <AppKit/AppKit.h>
#include <CoreMIDI/MIDIServices.h>

// **********************************************************
// This variant of CAMIDIEndpointMenu requires Tiger or later
// **********************************************************

#if defined(MACOS_VERSION_MAX_ALLOWED) && defined(MAC_OS_X_VERSION_10_4) && MACOS_VERSION_MAX_ALLOWED < MAC_OS_X_VERSION_10_4
	#warning CAMIDIEndpointMenu2 requires Mac OS X 10.4 or higher - check AvailabilityMacros
#endif

enum {
	kMIDIEndpointMenuSources = 0,
	kMIDIEndpointMenuDestinations = 1
};

enum {
	// option flags
	kMIDIEndpointMenuOpt_SortByName						= 1,
	kMIDIEndpointMenuOpt_IncludeUnconnectedExternalPorts = 2,
	kMIDIEndpointMenuOpt_CombineByPort					= 4,		// when multiple devices connected to a port,
																// present only a single endpoint
	kMIDIEndpointMenuOpt_CanSelectNone					= 0x80000000
};

@interface CAMIDIEndpointMenu : NSPopUpButton {
	BOOL			mInited;
	int				mType;
	int				mOptions;
	MIDIUniqueID	mSelectedUniqueID;
}

- (void)buildMenu: (int)type opts: (int)opts;
	// type is kMIDIEndpointMenuSources...
	// opts is option flags above
- (void)rebuildMenu;
	// called automatically when setup changes

- (MIDIEndpointRef)selectedEndpoint;
- (MIDIUniqueID)selectedUniqueID;
	// kMIDIInvalidUniqueID if none

- (BOOL)selectUniqueID: (MIDIUniqueID)uniqueID;
	// returns YES if the item exists

@end
