/*=============================================================================
	CASMPTETimeBase.h
	
	$Log: CASMPTETimeBase.h,v $
	Revision 1.4  2004/09/29 00:10:21  dwyatt
	rename ParseFrame -> HMSFToAbsoluteFrame
	
	Revision 1.3  2004/08/23 06:23:25  jcm10
	make it build on Windows
	
	Revision 1.2  2004/06/14 21:45:09  dwyatt
	renaming & cleanup
	
	Revision 1.1  2004/05/06 01:48:57  dwyatt
	initial checkin
	
	created Tue May 04 2004, Doug Wyatt
	Copyright (c) 2004 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CASMPTETimeBase_h__
#define __CASMPTETimeBase_h__

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

typedef UInt32 SMPTE_HMSF;  // nibbles: hhmmssff

class CASMPTETimeBase {
public:
	// Initialization
	CASMPTETimeBase(UInt32 format = kSMPTETimeType2997) { SetFormat(format); }

	bool	SetFormat(UInt32 format);
				// return true if format is valid
	
	// Accessors
	
	UInt32  GetFormat() const { return mFormat; }
	double  GetFramesPerSecond() const { return mFramesPerSecond; }				// e.g. 24, 25, 29.97, 30, 59.94, 60
	int		GetFormatFramesPerSecond() const { return mFormatFramesPerSecond; } // e.g. 24, 25, 30, 60
	int		GetMTCType() const { return mMTCType; }

	// Conversions

	void	SecondsToSMPTETime( Float64					inSeconds,
								UInt16					inSubframeDivisor,
								SMPTETime &				outSMPTETime) const;
	
	bool	SMPTETimeToSeconds( const SMPTETime &		inSMPTETime,
								Float64 &				outSeconds) const;
				// return true for success; false if the smpte time is invalid
				// This member method ignores inSMPTETime's mType.
	
	UInt32		HMSFToAbsoluteFrame(SMPTE_HMSF			inHMSF) const;
				// convert a 32-bit hhmmssff representation to number of frames since 0
	
	SMPTE_HMSF  AdvanceFrame(		SMPTE_HMSF			inHMSF, int nToAdvance) const;
				// increment a 32-bit hhmmssff representation to the next frame number, returning it
	
private:
	UInt32				mFormat;
	bool				mIsDropFrame;
	int					mMTCType;				// 0=24, 1=24, 2=30 DF, 3=30 ND, -1=other
	double				mFramesPerSecond;
	int					mFormatFramesPerSecond;
};

#endif // __CASMPTETimeBase_h__
