/*=============================================================================
	CASharedLibrary.h

	$Log: CASharedLibrary.h,v $
	Revision 1.2  2003/08/19 23:10:06  jcm10
	add GetRoutineAddressIfLibraryLoaded()
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.6  2001/06/22 01:28:04  jcm10
	get rid of the run time stuff and decide which API to use
	based on whether or not the Image based APIs are
	defined at compile time
	
	Revision 1.5  2001/06/20 21:20:10  jcm10
	make the choice between the Cheetah and Puma DYLD
	APIs at run time rather than compile time
	
	Revision 1.4  2001/06/13 00:40:56  jcm10
	remove GetRouineAddress() since it can't support the new
	dyld stuff and make LoadLibraryAndGetRoutineAddress()
	use the new dyld stuff.
	
	Revision 1.3  2001/03/08 03:03:05  jcm10
	add a path to the load library call
	
	Revision 1.2  2001/03/08 02:39:24  jcm10
	add LoadLibraryAndGetRoutineAddress
	
	Revision 1.1  2001/02/21 20:41:14  jcm10
	first checked in
	
	Revision 0.0  2001/02/21 12:19:02  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CASharedLibrary_h__)
#define __CASharedLibrary_h__

//=============================================================================
//	CASharedLibrary
//=============================================================================

class CASharedLibrary
{

//	Symbol Operations
public:
	static void*	LoadLibraryAndGetRoutineAddress(const char* inRoutineName, const char* inLibraryName, const char* inLibraryPath);
	static void*	GetRoutineAddressIfLibraryLoaded(const char* inRoutineName, const char* inLibraryName, const char* inLibraryPath);

};

#endif
