/*=============================================================================
	CAVectorUnit.cpp
	
	$Log: CAVectorUnit.cpp,v $
	Revision 1.2  2005/07/09 00:20:19  dwyatt
	don't use SUPPORT_AU_V1, fix uninitialized result in X86
	
	Revision 1.1  2005/07/08 00:12:54  asynth
	add CAVectorUnit
	
	
	created 07/06/05, James McCartney
	Copyright (c) 2005 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#include <CAConditionalMacros.h>

#if TARGET_API_MAC_OSX
	#include <CoreServices/CoreServices.h>
// ??? #else
#endif

#include "CAVectorUnit.h"

int CAVectorUnit::sVectorUnitType = kVecUninitialized;

SInt32	CAVectorUnit::CheckVectorUnit()
{
	int result = kVecNone;
	
#if DEBUG
	if (getenv("CA_NoVector")) {
		fprintf(stderr, "CA_NoVector set; Vector unit optimized routines will be bypassed\n");
		return result;
	} 
	else
#endif
	{
		long 	cpuFeatures;
#if TARGET_CPU_PPC
		OSErr	err = ::Gestalt(gestaltPowerPCProcessorFeatures, &cpuFeatures );
		result = (err == noErr && ( cpuFeatures & ( 1 << gestaltPowerPCHasVectorInstructions ) ) != 0 );
#else
		OSErr	err = ::Gestalt(gestaltX86Features, &cpuFeatures );
		if (err == noErr && (cpuFeatures & ( 1 << gestaltX86HasSSE2 ) )  != 0 ) result = kVecSSE2;
		err = ::Gestalt(gestaltX86AdditionalFeatures, &cpuFeatures );
		if (err == noErr && (cpuFeatures & ( 1 << gestaltX86HasSSE3 ) )  != 0 ) result = kVecSSE3;
#endif
	}
	sVectorUnitType = result;
	return result;
}

