/*=============================================================================
	CAVectorUnit.h
	
	$Log: CAVectorUnit.h,v $
	Revision 1.2  2005/07/09 00:02:48  asynth
	add CAVectorUnitTypes.h
	
	Revision 1.1  2005/07/08 00:12:54  asynth
	add CAVectorUnit
	

	created 07/06/05, James McCartney
	Copyright (c) 2005 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CAVectorUnit_h__
#define __CAVectorUnit_h__

#include "CAVectorUnitTypes.h"

// Unify checks for vector units into a single function.
// Allow setting an environment variable "CA_NoVector" to turn off vectorized code at runtime (very useful for performance testing).

class CAVectorUnit {
public:
	static SInt32		GetVectorUnitType() { int x = sVectorUnitType; return (x != kVecUninitialized) ? x : CheckVectorUnit(); }
	static bool			HasVectorUnit() { return GetVectorUnitType() > kVecNone; }
	static bool			HasAltivec() { return GetVectorUnitType() == kVecAltivec; }
	static bool			HasSSE2() { return GetVectorUnitType() >= kVecSSE2; }
	static bool			HasSSE3() { return GetVectorUnitType() == kVecSSE3; }

private:
	static SInt32		CheckVectorUnit();
	
	static int sVectorUnitType;
};

#endif // __CAVectorUnit_h__
