/*=============================================================================
*  CAFileBrowser.h
*  PlayPen
*-----------------------------------------------------------------------------
*
* $Log: CAFileBrowser.h,v $
* Revision 1.5.2.2  2005/08/12 00:41:56  mhopkins
* Pull latest version from TOT
*
* Revision 1.7  2005/06/03 19:26:19  luke
* cache & restore opened-item state across 'rescanFile' calls
*
* Revision 1.6  2005/06/03 05:43:15  luke
* allow right-clicking on a preset name to allow user to change preset name to file name if the two are not equal
*
* Revision 1.5  2005/05/02 17:47:43  luke
* don't invoke renaming bahvior if user is pressing keys
*
* Revision 1.4  2005/04/21 00:22:47  luke
* fix gcc 4.0 break
*
* Revision 1.3  2004/12/19 20:27:18  luke
* add 'presetName:ExistsAsChildOf:' method
*
* Revision 1.2  2004/11/16 17:36:17  luke
* last part of fix for [3747338]
*
* Revision 1.1  2004/07/29 00:21:15  luke
* factored out from PlayPen
*
* Revision 1.10  2004/07/28 23:57:20  luke
* pass 3: final
*
* Revision 1.9  2004/07/28 21:43:26  luke
* 2nd pass: CAFileBrowser API breakup
*
* Revision 1.8  2004/07/28 20:50:15  luke
* first pass: transition into approved API
*
* Revision 1.7  2004/07/02 01:02:31  mhopkins
* Fixed hang renaming files
*
* Revision 1.6  2004/06/24 23:21:30  mhopkins
* added methods to return name and data key strings
*
* Revision 1.5  2004/05/27 22:56:16  luke
* sync with changes to .mm file
*
* Revision 1.4  2004/05/26 21:09:54  luke
* add hasPresets method
*
* Revision 1.3  2004/05/26 19:41:23  luke
* fix font clipping
*
* Revision 1.2  2004/05/25 22:25:19  luke
* allow preset renaming (per [3616417])
*
* Revision 1.1  2004/04/17 20:05:20  luke
* source reorg.
*
* Revision 1.8  2003/12/18 19:48:29  luke
* push directory-creation code into CAFileBrowser superclass
*
* Revision 1.7  2003/11/06 19:28:23  luke
* pull 'savePresetWithName:asLocal: into superclass
*
* Revision 1.6  2003/10/22 22:17:32  luke
* add path accessor
*
* Revision 1.5  2003/10/21 23:28:26  luke
* added features that future subclasses may need
*
* Revision 1.4  2003/10/21 22:03:31  luke
* inherit from NSOutlineView & change some behavior per discussion with Bill
*
* Revision 1.3  2003/10/15 16:56:43  luke
* tighten up code.
*
* Revision 1.2  2003/10/15 00:46:03  luke
* tighten up code
*
* Revision 1.1  2003/10/15 00:12:30  luke
* new file
*
*
*-----------------------------------------------------------------------------
*  Created by Luke Bellandi on Tue Oct 14 2003.
*  Copyright (c) 2003 Apple Computer Inc. All rights reserved.
*=============================================================================*/

#import <Cocoa/Cocoa.h>

extern NSString *CARootUserDirectory;
extern NSString *CARootLocalDirectory;
extern NSString *CARootNetworkDirectory;

class CAFileHandling;

@interface CAFileBrowser : NSOutlineView {
	@protected
    NSTextFieldCell *		mCell;
	NSString *				mCachedRenameValue;
	
    CAFileHandling *		mFileHandler;
    
    NSMutableArray *		mBrowserTreeList;
    NSMutableArray *		mOutlineViewDataRetentionPool;
	
	BOOL					mBrowserWasDoubleClicked;
	BOOL					mKeysWerePressed;
	BOOL					mFileIsBeingRenamed;
	
	BOOL					mScanNetworkForFiles;
	
	// preset name vs. file name member holders
	CFTreeRef				mPresetToRename;
	NSString *				mPresetFileName;
	
	// cached-across-reload state
	NSArray *				mCachedOpenItemsState;
	int						mCachedSelectedRow;
}

// public functions
- (id)initWithFrame:(NSRect)inRect shouldScanNetworkForFiles:(BOOL)shouldScanNetworkForFiles;
	// scanning the network can prove time-consuming for some users, so we leave it
	// up to the client whether or not to scan it.

- (BOOL)scansNetworkForFiles;
	// self explanatory

- (NSURL *)URLForItem:(id)item;
	// returns autoreleased URL

- (CFPropertyListRef)readPropertyListForItem:(id)item;
	// client is responsible for releasing returned CFPropertyListRef
	// returns NULL if property list could not be retrieved

- (BOOL)presetName:(NSString *)inPresetName existsAsChildOf:(id)item;
	// use before calling savePresetWithName:asChildOf: to detect a potential overwrite

- (BOOL)savePresetWithName:(NSString *)inPresetName asChildOf:(id)item;
    // subclasses should implement this method to save appropriate
	// data at the location specified by the client.
	// returns: YES if operation was successful

- (NSArray *)expandedItems;
	// returns a storable array of the expanded items in the CAFileBrowser.
	// This can be saved to disk or cached to restore the items-expanded state
	// of the CAFileBrowser across calls to rescanFiles -- which loses the
	// expanded-items state of the CAFileBrowser -- or across app launches.
- (void)setExpandedItems:(NSArray *)inOpenedItems;
	// restores the CAFileBrowser's items-expanded state from an array retrieved
	// from an earlier call to expandedItems.

- (BOOL)createDirectory:(NSString *)inName asChildOfItem:(id)parent;
	// creates an empty directory as a child of the specified item
	// (specified item must be a directory.)
	// returns: YES if operation was successful

- (void)rescanFiles;
	// implemented by subclasses to rescan file system to pick up any
	// changes made on disk and integrate those into the hierarchy.
	// Subclasses should delete their CAFileHandlingObject here,
	// create a new one, and reset it using the protected
	// setCAFileHandlingObject method.

@end
