/*=============================================================================
*  CAFileBrowser_Protected.h
*  PlayPen
*-----------------------------------------------------------------------------
*
* $Log: CAFileBrowser_Protected.h,v $
* Revision 1.2.4.1  2005/08/12 00:42:44  mhopkins
* Pull latest version from TOT
*
* Revision 1.3  2005/06/03 19:24:56  luke
* add unsetCAFileHandlingObject method to alert CAFileBrowser when its CAFileHandling object should be considered invalid
*
* Revision 1.2  2004/11/13 17:46:17  luke
* removed NSAsserts & better handling errors
*
* Revision 1.1  2004/07/29 00:21:15  luke
* factored out from PlayPen
*
* Revision 1.2  2004/07/28 23:57:20  luke
* pass 3: final
*
* Revision 1.1  2004/07/28 21:43:33  luke
* new file
*
*
*-----------------------------------------------------------------------------
*  Created by Luke Bellandi on Wed Jul 28 2004.
*  Copyright (c) 2004 Apple Computer Inc. All rights reserved.
*=============================================================================*/

@interface CAFileBrowser(Protected)
#pragma mark ____ PUBLIC FUNCTIONS ____
- (BOOL)writePropertyList:(CFPropertyListRef)inPropertyList withName:(NSString *)inName asChildOfItem:(id)parent;
	// typically called by subclasses in their overridden method:
	// - (BOOL)savePresetWithName:(NSString *)inPresetName asChildOf:(id)item;
	// where the subclass produces the CFPropertyListRef, and passes the other
	// arguments through for CAFileBrowser to handle.

- (void)setCAFileHandlingObject:(CAFileHandling *)inCAFileHandlingObject;
	// called by subclasses to set the CAFileHandling derivative object they've
	// created for display.  CAFileBrowser just keeps a reference to that object,
	// so it's the subclass' responsibility to keep that object alive for the
	// duration of the lifespan of this, its superclass.

- (void)unsetCAFileHandlingObject;
	// called by subclasses before deleting the CAFileHandling object previously set
	// on them.  It is essential that this call be made before subsequent calls to
	// setCAFileHandlingObject are made.

- (CAFileHandling *)CAFileHandlingObject;
	// get current CAFileHandling object;

- (void)setTitle:(NSString *)inTitle;
	// Pass in string to use for outlineView's title.
- (NSString *)title;
	// String being used for outlineView's title.

- (BOOL)itemWasActivated:(id)object;
	// subclasses should override to implement any desired functionality when a user
	// double-clicks on an item in the outline view.  Because of the way CAFileBrowser
	// handles events, clients should NOT override setTarget:, setAction:,
	// setDoubleAction:, or other event handling methods.

- (NSString *)fileExtension;
	// subclasses should override to return the name of the preset file extension
	// (without the '.')

- (NSString *)nameKeyString;
	// subclasses should override to return the name of the key (usually "name") whose
	// value is the name of the preset.

- (BOOL)shouldAllowItemRenaming:(id)item;
	// subclasses may override to allow presets to be (selectively) renamed.
	// default returns YES for all items

@end
