/*=============================================================================
	CAMIDIEndpointMenu.h
	
	$Log: CAMIDIEndpointMenu.h,v $
	Revision 1.2  2004/09/04 21:22:00  dwyatt
	add accessor to get the CAMIDIEndpoints being used
	
	Revision 1.1  2004/06/23 19:07:11  dwyatt
	initial checkin
	
	created Mon Apr 19 2004, Doug Wyatt
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#import <AppKit/AppKit.h>
#include <CoreMIDI/MIDIServices.h>

enum {
	kMIDIEndpointMenuSources = 0,
	kMIDIEndpointMenuDestinations = 1,
	kMIDIEndpointMenuPairs = 2
};

enum {
	kMIDIEndpointMenuOpt_SortByName						= 1,
	kMIDIEndpointMenuOpt_IncludeUnconnectedExternalPorts = 2,
	kMIDIEndpointMenuOpt_CombineByPort					= 4,		// when multiple devices connected to a port,
																// present only a single endpoint
	kMIDIEndpointMenuOpt_CanSelectNone					= 0x80000000
};

#ifdef __cplusplus
class CAMIDIEndpoints;
#else
struct CAMIDIEndpoints;
#endif

@interface CAMIDIEndpointMenu : NSPopUpButton {
	void *			_endpointInfo;
	BOOL			mInited;
	int				mType;
	int				mOptions;
	MIDIUniqueID	mSelection;
	NSString *		mSelectionName;
}

- (void)buildMenu: (int)type opts: (int)opts;
	// type is kMIDIEndpointMenuSources...
- (void)rebuildMenu;
	// called automatically when setup changes

- (MIDIEndpointRef)selectedEndpoint;
- (MIDIUniqueID)selectedUniqueID;
	// kMIDIInvalidUniqueID if none
- (void)selectedEndpointPair: (MIDIEndpointRef *)outSource dest: (MIDIEndpointRef *)outDest;

- (BOOL)selectUniqueID: (MIDIUniqueID)uniqueID;
	// returns YES if the item exists

+ (CAMIDIEndpoints *)getEndpoints;

@end
