/*=============================================================================

	oalBuffer.h
	al_osx
	
	Created by Bob Aron on Mon Oct 13 2003.
	Copyright (c) 2003 Apple Computer Inc. All rights reserved.
 
 	$Log: oalBuffer.h,v $
 	Revision 1.8  2004/03/19 22:42:07  baron
 	Add BSD License and clean up comments before submitting to Open Source (Creative).
 	
 	Revision 1.7  2004/01/23 06:10:10  baron
 	Remember the original size and format of audio data when it gets converted on the way into OAL.
 	
 	Revision 1.6  2004/01/20 22:27:10  baron
 	fix comment
 	
 	Revision 1.5  2003/12/11 22:58:18  baron
 	Add a mDataHasBeenConverted field to the OALBuffer struct. So the Render proc knows to use an AudioConverter or not
 	
 	Revision 1.4  2003/12/09 01:26:22  baron
 	more cleanup.
 	
 	Revision 1.3  2003/12/03 23:17:09  baron
 	Add some doppler support and clean up comments
 	
 	Revision 1.2  2003/12/02 18:30:43  baron
 	Add check-in comment logging.
 		
	$NoKeywords: $

=============================================================================*/

/**********************************************************************************************************************************
*
*   OpenAL cross platform audio library
*   Copyright © 2004, Apple Computer, Inc. All rights reserved.
*
*   Redistribution and use in source and binary forms, with or without modification, are permitted provided 
*   that the following conditions are met:
*
*   1.  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
*   2.  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
*       disclaimer in the documentation and/or other materials provided with the distribution. 
*   3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of its contributors may be used to endorse or promote 
*       products derived from this software without specific prior written permission. 
*
*   THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
*   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS 
*   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
*   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
*   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
*   USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
**********************************************************************************************************************************/

#ifndef __OAL_BUFFER__
#define __OAL_BUFFER__

#include <Carbon/Carbon.h>
#include <CoreAudio/CoreAudioTypes.h>
#include <map>

struct OALBuffer{
					char							*mData;					// ptr to the actual audio data
					UInt32							mDataSize;				// size in bytes of the audio data ptr
					CAStreamBasicDescription		mDataFormat;			// format of the data of the data as it sits in memory
					UInt32							mPreConvertedDataSize;  // if data gets converted on the way in, it is necessary to remember the original size
					CAStreamBasicDescription		mPreConvertedDataFormat;// if data gets converted on the way in, it is necessary to remember the original format
					UInt32							mAttachedCount;			// count of the buffer's use across all valid source queues
					bool							mDataHasBeenConverted;	// was the data converted to the mixer format when handed to the library?
};

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#pragma mark _____OALDeviceMap_____
class OALBufferMap : std::multimap<UInt32, OALBuffer, std::less<UInt32> > {
public:
    
    void Add (const	UInt32	inBufferToken, OALBuffer *inBuffer)  
	{
		iterator it = upper_bound(inBufferToken);
		insert(it, value_type (inBufferToken, *inBuffer));
	}

    OALBuffer* Get(UInt32	inBufferToken) {
        iterator	it = find(inBufferToken);
        if (it != end())
            return (&(*it).second);
		return (NULL);
    }
    
    void Remove (const	UInt32	inBufferToken) {
        iterator 	it = find(inBufferToken);
        if (it != end())
            erase(it);
    }

    UInt32 Size () const { return size(); }
    bool Empty () const { return empty(); }
};

#endif