/*=============================================================================

	oalImp.h
	al_osx
	
	Created by Bob Aron on Mon Oct 13 2003.
	Copyright (c) 2003 Apple Computer Inc. All rights reserved.
 
 	$Log: oalImp.h,v $
 	Revision 1.10  2004/03/19 22:49:57  baron
 	Add BSD License and clean up comments before submitting to Open Source (Creative).
 	
 	Revision 1.9  2004/03/11 19:42:22  baron
 	Add extension to clamp rendering to stereo (ALC_RENDER_CHANNEL_COUNT). Merge the OAL3DGraph and OALDevice classes. General clean up.
 	
 	Revision 1.8  2004/01/29 22:02:59  baron
 	Remove ALC_SPEAKER_CONFIGURATION property and add ALC_RENDER_QUALITY property.
 	
 	Revision 1.7  2004/01/20 19:42:44  baron
 	cleanup.
 	
 	Revision 1.6  2004/01/20 00:48:08  baron
 	Add some AUTracer code.
 	
 	Revision 1.5  2004/01/06 02:00:08  baron
 	Add build flag for testing OAL with the stereo mixer.
 	
 	Revision 1.4  2003/12/17 18:31:53  baron
 	Remove Speaker Configuration from the OALEnvironment struct. This setting is per device, not per context.
 	
 	Revision 1.3  2003/12/03 23:17:09  baron
 	Add some doppler support and clean up comments
 	
 	Revision 1.2  2003/12/02 18:59:50  baron
 	Add check-in comment logging.
 	
	
	$NoKeywords: $

=============================================================================*/

/**********************************************************************************************************************************
*
*   OpenAL cross platform audio library
*   Copyright © 2004, Apple Computer, Inc. All rights reserved.
*
*   Redistribution and use in source and binary forms, with or without modification, are permitted provided 
*   that the following conditions are met:
*
*   1.  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
*   2.  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
*       disclaimer in the documentation and/or other materials provided with the distribution. 
*   3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of its contributors may be used to endorse or promote 
*       products derived from this software without specific prior written permission. 
*
*   THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
*   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS 
*   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
*   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
*   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
*   USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
**********************************************************************************************************************************/

#ifndef __OAL_IMP__
#define __OAL_IMP__

#include "al.h"
#include "alc.h"
#include "altypes.h"
#include "oalOSX.h"
#include <Carbon/Carbon.h>
#include <map>

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// development build flags
#define	USE_AU_TRACER 					0
#define LOG_GRAPH_AND_MIXER_CHANGES		0
#define GET_OVERLOAD_NOTIFICATIONS 		0
#define	LOG_IO 							0

#if LOG_IO
	#include  "AudioLogger.h"
#endif

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define AL_MAXBUFFERS 1024	
#define AL_MAXSOURCES 256 

#define kDefaultMaximumMixerBusCount    64
#define kDopplerDefault                 0	

#define	THROW_RESULT		if(result != noErr) throw static_cast<OSStatus>(result);

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/* 
	The OALEnvironmentInfo struct will define a set of parameters that should be applied to the 3DMixer 
    on a per context basis. i.e. Reverb setting, doppler, etc etc. These settings will be stored as a 
    member of the OALContext class. Upon context switching, they will be passed to the context's 
    owning OALDevice to reset the mixer.
*/

struct	OALEnvironmentInfo {
	// currently unused
};

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

UInt32	GetNewToken (void);

ALAPI ALvoid ALAPIENTRY alSetError (ALenum errorCode);

#endif

