#!/usr/bin/perl -w
##########################################
#
# ClamAV virus database listing generator
# June 2003, Ted Fines, Macalester College
#
# What it does:
# * Downloads the md5 checksums from the virus
#   definition files on the ClamAV website.
# * Computes md5 checksums of local virus
#   definitions.
# * If they don't match, it downloads new
#   definitions.
# * Read in the virus definitions files
#   and produce an HTML file of all 
#   of the viruses from the databases.
#
# Before running this, add the following 
# lines to your clamav.conf file:
#      # URLs for virus db updates
#      clamav.elektrapro.com etc. 
#      # Location for virus db output file
#      ClamdbHTML /usr/local/share/clamav/clamdb.html
#      # Location of Clamdb files
#      ClamdbFiles /usr/local/share/clamav
#      # Number of columns on output HTML file
#      ClamdbColumns 4
#
##########################################

require 'ctime.pl';

print "$0 started " . &ctime(time);
# Path to clamav.conf
my $clam_conf = '/usr/local/etc/clamav.conf';
# Url from which to grab viruses.db and viruses.db2
my $clamurl_tag = 'ClamdbURL';
# HTML Output filename
my $clamhtml_tag = 'ClamdbHTML';
# Where to keep downloaded files
my $clamdbfiles_tag = 'ClamdbFiles';
# Number of Colums in HTML file
my $clamcolumns_tag = 'ClamdbColumns';

# Name of HTML template file
my $clamdb_template = 'clamdb_template.html';
# Tag in template indicating where to start inserting data
my $htmltag = '<!-- Insert Table Rows Here -->';

my @vir_files=('viruses.db',  'viruses.db2');
 
# Read clamav.conf and get URL and filename info
my @clamurl = &Read_clam_conf;
$clamhtml = shift(@clamurl);
$clamfiles_loc = shift(@clamurl);
$clamcolumns = shift(@clamurl);
for ($i = 0; $i < scalar(@clamurl); $i +=1) {
    $clamurl[$i] = "http://" . $clamurl[$i] . "/database/";
}
if (substr($clamfiles_loc,-1,1) ne '/') {
    $clamfiles_loc .= '/';
}

@all_virs_list = &Create_virus_list;
print "INFO: Found ",scalar(@all_virs_list), " virus entries.\n";
&Generate_html_file;
print "$0 finished " . &ctime(time) . "\n";

# SUBROUTINES BEGIN HERE
     
sub Read_clam_conf {
    my @tmp = ();
    my $diemsg = "Could not determine $clamurl_tag, and/or " .
                 "$clamhtml_tag \nand/or $clamdbfiles_tag, " .
                 "and/or $clamcolumns_tag from $clam_conf.\n";
    open (CLAM,$clam_conf) || &subdie("Could not open $clam_conf. Quitting.\n");
    while (<CLAM>) {
        chomp;
        my $li=$_;
        if ($li =~ /$clamurl_tag/i) {
            if (substr($li,0,1) ne '#') {
                @clamurl = split(/\s/,$li,2);
                @clamurl = split(/\s/,$clamurl[1]);
            }
        } elsif ($li =~ /$clamhtml_tag/i) {
            if (substr($li,0,1) ne "#") {
                my @tmp = split ;
                $clamhtml= $tmp[1];
            }
        } elsif ($li =~ /$clamdbfiles_tag/i) {
            if (substr($li,0,1) ne "#") {
                my @tmp = split ;
                $clamfiles_loc= $tmp[1];
            }
        } elsif ($li =~ /$clamcolumns_tag/i) {
            if (substr($li,0,1) ne "#") {
                my @tmp = split ;
                $clamcolumns= $tmp[1];
            }
        }
    }
    close CLAM;
    if (defined($clamhtml) && defined($clamfiles_loc) &&
        defined($clamcolumns)) {
        if ($clamhtml ne $clamhtml_tag &&
         $clamfiles_loc ne $clamdbfiles_tag && 
         $clamcolumns ne $clamcolumns_tag &&
         scalar(@clamurl) > 0) {
            return ($clamhtml, $clamfiles_loc, $clamcolumns,
                    @clamurl);
        } else {
            &subdie($diemsg);
        }    
    } else {
        &subdie($diemsg);
    }
}

sub Create_virus_list {
    my @all_virs_list = ();
    my $tmp='';
    my @temp = ();
    foreach $f (@vir_files) {
        if (open (VIR,$clamfiles_loc.$f)) {
            while (<VIR>) {
                $tmp=$_;
                @temp=split(/=/,$tmp,2);
                if ($temp[0] ne "") { 
                    push(@all_virs_list,$temp[0]);
                }
            }
            close VIR;
        } else {
            &subdie("ERROR: Unable to read $clamfiles_loc$f. Quitting.\n");
        }
    }
    return sort @all_virs_list;
}

sub Generate_html_file {
    my @html = ();
    my $li = '';
    my $c = 0;
    my $tmp='';
    my $goahead=1;
    my ($trhead, $trtail, $tdtail)=
       ('<tr>','</tr>', '</td>');
    my $tdhead = '<td width="' . int(100/$clamcolumns) . '%">';
    open(TEMPLATE,$clamfiles_loc.$clamdb_template) ||
     &subdie("ERROR: No $clamfiles_loc$clamdb_template found.  Quitting.\n");
    while (<TEMPLATE>) {
        push (@html,$_);
    }
    close TEMPLATE;
    open(CF,">$clamhtml") ||
     &subdie("ERROR: $clamhtml could not be opened for write.\n");
    until ($li =~ $htmltag) {
        $li = shift(@html);
        if ($li =~ /\<body/i) {
            print CF $li;
            print CF scalar(@all_virs_list) . " viruses listed.  This page ";
            print CF "Generated on ",&ctime(time),"\n";
        } else {
            print CF $li;
        }
    }    
    print "INFO: Writing new $clamhtml\n";
    while ($goahead) {
        print CF "$trhead\n";
        while ($c < $clamcolumns) {
            if ($tmp = shift(@all_virs_list)) {
                print CF "    $tdhead";
                print CF $tmp;
                print CF "$tdtail\n";
            } else {
                $c = $clamcolumns + 1;
                $goahead=0;
            }
            $c += 1;
        }
        print CF "$trtail\n";
        $c = 0;
    }
    while ($li = shift(@html)) {
        print CF $li;
    }    
    close CF;
}

sub subdie {
    my ($msg) = @_;
    print $msg;
    die "$0 finished " . &ctime(time) . "\n";
}    
