<?php

/*
 * decode/big5.php
 * $Id: big5.php,v 1.2.4.2 2004/02/24 15:57:27 kink Exp $
 *
 * Copyright (c) 2003-2004 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file contains big5 decoding function that is needed to read
 * big5 encoded mails in non-big5 locale.
 * 
 * Original data taken from:
 *  ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT
 *
 * Name:             BIG5 to Unicode table (complete)
 * Unicode version:  1.1
 * Table version:    0.0d3
 * Table format:     Format A
 * Date:             11 February 1994
 *
 * Copyright (c) 1991-1994 Unicode, Inc.  All Rights reserved.
 *
 * This file is provided as-is by Unicode, Inc. (The Unicode Consortium).
 * No claims are made as to fitness for any particular purpose.  No
 * warranties of any kind are expressed or implied.  The recipient
 * agrees to determine applicability of information provided.  If this
 * file has been provided on magnetic media by Unicode, Inc., the sole
 * remedy for any claim will be exchange of defective media within 90
 * days of receipt.
 *
 * Recipient is granted the right to make copies in any form for
 * internal distribution and to freely use the information supplied
 * in the creation of products supporting Unicode.  Unicode, Inc.
 * specifically excludes the right to re-distribute this file directly
 * to third parties or other organizations whether for profit or not.
 *
 */

function charset_decode_big5 ($string) {
    global $default_charset;

    if (strtolower($default_charset) == 'big5')
        return $string;

    /* Only do the slow convert if there are 8-bit characters */
    if (! ereg("[\200-\377]", $string))
        return $string;

    $big5tounicode = array(
		"\xA1\x40" => '&#12288;',
		"\xA1\x41" => '&#65292;',
		"\xA1\x42" => '&#12289;',
		"\xA1\x43" => '&#12290;',
		"\xA1\x44" => '&#65294;',
		"\xA1\x45" => '&#8226;',
		"\xA1\x46" => '&#65307;',
		"\xA1\x47" => '&#65306;',
		"\xA1\x48" => '&#65311;',
		"\xA1\x49" => '&#65281;',
		"\xA1\x4A" => '&#65072;',
		"\xA1\x4B" => '&#8230;',
		"\xA1\x4C" => '&#8229;',
		"\xA1\x4D" => '&#65104;',
		"\xA1\x4E" => '&#65380;',
		"\xA1\x4F" => '&#65106;',
		"\xA1\x50" => '&#183;',
		"\xA1\x51" => '&#65108;',
		"\xA1\x52" => '&#65109;',
		"\xA1\x53" => '&#65110;',
		"\xA1\x54" => '&#65111;',
		"\xA1\x55" => '&#65372;',
		"\xA1\x56" => '&#8211;',
		"\xA1\x57" => '&#65073;',
		"\xA1\x58" => '&#8212;',
		"\xA1\x59" => '&#65075;',
		"\xA1\x5A" => '&#65533;',
		"\xA1\x5B" => '&#65076;',
		"\xA1\x5C" => '&#65103;',
		"\xA1\x5D" => '&#65288;',
		"\xA1\x5E" => '&#65289;',
		"\xA1\x5F" => '&#65077;',
		"\xA1\x60" => '&#65078;',
		"\xA1\x61" => '&#65371;',
		"\xA1\x62" => '&#65373;',
		"\xA1\x63" => '&#65079;',
		"\xA1\x64" => '&#65080;',
		"\xA1\x65" => '&#12308;',
		"\xA1\x66" => '&#12309;',
		"\xA1\x67" => '&#65081;',
		"\xA1\x68" => '&#65082;',
		"\xA1\x69" => '&#12304;',
		"\xA1\x6A" => '&#12305;',
		"\xA1\x6B" => '&#65083;',
		"\xA1\x6C" => '&#65084;',
		"\xA1\x6D" => '&#12298;',
		"\xA1\x6E" => '&#12299;',
		"\xA1\x6F" => '&#65085;',
		"\xA1\x70" => '&#65086;',
		"\xA1\x71" => '&#12296;',
		"\xA1\x72" => '&#12297;',
		"\xA1\x73" => '&#65087;',
		"\xA1\x74" => '&#65088;',
		"\xA1\x75" => '&#12300;',
		"\xA1\x76" => '&#12301;',
		"\xA1\x77" => '&#65089;',
		"\xA1\x78" => '&#65090;',
		"\xA1\x79" => '&#12302;',
		"\xA1\x7A" => '&#12303;',
		"\xA1\x7B" => '&#65091;',
		"\xA1\x7C" => '&#65092;',
		"\xA1\x7D" => '&#65113;',
		"\xA1\x7E" => '&#65114;',
		"\xA1\xA1" => '&#65115;',
		"\xA1\xA2" => '&#65116;',
		"\xA1\xA3" => '&#65117;',
		"\xA1\xA4" => '&#65118;',
		"\xA1\xA5" => '&#8216;',
		"\xA1\xA6" => '&#8217;',
		"\xA1\xA7" => '&#8220;',
		"\xA1\xA8" => '&#8221;',
		"\xA1\xA9" => '&#12317;',
		"\xA1\xAA" => '&#12318;',
		"\xA1\xAB" => '&#8245;',
		"\xA1\xAC" => '&#8242;',
		"\xA1\xAD" => '&#65283;',
		"\xA1\xAE" => '&#65286;',
		"\xA1\xAF" => '&#65290;',
		"\xA1\xB0" => '&#8251;',
		"\xA1\xB1" => '&#167;',
		"\xA1\xB2" => '&#12291;',
		"\xA1\xB3" => '&#9675;',
		"\xA1\xB4" => '&#9679;',
		"\xA1\xB5" => '&#9651;',
		"\xA1\xB6" => '&#9650;',
		"\xA1\xB7" => '&#9678;',
		"\xA1\xB8" => '&#9734;',
		"\xA1\xB9" => '&#9733;',
		"\xA1\xBA" => '&#9671;',
		"\xA1\xBB" => '&#9670;',
		"\xA1\xBC" => '&#9633;',
		"\xA1\xBD" => '&#9632;',
		"\xA1\xBE" => '&#9661;',
		"\xA1\xBF" => '&#9660;',
		"\xA1\xC0" => '&#12963;',
		"\xA1\xC1" => '&#8453;',
		"\xA1\xC2" => '&#8254;',
		"\xA1\xC3" => '&#65533;',
		"\xA1\xC4" => '&#65343;',
		"\xA1\xC5" => '&#65533;',
		"\xA1\xC6" => '&#65097;',
		"\xA1\xC7" => '&#65098;',
		"\xA1\xC8" => '&#65101;',
		"\xA1\xC9" => '&#65102;',
		"\xA1\xCA" => '&#65099;',
		"\xA1\xCB" => '&#65100;',
		"\xA1\xCC" => '&#65119;',
		"\xA1\xCD" => '&#65120;',
		"\xA1\xCE" => '&#65121;',
		"\xA1\xCF" => '&#65291;',
		"\xA1\xD0" => '&#65293;',
		"\xA1\xD1" => '&#215;',
		"\xA1\xD2" => '&#247;',
		"\xA1\xD3" => '&#177;',
		"\xA1\xD4" => '&#8730;',
		"\xA1\xD5" => '&#65308;',
		"\xA1\xD6" => '&#65310;',
		"\xA1\xD7" => '&#65309;',
		"\xA1\xD8" => '&#8806;',
		"\xA1\xD9" => '&#8807;',
		"\xA1\xDA" => '&#8800;',
		"\xA1\xDB" => '&#8734;',
		"\xA1\xDC" => '&#8786;',
		"\xA1\xDD" => '&#8801;',
		"\xA1\xDE" => '&#65122;',
		"\xA1\xDF" => '&#65123;',
		"\xA1\xE0" => '&#65124;',
		"\xA1\xE1" => '&#65125;',
		"\xA1\xE2" => '&#65126;',
		"\xA1\xE3" => '&#8764;',
		"\xA1\xE4" => '&#8745;',
		"\xA1\xE5" => '&#8746;',
		"\xA1\xE6" => '&#8869;',
		"\xA1\xE7" => '&#8736;',
		"\xA1\xE8" => '&#8735;',
		"\xA1\xE9" => '&#8895;',
		"\xA1\xEA" => '&#13266;',
		"\xA1\xEB" => '&#13265;',
		"\xA1\xEC" => '&#8747;',
		"\xA1\xED" => '&#8750;',
		"\xA1\xEE" => '&#8757;',
		"\xA1\xEF" => '&#8756;',
		"\xA1\xF0" => '&#9792;',
		"\xA1\xF1" => '&#9794;',
		"\xA1\xF2" => '&#9793;',
		"\xA1\xF3" => '&#9737;',
		"\xA1\xF4" => '&#8593;',
		"\xA1\xF5" => '&#8595;',
		"\xA1\xF6" => '&#8592;',
		"\xA1\xF7" => '&#8594;',
		"\xA1\xF8" => '&#8598;',
		"\xA1\xF9" => '&#8599;',
		"\xA1\xFA" => '&#8601;',
		"\xA1\xFB" => '&#8600;',
		"\xA1\xFC" => '&#8741;',
		"\xA1\xFD" => '&#8739;',
		"\xA1\xFE" => '&#65533;',
		"\xA2\x40" => '&#65533;',
		"\xA2\x41" => '&#65295;',
		"\xA2\x42" => '&#65340;',
		"\xA2\x43" => '&#65284;',
		"\xA2\x44" => '&#165;',
		"\xA2\x45" => '&#12306;',
		"\xA2\x46" => '&#162;',
		"\xA2\x47" => '&#163;',
		"\xA2\x48" => '&#65285;',
		"\xA2\x49" => '&#65312;',
		"\xA2\x4A" => '&#8451;',
		"\xA2\x4B" => '&#8457;',
		"\xA2\x4C" => '&#65129;',
		"\xA2\x4D" => '&#65130;',
		"\xA2\x4E" => '&#65131;',
		"\xA2\x4F" => '&#13269;',
		"\xA2\x50" => '&#13212;',
		"\xA2\x51" => '&#13213;',
		"\xA2\x52" => '&#13214;',
		"\xA2\x53" => '&#13262;',
		"\xA2\x54" => '&#13217;',
		"\xA2\x55" => '&#13198;',
		"\xA2\x56" => '&#13199;',
		"\xA2\x57" => '&#13252;',
		"\xA2\x58" => '&#176;',
		"\xA2\x59" => '&#20825;',
		"\xA2\x5A" => '&#20827;',
		"\xA2\x5B" => '&#20830;',
		"\xA2\x5C" => '&#20829;',
		"\xA2\x5D" => '&#20833;',
		"\xA2\x5E" => '&#20835;',
		"\xA2\x5F" => '&#21991;',
		"\xA2\x60" => '&#29929;',
		"\xA2\x61" => '&#31950;',
		"\xA2\x62" => '&#9601;',
		"\xA2\x63" => '&#9602;',
		"\xA2\x64" => '&#9603;',
		"\xA2\x65" => '&#9604;',
		"\xA2\x66" => '&#9605;',
		"\xA2\x67" => '&#9606;',
		"\xA2\x68" => '&#9607;',
		"\xA2\x69" => '&#9608;',
		"\xA2\x6A" => '&#9615;',
		"\xA2\x6B" => '&#9614;',
		"\xA2\x6C" => '&#9613;',
		"\xA2\x6D" => '&#9612;',
		"\xA2\x6E" => '&#9611;',
		"\xA2\x6F" => '&#9610;',
		"\xA2\x70" => '&#9609;',
		"\xA2\x71" => '&#9532;',
		"\xA2\x72" => '&#9524;',
		"\xA2\x73" => '&#9516;',
		"\xA2\x74" => '&#9508;',
		"\xA2\x75" => '&#9500;',
		"\xA2\x76" => '&#9620;',
		"\xA2\x77" => '&#9472;',
		"\xA2\x78" => '&#9474;',
		"\xA2\x79" => '&#9621;',
		"\xA2\x7A" => '&#9484;',
		"\xA2\x7B" => '&#9488;',
		"\xA2\x7C" => '&#9492;',
		"\xA2\x7D" => '&#9496;',
		"\xA2\x7E" => '&#9581;',
		"\xA2\xA1" => '&#9582;',
		"\xA2\xA2" => '&#9584;',
		"\xA2\xA3" => '&#9583;',
		"\xA2\xA4" => '&#9552;',
		"\xA2\xA5" => '&#9566;',
		"\xA2\xA6" => '&#9578;',
		"\xA2\xA7" => '&#9569;',
		"\xA2\xA8" => '&#9698;',
		"\xA2\xA9" => '&#9699;',
		"\xA2\xAA" => '&#9701;',
		"\xA2\xAB" => '&#9700;',
		"\xA2\xAC" => '&#9585;',
		"\xA2\xAD" => '&#9586;',
		"\xA2\xAE" => '&#9587;',
		"\xA2\xAF" => '&#65296;',
		"\xA2\xB0" => '&#65297;',
		"\xA2\xB1" => '&#65298;',
		"\xA2\xB2" => '&#65299;',
		"\xA2\xB3" => '&#65300;',
		"\xA2\xB4" => '&#65301;',
		"\xA2\xB5" => '&#65302;',
		"\xA2\xB6" => '&#65303;',
		"\xA2\xB7" => '&#65304;',
		"\xA2\xB8" => '&#65305;',
		"\xA2\xB9" => '&#8544;',
		"\xA2\xBA" => '&#8545;',
		"\xA2\xBB" => '&#8546;',
		"\xA2\xBC" => '&#8547;',
		"\xA2\xBD" => '&#8548;',
		"\xA2\xBE" => '&#8549;',
		"\xA2\xBF" => '&#8550;',
		"\xA2\xC0" => '&#8551;',
		"\xA2\xC1" => '&#8552;',
		"\xA2\xC2" => '&#8553;',
		"\xA2\xC3" => '&#12321;',
		"\xA2\xC4" => '&#12322;',
		"\xA2\xC5" => '&#12323;',
		"\xA2\xC6" => '&#12324;',
		"\xA2\xC7" => '&#12325;',
		"\xA2\xC8" => '&#12326;',
		"\xA2\xC9" => '&#12327;',
		"\xA2\xCA" => '&#12328;',
		"\xA2\xCB" => '&#12329;',
		"\xA2\xCC" => '&#65533;',
		"\xA2\xCD" => '&#21316;',
		"\xA2\xCE" => '&#65533;',
		"\xA2\xCF" => '&#65313;',
		"\xA2\xD0" => '&#65314;',
		"\xA2\xD1" => '&#65315;',
		"\xA2\xD2" => '&#65316;',
		"\xA2\xD3" => '&#65317;',
		"\xA2\xD4" => '&#65318;',
		"\xA2\xD5" => '&#65319;',
		"\xA2\xD6" => '&#65320;',
		"\xA2\xD7" => '&#65321;',
		"\xA2\xD8" => '&#65322;',
		"\xA2\xD9" => '&#65323;',
		"\xA2\xDA" => '&#65324;',
		"\xA2\xDB" => '&#65325;',
		"\xA2\xDC" => '&#65326;',
		"\xA2\xDD" => '&#65327;',
		"\xA2\xDE" => '&#65328;',
		"\xA2\xDF" => '&#65329;',
		"\xA2\xE0" => '&#65330;',
		"\xA2\xE1" => '&#65331;',
		"\xA2\xE2" => '&#65332;',
		"\xA2\xE3" => '&#65333;',
		"\xA2\xE4" => '&#65334;',
		"\xA2\xE5" => '&#65335;',
		"\xA2\xE6" => '&#65336;',
		"\xA2\xE7" => '&#65337;',
		"\xA2\xE8" => '&#65338;',
		"\xA2\xE9" => '&#65345;',
		"\xA2\xEA" => '&#65346;',
		"\xA2\xEB" => '&#65347;',
		"\xA2\xEC" => '&#65348;',
		"\xA2\xED" => '&#65349;',
		"\xA2\xEE" => '&#65350;',
		"\xA2\xEF" => '&#65351;',
		"\xA2\xF0" => '&#65352;',
		"\xA2\xF1" => '&#65353;',
		"\xA2\xF2" => '&#65354;',
		"\xA2\xF3" => '&#65355;',
		"\xA2\xF4" => '&#65356;',
		"\xA2\xF5" => '&#65357;',
		"\xA2\xF6" => '&#65358;',
		"\xA2\xF7" => '&#65359;',
		"\xA2\xF8" => '&#65360;',
		"\xA2\xF9" => '&#65361;',
		"\xA2\xFA" => '&#65362;',
		"\xA2\xFB" => '&#65363;',
		"\xA2\xFC" => '&#65364;',
		"\xA2\xFD" => '&#65365;',
		"\xA2\xFE" => '&#65366;',
		"\xA3\x40" => '&#65367;',
		"\xA3\x41" => '&#65368;',
		"\xA3\x42" => '&#65369;',
		"\xA3\x43" => '&#65370;',
		"\xA3\x44" => '&#913;',
		"\xA3\x45" => '&#914;',
		"\xA3\x46" => '&#915;',
		"\xA3\x47" => '&#916;',
		"\xA3\x48" => '&#917;',
		"\xA3\x49" => '&#918;',
		"\xA3\x4A" => '&#919;',
		"\xA3\x4B" => '&#920;',
		"\xA3\x4C" => '&#921;',
		"\xA3\x4D" => '&#922;',
		"\xA3\x4E" => '&#923;',
		"\xA3\x4F" => '&#924;',
		"\xA3\x50" => '&#925;',
		"\xA3\x51" => '&#926;',
		"\xA3\x52" => '&#927;',
		"\xA3\x53" => '&#928;',
		"\xA3\x54" => '&#929;',
		"\xA3\x55" => '&#931;',
		"\xA3\x56" => '&#932;',
		"\xA3\x57" => '&#933;',
		"\xA3\x58" => '&#934;',
		"\xA3\x59" => '&#935;',
		"\xA3\x5A" => '&#936;',
		"\xA3\x5B" => '&#937;',
		"\xA3\x5C" => '&#945;',
		"\xA3\x5D" => '&#946;',
		"\xA3\x5E" => '&#947;',
		"\xA3\x5F" => '&#948;',
		"\xA3\x60" => '&#949;',
		"\xA3\x61" => '&#950;',
		"\xA3\x62" => '&#951;',
		"\xA3\x63" => '&#952;',
		"\xA3\x64" => '&#953;',
		"\xA3\x65" => '&#954;',
		"\xA3\x66" => '&#955;',
		"\xA3\x67" => '&#956;',
		"\xA3\x68" => '&#957;',
		"\xA3\x69" => '&#958;',
		"\xA3\x6A" => '&#959;',
		"\xA3\x6B" => '&#960;',
		"\xA3\x6C" => '&#961;',
		"\xA3\x6D" => '&#963;',
		"\xA3\x6E" => '&#964;',
		"\xA3\x6F" => '&#965;',
		"\xA3\x70" => '&#966;',
		"\xA3\x71" => '&#967;',
		"\xA3\x72" => '&#968;',
		"\xA3\x73" => '&#969;',
		"\xA3\x74" => '&#12549;',
		"\xA3\x75" => '&#12550;',
		"\xA3\x76" => '&#12551;',
		"\xA3\x77" => '&#12552;',
		"\xA3\x78" => '&#12553;',
		"\xA3\x79" => '&#12554;',
		"\xA3\x7A" => '&#12555;',
		"\xA3\x7B" => '&#12556;',
		"\xA3\x7C" => '&#12557;',
		"\xA3\x7D" => '&#12558;',
		"\xA3\x7E" => '&#12559;',
		"\xA3\xA1" => '&#12560;',
		"\xA3\xA2" => '&#12561;',
		"\xA3\xA3" => '&#12562;',
		"\xA3\xA4" => '&#12563;',
		"\xA3\xA5" => '&#12564;',
		"\xA3\xA6" => '&#12565;',
		"\xA3\xA7" => '&#12566;',
		"\xA3\xA8" => '&#12567;',
		"\xA3\xA9" => '&#12568;',
		"\xA3\xAA" => '&#12569;',
		"\xA3\xAB" => '&#12570;',
		"\xA3\xAC" => '&#12571;',
		"\xA3\xAD" => '&#12572;',
		"\xA3\xAE" => '&#12573;',
		"\xA3\xAF" => '&#12574;',
		"\xA3\xB0" => '&#12575;',
		"\xA3\xB1" => '&#12576;',
		"\xA3\xB2" => '&#12577;',
		"\xA3\xB3" => '&#12578;',
		"\xA3\xB4" => '&#12579;',
		"\xA3\xB5" => '&#12580;',
		"\xA3\xB6" => '&#12581;',
		"\xA3\xB7" => '&#12582;',
		"\xA3\xB8" => '&#12583;',
		"\xA3\xB9" => '&#12584;',
		"\xA3\xBA" => '&#12585;',
		"\xA3\xBB" => '&#729;',
		"\xA3\xBC" => '&#713;',
		"\xA3\xBD" => '&#714;',
		"\xA3\xBE" => '&#711;',
		"\xA3\xBF" => '&#715;',
		"\xA4\x40" => '&#19968;',
		"\xA4\x41" => '&#20057;',
		"\xA4\x42" => '&#19969;',
		"\xA4\x43" => '&#19971;',
		"\xA4\x44" => '&#20035;',
		"\xA4\x45" => '&#20061;',
		"\xA4\x46" => '&#20102;',
		"\xA4\x47" => '&#20108;',
		"\xA4\x48" => '&#20154;',
		"\xA4\x49" => '&#20799;',
		"\xA4\x4A" => '&#20837;',
		"\xA4\x4B" => '&#20843;',
		"\xA4\x4C" => '&#20960;',
		"\xA4\x4D" => '&#20992;',
		"\xA4\x4E" => '&#20993;',
		"\xA4\x4F" => '&#21147;',
		"\xA4\x50" => '&#21269;',
		"\xA4\x51" => '&#21313;',
		"\xA4\x52" => '&#21340;',
		"\xA4\x53" => '&#21448;',
		"\xA4\x54" => '&#19977;',
		"\xA4\x55" => '&#19979;',
		"\xA4\x56" => '&#19976;',
		"\xA4\x57" => '&#19978;',
		"\xA4\x58" => '&#20011;',
		"\xA4\x59" => '&#20024;',
		"\xA4\x5A" => '&#20961;',
		"\xA4\x5B" => '&#20037;',
		"\xA4\x5C" => '&#20040;',
		"\xA4\x5D" => '&#20063;',
		"\xA4\x5E" => '&#20062;',
		"\xA4\x5F" => '&#20110;',
		"\xA4\x60" => '&#20129;',
		"\xA4\x61" => '&#20800;',
		"\xA4\x62" => '&#20995;',
		"\xA4\x63" => '&#21242;',
		"\xA4\x64" => '&#21315;',
		"\xA4\x65" => '&#21449;',
		"\xA4\x66" => '&#21475;',
		"\xA4\x67" => '&#22303;',
		"\xA4\x68" => '&#22763;',
		"\xA4\x69" => '&#22805;',
		"\xA4\x6A" => '&#22823;',
		"\xA4\x6B" => '&#22899;',
		"\xA4\x6C" => '&#23376;',
		"\xA4\x6D" => '&#23377;',
		"\xA4\x6E" => '&#23379;',
		"\xA4\x6F" => '&#23544;',
		"\xA4\x70" => '&#23567;',
		"\xA4\x71" => '&#23586;',
		"\xA4\x72" => '&#23608;',
		"\xA4\x73" => '&#23665;',
		"\xA4\x74" => '&#24029;',
		"\xA4\x75" => '&#24037;',
		"\xA4\x76" => '&#24049;',
		"\xA4\x77" => '&#24050;',
		"\xA4\x78" => '&#24051;',
		"\xA4\x79" => '&#24062;',
		"\xA4\x7A" => '&#24178;',
		"\xA4\x7B" => '&#24318;',
		"\xA4\x7C" => '&#24331;',
		"\xA4\x7D" => '&#24339;',
		"\xA4\x7E" => '&#25165;',
		"\xA4\xA1" => '&#19985;',
		"\xA4\xA2" => '&#19984;',
		"\xA4\xA3" => '&#19981;',
		"\xA4\xA4" => '&#20013;',
		"\xA4\xA5" => '&#20016;',
		"\xA4\xA6" => '&#20025;',
		"\xA4\xA7" => '&#20043;',
		"\xA4\xA8" => '&#23609;',
		"\xA4\xA9" => '&#20104;',
		"\xA4\xAA" => '&#20113;',
		"\xA4\xAB" => '&#20117;',
		"\xA4\xAC" => '&#20114;',
		"\xA4\xAD" => '&#20116;',
		"\xA4\xAE" => '&#20130;',
		"\xA4\xAF" => '&#20161;',
		"\xA4\xB0" => '&#20160;',
		"\xA4\xB1" => '&#20163;',
		"\xA4\xB2" => '&#20166;',
		"\xA4\xB3" => '&#20167;',
		"\xA4\xB4" => '&#20173;',
		"\xA4\xB5" => '&#20170;',
		"\xA4\xB6" => '&#20171;',
		"\xA4\xB7" => '&#20164;',
		"\xA4\xB8" => '&#20803;',
		"\xA4\xB9" => '&#20801;',
		"\xA4\xBA" => '&#20839;',
		"\xA4\xBB" => '&#20845;',
		"\xA4\xBC" => '&#20846;',
		"\xA4\xBD" => '&#20844;',
		"\xA4\xBE" => '&#20887;',
		"\xA4\xBF" => '&#20982;',
		"\xA4\xC0" => '&#20998;',
		"\xA4\xC1" => '&#20999;',
		"\xA4\xC2" => '&#21000;',
		"\xA4\xC3" => '&#21243;',
		"\xA4\xC4" => '&#21246;',
		"\xA4\xC5" => '&#21247;',
		"\xA4\xC6" => '&#21270;',
		"\xA4\xC7" => '&#21305;',
		"\xA4\xC8" => '&#21320;',
		"\xA4\xC9" => '&#21319;',
		"\xA4\xCA" => '&#21317;',
		"\xA4\xCB" => '&#21342;',
		"\xA4\xCC" => '&#21380;',
		"\xA4\xCD" => '&#21451;',
		"\xA4\xCE" => '&#21450;',
		"\xA4\xCF" => '&#21453;',
		"\xA4\xD0" => '&#22764;',
		"\xA4\xD1" => '&#22825;',
		"\xA4\xD2" => '&#22827;',
		"\xA4\xD3" => '&#22826;',
		"\xA4\xD4" => '&#22829;',
		"\xA4\xD5" => '&#23380;',
		"\xA4\xD6" => '&#23569;',
		"\xA4\xD7" => '&#23588;',
		"\xA4\xD8" => '&#23610;',
		"\xA4\xD9" => '&#23663;',
		"\xA4\xDA" => '&#24052;',
		"\xA4\xDB" => '&#24187;',
		"\xA4\xDC" => '&#24319;',
		"\xA4\xDD" => '&#24340;',
		"\xA4\xDE" => '&#24341;',
		"\xA4\xDF" => '&#24515;',
		"\xA4\xE0" => '&#25096;',
		"\xA4\xE1" => '&#25142;',
		"\xA4\xE2" => '&#25163;',
		"\xA4\xE3" => '&#25166;',
		"\xA4\xE4" => '&#25903;',
		"\xA4\xE5" => '&#25991;',
		"\xA4\xE6" => '&#26007;',
		"\xA4\xE7" => '&#26020;',
		"\xA4\xE8" => '&#26041;',
		"\xA4\xE9" => '&#26085;',
		"\xA4\xEA" => '&#26352;',
		"\xA4\xEB" => '&#26376;',
		"\xA4\xEC" => '&#26408;',
		"\xA4\xED" => '&#27424;',
		"\xA4\xEE" => '&#27490;',
		"\xA4\xEF" => '&#27513;',
		"\xA4\xF0" => '&#27595;',
		"\xA4\xF1" => '&#27604;',
		"\xA4\xF2" => '&#27611;',
		"\xA4\xF3" => '&#27663;',
		"\xA4\xF4" => '&#27700;',
		"\xA4\xF5" => '&#28779;',
		"\xA4\xF6" => '&#29226;',
		"\xA4\xF7" => '&#29238;',
		"\xA4\xF8" => '&#29243;',
		"\xA4\xF9" => '&#29255;',
		"\xA4\xFA" => '&#29273;',
		"\xA4\xFB" => '&#29275;',
		"\xA4\xFC" => '&#29356;',
		"\xA4\xFD" => '&#29579;',
		"\xA4\xFE" => '&#19993;',
		"\xA5\x40" => '&#19990;',
		"\xA5\x41" => '&#19989;',
		"\xA5\x42" => '&#19988;',
		"\xA5\x43" => '&#19992;',
		"\xA5\x44" => '&#20027;',
		"\xA5\x45" => '&#20045;',
		"\xA5\x46" => '&#20047;',
		"\xA5\x47" => '&#20046;',
		"\xA5\x48" => '&#20197;',
		"\xA5\x49" => '&#20184;',
		"\xA5\x4A" => '&#20180;',
		"\xA5\x4B" => '&#20181;',
		"\xA5\x4C" => '&#20182;',
		"\xA5\x4D" => '&#20183;',
		"\xA5\x4E" => '&#20195;',
		"\xA5\x4F" => '&#20196;',
		"\xA5\x50" => '&#20185;',
		"\xA5\x51" => '&#20190;',
		"\xA5\x52" => '&#20805;',
		"\xA5\x53" => '&#20804;',
		"\xA5\x54" => '&#20873;',
		"\xA5\x55" => '&#20874;',
		"\xA5\x56" => '&#20908;',
		"\xA5\x57" => '&#20985;',
		"\xA5\x58" => '&#20986;',
		"\xA5\x59" => '&#20984;',
		"\xA5\x5A" => '&#21002;',
		"\xA5\x5B" => '&#21152;',
		"\xA5\x5C" => '&#21151;',
		"\xA5\x5D" => '&#21253;',
		"\xA5\x5E" => '&#21254;',
		"\xA5\x5F" => '&#21271;',
		"\xA5\x60" => '&#21277;',
		"\xA5\x61" => '&#20191;',
		"\xA5\x62" => '&#21322;',
		"\xA5\x63" => '&#21321;',
		"\xA5\x64" => '&#21345;',
		"\xA5\x65" => '&#21344;',
		"\xA5\x66" => '&#21359;',
		"\xA5\x67" => '&#21358;',
		"\xA5\x68" => '&#21435;',
		"\xA5\x69" => '&#21487;',
		"\xA5\x6A" => '&#21476;',
		"\xA5\x6B" => '&#21491;',
		"\xA5\x6C" => '&#21484;',
		"\xA5\x6D" => '&#21486;',
		"\xA5\x6E" => '&#21481;',
		"\xA5\x6F" => '&#21480;',
		"\xA5\x70" => '&#21500;',
		"\xA5\x71" => '&#21496;',
		"\xA5\x72" => '&#21493;',
		"\xA5\x73" => '&#21483;',
		"\xA5\x74" => '&#21478;',
		"\xA5\x75" => '&#21482;',
		"\xA5\x76" => '&#21490;',
		"\xA5\x77" => '&#21489;',
		"\xA5\x78" => '&#21488;',
		"\xA5\x79" => '&#21477;',
		"\xA5\x7A" => '&#21485;',
		"\xA5\x7B" => '&#21499;',
		"\xA5\x7C" => '&#22235;',
		"\xA5\x7D" => '&#22234;',
		"\xA5\x7E" => '&#22806;',
		"\xA5\xA1" => '&#22830;',
		"\xA5\xA2" => '&#22833;',
		"\xA5\xA3" => '&#22900;',
		"\xA5\xA4" => '&#22902;',
		"\xA5\xA5" => '&#23381;',
		"\xA5\xA6" => '&#23427;',
		"\xA5\xA7" => '&#23612;',
		"\xA5\xA8" => '&#24040;',
		"\xA5\xA9" => '&#24039;',
		"\xA5\xAA" => '&#24038;',
		"\xA5\xAB" => '&#24066;',
		"\xA5\xAC" => '&#24067;',
		"\xA5\xAD" => '&#24179;',
		"\xA5\xAE" => '&#24188;',
		"\xA5\xAF" => '&#24321;',
		"\xA5\xB0" => '&#24344;',
		"\xA5\xB1" => '&#24343;',
		"\xA5\xB2" => '&#24517;',
		"\xA5\xB3" => '&#25098;',
		"\xA5\xB4" => '&#25171;',
		"\xA5\xB5" => '&#25172;',
		"\xA5\xB6" => '&#25170;',
		"\xA5\xB7" => '&#25169;',
		"\xA5\xB8" => '&#26021;',
		"\xA5\xB9" => '&#26086;',
		"\xA5\xBA" => '&#26414;',
		"\xA5\xBB" => '&#26412;',
		"\xA5\xBC" => '&#26410;',
		"\xA5\xBD" => '&#26411;',
		"\xA5\xBE" => '&#26413;',
		"\xA5\xBF" => '&#27491;',
		"\xA5\xC0" => '&#27597;',
		"\xA5\xC1" => '&#27665;',
		"\xA5\xC2" => '&#27664;',
		"\xA5\xC3" => '&#27704;',
		"\xA5\xC4" => '&#27713;',
		"\xA5\xC5" => '&#27712;',
		"\xA5\xC6" => '&#27710;',
		"\xA5\xC7" => '&#29359;',
		"\xA5\xC8" => '&#29572;',
		"\xA5\xC9" => '&#29577;',
		"\xA5\xCA" => '&#29916;',
		"\xA5\xCB" => '&#29926;',
		"\xA5\xCC" => '&#29976;',
		"\xA5\xCD" => '&#29983;',
		"\xA5\xCE" => '&#29992;',
		"\xA5\xCF" => '&#29993;',
		"\xA5\xD0" => '&#30000;',
		"\xA5\xD1" => '&#30001;',
		"\xA5\xD2" => '&#30002;',
		"\xA5\xD3" => '&#30003;',
		"\xA5\xD4" => '&#30091;',
		"\xA5\xD5" => '&#30333;',
		"\xA5\xD6" => '&#30382;',
		"\xA5\xD7" => '&#30399;',
		"\xA5\xD8" => '&#30446;',
		"\xA5\xD9" => '&#30683;',
		"\xA5\xDA" => '&#30690;',
		"\xA5\xDB" => '&#30707;',
		"\xA5\xDC" => '&#31034;',
		"\xA5\xDD" => '&#31166;',
		"\xA5\xDE" => '&#31348;',
		"\xA5\xDF" => '&#31435;',
		"\xA5\xE0" => '&#19998;',
		"\xA5\xE1" => '&#19999;',
		"\xA5\xE2" => '&#20050;',
		"\xA5\xE3" => '&#20051;',
		"\xA5\xE4" => '&#20073;',
		"\xA5\xE5" => '&#20121;',
		"\xA5\xE6" => '&#20132;',
		"\xA5\xE7" => '&#20134;',
		"\xA5\xE8" => '&#20133;',
		"\xA5\xE9" => '&#20223;',
		"\xA5\xEA" => '&#20233;',
		"\xA5\xEB" => '&#20249;',
		"\xA5\xEC" => '&#20234;',
		"\xA5\xED" => '&#20245;',
		"\xA5\xEE" => '&#20237;',
		"\xA5\xEF" => '&#20240;',
		"\xA5\xF0" => '&#20241;',
		"\xA5\xF1" => '&#20239;',
		"\xA5\xF2" => '&#20210;',
		"\xA5\xF3" => '&#20214;',
		"\xA5\xF4" => '&#20219;',
		"\xA5\xF5" => '&#20208;',
		"\xA5\xF6" => '&#20211;',
		"\xA5\xF7" => '&#20221;',
		"\xA5\xF8" => '&#20225;',
		"\xA5\xF9" => '&#20235;',
		"\xA5\xFA" => '&#20809;',
		"\xA5\xFB" => '&#20807;',
		"\xA5\xFC" => '&#20806;',
		"\xA5\xFD" => '&#20808;',
		"\xA5\xFE" => '&#20840;',
		"\xA6\x40" => '&#20849;',
		"\xA6\x41" => '&#20877;',
		"\xA6\x42" => '&#20912;',
		"\xA6\x43" => '&#21015;',
		"\xA6\x44" => '&#21009;',
		"\xA6\x45" => '&#21010;',
		"\xA6\x46" => '&#21006;',
		"\xA6\x47" => '&#21014;',
		"\xA6\x48" => '&#21155;',
		"\xA6\x49" => '&#21256;',
		"\xA6\x4A" => '&#21281;',
		"\xA6\x4B" => '&#21280;',
		"\xA6\x4C" => '&#21360;',
		"\xA6\x4D" => '&#21361;',
		"\xA6\x4E" => '&#21513;',
		"\xA6\x4F" => '&#21519;',
		"\xA6\x50" => '&#21516;',
		"\xA6\x51" => '&#21514;',
		"\xA6\x52" => '&#21520;',
		"\xA6\x53" => '&#21505;',
		"\xA6\x54" => '&#21515;',
		"\xA6\x55" => '&#21508;',
		"\xA6\x56" => '&#21521;',
		"\xA6\x57" => '&#21517;',
		"\xA6\x58" => '&#21512;',
		"\xA6\x59" => '&#21507;',
		"\xA6\x5A" => '&#21518;',
		"\xA6\x5B" => '&#21510;',
		"\xA6\x5C" => '&#21522;',
		"\xA6\x5D" => '&#22240;',
		"\xA6\x5E" => '&#22238;',
		"\xA6\x5F" => '&#22237;',
		"\xA6\x60" => '&#22323;',
		"\xA6\x61" => '&#22320;',
		"\xA6\x62" => '&#22312;',
		"\xA6\x63" => '&#22317;',
		"\xA6\x64" => '&#22316;',
		"\xA6\x65" => '&#22319;',
		"\xA6\x66" => '&#22313;',
		"\xA6\x67" => '&#22809;',
		"\xA6\x68" => '&#22810;',
		"\xA6\x69" => '&#22839;',
		"\xA6\x6A" => '&#22840;',
		"\xA6\x6B" => '&#22916;',
		"\xA6\x6C" => '&#22904;',
		"\xA6\x6D" => '&#22915;',
		"\xA6\x6E" => '&#22909;',
		"\xA6\x6F" => '&#22905;',
		"\xA6\x70" => '&#22914;',
		"\xA6\x71" => '&#22913;',
		"\xA6\x72" => '&#23383;',
		"\xA6\x73" => '&#23384;',
		"\xA6\x74" => '&#23431;',
		"\xA6\x75" => '&#23432;',
		"\xA6\x76" => '&#23429;',
		"\xA6\x77" => '&#23433;',
		"\xA6\x78" => '&#23546;',
		"\xA6\x79" => '&#23574;',
		"\xA6\x7A" => '&#23673;',
		"\xA6\x7B" => '&#24030;',
		"\xA6\x7C" => '&#24070;',
		"\xA6\x7D" => '&#24182;',
		"\xA6\x7E" => '&#24180;',
		"\xA6\xA1" => '&#24335;',
		"\xA6\xA2" => '&#24347;',
		"\xA6\xA3" => '&#24537;',
		"\xA6\xA4" => '&#24534;',
		"\xA6\xA5" => '&#25102;',
		"\xA6\xA6" => '&#25100;',
		"\xA6\xA7" => '&#25101;',
		"\xA6\xA8" => '&#25104;',
		"\xA6\xA9" => '&#25187;',
		"\xA6\xAA" => '&#25179;',
		"\xA6\xAB" => '&#25176;',
		"\xA6\xAC" => '&#25910;',
		"\xA6\xAD" => '&#26089;',
		"\xA6\xAE" => '&#26088;',
		"\xA6\xAF" => '&#26092;',
		"\xA6\xB0" => '&#26093;',
		"\xA6\xB1" => '&#26354;',
		"\xA6\xB2" => '&#26355;',
		"\xA6\xB3" => '&#26377;',
		"\xA6\xB4" => '&#26429;',
		"\xA6\xB5" => '&#26420;',
		"\xA6\xB6" => '&#26417;',
		"\xA6\xB7" => '&#26421;',
		"\xA6\xB8" => '&#27425;',
		"\xA6\xB9" => '&#27492;',
		"\xA6\xBA" => '&#27515;',
		"\xA6\xBB" => '&#27670;',
		"\xA6\xBC" => '&#27741;',
		"\xA6\xBD" => '&#27735;',
		"\xA6\xBE" => '&#27737;',
		"\xA6\xBF" => '&#27743;',
		"\xA6\xC0" => '&#27744;',
		"\xA6\xC1" => '&#27728;',
		"\xA6\xC2" => '&#27733;',
		"\xA6\xC3" => '&#27745;',
		"\xA6\xC4" => '&#27739;',
		"\xA6\xC5" => '&#27725;',
		"\xA6\xC6" => '&#27726;',
		"\xA6\xC7" => '&#28784;',
		"\xA6\xC8" => '&#29279;',
		"\xA6\xC9" => '&#29277;',
		"\xA6\xCA" => '&#30334;',
		"\xA6\xCB" => '&#31481;',
		"\xA6\xCC" => '&#31859;',
		"\xA6\xCD" => '&#31992;',
		"\xA6\xCE" => '&#32566;',
		"\xA6\xCF" => '&#32650;',
		"\xA6\xD0" => '&#32701;',
		"\xA6\xD1" => '&#32769;',
		"\xA6\xD2" => '&#32771;',
		"\xA6\xD3" => '&#32780;',
		"\xA6\xD4" => '&#32786;',
		"\xA6\xD5" => '&#32819;',
		"\xA6\xD6" => '&#32895;',
		"\xA6\xD7" => '&#32905;',
		"\xA6\xD8" => '&#32907;',
		"\xA6\xD9" => '&#32908;',
		"\xA6\xDA" => '&#33251;',
		"\xA6\xDB" => '&#33258;',
		"\xA6\xDC" => '&#33267;',
		"\xA6\xDD" => '&#33276;',
		"\xA6\xDE" => '&#33292;',
		"\xA6\xDF" => '&#33307;',
		"\xA6\xE0" => '&#33311;',
		"\xA6\xE1" => '&#33390;',
		"\xA6\xE2" => '&#33394;',
		"\xA6\xE3" => '&#33406;',
		"\xA6\xE4" => '&#34411;',
		"\xA6\xE5" => '&#34880;',
		"\xA6\xE6" => '&#34892;',
		"\xA6\xE7" => '&#34915;',
		"\xA6\xE8" => '&#35199;',
		"\xA6\xE9" => '&#38433;',
		"\xA6\xEA" => '&#20018;',
		"\xA6\xEB" => '&#20136;',
		"\xA6\xEC" => '&#20301;',
		"\xA6\xED" => '&#20303;',
		"\xA6\xEE" => '&#20295;',
		"\xA6\xEF" => '&#20311;',
		"\xA6\xF0" => '&#20318;',
		"\xA6\xF1" => '&#20276;',
		"\xA6\xF2" => '&#20315;',
		"\xA6\xF3" => '&#20309;',
		"\xA6\xF4" => '&#20272;',
		"\xA6\xF5" => '&#20304;',
		"\xA6\xF6" => '&#20305;',
		"\xA6\xF7" => '&#20285;',
		"\xA6\xF8" => '&#20282;',
		"\xA6\xF9" => '&#20280;',
		"\xA6\xFA" => '&#20291;',
		"\xA6\xFB" => '&#20308;',
		"\xA6\xFC" => '&#20284;',
		"\xA6\xFD" => '&#20294;',
		"\xA6\xFE" => '&#20323;',
		"\xA7\x40" => '&#20316;',
		"\xA7\x41" => '&#20320;',
		"\xA7\x42" => '&#20271;',
		"\xA7\x43" => '&#20302;',
		"\xA7\x44" => '&#20278;',
		"\xA7\x45" => '&#20313;',
		"\xA7\x46" => '&#20317;',
		"\xA7\x47" => '&#20296;',
		"\xA7\x48" => '&#20314;',
		"\xA7\x49" => '&#20812;',
		"\xA7\x4A" => '&#20811;',
		"\xA7\x4B" => '&#20813;',
		"\xA7\x4C" => '&#20853;',
		"\xA7\x4D" => '&#20918;',
		"\xA7\x4E" => '&#20919;',
		"\xA7\x4F" => '&#21029;',
		"\xA7\x50" => '&#21028;',
		"\xA7\x51" => '&#21033;',
		"\xA7\x52" => '&#21034;',
		"\xA7\x53" => '&#21032;',
		"\xA7\x54" => '&#21163;',
		"\xA7\x55" => '&#21161;',
		"\xA7\x56" => '&#21162;',
		"\xA7\x57" => '&#21164;',
		"\xA7\x58" => '&#21283;',
		"\xA7\x59" => '&#21363;',
		"\xA7\x5A" => '&#21365;',
		"\xA7\x5B" => '&#21533;',
		"\xA7\x5C" => '&#21549;',
		"\xA7\x5D" => '&#21534;',
		"\xA7\x5E" => '&#21566;',
		"\xA7\x5F" => '&#21542;',
		"\xA7\x60" => '&#21582;',
		"\xA7\x61" => '&#21543;',
		"\xA7\x62" => '&#21574;',
		"\xA7\x63" => '&#21571;',
		"\xA7\x64" => '&#21555;',
		"\xA7\x65" => '&#21576;',
		"\xA7\x66" => '&#21570;',
		"\xA7\x67" => '&#21531;',
		"\xA7\x68" => '&#21545;',
		"\xA7\x69" => '&#21578;',
		"\xA7\x6A" => '&#21561;',
		"\xA7\x6B" => '&#21563;',
		"\xA7\x6C" => '&#21560;',
		"\xA7\x6D" => '&#21550;',
		"\xA7\x6E" => '&#21557;',
		"\xA7\x6F" => '&#21558;',
		"\xA7\x70" => '&#21536;',
		"\xA7\x71" => '&#21564;',
		"\xA7\x72" => '&#21568;',
		"\xA7\x73" => '&#21553;',
		"\xA7\x74" => '&#21547;',
		"\xA7\x75" => '&#21535;',
		"\xA7\x76" => '&#21548;',
		"\xA7\x77" => '&#22250;',
		"\xA7\x78" => '&#22256;',
		"\xA7\x79" => '&#22244;',
		"\xA7\x7A" => '&#22251;',
		"\xA7\x7B" => '&#22346;',
		"\xA7\x7C" => '&#22353;',
		"\xA7\x7D" => '&#22336;',
		"\xA7\x7E" => '&#22349;',
		"\xA7\xA1" => '&#22343;',
		"\xA7\xA2" => '&#22350;',
		"\xA7\xA3" => '&#22334;',
		"\xA7\xA4" => '&#22352;',
		"\xA7\xA5" => '&#22351;',
		"\xA7\xA6" => '&#22331;',
		"\xA7\xA7" => '&#22767;',
		"\xA7\xA8" => '&#22846;',
		"\xA7\xA9" => '&#22941;',
		"\xA7\xAA" => '&#22930;',
		"\xA7\xAB" => '&#22952;',
		"\xA7\xAC" => '&#22942;',
		"\xA7\xAD" => '&#22947;',
		"\xA7\xAE" => '&#22937;',
		"\xA7\xAF" => '&#22934;',
		"\xA7\xB0" => '&#22925;',
		"\xA7\xB1" => '&#22948;',
		"\xA7\xB2" => '&#22931;',
		"\xA7\xB3" => '&#22922;',
		"\xA7\xB4" => '&#22949;',
		"\xA7\xB5" => '&#23389;',
		"\xA7\xB6" => '&#23388;',
		"\xA7\xB7" => '&#23386;',
		"\xA7\xB8" => '&#23387;',
		"\xA7\xB9" => '&#23436;',
		"\xA7\xBA" => '&#23435;',
		"\xA7\xBB" => '&#23439;',
		"\xA7\xBC" => '&#23596;',
		"\xA7\xBD" => '&#23616;',
		"\xA7\xBE" => '&#23617;',
		"\xA7\xBF" => '&#23615;',
		"\xA7\xC0" => '&#23614;',
		"\xA7\xC1" => '&#23696;',
		"\xA7\xC2" => '&#23697;',
		"\xA7\xC3" => '&#23700;',
		"\xA7\xC4" => '&#23692;',
		"\xA7\xC5" => '&#24043;',
		"\xA7\xC6" => '&#24076;',
		"\xA7\xC7" => '&#24207;',
		"\xA7\xC8" => '&#24199;',
		"\xA7\xC9" => '&#24202;',
		"\xA7\xCA" => '&#24311;',
		"\xA7\xCB" => '&#24324;',
		"\xA7\xCC" => '&#24351;',
		"\xA7\xCD" => '&#24420;',
		"\xA7\xCE" => '&#24418;',
		"\xA7\xCF" => '&#24439;',
		"\xA7\xD0" => '&#24441;',
		"\xA7\xD1" => '&#24536;',
		"\xA7\xD2" => '&#24524;',
		"\xA7\xD3" => '&#24535;',
		"\xA7\xD4" => '&#24525;',
		"\xA7\xD5" => '&#24561;',
		"\xA7\xD6" => '&#24555;',
		"\xA7\xD7" => '&#24568;',
		"\xA7\xD8" => '&#24554;',
		"\xA7\xD9" => '&#25106;',
		"\xA7\xDA" => '&#25105;',
		"\xA7\xDB" => '&#25220;',
		"\xA7\xDC" => '&#25239;',
		"\xA7\xDD" => '&#25238;',
		"\xA7\xDE" => '&#25216;',
		"\xA7\xDF" => '&#25206;',
		"\xA7\xE0" => '&#25225;',
		"\xA7\xE1" => '&#25197;',
		"\xA7\xE2" => '&#25226;',
		"\xA7\xE3" => '&#25212;',
		"\xA7\xE4" => '&#25214;',
		"\xA7\xE5" => '&#25209;',
		"\xA7\xE6" => '&#25203;',
		"\xA7\xE7" => '&#25234;',
		"\xA7\xE8" => '&#25199;',
		"\xA7\xE9" => '&#25240;',
		"\xA7\xEA" => '&#25198;',
		"\xA7\xEB" => '&#25237;',
		"\xA7\xEC" => '&#25235;',
		"\xA7\xED" => '&#25233;',
		"\xA7\xEE" => '&#25222;',
		"\xA7\xEF" => '&#25913;',
		"\xA7\xF0" => '&#25915;',
		"\xA7\xF1" => '&#25912;',
		"\xA7\xF2" => '&#26097;',
		"\xA7\xF3" => '&#26356;',
		"\xA7\xF4" => '&#26463;',
		"\xA7\xF5" => '&#26446;',
		"\xA7\xF6" => '&#26447;',
		"\xA7\xF7" => '&#26448;',
		"\xA7\xF8" => '&#26449;',
		"\xA7\xF9" => '&#26460;',
		"\xA7\xFA" => '&#26454;',
		"\xA7\xFB" => '&#26462;',
		"\xA7\xFC" => '&#26441;',
		"\xA7\xFD" => '&#26438;',
		"\xA7\xFE" => '&#26464;',
		"\xA8\x40" => '&#26451;',
		"\xA8\x41" => '&#26455;',
		"\xA8\x42" => '&#27493;',
		"\xA8\x43" => '&#27599;',
		"\xA8\x44" => '&#27714;',
		"\xA8\x45" => '&#27742;',
		"\xA8\x46" => '&#27801;',
		"\xA8\x47" => '&#27777;',
		"\xA8\x48" => '&#27784;',
		"\xA8\x49" => '&#27785;',
		"\xA8\x4A" => '&#27781;',
		"\xA8\x4B" => '&#27803;',
		"\xA8\x4C" => '&#27754;',
		"\xA8\x4D" => '&#27770;',
		"\xA8\x4E" => '&#27792;',
		"\xA8\x4F" => '&#27760;',
		"\xA8\x50" => '&#27788;',
		"\xA8\x51" => '&#27752;',
		"\xA8\x52" => '&#27798;',
		"\xA8\x53" => '&#27794;',
		"\xA8\x54" => '&#27773;',
		"\xA8\x55" => '&#27779;',
		"\xA8\x56" => '&#27762;',
		"\xA8\x57" => '&#27774;',
		"\xA8\x58" => '&#27764;',
		"\xA8\x59" => '&#27782;',
		"\xA8\x5A" => '&#27766;',
		"\xA8\x5B" => '&#27789;',
		"\xA8\x5C" => '&#27796;',
		"\xA8\x5D" => '&#27800;',
		"\xA8\x5E" => '&#27778;',
		"\xA8\x5F" => '&#28790;',
		"\xA8\x60" => '&#28796;',
		"\xA8\x61" => '&#28797;',
		"\xA8\x62" => '&#28792;',
		"\xA8\x63" => '&#29282;',
		"\xA8\x64" => '&#29281;',
		"\xA8\x65" => '&#29280;',
		"\xA8\x66" => '&#29380;',
		"\xA8\x67" => '&#29378;',
		"\xA8\x68" => '&#29590;',
		"\xA8\x69" => '&#29996;',
		"\xA8\x6A" => '&#29995;',
		"\xA8\x6B" => '&#30007;',
		"\xA8\x6C" => '&#30008;',
		"\xA8\x6D" => '&#30338;',
		"\xA8\x6E" => '&#30447;',
		"\xA8\x6F" => '&#30691;',
		"\xA8\x70" => '&#31169;',
		"\xA8\x71" => '&#31168;',
		"\xA8\x72" => '&#31167;',
		"\xA8\x73" => '&#31350;',
		"\xA8\x74" => '&#31995;',
		"\xA8\x75" => '&#32597;',
		"\xA8\x76" => '&#32918;',
		"\xA8\x77" => '&#32915;',
		"\xA8\x78" => '&#32925;',
		"\xA8\x79" => '&#32920;',
		"\xA8\x7A" => '&#32923;',
		"\xA8\x7B" => '&#32922;',
		"\xA8\x7C" => '&#32946;',
		"\xA8\x7D" => '&#33391;',
		"\xA8\x7E" => '&#33426;',
		"\xA8\xA1" => '&#33419;',
		"\xA8\xA2" => '&#33421;',
		"\xA8\xA3" => '&#35211;',
		"\xA8\xA4" => '&#35282;',
		"\xA8\xA5" => '&#35328;',
		"\xA8\xA6" => '&#35895;',
		"\xA8\xA7" => '&#35910;',
		"\xA8\xA8" => '&#35925;',
		"\xA8\xA9" => '&#35997;',
		"\xA8\xAA" => '&#36196;',
		"\xA8\xAB" => '&#36208;',
		"\xA8\xAC" => '&#36275;',
		"\xA8\xAD" => '&#36523;',
		"\xA8\xAE" => '&#36554;',
		"\xA8\xAF" => '&#36763;',
		"\xA8\xB0" => '&#36784;',
		"\xA8\xB1" => '&#36802;',
		"\xA8\xB2" => '&#36806;',
		"\xA8\xB3" => '&#36805;',
		"\xA8\xB4" => '&#36804;',
		"\xA8\xB5" => '&#24033;',
		"\xA8\xB6" => '&#37009;',
		"\xA8\xB7" => '&#37026;',
		"\xA8\xB8" => '&#37034;',
		"\xA8\xB9" => '&#37030;',
		"\xA8\xBA" => '&#37027;',
		"\xA8\xBB" => '&#37193;',
		"\xA8\xBC" => '&#37318;',
		"\xA8\xBD" => '&#37324;',
		"\xA8\xBE" => '&#38450;',
		"\xA8\xBF" => '&#38446;',
		"\xA8\xC0" => '&#38449;',
		"\xA8\xC1" => '&#38442;',
		"\xA8\xC2" => '&#38444;',
		"\xA8\xC3" => '&#20006;',
		"\xA8\xC4" => '&#20054;',
		"\xA8\xC5" => '&#20083;',
		"\xA8\xC6" => '&#20107;',
		"\xA8\xC7" => '&#20123;',
		"\xA8\xC8" => '&#20126;',
		"\xA8\xC9" => '&#20139;',
		"\xA8\xCA" => '&#20140;',
		"\xA8\xCB" => '&#20335;',
		"\xA8\xCC" => '&#20381;',
		"\xA8\xCD" => '&#20365;',
		"\xA8\xCE" => '&#20339;',
		"\xA8\xCF" => '&#20351;',
		"\xA8\xD0" => '&#20332;',
		"\xA8\xD1" => '&#20379;',
		"\xA8\xD2" => '&#20363;',
		"\xA8\xD3" => '&#20358;',
		"\xA8\xD4" => '&#20355;',
		"\xA8\xD5" => '&#20336;',
		"\xA8\xD6" => '&#20341;',
		"\xA8\xD7" => '&#20360;',
		"\xA8\xD8" => '&#20329;',
		"\xA8\xD9" => '&#20347;',
		"\xA8\xDA" => '&#20374;',
		"\xA8\xDB" => '&#20350;',
		"\xA8\xDC" => '&#20367;',
		"\xA8\xDD" => '&#20369;',
		"\xA8\xDE" => '&#20346;',
		"\xA8\xDF" => '&#20820;',
		"\xA8\xE0" => '&#20818;',
		"\xA8\xE1" => '&#20821;',
		"\xA8\xE2" => '&#20841;',
		"\xA8\xE3" => '&#20855;',
		"\xA8\xE4" => '&#20854;',
		"\xA8\xE5" => '&#20856;',
		"\xA8\xE6" => '&#20925;',
		"\xA8\xE7" => '&#20989;',
		"\xA8\xE8" => '&#21051;',
		"\xA8\xE9" => '&#21048;',
		"\xA8\xEA" => '&#21047;',
		"\xA8\xEB" => '&#21050;',
		"\xA8\xEC" => '&#21040;',
		"\xA8\xED" => '&#21038;',
		"\xA8\xEE" => '&#21046;',
		"\xA8\xEF" => '&#21057;',
		"\xA8\xF0" => '&#21182;',
		"\xA8\xF1" => '&#21179;',
		"\xA8\xF2" => '&#21330;',
		"\xA8\xF3" => '&#21332;',
		"\xA8\xF4" => '&#21331;',
		"\xA8\xF5" => '&#21329;',
		"\xA8\xF6" => '&#21350;',
		"\xA8\xF7" => '&#21367;',
		"\xA8\xF8" => '&#21368;',
		"\xA8\xF9" => '&#21369;',
		"\xA8\xFA" => '&#21462;',
		"\xA8\xFB" => '&#21460;',
		"\xA8\xFC" => '&#21463;',
		"\xA8\xFD" => '&#21619;',
		"\xA8\xFE" => '&#21621;',
		"\xA9\x40" => '&#21654;',
		"\xA9\x41" => '&#21624;',
		"\xA9\x42" => '&#21653;',
		"\xA9\x43" => '&#21632;',
		"\xA9\x44" => '&#21627;',
		"\xA9\x45" => '&#21623;',
		"\xA9\x46" => '&#21636;',
		"\xA9\x47" => '&#21650;',
		"\xA9\x48" => '&#21638;',
		"\xA9\x49" => '&#21628;',
		"\xA9\x4A" => '&#21648;',
		"\xA9\x4B" => '&#21617;',
		"\xA9\x4C" => '&#21622;',
		"\xA9\x4D" => '&#21644;',
		"\xA9\x4E" => '&#21658;',
		"\xA9\x4F" => '&#21602;',
		"\xA9\x50" => '&#21608;',
		"\xA9\x51" => '&#21643;',
		"\xA9\x52" => '&#21629;',
		"\xA9\x53" => '&#21646;',
		"\xA9\x54" => '&#22266;',
		"\xA9\x55" => '&#22403;',
		"\xA9\x56" => '&#22391;',
		"\xA9\x57" => '&#22378;',
		"\xA9\x58" => '&#22377;',
		"\xA9\x59" => '&#22369;',
		"\xA9\x5A" => '&#22374;',
		"\xA9\x5B" => '&#22372;',
		"\xA9\x5C" => '&#22396;',
		"\xA9\x5D" => '&#22812;',
		"\xA9\x5E" => '&#22857;',
		"\xA9\x5F" => '&#22855;',
		"\xA9\x60" => '&#22856;',
		"\xA9\x61" => '&#22852;',
		"\xA9\x62" => '&#22868;',
		"\xA9\x63" => '&#22974;',
		"\xA9\x64" => '&#22971;',
		"\xA9\x65" => '&#22996;',
		"\xA9\x66" => '&#22969;',
		"\xA9\x67" => '&#22958;',
		"\xA9\x68" => '&#22993;',
		"\xA9\x69" => '&#22982;',
		"\xA9\x6A" => '&#22992;',
		"\xA9\x6B" => '&#22989;',
		"\xA9\x6C" => '&#22987;',
		"\xA9\x6D" => '&#22995;',
		"\xA9\x6E" => '&#22986;',
		"\xA9\x6F" => '&#22959;',
		"\xA9\x70" => '&#22963;',
		"\xA9\x71" => '&#22994;',
		"\xA9\x72" => '&#22981;',
		"\xA9\x73" => '&#23391;',
		"\xA9\x74" => '&#23396;',
		"\xA9\x75" => '&#23395;',
		"\xA9\x76" => '&#23447;',
		"\xA9\x77" => '&#23450;',
		"\xA9\x78" => '&#23448;',
		"\xA9\x79" => '&#23452;',
		"\xA9\x7A" => '&#23449;',
		"\xA9\x7B" => '&#23451;',
		"\xA9\x7C" => '&#23578;',
		"\xA9\x7D" => '&#23624;',
		"\xA9\x7E" => '&#23621;',
		"\xA9\xA1" => '&#23622;',
		"\xA9\xA2" => '&#23735;',
		"\xA9\xA3" => '&#23713;',
		"\xA9\xA4" => '&#23736;',
		"\xA9\xA5" => '&#23721;',
		"\xA9\xA6" => '&#23723;',
		"\xA9\xA7" => '&#23729;',
		"\xA9\xA8" => '&#23731;',
		"\xA9\xA9" => '&#24088;',
		"\xA9\xAA" => '&#24090;',
		"\xA9\xAB" => '&#24086;',
		"\xA9\xAC" => '&#24085;',
		"\xA9\xAD" => '&#24091;',
		"\xA9\xAE" => '&#24081;',
		"\xA9\xAF" => '&#24184;',
		"\xA9\xB0" => '&#24218;',
		"\xA9\xB1" => '&#24215;',
		"\xA9\xB2" => '&#24220;',
		"\xA9\xB3" => '&#24213;',
		"\xA9\xB4" => '&#24214;',
		"\xA9\xB5" => '&#24310;',
		"\xA9\xB6" => '&#24358;',
		"\xA9\xB7" => '&#24359;',
		"\xA9\xB8" => '&#24361;',
		"\xA9\xB9" => '&#24448;',
		"\xA9\xBA" => '&#24449;',
		"\xA9\xBB" => '&#24447;',
		"\xA9\xBC" => '&#24444;',
		"\xA9\xBD" => '&#24541;',
		"\xA9\xBE" => '&#24544;',
		"\xA9\xBF" => '&#24573;',
		"\xA9\xC0" => '&#24565;',
		"\xA9\xC1" => '&#24575;',
		"\xA9\xC2" => '&#24591;',
		"\xA9\xC3" => '&#24596;',
		"\xA9\xC4" => '&#24623;',
		"\xA9\xC5" => '&#24629;',
		"\xA9\xC6" => '&#24598;',
		"\xA9\xC7" => '&#24618;',
		"\xA9\xC8" => '&#24597;',
		"\xA9\xC9" => '&#24609;',
		"\xA9\xCA" => '&#24615;',
		"\xA9\xCB" => '&#24617;',
		"\xA9\xCC" => '&#24619;',
		"\xA9\xCD" => '&#24603;',
		"\xA9\xCE" => '&#25110;',
		"\xA9\xCF" => '&#25109;',
		"\xA9\xD0" => '&#25151;',
		"\xA9\xD1" => '&#25150;',
		"\xA9\xD2" => '&#25152;',
		"\xA9\xD3" => '&#25215;',
		"\xA9\xD4" => '&#25289;',
		"\xA9\xD5" => '&#25292;',
		"\xA9\xD6" => '&#25284;',
		"\xA9\xD7" => '&#25279;',
		"\xA9\xD8" => '&#25282;',
		"\xA9\xD9" => '&#25273;',
		"\xA9\xDA" => '&#25298;',
		"\xA9\xDB" => '&#25307;',
		"\xA9\xDC" => '&#25259;',
		"\xA9\xDD" => '&#25299;',
		"\xA9\xDE" => '&#25300;',
		"\xA9\xDF" => '&#25291;',
		"\xA9\xE0" => '&#25288;',
		"\xA9\xE1" => '&#25256;',
		"\xA9\xE2" => '&#25277;',
		"\xA9\xE3" => '&#25276;',
		"\xA9\xE4" => '&#25296;',
		"\xA9\xE5" => '&#25305;',
		"\xA9\xE6" => '&#25287;',
		"\xA9\xE7" => '&#25293;',
		"\xA9\xE8" => '&#25269;',
		"\xA9\xE9" => '&#25306;',
		"\xA9\xEA" => '&#25265;',
		"\xA9\xEB" => '&#25304;',
		"\xA9\xEC" => '&#25302;',
		"\xA9\xED" => '&#25303;',
		"\xA9\xEE" => '&#25286;',
		"\xA9\xEF" => '&#25260;',
		"\xA9\xF0" => '&#25294;',
		"\xA9\xF1" => '&#25918;',
		"\xA9\xF2" => '&#26023;',
		"\xA9\xF3" => '&#26044;',
		"\xA9\xF4" => '&#26106;',
		"\xA9\xF5" => '&#26132;',
		"\xA9\xF6" => '&#26131;',
		"\xA9\xF7" => '&#26124;',
		"\xA9\xF8" => '&#26118;',
		"\xA9\xF9" => '&#26114;',
		"\xA9\xFA" => '&#26126;',
		"\xA9\xFB" => '&#26112;',
		"\xA9\xFC" => '&#26127;',
		"\xA9\xFD" => '&#26133;',
		"\xA9\xFE" => '&#26122;',
		"\xAA\x40" => '&#26119;',
		"\xAA\x41" => '&#26381;',
		"\xAA\x42" => '&#26379;',
		"\xAA\x43" => '&#26477;',
		"\xAA\x44" => '&#26507;',
		"\xAA\x45" => '&#26517;',
		"\xAA\x46" => '&#26481;',
		"\xAA\x47" => '&#26524;',
		"\xAA\x48" => '&#26483;',
		"\xAA\x49" => '&#26487;',
		"\xAA\x4A" => '&#26503;',
		"\xAA\x4B" => '&#26525;',
		"\xAA\x4C" => '&#26519;',
		"\xAA\x4D" => '&#26479;',
		"\xAA\x4E" => '&#26480;',
		"\xAA\x4F" => '&#26495;',
		"\xAA\x50" => '&#26505;',
		"\xAA\x51" => '&#26494;',
		"\xAA\x52" => '&#26512;',
		"\xAA\x53" => '&#26485;',
		"\xAA\x54" => '&#26522;',
		"\xAA\x55" => '&#26515;',
		"\xAA\x56" => '&#26492;',
		"\xAA\x57" => '&#26474;',
		"\xAA\x58" => '&#26482;',
		"\xAA\x59" => '&#27427;',
		"\xAA\x5A" => '&#27494;',
		"\xAA\x5B" => '&#27495;',
		"\xAA\x5C" => '&#27519;',
		"\xAA\x5D" => '&#27667;',
		"\xAA\x5E" => '&#27675;',
		"\xAA\x5F" => '&#27875;',
		"\xAA\x60" => '&#27880;',
		"\xAA\x61" => '&#27891;',
		"\xAA\x62" => '&#27825;',
		"\xAA\x63" => '&#27852;',
		"\xAA\x64" => '&#27877;',
		"\xAA\x65" => '&#27827;',
		"\xAA\x66" => '&#27837;',
		"\xAA\x67" => '&#27838;',
		"\xAA\x68" => '&#27836;',
		"\xAA\x69" => '&#27874;',
		"\xAA\x6A" => '&#27819;',
		"\xAA\x6B" => '&#27861;',
		"\xAA\x6C" => '&#27859;',
		"\xAA\x6D" => '&#27832;',
		"\xAA\x6E" => '&#27844;',
		"\xAA\x6F" => '&#27833;',
		"\xAA\x70" => '&#27841;',
		"\xAA\x71" => '&#27822;',
		"\xAA\x72" => '&#27863;',
		"\xAA\x73" => '&#27845;',
		"\xAA\x74" => '&#27889;',
		"\xAA\x75" => '&#27839;',
		"\xAA\x76" => '&#27835;',
		"\xAA\x77" => '&#27873;',
		"\xAA\x78" => '&#27867;',
		"\xAA\x79" => '&#27850;',
		"\xAA\x7A" => '&#27820;',
		"\xAA\x7B" => '&#27887;',
		"\xAA\x7C" => '&#27868;',
		"\xAA\x7D" => '&#27862;',
		"\xAA\x7E" => '&#27872;',
		"\xAA\xA1" => '&#28821;',
		"\xAA\xA2" => '&#28814;',
		"\xAA\xA3" => '&#28818;',
		"\xAA\xA4" => '&#28810;',
		"\xAA\xA5" => '&#28825;',
		"\xAA\xA6" => '&#29228;',
		"\xAA\xA7" => '&#29229;',
		"\xAA\xA8" => '&#29240;',
		"\xAA\xA9" => '&#29256;',
		"\xAA\xAA" => '&#29287;',
		"\xAA\xAB" => '&#29289;',
		"\xAA\xAC" => '&#29376;',
		"\xAA\xAD" => '&#29390;',
		"\xAA\xAE" => '&#29401;',
		"\xAA\xAF" => '&#29399;',
		"\xAA\xB0" => '&#29392;',
		"\xAA\xB1" => '&#29609;',
		"\xAA\xB2" => '&#29608;',
		"\xAA\xB3" => '&#29599;',
		"\xAA\xB4" => '&#29611;',
		"\xAA\xB5" => '&#29605;',
		"\xAA\xB6" => '&#30013;',
		"\xAA\xB7" => '&#30109;',
		"\xAA\xB8" => '&#30105;',
		"\xAA\xB9" => '&#30106;',
		"\xAA\xBA" => '&#30340;',
		"\xAA\xBB" => '&#30402;',
		"\xAA\xBC" => '&#30450;',
		"\xAA\xBD" => '&#30452;',
		"\xAA\xBE" => '&#30693;',
		"\xAA\xBF" => '&#30717;',
		"\xAA\xC0" => '&#31038;',
		"\xAA\xC1" => '&#31040;',
		"\xAA\xC2" => '&#31041;',
		"\xAA\xC3" => '&#31177;',
		"\xAA\xC4" => '&#31176;',
		"\xAA\xC5" => '&#31354;',
		"\xAA\xC6" => '&#31353;',
		"\xAA\xC7" => '&#31482;',
		"\xAA\xC8" => '&#31998;',
		"\xAA\xC9" => '&#32596;',
		"\xAA\xCA" => '&#32652;',
		"\xAA\xCB" => '&#32651;',
		"\xAA\xCC" => '&#32773;',
		"\xAA\xCD" => '&#32954;',
		"\xAA\xCE" => '&#32933;',
		"\xAA\xCF" => '&#32930;',
		"\xAA\xD0" => '&#32945;',
		"\xAA\xD1" => '&#32929;',
		"\xAA\xD2" => '&#32939;',
		"\xAA\xD3" => '&#32937;',
		"\xAA\xD4" => '&#32948;',
		"\xAA\xD5" => '&#32938;',
		"\xAA\xD6" => '&#32943;',
		"\xAA\xD7" => '&#33253;',
		"\xAA\xD8" => '&#33278;',
		"\xAA\xD9" => '&#33293;',
		"\xAA\xDA" => '&#33459;',
		"\xAA\xDB" => '&#33437;',
		"\xAA\xDC" => '&#33433;',
		"\xAA\xDD" => '&#33453;',
		"\xAA\xDE" => '&#33469;',
		"\xAA\xDF" => '&#33439;',
		"\xAA\xE0" => '&#33465;',
		"\xAA\xE1" => '&#33457;',
		"\xAA\xE2" => '&#33452;',
		"\xAA\xE3" => '&#33445;',
		"\xAA\xE4" => '&#33455;',
		"\xAA\xE5" => '&#33464;',
		"\xAA\xE6" => '&#33443;',
		"\xAA\xE7" => '&#33456;',
		"\xAA\xE8" => '&#33470;',
		"\xAA\xE9" => '&#33463;',
		"\xAA\xEA" => '&#34382;',
		"\xAA\xEB" => '&#34417;',
		"\xAA\xEC" => '&#21021;',
		"\xAA\xED" => '&#34920;',
		"\xAA\xEE" => '&#36555;',
		"\xAA\xEF" => '&#36814;',
		"\xAA\xF0" => '&#36820;',
		"\xAA\xF1" => '&#36817;',
		"\xAA\xF2" => '&#37045;',
		"\xAA\xF3" => '&#37048;',
		"\xAA\xF4" => '&#37041;',
		"\xAA\xF5" => '&#37046;',
		"\xAA\xF6" => '&#37319;',
		"\xAA\xF7" => '&#37329;',
		"\xAA\xF8" => '&#38263;',
		"\xAA\xF9" => '&#38272;',
		"\xAA\xFA" => '&#38428;',
		"\xAA\xFB" => '&#38464;',
		"\xAA\xFC" => '&#38463;',
		"\xAA\xFD" => '&#38459;',
		"\xAA\xFE" => '&#38468;',
		"\xAB\x40" => '&#38466;',
		"\xAB\x41" => '&#38585;',
		"\xAB\x42" => '&#38632;',
		"\xAB\x43" => '&#38738;',
		"\xAB\x44" => '&#38750;',
		"\xAB\x45" => '&#20127;',
		"\xAB\x46" => '&#20141;',
		"\xAB\x47" => '&#20142;',
		"\xAB\x48" => '&#20449;',
		"\xAB\x49" => '&#20405;',
		"\xAB\x4A" => '&#20399;',
		"\xAB\x4B" => '&#20415;',
		"\xAB\x4C" => '&#20448;',
		"\xAB\x4D" => '&#20433;',
		"\xAB\x4E" => '&#20431;',
		"\xAB\x4F" => '&#20445;',
		"\xAB\x50" => '&#20419;',
		"\xAB\x51" => '&#20406;',
		"\xAB\x52" => '&#20440;',
		"\xAB\x53" => '&#20447;',
		"\xAB\x54" => '&#20426;',
		"\xAB\x55" => '&#20439;',
		"\xAB\x56" => '&#20398;',
		"\xAB\x57" => '&#20432;',
		"\xAB\x58" => '&#20420;',
		"\xAB\x59" => '&#20418;',
		"\xAB\x5A" => '&#20442;',
		"\xAB\x5B" => '&#20430;',
		"\xAB\x5C" => '&#20446;',
		"\xAB\x5D" => '&#20407;',
		"\xAB\x5E" => '&#20823;',
		"\xAB\x5F" => '&#20882;',
		"\xAB\x60" => '&#20881;',
		"\xAB\x61" => '&#20896;',
		"\xAB\x62" => '&#21070;',
		"\xAB\x63" => '&#21059;',
		"\xAB\x64" => '&#21066;',
		"\xAB\x65" => '&#21069;',
		"\xAB\x66" => '&#21068;',
		"\xAB\x67" => '&#21067;',
		"\xAB\x68" => '&#21063;',
		"\xAB\x69" => '&#21191;',
		"\xAB\x6A" => '&#21193;',
		"\xAB\x6B" => '&#21187;',
		"\xAB\x6C" => '&#21185;',
		"\xAB\x6D" => '&#21261;',
		"\xAB\x6E" => '&#21335;',
		"\xAB\x6F" => '&#21371;',
		"\xAB\x70" => '&#21402;',
		"\xAB\x71" => '&#21467;',
		"\xAB\x72" => '&#21676;',
		"\xAB\x73" => '&#21696;',
		"\xAB\x74" => '&#21672;',
		"\xAB\x75" => '&#21710;',
		"\xAB\x76" => '&#21705;',
		"\xAB\x77" => '&#21688;',
		"\xAB\x78" => '&#21670;',
		"\xAB\x79" => '&#21683;',
		"\xAB\x7A" => '&#21703;',
		"\xAB\x7B" => '&#21698;',
		"\xAB\x7C" => '&#21693;',
		"\xAB\x7D" => '&#21674;',
		"\xAB\x7E" => '&#21697;',
		"\xAB\xA1" => '&#21700;',
		"\xAB\xA2" => '&#21704;',
		"\xAB\xA3" => '&#21679;',
		"\xAB\xA4" => '&#21675;',
		"\xAB\xA5" => '&#21681;',
		"\xAB\xA6" => '&#21691;',
		"\xAB\xA7" => '&#21673;',
		"\xAB\xA8" => '&#21671;',
		"\xAB\xA9" => '&#21695;',
		"\xAB\xAA" => '&#22271;',
		"\xAB\xAB" => '&#22402;',
		"\xAB\xAC" => '&#22411;',
		"\xAB\xAD" => '&#22432;',
		"\xAB\xAE" => '&#22435;',
		"\xAB\xAF" => '&#22434;',
		"\xAB\xB0" => '&#22478;',
		"\xAB\xB1" => '&#22446;',
		"\xAB\xB2" => '&#22419;',
		"\xAB\xB3" => '&#22869;',
		"\xAB\xB4" => '&#22865;',
		"\xAB\xB5" => '&#22863;',
		"\xAB\xB6" => '&#22862;',
		"\xAB\xB7" => '&#22864;',
		"\xAB\xB8" => '&#23004;',
		"\xAB\xB9" => '&#23000;',
		"\xAB\xBA" => '&#23039;',
		"\xAB\xBB" => '&#23011;',
		"\xAB\xBC" => '&#23016;',
		"\xAB\xBD" => '&#23043;',
		"\xAB\xBE" => '&#23013;',
		"\xAB\xBF" => '&#23018;',
		"\xAB\xC0" => '&#23002;',
		"\xAB\xC1" => '&#23014;',
		"\xAB\xC2" => '&#23041;',
		"\xAB\xC3" => '&#23035;',
		"\xAB\xC4" => '&#23401;',
		"\xAB\xC5" => '&#23459;',
		"\xAB\xC6" => '&#23462;',
		"\xAB\xC7" => '&#23460;',
		"\xAB\xC8" => '&#23458;',
		"\xAB\xC9" => '&#23461;',
		"\xAB\xCA" => '&#23553;',
		"\xAB\xCB" => '&#23630;',
		"\xAB\xCC" => '&#23631;',
		"\xAB\xCD" => '&#23629;',
		"\xAB\xCE" => '&#23627;',
		"\xAB\xCF" => '&#23769;',
		"\xAB\xD0" => '&#23762;',
		"\xAB\xD1" => '&#24055;',
		"\xAB\xD2" => '&#24093;',
		"\xAB\xD3" => '&#24101;',
		"\xAB\xD4" => '&#24095;',
		"\xAB\xD5" => '&#24189;',
		"\xAB\xD6" => '&#24224;',
		"\xAB\xD7" => '&#24230;',
		"\xAB\xD8" => '&#24314;',
		"\xAB\xD9" => '&#24328;',
		"\xAB\xDA" => '&#24365;',
		"\xAB\xDB" => '&#24421;',
		"\xAB\xDC" => '&#24456;',
		"\xAB\xDD" => '&#24453;',
		"\xAB\xDE" => '&#24458;',
		"\xAB\xDF" => '&#24459;',
		"\xAB\xE0" => '&#24455;',
		"\xAB\xE1" => '&#24460;',
		"\xAB\xE2" => '&#24457;',
		"\xAB\xE3" => '&#24594;',
		"\xAB\xE4" => '&#24605;',
		"\xAB\xE5" => '&#24608;',
		"\xAB\xE6" => '&#24613;',
		"\xAB\xE7" => '&#24590;',
		"\xAB\xE8" => '&#24616;',
		"\xAB\xE9" => '&#24653;',
		"\xAB\xEA" => '&#24688;',
		"\xAB\xEB" => '&#24680;',
		"\xAB\xEC" => '&#24674;',
		"\xAB\xED" => '&#24646;',
		"\xAB\xEE" => '&#24643;',
		"\xAB\xEF" => '&#24684;',
		"\xAB\xF0" => '&#24683;',
		"\xAB\xF1" => '&#24682;',
		"\xAB\xF2" => '&#24676;',
		"\xAB\xF3" => '&#25153;',
		"\xAB\xF4" => '&#25308;',
		"\xAB\xF5" => '&#25366;',
		"\xAB\xF6" => '&#25353;',
		"\xAB\xF7" => '&#25340;',
		"\xAB\xF8" => '&#25325;',
		"\xAB\xF9" => '&#25345;',
		"\xAB\xFA" => '&#25326;',
		"\xAB\xFB" => '&#25341;',
		"\xAB\xFC" => '&#25351;',
		"\xAB\xFD" => '&#25329;',
		"\xAB\xFE" => '&#25335;',
		"\xAC\x40" => '&#25327;',
		"\xAC\x41" => '&#25324;',
		"\xAC\x42" => '&#25342;',
		"\xAC\x43" => '&#25332;',
		"\xAC\x44" => '&#25361;',
		"\xAC\x45" => '&#25346;',
		"\xAC\x46" => '&#25919;',
		"\xAC\x47" => '&#25925;',
		"\xAC\x48" => '&#26027;',
		"\xAC\x49" => '&#26045;',
		"\xAC\x4A" => '&#26082;',
		"\xAC\x4B" => '&#26149;',
		"\xAC\x4C" => '&#26157;',
		"\xAC\x4D" => '&#26144;',
		"\xAC\x4E" => '&#26151;',
		"\xAC\x4F" => '&#26159;',
		"\xAC\x50" => '&#26143;',
		"\xAC\x51" => '&#26152;',
		"\xAC\x52" => '&#26161;',
		"\xAC\x53" => '&#26148;',
		"\xAC\x54" => '&#26359;',
		"\xAC\x55" => '&#26623;',
		"\xAC\x56" => '&#26579;',
		"\xAC\x57" => '&#26609;',
		"\xAC\x58" => '&#26580;',
		"\xAC\x59" => '&#26576;',
		"\xAC\x5A" => '&#26604;',
		"\xAC\x5B" => '&#26550;',
		"\xAC\x5C" => '&#26543;',
		"\xAC\x5D" => '&#26613;',
		"\xAC\x5E" => '&#26601;',
		"\xAC\x5F" => '&#26607;',
		"\xAC\x60" => '&#26564;',
		"\xAC\x61" => '&#26577;',
		"\xAC\x62" => '&#26548;',
		"\xAC\x63" => '&#26586;',
		"\xAC\x64" => '&#26597;',
		"\xAC\x65" => '&#26552;',
		"\xAC\x66" => '&#26575;',
		"\xAC\x67" => '&#26590;',
		"\xAC\x68" => '&#26611;',
		"\xAC\x69" => '&#26544;',
		"\xAC\x6A" => '&#26585;',
		"\xAC\x6B" => '&#26594;',
		"\xAC\x6C" => '&#26589;',
		"\xAC\x6D" => '&#26578;',
		"\xAC\x6E" => '&#27498;',
		"\xAC\x6F" => '&#27523;',
		"\xAC\x70" => '&#27526;',
		"\xAC\x71" => '&#27573;',
		"\xAC\x72" => '&#27602;',
		"\xAC\x73" => '&#27607;',
		"\xAC\x74" => '&#27679;',
		"\xAC\x75" => '&#27849;',
		"\xAC\x76" => '&#27915;',
		"\xAC\x77" => '&#27954;',
		"\xAC\x78" => '&#27946;',
		"\xAC\x79" => '&#27969;',
		"\xAC\x7A" => '&#27941;',
		"\xAC\x7B" => '&#27916;',
		"\xAC\x7C" => '&#27953;',
		"\xAC\x7D" => '&#27934;',
		"\xAC\x7E" => '&#27927;',
		"\xAC\xA1" => '&#27963;',
		"\xAC\xA2" => '&#27965;',
		"\xAC\xA3" => '&#27966;',
		"\xAC\xA4" => '&#27958;',
		"\xAC\xA5" => '&#27931;',
		"\xAC\xA6" => '&#27893;',
		"\xAC\xA7" => '&#27961;',
		"\xAC\xA8" => '&#27943;',
		"\xAC\xA9" => '&#27960;',
		"\xAC\xAA" => '&#27945;',
		"\xAC\xAB" => '&#27950;',
		"\xAC\xAC" => '&#27957;',
		"\xAC\xAD" => '&#27918;',
		"\xAC\xAE" => '&#27947;',
		"\xAC\xAF" => '&#28843;',
		"\xAC\xB0" => '&#28858;',
		"\xAC\xB1" => '&#28851;',
		"\xAC\xB2" => '&#28844;',
		"\xAC\xB3" => '&#28847;',
		"\xAC\xB4" => '&#28845;',
		"\xAC\xB5" => '&#28856;',
		"\xAC\xB6" => '&#28846;',
		"\xAC\xB7" => '&#28836;',
		"\xAC\xB8" => '&#29232;',
		"\xAC\xB9" => '&#29298;',
		"\xAC\xBA" => '&#29295;',
		"\xAC\xBB" => '&#29300;',
		"\xAC\xBC" => '&#29417;',
		"\xAC\xBD" => '&#29408;',
		"\xAC\xBE" => '&#29409;',
		"\xAC\xBF" => '&#29623;',
		"\xAC\xC0" => '&#29642;',
		"\xAC\xC1" => '&#29627;',
		"\xAC\xC2" => '&#29618;',
		"\xAC\xC3" => '&#29645;',
		"\xAC\xC4" => '&#29632;',
		"\xAC\xC5" => '&#29619;',
		"\xAC\xC6" => '&#29978;',
		"\xAC\xC7" => '&#29997;',
		"\xAC\xC8" => '&#30031;',
		"\xAC\xC9" => '&#30028;',
		"\xAC\xCA" => '&#30030;',
		"\xAC\xCB" => '&#30027;',
		"\xAC\xCC" => '&#30123;',
		"\xAC\xCD" => '&#30116;',
		"\xAC\xCE" => '&#30117;',
		"\xAC\xCF" => '&#30114;',
		"\xAC\xD0" => '&#30115;',
		"\xAC\xD1" => '&#30328;',
		"\xAC\xD2" => '&#30342;',
		"\xAC\xD3" => '&#30343;',
		"\xAC\xD4" => '&#30344;',
		"\xAC\xD5" => '&#30408;',
		"\xAC\xD6" => '&#30406;',
		"\xAC\xD7" => '&#30403;',
		"\xAC\xD8" => '&#30405;',
		"\xAC\xD9" => '&#30465;',
		"\xAC\xDA" => '&#30457;',
		"\xAC\xDB" => '&#30456;',
		"\xAC\xDC" => '&#30473;',
		"\xAC\xDD" => '&#30475;',
		"\xAC\xDE" => '&#30462;',
		"\xAC\xDF" => '&#30460;',
		"\xAC\xE0" => '&#30471;',
		"\xAC\xE1" => '&#30684;',
		"\xAC\xE2" => '&#30722;',
		"\xAC\xE3" => '&#30740;',
		"\xAC\xE4" => '&#30732;',
		"\xAC\xE5" => '&#30733;',
		"\xAC\xE6" => '&#31046;',
		"\xAC\xE7" => '&#31049;',
		"\xAC\xE8" => '&#31048;',
		"\xAC\xE9" => '&#31047;',
		"\xAC\xEA" => '&#31161;',
		"\xAC\xEB" => '&#31162;',
		"\xAC\xEC" => '&#31185;',
		"\xAC\xED" => '&#31186;',
		"\xAC\xEE" => '&#31179;',
		"\xAC\xEF" => '&#31359;',
		"\xAC\xF0" => '&#31361;',
		"\xAC\xF1" => '&#31487;',
		"\xAC\xF2" => '&#31485;',
		"\xAC\xF3" => '&#31869;',
		"\xAC\xF4" => '&#32002;',
		"\xAC\xF5" => '&#32005;',
		"\xAC\xF6" => '&#32000;',
		"\xAC\xF7" => '&#32009;',
		"\xAC\xF8" => '&#32007;',
		"\xAC\xF9" => '&#32004;',
		"\xAC\xFA" => '&#32006;',
		"\xAC\xFB" => '&#32568;',
		"\xAC\xFC" => '&#32654;',
		"\xAC\xFD" => '&#32703;',
		"\xAC\xFE" => '&#32772;',
		"\xAD\x40" => '&#32784;',
		"\xAD\x41" => '&#32781;',
		"\xAD\x42" => '&#32785;',
		"\xAD\x43" => '&#32822;',
		"\xAD\x44" => '&#32982;',
		"\xAD\x45" => '&#32997;',
		"\xAD\x46" => '&#32986;',
		"\xAD\x47" => '&#32963;',
		"\xAD\x48" => '&#32964;',
		"\xAD\x49" => '&#32972;',
		"\xAD\x4A" => '&#32993;',
		"\xAD\x4B" => '&#32987;',
		"\xAD\x4C" => '&#32974;',
		"\xAD\x4D" => '&#32990;',
		"\xAD\x4E" => '&#32996;',
		"\xAD\x4F" => '&#32989;',
		"\xAD\x50" => '&#33268;',
		"\xAD\x51" => '&#33314;',
		"\xAD\x52" => '&#33511;',
		"\xAD\x53" => '&#33539;',
		"\xAD\x54" => '&#33541;',
		"\xAD\x55" => '&#33507;',
		"\xAD\x56" => '&#33499;',
		"\xAD\x57" => '&#33510;',
		"\xAD\x58" => '&#33540;',
		"\xAD\x59" => '&#33509;',
		"\xAD\x5A" => '&#33538;',
		"\xAD\x5B" => '&#33545;',
		"\xAD\x5C" => '&#33490;',
		"\xAD\x5D" => '&#33495;',
		"\xAD\x5E" => '&#33521;',
		"\xAD\x5F" => '&#33537;',
		"\xAD\x60" => '&#33500;',
		"\xAD\x61" => '&#33492;',
		"\xAD\x62" => '&#33489;',
		"\xAD\x63" => '&#33502;',
		"\xAD\x64" => '&#33491;',
		"\xAD\x65" => '&#33503;',
		"\xAD\x66" => '&#33519;',
		"\xAD\x67" => '&#33542;',
		"\xAD\x68" => '&#34384;',
		"\xAD\x69" => '&#34425;',
		"\xAD\x6A" => '&#34427;',
		"\xAD\x6B" => '&#34426;',
		"\xAD\x6C" => '&#34893;',
		"\xAD\x6D" => '&#34923;',
		"\xAD\x6E" => '&#35201;',
		"\xAD\x6F" => '&#35284;',
		"\xAD\x70" => '&#35336;',
		"\xAD\x71" => '&#35330;',
		"\xAD\x72" => '&#35331;',
		"\xAD\x73" => '&#35998;',
		"\xAD\x74" => '&#36000;',
		"\xAD\x75" => '&#36212;',
		"\xAD\x76" => '&#36211;',
		"\xAD\x77" => '&#36276;',
		"\xAD\x78" => '&#36557;',
		"\xAD\x79" => '&#36556;',
		"\xAD\x7A" => '&#36848;',
		"\xAD\x7B" => '&#36838;',
		"\xAD\x7C" => '&#36834;',
		"\xAD\x7D" => '&#36842;',
		"\xAD\x7E" => '&#36837;',
		"\xAD\xA1" => '&#36845;',
		"\xAD\xA2" => '&#36843;',
		"\xAD\xA3" => '&#36836;',
		"\xAD\xA4" => '&#36840;',
		"\xAD\xA5" => '&#37066;',
		"\xAD\xA6" => '&#37070;',
		"\xAD\xA7" => '&#37057;',
		"\xAD\xA8" => '&#37059;',
		"\xAD\xA9" => '&#37195;',
		"\xAD\xAA" => '&#37194;',
		"\xAD\xAB" => '&#37325;',
		"\xAD\xAC" => '&#38274;',
		"\xAD\xAD" => '&#38480;',
		"\xAD\xAE" => '&#38475;',
		"\xAD\xAF" => '&#38476;',
		"\xAD\xB0" => '&#38477;',
		"\xAD\xB1" => '&#38754;',
		"\xAD\xB2" => '&#38761;',
		"\xAD\xB3" => '&#38859;',
		"\xAD\xB4" => '&#38893;',
		"\xAD\xB5" => '&#38899;',
		"\xAD\xB6" => '&#38913;',
		"\xAD\xB7" => '&#39080;',
		"\xAD\xB8" => '&#39131;',
		"\xAD\xB9" => '&#39135;',
		"\xAD\xBA" => '&#39318;',
		"\xAD\xBB" => '&#39321;',
		"\xAD\xBC" => '&#20056;',
		"\xAD\xBD" => '&#20147;',
		"\xAD\xBE" => '&#20492;',
		"\xAD\xBF" => '&#20493;',
		"\xAD\xC0" => '&#20515;',
		"\xAD\xC1" => '&#20463;',
		"\xAD\xC2" => '&#20518;',
		"\xAD\xC3" => '&#20517;',
		"\xAD\xC4" => '&#20472;',
		"\xAD\xC5" => '&#20521;',
		"\xAD\xC6" => '&#20502;',
		"\xAD\xC7" => '&#20486;',
		"\xAD\xC8" => '&#20540;',
		"\xAD\xC9" => '&#20511;',
		"\xAD\xCA" => '&#20506;',
		"\xAD\xCB" => '&#20498;',
		"\xAD\xCC" => '&#20497;',
		"\xAD\xCD" => '&#20474;',
		"\xAD\xCE" => '&#20480;',
		"\xAD\xCF" => '&#20500;',
		"\xAD\xD0" => '&#20520;',
		"\xAD\xD1" => '&#20465;',
		"\xAD\xD2" => '&#20513;',
		"\xAD\xD3" => '&#20491;',
		"\xAD\xD4" => '&#20505;',
		"\xAD\xD5" => '&#20504;',
		"\xAD\xD6" => '&#20467;',
		"\xAD\xD7" => '&#20462;',
		"\xAD\xD8" => '&#20525;',
		"\xAD\xD9" => '&#20522;',
		"\xAD\xDA" => '&#20478;',
		"\xAD\xDB" => '&#20523;',
		"\xAD\xDC" => '&#20489;',
		"\xAD\xDD" => '&#20860;',
		"\xAD\xDE" => '&#20900;',
		"\xAD\xDF" => '&#20901;',
		"\xAD\xE0" => '&#20898;',
		"\xAD\xE1" => '&#20941;',
		"\xAD\xE2" => '&#20940;',
		"\xAD\xE3" => '&#20934;',
		"\xAD\xE4" => '&#20939;',
		"\xAD\xE5" => '&#21078;',
		"\xAD\xE6" => '&#21084;',
		"\xAD\xE7" => '&#21076;',
		"\xAD\xE8" => '&#21083;',
		"\xAD\xE9" => '&#21085;',
		"\xAD\xEA" => '&#21290;',
		"\xAD\xEB" => '&#21375;',
		"\xAD\xEC" => '&#21407;',
		"\xAD\xED" => '&#21405;',
		"\xAD\xEE" => '&#21471;',
		"\xAD\xEF" => '&#21736;',
		"\xAD\xF0" => '&#21776;',
		"\xAD\xF1" => '&#21761;',
		"\xAD\xF2" => '&#21815;',
		"\xAD\xF3" => '&#21756;',
		"\xAD\xF4" => '&#21733;',
		"\xAD\xF5" => '&#21746;',
		"\xAD\xF6" => '&#21766;',
		"\xAD\xF7" => '&#21754;',
		"\xAD\xF8" => '&#21780;',
		"\xAD\xF9" => '&#21737;',
		"\xAD\xFA" => '&#21741;',
		"\xAD\xFB" => '&#21729;',
		"\xAD\xFC" => '&#21769;',
		"\xAD\xFD" => '&#21742;',
		"\xAD\xFE" => '&#21738;',
		"\xAE\x40" => '&#21734;',
		"\xAE\x41" => '&#21799;',
		"\xAE\x42" => '&#21767;',
		"\xAE\x43" => '&#21757;',
		"\xAE\x44" => '&#21775;',
		"\xAE\x45" => '&#22275;',
		"\xAE\x46" => '&#22276;',
		"\xAE\x47" => '&#22466;',
		"\xAE\x48" => '&#22484;',
		"\xAE\x49" => '&#22475;',
		"\xAE\x4A" => '&#22467;',
		"\xAE\x4B" => '&#22537;',
		"\xAE\x4C" => '&#22799;',
		"\xAE\x4D" => '&#22871;',
		"\xAE\x4E" => '&#22872;',
		"\xAE\x4F" => '&#22874;',
		"\xAE\x50" => '&#23057;',
		"\xAE\x51" => '&#23064;',
		"\xAE\x52" => '&#23068;',
		"\xAE\x53" => '&#23071;',
		"\xAE\x54" => '&#23067;',
		"\xAE\x55" => '&#23059;',
		"\xAE\x56" => '&#23020;',
		"\xAE\x57" => '&#23072;',
		"\xAE\x58" => '&#23075;',
		"\xAE\x59" => '&#23081;',
		"\xAE\x5A" => '&#23077;',
		"\xAE\x5B" => '&#23052;',
		"\xAE\x5C" => '&#23049;',
		"\xAE\x5D" => '&#23403;',
		"\xAE\x5E" => '&#23640;',
		"\xAE\x5F" => '&#23472;',
		"\xAE\x60" => '&#23475;',
		"\xAE\x61" => '&#23478;',
		"\xAE\x62" => '&#23476;',
		"\xAE\x63" => '&#23470;',
		"\xAE\x64" => '&#23477;',
		"\xAE\x65" => '&#23481;',
		"\xAE\x66" => '&#23480;',
		"\xAE\x67" => '&#23556;',
		"\xAE\x68" => '&#23633;',
		"\xAE\x69" => '&#23637;',
		"\xAE\x6A" => '&#23632;',
		"\xAE\x6B" => '&#23789;',
		"\xAE\x6C" => '&#23805;',
		"\xAE\x6D" => '&#23803;',
		"\xAE\x6E" => '&#23786;',
		"\xAE\x6F" => '&#23784;',
		"\xAE\x70" => '&#23792;',
		"\xAE\x71" => '&#23798;',
		"\xAE\x72" => '&#23809;',
		"\xAE\x73" => '&#23796;',
		"\xAE\x74" => '&#24046;',
		"\xAE\x75" => '&#24109;',
		"\xAE\x76" => '&#24107;',
		"\xAE\x77" => '&#24235;',
		"\xAE\x78" => '&#24237;',
		"\xAE\x79" => '&#24231;',
		"\xAE\x7A" => '&#24369;',
		"\xAE\x7B" => '&#24466;',
		"\xAE\x7C" => '&#24465;',
		"\xAE\x7D" => '&#24464;',
		"\xAE\x7E" => '&#24665;',
		"\xAE\xA1" => '&#24675;',
		"\xAE\xA2" => '&#24677;',
		"\xAE\xA3" => '&#24656;',
		"\xAE\xA4" => '&#24661;',
		"\xAE\xA5" => '&#24685;',
		"\xAE\xA6" => '&#24681;',
		"\xAE\xA7" => '&#24687;',
		"\xAE\xA8" => '&#24708;',
		"\xAE\xA9" => '&#24735;',
		"\xAE\xAA" => '&#24730;',
		"\xAE\xAB" => '&#24717;',
		"\xAE\xAC" => '&#24724;',
		"\xAE\xAD" => '&#24716;',
		"\xAE\xAE" => '&#24709;',
		"\xAE\xAF" => '&#24726;',
		"\xAE\xB0" => '&#25159;',
		"\xAE\xB1" => '&#25331;',
		"\xAE\xB2" => '&#25352;',
		"\xAE\xB3" => '&#25343;',
		"\xAE\xB4" => '&#25422;',
		"\xAE\xB5" => '&#25406;',
		"\xAE\xB6" => '&#25391;',
		"\xAE\xB7" => '&#25429;',
		"\xAE\xB8" => '&#25410;',
		"\xAE\xB9" => '&#25414;',
		"\xAE\xBA" => '&#25423;',
		"\xAE\xBB" => '&#25417;',
		"\xAE\xBC" => '&#25402;',
		"\xAE\xBD" => '&#25424;',
		"\xAE\xBE" => '&#25405;',
		"\xAE\xBF" => '&#25386;',
		"\xAE\xC0" => '&#25387;',
		"\xAE\xC1" => '&#25384;',
		"\xAE\xC2" => '&#25421;',
		"\xAE\xC3" => '&#25420;',
		"\xAE\xC4" => '&#25928;',
		"\xAE\xC5" => '&#25929;',
		"\xAE\xC6" => '&#26009;',
		"\xAE\xC7" => '&#26049;',
		"\xAE\xC8" => '&#26053;',
		"\xAE\xC9" => '&#26178;',
		"\xAE\xCA" => '&#26185;',
		"\xAE\xCB" => '&#26191;',
		"\xAE\xCC" => '&#26179;',
		"\xAE\xCD" => '&#26194;',
		"\xAE\xCE" => '&#26188;',
		"\xAE\xCF" => '&#26181;',
		"\xAE\xD0" => '&#26177;',
		"\xAE\xD1" => '&#26360;',
		"\xAE\xD2" => '&#26388;',
		"\xAE\xD3" => '&#26389;',
		"\xAE\xD4" => '&#26391;',
		"\xAE\xD5" => '&#26657;',
		"\xAE\xD6" => '&#26680;',
		"\xAE\xD7" => '&#26696;',
		"\xAE\xD8" => '&#26694;',
		"\xAE\xD9" => '&#26707;',
		"\xAE\xDA" => '&#26681;',
		"\xAE\xDB" => '&#26690;',
		"\xAE\xDC" => '&#26708;',
		"\xAE\xDD" => '&#26665;',
		"\xAE\xDE" => '&#26803;',
		"\xAE\xDF" => '&#26647;',
		"\xAE\xE0" => '&#26700;',
		"\xAE\xE1" => '&#26705;',
		"\xAE\xE2" => '&#26685;',
		"\xAE\xE3" => '&#26612;',
		"\xAE\xE4" => '&#26704;',
		"\xAE\xE5" => '&#26688;',
		"\xAE\xE6" => '&#26684;',
		"\xAE\xE7" => '&#26691;',
		"\xAE\xE8" => '&#26666;',
		"\xAE\xE9" => '&#26693;',
		"\xAE\xEA" => '&#26643;',
		"\xAE\xEB" => '&#26648;',
		"\xAE\xEC" => '&#26689;',
		"\xAE\xED" => '&#27530;',
		"\xAE\xEE" => '&#27529;',
		"\xAE\xEF" => '&#27575;',
		"\xAE\xF0" => '&#27683;',
		"\xAE\xF1" => '&#27687;',
		"\xAE\xF2" => '&#27688;',
		"\xAE\xF3" => '&#27686;',
		"\xAE\xF4" => '&#27684;',
		"\xAE\xF5" => '&#27888;',
		"\xAE\xF6" => '&#28010;',
		"\xAE\xF7" => '&#28053;',
		"\xAE\xF8" => '&#28040;',
		"\xAE\xF9" => '&#28039;',
		"\xAE\xFA" => '&#28006;',
		"\xAE\xFB" => '&#28024;',
		"\xAE\xFC" => '&#28023;',
		"\xAE\xFD" => '&#27993;',
		"\xAE\xFE" => '&#28051;',
		"\xAF\x40" => '&#28012;',
		"\xAF\x41" => '&#28041;',
		"\xAF\x42" => '&#28014;',
		"\xAF\x43" => '&#27994;',
		"\xAF\x44" => '&#28020;',
		"\xAF\x45" => '&#28009;',
		"\xAF\x46" => '&#28044;',
		"\xAF\x47" => '&#28042;',
		"\xAF\x48" => '&#28025;',
		"\xAF\x49" => '&#28037;',
		"\xAF\x4A" => '&#28005;',
		"\xAF\x4B" => '&#28052;',
		"\xAF\x4C" => '&#28874;',
		"\xAF\x4D" => '&#28888;',
		"\xAF\x4E" => '&#28900;',
		"\xAF\x4F" => '&#28889;',
		"\xAF\x50" => '&#28872;',
		"\xAF\x51" => '&#28879;',
		"\xAF\x52" => '&#29241;',
		"\xAF\x53" => '&#29305;',
		"\xAF\x54" => '&#29436;',
		"\xAF\x55" => '&#29433;',
		"\xAF\x56" => '&#29437;',
		"\xAF\x57" => '&#29432;',
		"\xAF\x58" => '&#29431;',
		"\xAF\x59" => '&#29574;',
		"\xAF\x5A" => '&#29677;',
		"\xAF\x5B" => '&#29705;',
		"\xAF\x5C" => '&#29678;',
		"\xAF\x5D" => '&#29664;',
		"\xAF\x5E" => '&#29674;',
		"\xAF\x5F" => '&#29662;',
		"\xAF\x60" => '&#30036;',
		"\xAF\x61" => '&#30045;',
		"\xAF\x62" => '&#30044;',
		"\xAF\x63" => '&#30042;',
		"\xAF\x64" => '&#30041;',
		"\xAF\x65" => '&#30142;',
		"\xAF\x66" => '&#30149;',
		"\xAF\x67" => '&#30151;',
		"\xAF\x68" => '&#30130;',
		"\xAF\x69" => '&#30131;',
		"\xAF\x6A" => '&#30141;',
		"\xAF\x6B" => '&#30140;',
		"\xAF\x6C" => '&#30137;',
		"\xAF\x6D" => '&#30146;',
		"\xAF\x6E" => '&#30136;',
		"\xAF\x6F" => '&#30347;',
		"\xAF\x70" => '&#30384;',
		"\xAF\x71" => '&#30410;',
		"\xAF\x72" => '&#30413;',
		"\xAF\x73" => '&#30414;',
		"\xAF\x74" => '&#30505;',
		"\xAF\x75" => '&#30495;',
		"\xAF\x76" => '&#30496;',
		"\xAF\x77" => '&#30504;',
		"\xAF\x78" => '&#30697;',
		"\xAF\x79" => '&#30768;',
		"\xAF\x7A" => '&#30759;',
		"\xAF\x7B" => '&#30776;',
		"\xAF\x7C" => '&#30749;',
		"\xAF\x7D" => '&#30772;',
		"\xAF\x7E" => '&#30775;',
		"\xAF\xA1" => '&#30757;',
		"\xAF\xA2" => '&#30765;',
		"\xAF\xA3" => '&#30752;',
		"\xAF\xA4" => '&#30751;',
		"\xAF\xA5" => '&#30770;',
		"\xAF\xA6" => '&#31061;',
		"\xAF\xA7" => '&#31056;',
		"\xAF\xA8" => '&#31072;',
		"\xAF\xA9" => '&#31071;',
		"\xAF\xAA" => '&#31062;',
		"\xAF\xAB" => '&#31070;',
		"\xAF\xAC" => '&#31069;',
		"\xAF\xAD" => '&#31063;',
		"\xAF\xAE" => '&#31066;',
		"\xAF\xAF" => '&#31204;',
		"\xAF\xB0" => '&#31203;',
		"\xAF\xB1" => '&#31207;',
		"\xAF\xB2" => '&#31199;',
		"\xAF\xB3" => '&#31206;',
		"\xAF\xB4" => '&#31209;',
		"\xAF\xB5" => '&#31192;',
		"\xAF\xB6" => '&#31364;',
		"\xAF\xB7" => '&#31368;',
		"\xAF\xB8" => '&#31449;',
		"\xAF\xB9" => '&#31494;',
		"\xAF\xBA" => '&#31505;',
		"\xAF\xBB" => '&#31881;',
		"\xAF\xBC" => '&#32033;',
		"\xAF\xBD" => '&#32023;',
		"\xAF\xBE" => '&#32011;',
		"\xAF\xBF" => '&#32010;',
		"\xAF\xC0" => '&#32032;',
		"\xAF\xC1" => '&#32034;',
		"\xAF\xC2" => '&#32020;',
		"\xAF\xC3" => '&#32016;',
		"\xAF\xC4" => '&#32021;',
		"\xAF\xC5" => '&#32026;',
		"\xAF\xC6" => '&#32028;',
		"\xAF\xC7" => '&#32013;',
		"\xAF\xC8" => '&#32025;',
		"\xAF\xC9" => '&#32027;',
		"\xAF\xCA" => '&#32570;',
		"\xAF\xCB" => '&#32607;',
		"\xAF\xCC" => '&#32660;',
		"\xAF\xCD" => '&#32709;',
		"\xAF\xCE" => '&#32705;',
		"\xAF\xCF" => '&#32774;',
		"\xAF\xD0" => '&#32792;',
		"\xAF\xD1" => '&#32789;',
		"\xAF\xD2" => '&#32793;',
		"\xAF\xD3" => '&#32791;',
		"\xAF\xD4" => '&#32829;',
		"\xAF\xD5" => '&#32831;',
		"\xAF\xD6" => '&#33009;',
		"\xAF\xD7" => '&#33026;',
		"\xAF\xD8" => '&#33008;',
		"\xAF\xD9" => '&#33029;',
		"\xAF\xDA" => '&#33005;',
		"\xAF\xDB" => '&#33012;',
		"\xAF\xDC" => '&#33030;',
		"\xAF\xDD" => '&#33016;',
		"\xAF\xDE" => '&#33011;',
		"\xAF\xDF" => '&#33032;',
		"\xAF\xE0" => '&#33021;',
		"\xAF\xE1" => '&#33034;',
		"\xAF\xE2" => '&#33020;',
		"\xAF\xE3" => '&#33007;',
		"\xAF\xE4" => '&#33261;',
		"\xAF\xE5" => '&#33260;',
		"\xAF\xE6" => '&#33280;',
		"\xAF\xE7" => '&#33296;',
		"\xAF\xE8" => '&#33322;',
		"\xAF\xE9" => '&#33323;',
		"\xAF\xEA" => '&#33320;',
		"\xAF\xEB" => '&#33324;',
		"\xAF\xEC" => '&#33467;',
		"\xAF\xED" => '&#33579;',
		"\xAF\xEE" => '&#33618;',
		"\xAF\xEF" => '&#33620;',
		"\xAF\xF0" => '&#33610;',
		"\xAF\xF1" => '&#33592;',
		"\xAF\xF2" => '&#33616;',
		"\xAF\xF3" => '&#33609;',
		"\xAF\xF4" => '&#33589;',
		"\xAF\xF5" => '&#33588;',
		"\xAF\xF6" => '&#33615;',
		"\xAF\xF7" => '&#33586;',
		"\xAF\xF8" => '&#33593;',
		"\xAF\xF9" => '&#33590;',
		"\xAF\xFA" => '&#33559;',
		"\xAF\xFB" => '&#33600;',
		"\xAF\xFC" => '&#33585;',
		"\xAF\xFD" => '&#33576;',
		"\xAF\xFE" => '&#33603;',
		"\xB0\x40" => '&#34388;',
		"\xB0\x41" => '&#34442;',
		"\xB0\x42" => '&#34474;',
		"\xB0\x43" => '&#34451;',
		"\xB0\x44" => '&#34468;',
		"\xB0\x45" => '&#34473;',
		"\xB0\x46" => '&#34444;',
		"\xB0\x47" => '&#34467;',
		"\xB0\x48" => '&#34460;',
		"\xB0\x49" => '&#34928;',
		"\xB0\x4A" => '&#34935;',
		"\xB0\x4B" => '&#34945;',
		"\xB0\x4C" => '&#34946;',
		"\xB0\x4D" => '&#34941;',
		"\xB0\x4E" => '&#34937;',
		"\xB0\x4F" => '&#35352;',
		"\xB0\x50" => '&#35344;',
		"\xB0\x51" => '&#35342;',
		"\xB0\x52" => '&#35340;',
		"\xB0\x53" => '&#35349;',
		"\xB0\x54" => '&#35338;',
		"\xB0\x55" => '&#35351;',
		"\xB0\x56" => '&#35347;',
		"\xB0\x57" => '&#35350;',
		"\xB0\x58" => '&#35343;',
		"\xB0\x59" => '&#35345;',
		"\xB0\x5A" => '&#35912;',
		"\xB0\x5B" => '&#35962;',
		"\xB0\x5C" => '&#35961;',
		"\xB0\x5D" => '&#36001;',
		"\xB0\x5E" => '&#36002;',
		"\xB0\x5F" => '&#36215;',
		"\xB0\x60" => '&#36524;',
		"\xB0\x61" => '&#36562;',
		"\xB0\x62" => '&#36564;',
		"\xB0\x63" => '&#36559;',
		"\xB0\x64" => '&#36785;',
		"\xB0\x65" => '&#36865;',
		"\xB0\x66" => '&#36870;',
		"\xB0\x67" => '&#36855;',
		"\xB0\x68" => '&#36864;',
		"\xB0\x69" => '&#36858;',
		"\xB0\x6A" => '&#36852;',
		"\xB0\x6B" => '&#36867;',
		"\xB0\x6C" => '&#36861;',
		"\xB0\x6D" => '&#36869;',
		"\xB0\x6E" => '&#36856;',
		"\xB0\x6F" => '&#37013;',
		"\xB0\x70" => '&#37089;',
		"\xB0\x71" => '&#37085;',
		"\xB0\x72" => '&#37090;',
		"\xB0\x73" => '&#37202;',
		"\xB0\x74" => '&#37197;',
		"\xB0\x75" => '&#37196;',
		"\xB0\x76" => '&#37336;',
		"\xB0\x77" => '&#37341;',
		"\xB0\x78" => '&#37335;',
		"\xB0\x79" => '&#37340;',
		"\xB0\x7A" => '&#37337;',
		"\xB0\x7B" => '&#38275;',
		"\xB0\x7C" => '&#38498;',
		"\xB0\x7D" => '&#38499;',
		"\xB0\x7E" => '&#38497;',
		"\xB0\xA1" => '&#38491;',
		"\xB0\xA2" => '&#38493;',
		"\xB0\xA3" => '&#38500;',
		"\xB0\xA4" => '&#38488;',
		"\xB0\xA5" => '&#38494;',
		"\xB0\xA6" => '&#38587;',
		"\xB0\xA7" => '&#39138;',
		"\xB0\xA8" => '&#39340;',
		"\xB0\xA9" => '&#39592;',
		"\xB0\xAA" => '&#39640;',
		"\xB0\xAB" => '&#39717;',
		"\xB0\xAC" => '&#39730;',
		"\xB0\xAD" => '&#39740;',
		"\xB0\xAE" => '&#20094;',
		"\xB0\xAF" => '&#20602;',
		"\xB0\xB0" => '&#20605;',
		"\xB0\xB1" => '&#20572;',
		"\xB0\xB2" => '&#20551;',
		"\xB0\xB3" => '&#20547;',
		"\xB0\xB4" => '&#20556;',
		"\xB0\xB5" => '&#20570;',
		"\xB0\xB6" => '&#20553;',
		"\xB0\xB7" => '&#20581;',
		"\xB0\xB8" => '&#20598;',
		"\xB0\xB9" => '&#20558;',
		"\xB0\xBA" => '&#20565;',
		"\xB0\xBB" => '&#20597;',
		"\xB0\xBC" => '&#20596;',
		"\xB0\xBD" => '&#20599;',
		"\xB0\xBE" => '&#20559;',
		"\xB0\xBF" => '&#20495;',
		"\xB0\xC0" => '&#20591;',
		"\xB0\xC1" => '&#20589;',
		"\xB0\xC2" => '&#20828;',
		"\xB0\xC3" => '&#20885;',
		"\xB0\xC4" => '&#20976;',
		"\xB0\xC5" => '&#21098;',
		"\xB0\xC6" => '&#21103;',
		"\xB0\xC7" => '&#21202;',
		"\xB0\xC8" => '&#21209;',
		"\xB0\xC9" => '&#21208;',
		"\xB0\xCA" => '&#21205;',
		"\xB0\xCB" => '&#21264;',
		"\xB0\xCC" => '&#21263;',
		"\xB0\xCD" => '&#21273;',
		"\xB0\xCE" => '&#21311;',
		"\xB0\xCF" => '&#21312;',
		"\xB0\xD0" => '&#21310;',
		"\xB0\xD1" => '&#21443;',
		"\xB0\xD2" => '&#26364;',
		"\xB0\xD3" => '&#21830;',
		"\xB0\xD4" => '&#21866;',
		"\xB0\xD5" => '&#21862;',
		"\xB0\xD6" => '&#21828;',
		"\xB0\xD7" => '&#21854;',
		"\xB0\xD8" => '&#21857;',
		"\xB0\xD9" => '&#21827;',
		"\xB0\xDA" => '&#21834;',
		"\xB0\xDB" => '&#21809;',
		"\xB0\xDC" => '&#21846;',
		"\xB0\xDD" => '&#21839;',
		"\xB0\xDE" => '&#21845;',
		"\xB0\xDF" => '&#21807;',
		"\xB0\xE0" => '&#21860;',
		"\xB0\xE1" => '&#21816;',
		"\xB0\xE2" => '&#21806;',
		"\xB0\xE3" => '&#21852;',
		"\xB0\xE4" => '&#21804;',
		"\xB0\xE5" => '&#21859;',
		"\xB0\xE6" => '&#21811;',
		"\xB0\xE7" => '&#21825;',
		"\xB0\xE8" => '&#21847;',
		"\xB0\xE9" => '&#22280;',
		"\xB0\xEA" => '&#22283;',
		"\xB0\xEB" => '&#22281;',
		"\xB0\xEC" => '&#22495;',
		"\xB0\xED" => '&#22533;',
		"\xB0\xEE" => '&#22538;',
		"\xB0\xEF" => '&#22534;',
		"\xB0\xF0" => '&#22496;',
		"\xB0\xF1" => '&#22500;',
		"\xB0\xF2" => '&#22522;',
		"\xB0\xF3" => '&#22530;',
		"\xB0\xF4" => '&#22581;',
		"\xB0\xF5" => '&#22519;',
		"\xB0\xF6" => '&#22521;',
		"\xB0\xF7" => '&#22816;',
		"\xB0\xF8" => '&#22882;',
		"\xB0\xF9" => '&#23094;',
		"\xB0\xFA" => '&#23105;',
		"\xB0\xFB" => '&#23113;',
		"\xB0\xFC" => '&#23142;',
		"\xB0\xFD" => '&#23146;',
		"\xB0\xFE" => '&#23104;',
		"\xB1\x40" => '&#23100;',
		"\xB1\x41" => '&#23138;',
		"\xB1\x42" => '&#23130;',
		"\xB1\x43" => '&#23110;',
		"\xB1\x44" => '&#23114;',
		"\xB1\x45" => '&#23408;',
		"\xB1\x46" => '&#23495;',
		"\xB1\x47" => '&#23493;',
		"\xB1\x48" => '&#23492;',
		"\xB1\x49" => '&#23490;',
		"\xB1\x4A" => '&#23487;',
		"\xB1\x4B" => '&#23494;',
		"\xB1\x4C" => '&#23561;',
		"\xB1\x4D" => '&#23560;',
		"\xB1\x4E" => '&#23559;',
		"\xB1\x4F" => '&#23648;',
		"\xB1\x50" => '&#23644;',
		"\xB1\x51" => '&#23645;',
		"\xB1\x52" => '&#23815;',
		"\xB1\x53" => '&#23814;',
		"\xB1\x54" => '&#23822;',
		"\xB1\x55" => '&#23835;',
		"\xB1\x56" => '&#23830;',
		"\xB1\x57" => '&#23842;',
		"\xB1\x58" => '&#23825;',
		"\xB1\x59" => '&#23849;',
		"\xB1\x5A" => '&#23828;',
		"\xB1\x5B" => '&#23833;',
		"\xB1\x5C" => '&#23844;',
		"\xB1\x5D" => '&#23847;',
		"\xB1\x5E" => '&#23831;',
		"\xB1\x5F" => '&#24034;',
		"\xB1\x60" => '&#24120;',
		"\xB1\x61" => '&#24118;',
		"\xB1\x62" => '&#24115;',
		"\xB1\x63" => '&#24119;',
		"\xB1\x64" => '&#24247;',
		"\xB1\x65" => '&#24248;',
		"\xB1\x66" => '&#24246;',
		"\xB1\x67" => '&#24245;',
		"\xB1\x68" => '&#24254;',
		"\xB1\x69" => '&#24373;',
		"\xB1\x6A" => '&#24375;',
		"\xB1\x6B" => '&#24407;',
		"\xB1\x6C" => '&#24428;',
		"\xB1\x6D" => '&#24425;',
		"\xB1\x6E" => '&#24427;',
		"\xB1\x6F" => '&#24471;',
		"\xB1\x70" => '&#24473;',
		"\xB1\x71" => '&#24478;',
		"\xB1\x72" => '&#24472;',
		"\xB1\x73" => '&#24481;',
		"\xB1\x74" => '&#24480;',
		"\xB1\x75" => '&#24476;',
		"\xB1\x76" => '&#24703;',
		"\xB1\x77" => '&#24739;',
		"\xB1\x78" => '&#24713;',
		"\xB1\x79" => '&#24736;',
		"\xB1\x7A" => '&#24744;',
		"\xB1\x7B" => '&#24779;',
		"\xB1\x7C" => '&#24756;',
		"\xB1\x7D" => '&#24806;',
		"\xB1\x7E" => '&#24765;',
		"\xB1\xA1" => '&#24773;',
		"\xB1\xA2" => '&#24763;',
		"\xB1\xA3" => '&#24757;',
		"\xB1\xA4" => '&#24796;',
		"\xB1\xA5" => '&#24764;',
		"\xB1\xA6" => '&#24792;',
		"\xB1\xA7" => '&#24789;',
		"\xB1\xA8" => '&#24774;',
		"\xB1\xA9" => '&#24799;',
		"\xB1\xAA" => '&#24760;',
		"\xB1\xAB" => '&#24794;',
		"\xB1\xAC" => '&#24775;',
		"\xB1\xAD" => '&#25114;',
		"\xB1\xAE" => '&#25115;',
		"\xB1\xAF" => '&#25160;',
		"\xB1\xB0" => '&#25504;',
		"\xB1\xB1" => '&#25511;',
		"\xB1\xB2" => '&#25458;',
		"\xB1\xB3" => '&#25494;',
		"\xB1\xB4" => '&#25506;',
		"\xB1\xB5" => '&#25509;',
		"\xB1\xB6" => '&#25463;',
		"\xB1\xB7" => '&#25447;',
		"\xB1\xB8" => '&#25496;',
		"\xB1\xB9" => '&#25514;',
		"\xB1\xBA" => '&#25457;',
		"\xB1\xBB" => '&#25513;',
		"\xB1\xBC" => '&#25481;',
		"\xB1\xBD" => '&#25475;',
		"\xB1\xBE" => '&#25499;',
		"\xB1\xBF" => '&#25451;',
		"\xB1\xC0" => '&#25512;',
		"\xB1\xC1" => '&#25476;',
		"\xB1\xC2" => '&#25480;',
		"\xB1\xC3" => '&#25497;',
		"\xB1\xC4" => '&#25505;',
		"\xB1\xC5" => '&#25516;',
		"\xB1\xC6" => '&#25490;',
		"\xB1\xC7" => '&#25487;',
		"\xB1\xC8" => '&#25472;',
		"\xB1\xC9" => '&#25467;',
		"\xB1\xCA" => '&#25449;',
		"\xB1\xCB" => '&#25448;',
		"\xB1\xCC" => '&#25466;',
		"\xB1\xCD" => '&#25949;',
		"\xB1\xCE" => '&#25942;',
		"\xB1\xCF" => '&#25937;',
		"\xB1\xD0" => '&#25945;',
		"\xB1\xD1" => '&#25943;',
		"\xB1\xD2" => '&#21855;',
		"\xB1\xD3" => '&#25935;',
		"\xB1\xD4" => '&#25944;',
		"\xB1\xD5" => '&#25941;',
		"\xB1\xD6" => '&#25940;',
		"\xB1\xD7" => '&#26012;',
		"\xB1\xD8" => '&#26011;',
		"\xB1\xD9" => '&#26028;',
		"\xB1\xDA" => '&#26063;',
		"\xB1\xDB" => '&#26059;',
		"\xB1\xDC" => '&#26060;',
		"\xB1\xDD" => '&#26062;',
		"\xB1\xDE" => '&#26205;',
		"\xB1\xDF" => '&#26202;',
		"\xB1\xE0" => '&#26212;',
		"\xB1\xE1" => '&#26216;',
		"\xB1\xE2" => '&#26214;',
		"\xB1\xE3" => '&#26206;',
		"\xB1\xE4" => '&#26361;',
		"\xB1\xE5" => '&#21207;',
		"\xB1\xE6" => '&#26395;',
		"\xB1\xE7" => '&#26753;',
		"\xB1\xE8" => '&#26799;',
		"\xB1\xE9" => '&#26786;',
		"\xB1\xEA" => '&#26771;',
		"\xB1\xEB" => '&#26805;',
		"\xB1\xEC" => '&#26751;',
		"\xB1\xED" => '&#26742;',
		"\xB1\xEE" => '&#26801;',
		"\xB1\xEF" => '&#26791;',
		"\xB1\xF0" => '&#26775;',
		"\xB1\xF1" => '&#26800;',
		"\xB1\xF2" => '&#26755;',
		"\xB1\xF3" => '&#26820;',
		"\xB1\xF4" => '&#26797;',
		"\xB1\xF5" => '&#26758;',
		"\xB1\xF6" => '&#26757;',
		"\xB1\xF7" => '&#26772;',
		"\xB1\xF8" => '&#26781;',
		"\xB1\xF9" => '&#26792;',
		"\xB1\xFA" => '&#26783;',
		"\xB1\xFB" => '&#26785;',
		"\xB1\xFC" => '&#26754;',
		"\xB1\xFD" => '&#27442;',
		"\xB1\xFE" => '&#27578;',
		"\xB2\x40" => '&#27627;',
		"\xB2\x41" => '&#27628;',
		"\xB2\x42" => '&#27691;',
		"\xB2\x43" => '&#28046;',
		"\xB2\x44" => '&#28092;',
		"\xB2\x45" => '&#28147;',
		"\xB2\x46" => '&#28121;',
		"\xB2\x47" => '&#28082;',
		"\xB2\x48" => '&#28129;',
		"\xB2\x49" => '&#28108;',
		"\xB2\x4A" => '&#28132;',
		"\xB2\x4B" => '&#28155;',
		"\xB2\x4C" => '&#28154;',
		"\xB2\x4D" => '&#28165;',
		"\xB2\x4E" => '&#28103;',
		"\xB2\x4F" => '&#28107;',
		"\xB2\x50" => '&#28079;',
		"\xB2\x51" => '&#28113;',
		"\xB2\x52" => '&#28078;',
		"\xB2\x53" => '&#28126;',
		"\xB2\x54" => '&#28153;',
		"\xB2\x55" => '&#28088;',
		"\xB2\x56" => '&#28151;',
		"\xB2\x57" => '&#28149;',
		"\xB2\x58" => '&#28101;',
		"\xB2\x59" => '&#28114;',
		"\xB2\x5A" => '&#28186;',
		"\xB2\x5B" => '&#28085;',
		"\xB2\x5C" => '&#28122;',
		"\xB2\x5D" => '&#28139;',
		"\xB2\x5E" => '&#28120;',
		"\xB2\x5F" => '&#28138;',
		"\xB2\x60" => '&#28145;',
		"\xB2\x61" => '&#28142;',
		"\xB2\x62" => '&#28136;',
		"\xB2\x63" => '&#28102;',
		"\xB2\x64" => '&#28100;',
		"\xB2\x65" => '&#28074;',
		"\xB2\x66" => '&#28140;',
		"\xB2\x67" => '&#28095;',
		"\xB2\x68" => '&#28134;',
		"\xB2\x69" => '&#28921;',
		"\xB2\x6A" => '&#28937;',
		"\xB2\x6B" => '&#28938;',
		"\xB2\x6C" => '&#28925;',
		"\xB2\x6D" => '&#28911;',
		"\xB2\x6E" => '&#29245;',
		"\xB2\x6F" => '&#29309;',
		"\xB2\x70" => '&#29313;',
		"\xB2\x71" => '&#29468;',
		"\xB2\x72" => '&#29467;',
		"\xB2\x73" => '&#29462;',
		"\xB2\x74" => '&#29459;',
		"\xB2\x75" => '&#29465;',
		"\xB2\x76" => '&#29575;',
		"\xB2\x77" => '&#29701;',
		"\xB2\x78" => '&#29706;',
		"\xB2\x79" => '&#29699;',
		"\xB2\x7A" => '&#29702;',
		"\xB2\x7B" => '&#29694;',
		"\xB2\x7C" => '&#29709;',
		"\xB2\x7D" => '&#29920;',
		"\xB2\x7E" => '&#29942;',
		"\xB2\xA1" => '&#29943;',
		"\xB2\xA2" => '&#29980;',
		"\xB2\xA3" => '&#29986;',
		"\xB2\xA4" => '&#30053;',
		"\xB2\xA5" => '&#30054;',
		"\xB2\xA6" => '&#30050;',
		"\xB2\xA7" => '&#30064;',
		"\xB2\xA8" => '&#30095;',
		"\xB2\xA9" => '&#30164;',
		"\xB2\xAA" => '&#30165;',
		"\xB2\xAB" => '&#30133;',
		"\xB2\xAC" => '&#30154;',
		"\xB2\xAD" => '&#30157;',
		"\xB2\xAE" => '&#30350;',
		"\xB2\xAF" => '&#30420;',
		"\xB2\xB0" => '&#30418;',
		"\xB2\xB1" => '&#30427;',
		"\xB2\xB2" => '&#30519;',
		"\xB2\xB3" => '&#30526;',
		"\xB2\xB4" => '&#30524;',
		"\xB2\xB5" => '&#30518;',
		"\xB2\xB6" => '&#30520;',
		"\xB2\xB7" => '&#30522;',
		"\xB2\xB8" => '&#30827;',
		"\xB2\xB9" => '&#30787;',
		"\xB2\xBA" => '&#30798;',
		"\xB2\xBB" => '&#31077;',
		"\xB2\xBC" => '&#31080;',
		"\xB2\xBD" => '&#31085;',
		"\xB2\xBE" => '&#31227;',
		"\xB2\xBF" => '&#31378;',
		"\xB2\xC0" => '&#31381;',
		"\xB2\xC1" => '&#31520;',
		"\xB2\xC2" => '&#31528;',
		"\xB2\xC3" => '&#31515;',
		"\xB2\xC4" => '&#31532;',
		"\xB2\xC5" => '&#31526;',
		"\xB2\xC6" => '&#31513;',
		"\xB2\xC7" => '&#31518;',
		"\xB2\xC8" => '&#31534;',
		"\xB2\xC9" => '&#31890;',
		"\xB2\xCA" => '&#31895;',
		"\xB2\xCB" => '&#31893;',
		"\xB2\xCC" => '&#32070;',
		"\xB2\xCD" => '&#32067;',
		"\xB2\xCE" => '&#32113;',
		"\xB2\xCF" => '&#32046;',
		"\xB2\xD0" => '&#32057;',
		"\xB2\xD1" => '&#32060;',
		"\xB2\xD2" => '&#32064;',
		"\xB2\xD3" => '&#32048;',
		"\xB2\xD4" => '&#32051;',
		"\xB2\xD5" => '&#32068;',
		"\xB2\xD6" => '&#32047;',
		"\xB2\xD7" => '&#32066;',
		"\xB2\xD8" => '&#32050;',
		"\xB2\xD9" => '&#32049;',
		"\xB2\xDA" => '&#32573;',
		"\xB2\xDB" => '&#32670;',
		"\xB2\xDC" => '&#32666;',
		"\xB2\xDD" => '&#32716;',
		"\xB2\xDE" => '&#32718;',
		"\xB2\xDF" => '&#32722;',
		"\xB2\xE0" => '&#32796;',
		"\xB2\xE1" => '&#32842;',
		"\xB2\xE2" => '&#32838;',
		"\xB2\xE3" => '&#33071;',
		"\xB2\xE4" => '&#33046;',
		"\xB2\xE5" => '&#33059;',
		"\xB2\xE6" => '&#33067;',
		"\xB2\xE7" => '&#33065;',
		"\xB2\xE8" => '&#33072;',
		"\xB2\xE9" => '&#33060;',
		"\xB2\xEA" => '&#33282;',
		"\xB2\xEB" => '&#33333;',
		"\xB2\xEC" => '&#33335;',
		"\xB2\xED" => '&#33334;',
		"\xB2\xEE" => '&#33337;',
		"\xB2\xEF" => '&#33678;',
		"\xB2\xF0" => '&#33694;',
		"\xB2\xF1" => '&#33688;',
		"\xB2\xF2" => '&#33656;',
		"\xB2\xF3" => '&#33698;',
		"\xB2\xF4" => '&#33686;',
		"\xB2\xF5" => '&#33725;',
		"\xB2\xF6" => '&#33707;',
		"\xB2\xF7" => '&#33682;',
		"\xB2\xF8" => '&#33674;',
		"\xB2\xF9" => '&#33683;',
		"\xB2\xFA" => '&#33673;',
		"\xB2\xFB" => '&#33696;',
		"\xB2\xFC" => '&#33655;',
		"\xB2\xFD" => '&#33659;',
		"\xB2\xFE" => '&#33660;',
		"\xB3\x40" => '&#33670;',
		"\xB3\x41" => '&#33703;',
		"\xB3\x42" => '&#34389;',
		"\xB3\x43" => '&#24426;',
		"\xB3\x44" => '&#34503;',
		"\xB3\x45" => '&#34496;',
		"\xB3\x46" => '&#34486;',
		"\xB3\x47" => '&#34500;',
		"\xB3\x48" => '&#34485;',
		"\xB3\x49" => '&#34502;',
		"\xB3\x4A" => '&#34507;',
		"\xB3\x4B" => '&#34481;',
		"\xB3\x4C" => '&#34479;',
		"\xB3\x4D" => '&#34505;',
		"\xB3\x4E" => '&#34899;',
		"\xB3\x4F" => '&#34974;',
		"\xB3\x50" => '&#34952;',
		"\xB3\x51" => '&#34987;',
		"\xB3\x52" => '&#34962;',
		"\xB3\x53" => '&#34966;',
		"\xB3\x54" => '&#34957;',
		"\xB3\x55" => '&#34955;',
		"\xB3\x56" => '&#35219;',
		"\xB3\x57" => '&#35215;',
		"\xB3\x58" => '&#35370;',
		"\xB3\x59" => '&#35357;',
		"\xB3\x5A" => '&#35363;',
		"\xB3\x5B" => '&#35365;',
		"\xB3\x5C" => '&#35377;',
		"\xB3\x5D" => '&#35373;',
		"\xB3\x5E" => '&#35359;',
		"\xB3\x5F" => '&#35355;',
		"\xB3\x60" => '&#35362;',
		"\xB3\x61" => '&#35913;',
		"\xB3\x62" => '&#35930;',
		"\xB3\x63" => '&#36009;',
		"\xB3\x64" => '&#36012;',
		"\xB3\x65" => '&#36011;',
		"\xB3\x66" => '&#36008;',
		"\xB3\x67" => '&#36010;',
		"\xB3\x68" => '&#36007;',
		"\xB3\x69" => '&#36199;',
		"\xB3\x6A" => '&#36198;',
		"\xB3\x6B" => '&#36286;',
		"\xB3\x6C" => '&#36282;',
		"\xB3\x6D" => '&#36571;',
		"\xB3\x6E" => '&#36575;',
		"\xB3\x6F" => '&#36889;',
		"\xB3\x70" => '&#36877;',
		"\xB3\x71" => '&#36890;',
		"\xB3\x72" => '&#36887;',
		"\xB3\x73" => '&#36899;',
		"\xB3\x74" => '&#36895;',
		"\xB3\x75" => '&#36893;',
		"\xB3\x76" => '&#36880;',
		"\xB3\x77" => '&#36885;',
		"\xB3\x78" => '&#36894;',
		"\xB3\x79" => '&#36896;',
		"\xB3\x7A" => '&#36879;',
		"\xB3\x7B" => '&#36898;',
		"\xB3\x7C" => '&#36886;',
		"\xB3\x7D" => '&#36891;',
		"\xB3\x7E" => '&#36884;',
		"\xB3\xA1" => '&#37096;',
		"\xB3\xA2" => '&#37101;',
		"\xB3\xA3" => '&#37117;',
		"\xB3\xA4" => '&#37207;',
		"\xB3\xA5" => '&#37326;',
		"\xB3\xA6" => '&#37365;',
		"\xB3\xA7" => '&#37350;',
		"\xB3\xA8" => '&#37347;',
		"\xB3\xA9" => '&#37351;',
		"\xB3\xAA" => '&#37357;',
		"\xB3\xAB" => '&#37353;',
		"\xB3\xAC" => '&#38281;',
		"\xB3\xAD" => '&#38506;',
		"\xB3\xAE" => '&#38517;',
		"\xB3\xAF" => '&#38515;',
		"\xB3\xB0" => '&#38520;',
		"\xB3\xB1" => '&#38512;',
		"\xB3\xB2" => '&#38516;',
		"\xB3\xB3" => '&#38518;',
		"\xB3\xB4" => '&#38519;',
		"\xB3\xB5" => '&#38508;',
		"\xB3\xB6" => '&#38592;',
		"\xB3\xB7" => '&#38634;',
		"\xB3\xB8" => '&#38633;',
		"\xB3\xB9" => '&#31456;',
		"\xB3\xBA" => '&#31455;',
		"\xB3\xBB" => '&#38914;',
		"\xB3\xBC" => '&#38915;',
		"\xB3\xBD" => '&#39770;',
		"\xB3\xBE" => '&#40165;',
		"\xB3\xBF" => '&#40565;',
		"\xB3\xC0" => '&#40575;',
		"\xB3\xC1" => '&#40613;',
		"\xB3\xC2" => '&#40635;',
		"\xB3\xC3" => '&#20642;',
		"\xB3\xC4" => '&#20621;',
		"\xB3\xC5" => '&#20613;',
		"\xB3\xC6" => '&#20633;',
		"\xB3\xC7" => '&#20625;',
		"\xB3\xC8" => '&#20608;',
		"\xB3\xC9" => '&#20630;',
		"\xB3\xCA" => '&#20632;',
		"\xB3\xCB" => '&#20634;',
		"\xB3\xCC" => '&#26368;',
		"\xB3\xCD" => '&#20977;',
		"\xB3\xCE" => '&#21106;',
		"\xB3\xCF" => '&#21108;',
		"\xB3\xD0" => '&#21109;',
		"\xB3\xD1" => '&#21097;',
		"\xB3\xD2" => '&#21214;',
		"\xB3\xD3" => '&#21213;',
		"\xB3\xD4" => '&#21211;',
		"\xB3\xD5" => '&#21338;',
		"\xB3\xD6" => '&#21413;',
		"\xB3\xD7" => '&#21883;',
		"\xB3\xD8" => '&#21888;',
		"\xB3\xD9" => '&#21927;',
		"\xB3\xDA" => '&#21884;',
		"\xB3\xDB" => '&#21898;',
		"\xB3\xDC" => '&#21917;',
		"\xB3\xDD" => '&#21912;',
		"\xB3\xDE" => '&#21890;',
		"\xB3\xDF" => '&#21916;',
		"\xB3\xE0" => '&#21930;',
		"\xB3\xE1" => '&#21908;',
		"\xB3\xE2" => '&#21895;',
		"\xB3\xE3" => '&#21899;',
		"\xB3\xE4" => '&#21891;',
		"\xB3\xE5" => '&#21939;',
		"\xB3\xE6" => '&#21934;',
		"\xB3\xE7" => '&#21919;',
		"\xB3\xE8" => '&#21822;',
		"\xB3\xE9" => '&#21938;',
		"\xB3\xEA" => '&#21914;',
		"\xB3\xEB" => '&#21947;',
		"\xB3\xEC" => '&#21932;',
		"\xB3\xED" => '&#21937;',
		"\xB3\xEE" => '&#21886;',
		"\xB3\xEF" => '&#21897;',
		"\xB3\xF0" => '&#21931;',
		"\xB3\xF1" => '&#21913;',
		"\xB3\xF2" => '&#22285;',
		"\xB3\xF3" => '&#22575;',
		"\xB3\xF4" => '&#22570;',
		"\xB3\xF5" => '&#22580;',
		"\xB3\xF6" => '&#22564;',
		"\xB3\xF7" => '&#22576;',
		"\xB3\xF8" => '&#22577;',
		"\xB3\xF9" => '&#22561;',
		"\xB3\xFA" => '&#22557;',
		"\xB3\xFB" => '&#22560;',
		"\xB3\xFC" => '&#22777;',
		"\xB3\xFD" => '&#22778;',
		"\xB3\xFE" => '&#22880;',
		"\xB4\x40" => '&#23159;',
		"\xB4\x41" => '&#23194;',
		"\xB4\x42" => '&#23167;',
		"\xB4\x43" => '&#23186;',
		"\xB4\x44" => '&#23195;',
		"\xB4\x45" => '&#23207;',
		"\xB4\x46" => '&#23411;',
		"\xB4\x47" => '&#23409;',
		"\xB4\x48" => '&#23506;',
		"\xB4\x49" => '&#23500;',
		"\xB4\x4A" => '&#23507;',
		"\xB4\x4B" => '&#23504;',
		"\xB4\x4C" => '&#23562;',
		"\xB4\x4D" => '&#23563;',
		"\xB4\x4E" => '&#23601;',
		"\xB4\x4F" => '&#23884;',
		"\xB4\x50" => '&#23888;',
		"\xB4\x51" => '&#23860;',
		"\xB4\x52" => '&#23879;',
		"\xB4\x53" => '&#24061;',
		"\xB4\x54" => '&#24133;',
		"\xB4\x55" => '&#24125;',
		"\xB4\x56" => '&#24128;',
		"\xB4\x57" => '&#24131;',
		"\xB4\x58" => '&#24190;',
		"\xB4\x59" => '&#24266;',
		"\xB4\x5A" => '&#24257;',
		"\xB4\x5B" => '&#24258;',
		"\xB4\x5C" => '&#24260;',
		"\xB4\x5D" => '&#24380;',
		"\xB4\x5E" => '&#24429;',
		"\xB4\x5F" => '&#24489;',
		"\xB4\x60" => '&#24490;',
		"\xB4\x61" => '&#24488;',
		"\xB4\x62" => '&#24785;',
		"\xB4\x63" => '&#24801;',
		"\xB4\x64" => '&#24754;',
		"\xB4\x65" => '&#24758;',
		"\xB4\x66" => '&#24800;',
		"\xB4\x67" => '&#24860;',
		"\xB4\x68" => '&#24867;',
		"\xB4\x69" => '&#24826;',
		"\xB4\x6A" => '&#24853;',
		"\xB4\x6B" => '&#24816;',
		"\xB4\x6C" => '&#24827;',
		"\xB4\x6D" => '&#24820;',
		"\xB4\x6E" => '&#24936;',
		"\xB4\x6F" => '&#24817;',
		"\xB4\x70" => '&#24846;',
		"\xB4\x71" => '&#24822;',
		"\xB4\x72" => '&#24841;',
		"\xB4\x73" => '&#24832;',
		"\xB4\x74" => '&#24850;',
		"\xB4\x75" => '&#25119;',
		"\xB4\x76" => '&#25161;',
		"\xB4\x77" => '&#25507;',
		"\xB4\x78" => '&#25484;',
		"\xB4\x79" => '&#25551;',
		"\xB4\x7A" => '&#25536;',
		"\xB4\x7B" => '&#25577;',
		"\xB4\x7C" => '&#25545;',
		"\xB4\x7D" => '&#25542;',
		"\xB4\x7E" => '&#25549;',
		"\xB4\xA1" => '&#25554;',
		"\xB4\xA2" => '&#25571;',
		"\xB4\xA3" => '&#25552;',
		"\xB4\xA4" => '&#25569;',
		"\xB4\xA5" => '&#25558;',
		"\xB4\xA6" => '&#25581;',
		"\xB4\xA7" => '&#25582;',
		"\xB4\xA8" => '&#25462;',
		"\xB4\xA9" => '&#25588;',
		"\xB4\xAA" => '&#25578;',
		"\xB4\xAB" => '&#25563;',
		"\xB4\xAC" => '&#25682;',
		"\xB4\xAD" => '&#25562;',
		"\xB4\xAE" => '&#25593;',
		"\xB4\xAF" => '&#25950;',
		"\xB4\xB0" => '&#25958;',
		"\xB4\xB1" => '&#25954;',
		"\xB4\xB2" => '&#25955;',
		"\xB4\xB3" => '&#26001;',
		"\xB4\xB4" => '&#26000;',
		"\xB4\xB5" => '&#26031;',
		"\xB4\xB6" => '&#26222;',
		"\xB4\xB7" => '&#26224;',
		"\xB4\xB8" => '&#26228;',
		"\xB4\xB9" => '&#26230;',
		"\xB4\xBA" => '&#26223;',
		"\xB4\xBB" => '&#26257;',
		"\xB4\xBC" => '&#26234;',
		"\xB4\xBD" => '&#26238;',
		"\xB4\xBE" => '&#26231;',
		"\xB4\xBF" => '&#26366;',
		"\xB4\xC0" => '&#26367;',
		"\xB4\xC1" => '&#26399;',
		"\xB4\xC2" => '&#26397;',
		"\xB4\xC3" => '&#26874;',
		"\xB4\xC4" => '&#26837;',
		"\xB4\xC5" => '&#26848;',
		"\xB4\xC6" => '&#26840;',
		"\xB4\xC7" => '&#26839;',
		"\xB4\xC8" => '&#26885;',
		"\xB4\xC9" => '&#26847;',
		"\xB4\xCA" => '&#26869;',
		"\xB4\xCB" => '&#26862;',
		"\xB4\xCC" => '&#26855;',
		"\xB4\xCD" => '&#26873;',
		"\xB4\xCE" => '&#26834;',
		"\xB4\xCF" => '&#26866;',
		"\xB4\xD0" => '&#26851;',
		"\xB4\xD1" => '&#26827;',
		"\xB4\xD2" => '&#26829;',
		"\xB4\xD3" => '&#26893;',
		"\xB4\xD4" => '&#26898;',
		"\xB4\xD5" => '&#26894;',
		"\xB4\xD6" => '&#26825;',
		"\xB4\xD7" => '&#26842;',
		"\xB4\xD8" => '&#26990;',
		"\xB4\xD9" => '&#26875;',
		"\xB4\xDA" => '&#27454;',
		"\xB4\xDB" => '&#27450;',
		"\xB4\xDC" => '&#27453;',
		"\xB4\xDD" => '&#27544;',
		"\xB4\xDE" => '&#27542;',
		"\xB4\xDF" => '&#27580;',
		"\xB4\xE0" => '&#27631;',
		"\xB4\xE1" => '&#27694;',
		"\xB4\xE2" => '&#27695;',
		"\xB4\xE3" => '&#27692;',
		"\xB4\xE4" => '&#28207;',
		"\xB4\xE5" => '&#28216;',
		"\xB4\xE6" => '&#28244;',
		"\xB4\xE7" => '&#28193;',
		"\xB4\xE8" => '&#28210;',
		"\xB4\xE9" => '&#28263;',
		"\xB4\xEA" => '&#28234;',
		"\xB4\xEB" => '&#28192;',
		"\xB4\xEC" => '&#28197;',
		"\xB4\xED" => '&#28195;',
		"\xB4\xEE" => '&#28187;',
		"\xB4\xEF" => '&#28251;',
		"\xB4\xF0" => '&#28248;',
		"\xB4\xF1" => '&#28196;',
		"\xB4\xF2" => '&#28246;',
		"\xB4\xF3" => '&#28270;',
		"\xB4\xF4" => '&#28205;',
		"\xB4\xF5" => '&#28198;',
		"\xB4\xF6" => '&#28271;',
		"\xB4\xF7" => '&#28212;',
		"\xB4\xF8" => '&#28237;',
		"\xB4\xF9" => '&#28218;',
		"\xB4\xFA" => '&#28204;',
		"\xB4\xFB" => '&#28227;',
		"\xB4\xFC" => '&#28189;',
		"\xB4\xFD" => '&#28222;',
		"\xB4\xFE" => '&#28363;',
		"\xB5\x40" => '&#28297;',
		"\xB5\x41" => '&#28185;',
		"\xB5\x42" => '&#28238;',
		"\xB5\x43" => '&#28259;',
		"\xB5\x44" => '&#28228;',
		"\xB5\x45" => '&#28274;',
		"\xB5\x46" => '&#28265;',
		"\xB5\x47" => '&#28255;',
		"\xB5\x48" => '&#28953;',
		"\xB5\x49" => '&#28954;',
		"\xB5\x4A" => '&#28966;',
		"\xB5\x4B" => '&#28976;',
		"\xB5\x4C" => '&#28961;',
		"\xB5\x4D" => '&#28982;',
		"\xB5\x4E" => '&#29038;',
		"\xB5\x4F" => '&#28956;',
		"\xB5\x50" => '&#29260;',
		"\xB5\x51" => '&#29316;',
		"\xB5\x52" => '&#29312;',
		"\xB5\x53" => '&#29494;',
		"\xB5\x54" => '&#29477;',
		"\xB5\x55" => '&#29492;',
		"\xB5\x56" => '&#29481;',
		"\xB5\x57" => '&#29754;',
		"\xB5\x58" => '&#29738;',
		"\xB5\x59" => '&#29747;',
		"\xB5\x5A" => '&#29730;',
		"\xB5\x5B" => '&#29733;',
		"\xB5\x5C" => '&#29749;',
		"\xB5\x5D" => '&#29750;',
		"\xB5\x5E" => '&#29748;',
		"\xB5\x5F" => '&#29743;',
		"\xB5\x60" => '&#29723;',
		"\xB5\x61" => '&#29734;',
		"\xB5\x62" => '&#29736;',
		"\xB5\x63" => '&#29989;',
		"\xB5\x64" => '&#29990;',
		"\xB5\x65" => '&#30059;',
		"\xB5\x66" => '&#30058;',
		"\xB5\x67" => '&#30178;',
		"\xB5\x68" => '&#30171;',
		"\xB5\x69" => '&#30179;',
		"\xB5\x6A" => '&#30169;',
		"\xB5\x6B" => '&#30168;',
		"\xB5\x6C" => '&#30174;',
		"\xB5\x6D" => '&#30176;',
		"\xB5\x6E" => '&#30331;',
		"\xB5\x6F" => '&#30332;',
		"\xB5\x70" => '&#30358;',
		"\xB5\x71" => '&#30355;',
		"\xB5\x72" => '&#30388;',
		"\xB5\x73" => '&#30428;',
		"\xB5\x74" => '&#30543;',
		"\xB5\x75" => '&#30701;',
		"\xB5\x76" => '&#30813;',
		"\xB5\x77" => '&#30828;',
		"\xB5\x78" => '&#30831;',
		"\xB5\x79" => '&#31245;',
		"\xB5\x7A" => '&#31240;',
		"\xB5\x7B" => '&#31243;',
		"\xB5\x7C" => '&#31237;',
		"\xB5\x7D" => '&#31232;',
		"\xB5\x7E" => '&#31384;',
		"\xB5\xA1" => '&#31383;',
		"\xB5\xA2" => '&#31382;',
		"\xB5\xA3" => '&#31461;',
		"\xB5\xA4" => '&#31459;',
		"\xB5\xA5" => '&#31561;',
		"\xB5\xA6" => '&#31574;',
		"\xB5\xA7" => '&#31558;',
		"\xB5\xA8" => '&#31568;',
		"\xB5\xA9" => '&#31570;',
		"\xB5\xAA" => '&#31572;',
		"\xB5\xAB" => '&#31565;',
		"\xB5\xAC" => '&#31563;',
		"\xB5\xAD" => '&#31567;',
		"\xB5\xAE" => '&#31569;',
		"\xB5\xAF" => '&#31903;',
		"\xB5\xB0" => '&#31909;',
		"\xB5\xB1" => '&#32094;',
		"\xB5\xB2" => '&#32080;',
		"\xB5\xB3" => '&#32104;',
		"\xB5\xB4" => '&#32085;',
		"\xB5\xB5" => '&#32043;',
		"\xB5\xB6" => '&#32110;',
		"\xB5\xB7" => '&#32114;',
		"\xB5\xB8" => '&#32097;',
		"\xB5\xB9" => '&#32102;',
		"\xB5\xBA" => '&#32098;',
		"\xB5\xBB" => '&#32112;',
		"\xB5\xBC" => '&#32115;',
		"\xB5\xBD" => '&#21892;',
		"\xB5\xBE" => '&#32724;',
		"\xB5\xBF" => '&#32725;',
		"\xB5\xC0" => '&#32779;',
		"\xB5\xC1" => '&#32850;',
		"\xB5\xC2" => '&#32901;',
		"\xB5\xC3" => '&#33109;',
		"\xB5\xC4" => '&#33108;',
		"\xB5\xC5" => '&#33099;',
		"\xB5\xC6" => '&#33105;',
		"\xB5\xC7" => '&#33102;',
		"\xB5\xC8" => '&#33081;',
		"\xB5\xC9" => '&#33094;',
		"\xB5\xCA" => '&#33086;',
		"\xB5\xCB" => '&#33100;',
		"\xB5\xCC" => '&#33107;',
		"\xB5\xCD" => '&#33140;',
		"\xB5\xCE" => '&#33298;',
		"\xB5\xCF" => '&#33308;',
		"\xB5\xD0" => '&#33769;',
		"\xB5\xD1" => '&#33795;',
		"\xB5\xD2" => '&#33784;',
		"\xB5\xD3" => '&#33805;',
		"\xB5\xD4" => '&#33760;',
		"\xB5\xD5" => '&#33733;',
		"\xB5\xD6" => '&#33803;',
		"\xB5\xD7" => '&#33729;',
		"\xB5\xD8" => '&#33775;',
		"\xB5\xD9" => '&#33777;',
		"\xB5\xDA" => '&#33780;',
		"\xB5\xDB" => '&#33879;',
		"\xB5\xDC" => '&#33802;',
		"\xB5\xDD" => '&#33776;',
		"\xB5\xDE" => '&#33804;',
		"\xB5\xDF" => '&#33740;',
		"\xB5\xE0" => '&#33789;',
		"\xB5\xE1" => '&#33778;',
		"\xB5\xE2" => '&#33738;',
		"\xB5\xE3" => '&#33848;',
		"\xB5\xE4" => '&#33806;',
		"\xB5\xE5" => '&#33796;',
		"\xB5\xE6" => '&#33756;',
		"\xB5\xE7" => '&#33799;',
		"\xB5\xE8" => '&#33748;',
		"\xB5\xE9" => '&#33759;',
		"\xB5\xEA" => '&#34395;',
		"\xB5\xEB" => '&#34527;',
		"\xB5\xEC" => '&#34521;',
		"\xB5\xED" => '&#34541;',
		"\xB5\xEE" => '&#34516;',
		"\xB5\xEF" => '&#34523;',
		"\xB5\xF0" => '&#34532;',
		"\xB5\xF1" => '&#34512;',
		"\xB5\xF2" => '&#34526;',
		"\xB5\xF3" => '&#34903;',
		"\xB5\xF4" => '&#35009;',
		"\xB5\xF5" => '&#35010;',
		"\xB5\xF6" => '&#34993;',
		"\xB5\xF7" => '&#35203;',
		"\xB5\xF8" => '&#35222;',
		"\xB5\xF9" => '&#35387;',
		"\xB5\xFA" => '&#35424;',
		"\xB5\xFB" => '&#35413;',
		"\xB5\xFC" => '&#35422;',
		"\xB5\xFD" => '&#35388;',
		"\xB5\xFE" => '&#35393;',
		"\xB6\x40" => '&#35412;',
		"\xB6\x41" => '&#35419;',
		"\xB6\x42" => '&#35408;',
		"\xB6\x43" => '&#35398;',
		"\xB6\x44" => '&#35380;',
		"\xB6\x45" => '&#35386;',
		"\xB6\x46" => '&#35382;',
		"\xB6\x47" => '&#35414;',
		"\xB6\x48" => '&#35937;',
		"\xB6\x49" => '&#35970;',
		"\xB6\x4A" => '&#36015;',
		"\xB6\x4B" => '&#36028;',
		"\xB6\x4C" => '&#36019;',
		"\xB6\x4D" => '&#36029;',
		"\xB6\x4E" => '&#36033;',
		"\xB6\x4F" => '&#36027;',
		"\xB6\x50" => '&#36032;',
		"\xB6\x51" => '&#36020;',
		"\xB6\x52" => '&#36023;',
		"\xB6\x53" => '&#36022;',
		"\xB6\x54" => '&#36031;',
		"\xB6\x55" => '&#36024;',
		"\xB6\x56" => '&#36234;',
		"\xB6\x57" => '&#36229;',
		"\xB6\x58" => '&#36225;',
		"\xB6\x59" => '&#36302;',
		"\xB6\x5A" => '&#36317;',
		"\xB6\x5B" => '&#36299;',
		"\xB6\x5C" => '&#36314;',
		"\xB6\x5D" => '&#36305;',
		"\xB6\x5E" => '&#36300;',
		"\xB6\x5F" => '&#36315;',
		"\xB6\x60" => '&#36294;',
		"\xB6\x61" => '&#36603;',
		"\xB6\x62" => '&#36600;',
		"\xB6\x63" => '&#36604;',
		"\xB6\x64" => '&#36764;',
		"\xB6\x65" => '&#36910;',
		"\xB6\x66" => '&#36917;',
		"\xB6\x67" => '&#36913;',
		"\xB6\x68" => '&#36920;',
		"\xB6\x69" => '&#36914;',
		"\xB6\x6A" => '&#36918;',
		"\xB6\x6B" => '&#37122;',
		"\xB6\x6C" => '&#37109;',
		"\xB6\x6D" => '&#37129;',
		"\xB6\x6E" => '&#37118;',
		"\xB6\x6F" => '&#37219;',
		"\xB6\x70" => '&#37221;',
		"\xB6\x71" => '&#37327;',
		"\xB6\x72" => '&#37396;',
		"\xB6\x73" => '&#37397;',
		"\xB6\x74" => '&#37411;',
		"\xB6\x75" => '&#37385;',
		"\xB6\x76" => '&#37406;',
		"\xB6\x77" => '&#37389;',
		"\xB6\x78" => '&#37392;',
		"\xB6\x79" => '&#37383;',
		"\xB6\x7A" => '&#37393;',
		"\xB6\x7B" => '&#38292;',
		"\xB6\x7C" => '&#38287;',
		"\xB6\x7D" => '&#38283;',
		"\xB6\x7E" => '&#38289;',
		"\xB6\xA1" => '&#38291;',
		"\xB6\xA2" => '&#38290;',
		"\xB6\xA3" => '&#38286;',
		"\xB6\xA4" => '&#38538;',
		"\xB6\xA5" => '&#38542;',
		"\xB6\xA6" => '&#38539;',
		"\xB6\xA7" => '&#38525;',
		"\xB6\xA8" => '&#38533;',
		"\xB6\xA9" => '&#38534;',
		"\xB6\xAA" => '&#38541;',
		"\xB6\xAB" => '&#38514;',
		"\xB6\xAC" => '&#38532;',
		"\xB6\xAD" => '&#38593;',
		"\xB6\xAE" => '&#38597;',
		"\xB6\xAF" => '&#38596;',
		"\xB6\xB0" => '&#38598;',
		"\xB6\xB1" => '&#38599;',
		"\xB6\xB2" => '&#38639;',
		"\xB6\xB3" => '&#38642;',
		"\xB6\xB4" => '&#38860;',
		"\xB6\xB5" => '&#38917;',
		"\xB6\xB6" => '&#38918;',
		"\xB6\xB7" => '&#38920;',
		"\xB6\xB8" => '&#39143;',
		"\xB6\xB9" => '&#39146;',
		"\xB6\xBA" => '&#39151;',
		"\xB6\xBB" => '&#39145;',
		"\xB6\xBC" => '&#39154;',
		"\xB6\xBD" => '&#39149;',
		"\xB6\xBE" => '&#39342;',
		"\xB6\xBF" => '&#39341;',
		"\xB6\xC0" => '&#40643;',
		"\xB6\xC1" => '&#40653;',
		"\xB6\xC2" => '&#40657;',
		"\xB6\xC3" => '&#20098;',
		"\xB6\xC4" => '&#20653;',
		"\xB6\xC5" => '&#20661;',
		"\xB6\xC6" => '&#20658;',
		"\xB6\xC7" => '&#20659;',
		"\xB6\xC8" => '&#20677;',
		"\xB6\xC9" => '&#20670;',
		"\xB6\xCA" => '&#20652;',
		"\xB6\xCB" => '&#20663;',
		"\xB6\xCC" => '&#20667;',
		"\xB6\xCD" => '&#20655;',
		"\xB6\xCE" => '&#20679;',
		"\xB6\xCF" => '&#21119;',
		"\xB6\xD0" => '&#21111;',
		"\xB6\xD1" => '&#21117;',
		"\xB6\xD2" => '&#21215;',
		"\xB6\xD3" => '&#21222;',
		"\xB6\xD4" => '&#21220;',
		"\xB6\xD5" => '&#21218;',
		"\xB6\xD6" => '&#21219;',
		"\xB6\xD7" => '&#21295;',
		"\xB6\xD8" => '&#21983;',
		"\xB6\xD9" => '&#21992;',
		"\xB6\xDA" => '&#21971;',
		"\xB6\xDB" => '&#21990;',
		"\xB6\xDC" => '&#21966;',
		"\xB6\xDD" => '&#21980;',
		"\xB6\xDE" => '&#21959;',
		"\xB6\xDF" => '&#21969;',
		"\xB6\xE0" => '&#21987;',
		"\xB6\xE1" => '&#21988;',
		"\xB6\xE2" => '&#21999;',
		"\xB6\xE3" => '&#21978;',
		"\xB6\xE4" => '&#21985;',
		"\xB6\xE5" => '&#21957;',
		"\xB6\xE6" => '&#21958;',
		"\xB6\xE7" => '&#21989;',
		"\xB6\xE8" => '&#21961;',
		"\xB6\xE9" => '&#22290;',
		"\xB6\xEA" => '&#22291;',
		"\xB6\xEB" => '&#22622;',
		"\xB6\xEC" => '&#22609;',
		"\xB6\xED" => '&#22616;',
		"\xB6\xEE" => '&#22615;',
		"\xB6\xEF" => '&#22618;',
		"\xB6\xF0" => '&#22612;',
		"\xB6\xF1" => '&#22635;',
		"\xB6\xF2" => '&#22604;',
		"\xB6\xF3" => '&#22637;',
		"\xB6\xF4" => '&#22602;',
		"\xB6\xF5" => '&#22626;',
		"\xB6\xF6" => '&#22610;',
		"\xB6\xF7" => '&#22603;',
		"\xB6\xF8" => '&#22887;',
		"\xB6\xF9" => '&#23233;',
		"\xB6\xFA" => '&#23241;',
		"\xB6\xFB" => '&#23244;',
		"\xB6\xFC" => '&#23230;',
		"\xB6\xFD" => '&#23229;',
		"\xB6\xFE" => '&#23228;',
		"\xB7\x40" => '&#23219;',
		"\xB7\x41" => '&#23234;',
		"\xB7\x42" => '&#23218;',
		"\xB7\x43" => '&#23913;',
		"\xB7\x44" => '&#23919;',
		"\xB7\x45" => '&#24140;',
		"\xB7\x46" => '&#24185;',
		"\xB7\x47" => '&#24265;',
		"\xB7\x48" => '&#24264;',
		"\xB7\x49" => '&#24338;',
		"\xB7\x4A" => '&#24409;',
		"\xB7\x4B" => '&#24492;',
		"\xB7\x4C" => '&#24494;',
		"\xB7\x4D" => '&#24858;',
		"\xB7\x4E" => '&#24847;',
		"\xB7\x4F" => '&#24904;',
		"\xB7\x50" => '&#24863;',
		"\xB7\x51" => '&#24819;',
		"\xB7\x52" => '&#24859;',
		"\xB7\x53" => '&#24825;',
		"\xB7\x54" => '&#24833;',
		"\xB7\x55" => '&#24840;',
		"\xB7\x56" => '&#24910;',
		"\xB7\x57" => '&#24908;',
		"\xB7\x58" => '&#24900;',
		"\xB7\x59" => '&#24909;',
		"\xB7\x5A" => '&#24894;',
		"\xB7\x5B" => '&#24884;',
		"\xB7\x5C" => '&#24871;',
		"\xB7\x5D" => '&#24845;',
		"\xB7\x5E" => '&#24838;',
		"\xB7\x5F" => '&#24887;',
		"\xB7\x60" => '&#25121;',
		"\xB7\x61" => '&#25122;',
		"\xB7\x62" => '&#25619;',
		"\xB7\x63" => '&#25662;',
		"\xB7\x64" => '&#25630;',
		"\xB7\x65" => '&#25642;',
		"\xB7\x66" => '&#25645;',
		"\xB7\x67" => '&#25661;',
		"\xB7\x68" => '&#25644;',
		"\xB7\x69" => '&#25615;',
		"\xB7\x6A" => '&#25628;',
		"\xB7\x6B" => '&#25620;',
		"\xB7\x6C" => '&#25613;',
		"\xB7\x6D" => '&#25654;',
		"\xB7\x6E" => '&#25622;',
		"\xB7\x6F" => '&#25623;',
		"\xB7\x70" => '&#25606;',
		"\xB7\x71" => '&#25964;',
		"\xB7\x72" => '&#26015;',
		"\xB7\x73" => '&#26032;',
		"\xB7\x74" => '&#26263;',
		"\xB7\x75" => '&#26249;',
		"\xB7\x76" => '&#26247;',
		"\xB7\x77" => '&#26248;',
		"\xB7\x78" => '&#26262;',
		"\xB7\x79" => '&#26244;',
		"\xB7\x7A" => '&#26264;',
		"\xB7\x7B" => '&#26253;',
		"\xB7\x7C" => '&#26371;',
		"\xB7\x7D" => '&#27028;',
		"\xB7\x7E" => '&#26989;',
		"\xB7\xA1" => '&#26970;',
		"\xB7\xA2" => '&#26999;',
		"\xB7\xA3" => '&#26976;',
		"\xB7\xA4" => '&#26964;',
		"\xB7\xA5" => '&#26997;',
		"\xB7\xA6" => '&#26928;',
		"\xB7\xA7" => '&#27010;',
		"\xB7\xA8" => '&#26954;',
		"\xB7\xA9" => '&#26984;',
		"\xB7\xAA" => '&#26987;',
		"\xB7\xAB" => '&#26974;',
		"\xB7\xAC" => '&#26963;',
		"\xB7\xAD" => '&#27001;',
		"\xB7\xAE" => '&#27014;',
		"\xB7\xAF" => '&#26973;',
		"\xB7\xB0" => '&#26979;',
		"\xB7\xB1" => '&#26971;',
		"\xB7\xB2" => '&#27463;',
		"\xB7\xB3" => '&#27506;',
		"\xB7\xB4" => '&#27584;',
		"\xB7\xB5" => '&#27583;',
		"\xB7\xB6" => '&#27603;',
		"\xB7\xB7" => '&#27645;',
		"\xB7\xB8" => '&#28322;',
		"\xB7\xB9" => '&#28335;',
		"\xB7\xBA" => '&#28371;',
		"\xB7\xBB" => '&#28342;',
		"\xB7\xBC" => '&#28354;',
		"\xB7\xBD" => '&#28304;',
		"\xB7\xBE" => '&#28317;',
		"\xB7\xBF" => '&#28359;',
		"\xB7\xC0" => '&#28357;',
		"\xB7\xC1" => '&#28325;',
		"\xB7\xC2" => '&#28312;',
		"\xB7\xC3" => '&#28348;',
		"\xB7\xC4" => '&#28346;',
		"\xB7\xC5" => '&#28331;',
		"\xB7\xC6" => '&#28369;',
		"\xB7\xC7" => '&#28310;',
		"\xB7\xC8" => '&#28316;',
		"\xB7\xC9" => '&#28356;',
		"\xB7\xCA" => '&#28372;',
		"\xB7\xCB" => '&#28330;',
		"\xB7\xCC" => '&#28327;',
		"\xB7\xCD" => '&#28340;',
		"\xB7\xCE" => '&#29006;',
		"\xB7\xCF" => '&#29017;',
		"\xB7\xD0" => '&#29033;',
		"\xB7\xD1" => '&#29028;',
		"\xB7\xD2" => '&#29001;',
		"\xB7\xD3" => '&#29031;',
		"\xB7\xD4" => '&#29020;',
		"\xB7\xD5" => '&#29036;',
		"\xB7\xD6" => '&#29030;',
		"\xB7\xD7" => '&#29004;',
		"\xB7\xD8" => '&#29029;',
		"\xB7\xD9" => '&#29022;',
		"\xB7\xDA" => '&#28998;',
		"\xB7\xDB" => '&#29032;',
		"\xB7\xDC" => '&#29014;',
		"\xB7\xDD" => '&#29242;',
		"\xB7\xDE" => '&#29266;',
		"\xB7\xDF" => '&#29495;',
		"\xB7\xE0" => '&#29509;',
		"\xB7\xE1" => '&#29503;',
		"\xB7\xE2" => '&#29502;',
		"\xB7\xE3" => '&#29807;',
		"\xB7\xE4" => '&#29786;',
		"\xB7\xE5" => '&#29781;',
		"\xB7\xE6" => '&#29791;',
		"\xB7\xE7" => '&#29790;',
		"\xB7\xE8" => '&#29761;',
		"\xB7\xE9" => '&#29759;',
		"\xB7\xEA" => '&#29785;',
		"\xB7\xEB" => '&#29787;',
		"\xB7\xEC" => '&#29788;',
		"\xB7\xED" => '&#30070;',
		"\xB7\xEE" => '&#30072;',
		"\xB7\xEF" => '&#30208;',
		"\xB7\xF0" => '&#30192;',
		"\xB7\xF1" => '&#30209;',
		"\xB7\xF2" => '&#30194;',
		"\xB7\xF3" => '&#30193;',
		"\xB7\xF4" => '&#30202;',
		"\xB7\xF5" => '&#30207;',
		"\xB7\xF6" => '&#30196;',
		"\xB7\xF7" => '&#30195;',
		"\xB7\xF8" => '&#30430;',
		"\xB7\xF9" => '&#30431;',
		"\xB7\xFA" => '&#30555;',
		"\xB7\xFB" => '&#30571;',
		"\xB7\xFC" => '&#30566;',
		"\xB7\xFD" => '&#30558;',
		"\xB7\xFE" => '&#30563;',
		"\xB8\x40" => '&#30585;',
		"\xB8\x41" => '&#30570;',
		"\xB8\x42" => '&#30572;',
		"\xB8\x43" => '&#30556;',
		"\xB8\x44" => '&#30565;',
		"\xB8\x45" => '&#30568;',
		"\xB8\x46" => '&#30562;',
		"\xB8\x47" => '&#30702;',
		"\xB8\x48" => '&#30862;',
		"\xB8\x49" => '&#30896;',
		"\xB8\x4A" => '&#30871;',
		"\xB8\x4B" => '&#30872;',
		"\xB8\x4C" => '&#30860;',
		"\xB8\x4D" => '&#30857;',
		"\xB8\x4E" => '&#30844;',
		"\xB8\x4F" => '&#30865;',
		"\xB8\x50" => '&#30867;',
		"\xB8\x51" => '&#30847;',
		"\xB8\x52" => '&#31098;',
		"\xB8\x53" => '&#31103;',
		"\xB8\x54" => '&#31105;',
		"\xB8\x55" => '&#33836;',
		"\xB8\x56" => '&#31165;',
		"\xB8\x57" => '&#31260;',
		"\xB8\x58" => '&#31258;',
		"\xB8\x59" => '&#31264;',
		"\xB8\x5A" => '&#31252;',
		"\xB8\x5B" => '&#31263;',
		"\xB8\x5C" => '&#31262;',
		"\xB8\x5D" => '&#31391;',
		"\xB8\x5E" => '&#31392;',
		"\xB8\x5F" => '&#31607;',
		"\xB8\x60" => '&#31680;',
		"\xB8\x61" => '&#31584;',
		"\xB8\x62" => '&#31598;',
		"\xB8\x63" => '&#31591;',
		"\xB8\x64" => '&#31921;',
		"\xB8\x65" => '&#31923;',
		"\xB8\x66" => '&#31925;',
		"\xB8\x67" => '&#32147;',
		"\xB8\x68" => '&#32121;',
		"\xB8\x69" => '&#32145;',
		"\xB8\x6A" => '&#32129;',
		"\xB8\x6B" => '&#32143;',
		"\xB8\x6C" => '&#32091;',
		"\xB8\x6D" => '&#32622;',
		"\xB8\x6E" => '&#32617;',
		"\xB8\x6F" => '&#32618;',
		"\xB8\x70" => '&#32626;',
		"\xB8\x71" => '&#32681;',
		"\xB8\x72" => '&#32680;',
		"\xB8\x73" => '&#32676;',
		"\xB8\x74" => '&#32854;',
		"\xB8\x75" => '&#32856;',
		"\xB8\x76" => '&#32902;',
		"\xB8\x77" => '&#32900;',
		"\xB8\x78" => '&#33137;',
		"\xB8\x79" => '&#33136;',
		"\xB8\x7A" => '&#33144;',
		"\xB8\x7B" => '&#33125;',
		"\xB8\x7C" => '&#33134;',
		"\xB8\x7D" => '&#33139;',
		"\xB8\x7E" => '&#33131;',
		"\xB8\xA1" => '&#33145;',
		"\xB8\xA2" => '&#33146;',
		"\xB8\xA3" => '&#33126;',
		"\xB8\xA4" => '&#33285;',
		"\xB8\xA5" => '&#33351;',
		"\xB8\xA6" => '&#33922;',
		"\xB8\xA7" => '&#33911;',
		"\xB8\xA8" => '&#33853;',
		"\xB8\xA9" => '&#33841;',
		"\xB8\xAA" => '&#33909;',
		"\xB8\xAB" => '&#33894;',
		"\xB8\xAC" => '&#33899;',
		"\xB8\xAD" => '&#33865;',
		"\xB8\xAE" => '&#33900;',
		"\xB8\xAF" => '&#33883;',
		"\xB8\xB0" => '&#33852;',
		"\xB8\xB1" => '&#33845;',
		"\xB8\xB2" => '&#33889;',
		"\xB8\xB3" => '&#33891;',
		"\xB8\xB4" => '&#33897;',
		"\xB8\xB5" => '&#33901;',
		"\xB8\xB6" => '&#33862;',
		"\xB8\xB7" => '&#34398;',
		"\xB8\xB8" => '&#34396;',
		"\xB8\xB9" => '&#34399;',
		"\xB8\xBA" => '&#34553;',
		"\xB8\xBB" => '&#34579;',
		"\xB8\xBC" => '&#34568;',
		"\xB8\xBD" => '&#34567;',
		"\xB8\xBE" => '&#34560;',
		"\xB8\xBF" => '&#34558;',
		"\xB8\xC0" => '&#34555;',
		"\xB8\xC1" => '&#34562;',
		"\xB8\xC2" => '&#34563;',
		"\xB8\xC3" => '&#34566;',
		"\xB8\xC4" => '&#34570;',
		"\xB8\xC5" => '&#34905;',
		"\xB8\xC6" => '&#35039;',
		"\xB8\xC7" => '&#35028;',
		"\xB8\xC8" => '&#35033;',
		"\xB8\xC9" => '&#35036;',
		"\xB8\xCA" => '&#35032;',
		"\xB8\xCB" => '&#35037;',
		"\xB8\xCC" => '&#35041;',
		"\xB8\xCD" => '&#35018;',
		"\xB8\xCE" => '&#35029;',
		"\xB8\xCF" => '&#35026;',
		"\xB8\xD0" => '&#35228;',
		"\xB8\xD1" => '&#35299;',
		"\xB8\xD2" => '&#35435;',
		"\xB8\xD3" => '&#35442;',
		"\xB8\xD4" => '&#35443;',
		"\xB8\xD5" => '&#35430;',
		"\xB8\xD6" => '&#35433;',
		"\xB8\xD7" => '&#35440;',
		"\xB8\xD8" => '&#35463;',
		"\xB8\xD9" => '&#35452;',
		"\xB8\xDA" => '&#35427;',
		"\xB8\xDB" => '&#35488;',
		"\xB8\xDC" => '&#35441;',
		"\xB8\xDD" => '&#35461;',
		"\xB8\xDE" => '&#35437;',
		"\xB8\xDF" => '&#35426;',
		"\xB8\xE0" => '&#35438;',
		"\xB8\xE1" => '&#35436;',
		"\xB8\xE2" => '&#35449;',
		"\xB8\xE3" => '&#35451;',
		"\xB8\xE4" => '&#35390;',
		"\xB8\xE5" => '&#35432;',
		"\xB8\xE6" => '&#35938;',
		"\xB8\xE7" => '&#35978;',
		"\xB8\xE8" => '&#35977;',
		"\xB8\xE9" => '&#36042;',
		"\xB8\xEA" => '&#36039;',
		"\xB8\xEB" => '&#36040;',
		"\xB8\xEC" => '&#36036;',
		"\xB8\xED" => '&#36018;',
		"\xB8\xEE" => '&#36035;',
		"\xB8\xEF" => '&#36034;',
		"\xB8\xF0" => '&#36037;',
		"\xB8\xF1" => '&#36321;',
		"\xB8\xF2" => '&#36319;',
		"\xB8\xF3" => '&#36328;',
		"\xB8\xF4" => '&#36335;',
		"\xB8\xF5" => '&#36339;',
		"\xB8\xF6" => '&#36346;',
		"\xB8\xF7" => '&#36330;',
		"\xB8\xF8" => '&#36324;',
		"\xB8\xF9" => '&#36326;',
		"\xB8\xFA" => '&#36530;',
		"\xB8\xFB" => '&#36611;',
		"\xB8\xFC" => '&#36617;',
		"\xB8\xFD" => '&#36606;',
		"\xB8\xFE" => '&#36618;',
		"\xB9\x40" => '&#36767;',
		"\xB9\x41" => '&#36786;',
		"\xB9\x42" => '&#36939;',
		"\xB9\x43" => '&#36938;',
		"\xB9\x44" => '&#36947;',
		"\xB9\x45" => '&#36930;',
		"\xB9\x46" => '&#36948;',
		"\xB9\x47" => '&#36924;',
		"\xB9\x48" => '&#36949;',
		"\xB9\x49" => '&#36944;',
		"\xB9\x4A" => '&#36935;',
		"\xB9\x4B" => '&#36943;',
		"\xB9\x4C" => '&#36942;',
		"\xB9\x4D" => '&#36941;',
		"\xB9\x4E" => '&#36945;',
		"\xB9\x4F" => '&#36926;',
		"\xB9\x50" => '&#36929;',
		"\xB9\x51" => '&#37138;',
		"\xB9\x52" => '&#37143;',
		"\xB9\x53" => '&#37228;',
		"\xB9\x54" => '&#37226;',
		"\xB9\x55" => '&#37225;',
		"\xB9\x56" => '&#37321;',
		"\xB9\x57" => '&#37431;',
		"\xB9\x58" => '&#37463;',
		"\xB9\x59" => '&#37432;',
		"\xB9\x5A" => '&#37437;',
		"\xB9\x5B" => '&#37440;',
		"\xB9\x5C" => '&#37438;',
		"\xB9\x5D" => '&#37467;',
		"\xB9\x5E" => '&#37451;',
		"\xB9\x5F" => '&#37476;',
		"\xB9\x60" => '&#37457;',
		"\xB9\x61" => '&#37428;',
		"\xB9\x62" => '&#37449;',
		"\xB9\x63" => '&#37453;',
		"\xB9\x64" => '&#37445;',
		"\xB9\x65" => '&#37433;',
		"\xB9\x66" => '&#37439;',
		"\xB9\x67" => '&#37466;',
		"\xB9\x68" => '&#38296;',
		"\xB9\x69" => '&#38552;',
		"\xB9\x6A" => '&#38548;',
		"\xB9\x6B" => '&#38549;',
		"\xB9\x6C" => '&#38605;',
		"\xB9\x6D" => '&#38603;',
		"\xB9\x6E" => '&#38601;',
		"\xB9\x6F" => '&#38602;',
		"\xB9\x70" => '&#38647;',
		"\xB9\x71" => '&#38651;',
		"\xB9\x72" => '&#38649;',
		"\xB9\x73" => '&#38646;',
		"\xB9\x74" => '&#38742;',
		"\xB9\x75" => '&#38772;',
		"\xB9\x76" => '&#38774;',
		"\xB9\x77" => '&#38928;',
		"\xB9\x78" => '&#38929;',
		"\xB9\x79" => '&#38931;',
		"\xB9\x7A" => '&#38922;',
		"\xB9\x7B" => '&#38930;',
		"\xB9\x7C" => '&#38924;',
		"\xB9\x7D" => '&#39164;',
		"\xB9\x7E" => '&#39156;',
		"\xB9\xA1" => '&#39165;',
		"\xB9\xA2" => '&#39166;',
		"\xB9\xA3" => '&#39347;',
		"\xB9\xA4" => '&#39345;',
		"\xB9\xA5" => '&#39348;',
		"\xB9\xA6" => '&#39649;',
		"\xB9\xA7" => '&#40169;',
		"\xB9\xA8" => '&#40578;',
		"\xB9\xA9" => '&#40718;',
		"\xB9\xAA" => '&#40723;',
		"\xB9\xAB" => '&#40736;',
		"\xB9\xAC" => '&#20711;',
		"\xB9\xAD" => '&#20718;',
		"\xB9\xAE" => '&#20709;',
		"\xB9\xAF" => '&#20694;',
		"\xB9\xB0" => '&#20717;',
		"\xB9\xB1" => '&#20698;',
		"\xB9\xB2" => '&#20693;',
		"\xB9\xB3" => '&#20687;',
		"\xB9\xB4" => '&#20689;',
		"\xB9\xB5" => '&#20721;',
		"\xB9\xB6" => '&#20686;',
		"\xB9\xB7" => '&#20713;',
		"\xB9\xB8" => '&#20834;',
		"\xB9\xB9" => '&#20979;',
		"\xB9\xBA" => '&#21123;',
		"\xB9\xBB" => '&#21122;',
		"\xB9\xBC" => '&#21297;',
		"\xB9\xBD" => '&#21421;',
		"\xB9\xBE" => '&#22014;',
		"\xB9\xBF" => '&#22016;',
		"\xB9\xC0" => '&#22043;',
		"\xB9\xC1" => '&#22039;',
		"\xB9\xC2" => '&#22013;',
		"\xB9\xC3" => '&#22036;',
		"\xB9\xC4" => '&#22022;',
		"\xB9\xC5" => '&#22025;',
		"\xB9\xC6" => '&#22029;',
		"\xB9\xC7" => '&#22030;',
		"\xB9\xC8" => '&#22007;',
		"\xB9\xC9" => '&#22038;',
		"\xB9\xCA" => '&#22047;',
		"\xB9\xCB" => '&#22024;',
		"\xB9\xCC" => '&#22032;',
		"\xB9\xCD" => '&#22006;',
		"\xB9\xCE" => '&#22296;',
		"\xB9\xCF" => '&#22294;',
		"\xB9\xD0" => '&#22645;',
		"\xB9\xD1" => '&#22654;',
		"\xB9\xD2" => '&#22659;',
		"\xB9\xD3" => '&#22675;',
		"\xB9\xD4" => '&#22666;',
		"\xB9\xD5" => '&#22649;',
		"\xB9\xD6" => '&#22661;',
		"\xB9\xD7" => '&#22653;',
		"\xB9\xD8" => '&#22781;',
		"\xB9\xD9" => '&#22821;',
		"\xB9\xDA" => '&#22818;',
		"\xB9\xDB" => '&#22820;',
		"\xB9\xDC" => '&#22890;',
		"\xB9\xDD" => '&#22889;',
		"\xB9\xDE" => '&#23265;',
		"\xB9\xDF" => '&#23270;',
		"\xB9\xE0" => '&#23273;',
		"\xB9\xE1" => '&#23255;',
		"\xB9\xE2" => '&#23254;',
		"\xB9\xE3" => '&#23256;',
		"\xB9\xE4" => '&#23267;',
		"\xB9\xE5" => '&#23413;',
		"\xB9\xE6" => '&#23518;',
		"\xB9\xE7" => '&#23527;',
		"\xB9\xE8" => '&#23521;',
		"\xB9\xE9" => '&#23525;',
		"\xB9\xEA" => '&#23526;',
		"\xB9\xEB" => '&#23528;',
		"\xB9\xEC" => '&#23522;',
		"\xB9\xED" => '&#23524;',
		"\xB9\xEE" => '&#23519;',
		"\xB9\xEF" => '&#23565;',
		"\xB9\xF0" => '&#23650;',
		"\xB9\xF1" => '&#23940;',
		"\xB9\xF2" => '&#23943;',
		"\xB9\xF3" => '&#24155;',
		"\xB9\xF4" => '&#24163;',
		"\xB9\xF5" => '&#24149;',
		"\xB9\xF6" => '&#24151;',
		"\xB9\xF7" => '&#24148;',
		"\xB9\xF8" => '&#24275;',
		"\xB9\xF9" => '&#24278;',
		"\xB9\xFA" => '&#24330;',
		"\xB9\xFB" => '&#24390;',
		"\xB9\xFC" => '&#24432;',
		"\xB9\xFD" => '&#24505;',
		"\xB9\xFE" => '&#24903;',
		"\xBA\x40" => '&#24895;',
		"\xBA\x41" => '&#24907;',
		"\xBA\x42" => '&#24951;',
		"\xBA\x43" => '&#24930;',
		"\xBA\x44" => '&#24931;',
		"\xBA\x45" => '&#24927;',
		"\xBA\x46" => '&#24922;',
		"\xBA\x47" => '&#24920;',
		"\xBA\x48" => '&#24949;',
		"\xBA\x49" => '&#25130;',
		"\xBA\x4A" => '&#25735;',
		"\xBA\x4B" => '&#25688;',
		"\xBA\x4C" => '&#25684;',
		"\xBA\x4D" => '&#25764;',
		"\xBA\x4E" => '&#25720;',
		"\xBA\x4F" => '&#25695;',
		"\xBA\x50" => '&#25722;',
		"\xBA\x51" => '&#25681;',
		"\xBA\x52" => '&#25703;',
		"\xBA\x53" => '&#25652;',
		"\xBA\x54" => '&#25709;',
		"\xBA\x55" => '&#25723;',
		"\xBA\x56" => '&#25970;',
		"\xBA\x57" => '&#26017;',
		"\xBA\x58" => '&#26071;',
		"\xBA\x59" => '&#26070;',
		"\xBA\x5A" => '&#26274;',
		"\xBA\x5B" => '&#26280;',
		"\xBA\x5C" => '&#26269;',
		"\xBA\x5D" => '&#27036;',
		"\xBA\x5E" => '&#27048;',
		"\xBA\x5F" => '&#27029;',
		"\xBA\x60" => '&#27073;',
		"\xBA\x61" => '&#27054;',
		"\xBA\x62" => '&#27091;',
		"\xBA\x63" => '&#27083;',
		"\xBA\x64" => '&#27035;',
		"\xBA\x65" => '&#27063;',
		"\xBA\x66" => '&#27067;',
		"\xBA\x67" => '&#27051;',
		"\xBA\x68" => '&#27060;',
		"\xBA\x69" => '&#27088;',
		"\xBA\x6A" => '&#27085;',
		"\xBA\x6B" => '&#27053;',
		"\xBA\x6C" => '&#27084;',
		"\xBA\x6D" => '&#27046;',
		"\xBA\x6E" => '&#27075;',
		"\xBA\x6F" => '&#27043;',
		"\xBA\x70" => '&#27465;',
		"\xBA\x71" => '&#27468;',
		"\xBA\x72" => '&#27699;',
		"\xBA\x73" => '&#28467;',
		"\xBA\x74" => '&#28436;',
		"\xBA\x75" => '&#28414;',
		"\xBA\x76" => '&#28435;',
		"\xBA\x77" => '&#28404;',
		"\xBA\x78" => '&#28457;',
		"\xBA\x79" => '&#28478;',
		"\xBA\x7A" => '&#28448;',
		"\xBA\x7B" => '&#28460;',
		"\xBA\x7C" => '&#28431;',
		"\xBA\x7D" => '&#28418;',
		"\xBA\x7E" => '&#28450;',
		"\xBA\xA1" => '&#28415;',
		"\xBA\xA2" => '&#28399;',
		"\xBA\xA3" => '&#28422;',
		"\xBA\xA4" => '&#28465;',
		"\xBA\xA5" => '&#28472;',
		"\xBA\xA6" => '&#28466;',
		"\xBA\xA7" => '&#28451;',
		"\xBA\xA8" => '&#28437;',
		"\xBA\xA9" => '&#28459;',
		"\xBA\xAA" => '&#28463;',
		"\xBA\xAB" => '&#28552;',
		"\xBA\xAC" => '&#28458;',
		"\xBA\xAD" => '&#28396;',
		"\xBA\xAE" => '&#28417;',
		"\xBA\xAF" => '&#28402;',
		"\xBA\xB0" => '&#28364;',
		"\xBA\xB1" => '&#28407;',
		"\xBA\xB2" => '&#29076;',
		"\xBA\xB3" => '&#29081;',
		"\xBA\xB4" => '&#29053;',
		"\xBA\xB5" => '&#29066;',
		"\xBA\xB6" => '&#29060;',
		"\xBA\xB7" => '&#29074;',
		"\xBA\xB8" => '&#29246;',
		"\xBA\xB9" => '&#29330;',
		"\xBA\xBA" => '&#29334;',
		"\xBA\xBB" => '&#29508;',
		"\xBA\xBC" => '&#29520;',
		"\xBA\xBD" => '&#29796;',
		"\xBA\xBE" => '&#29795;',
		"\xBA\xBF" => '&#29802;',
		"\xBA\xC0" => '&#29808;',
		"\xBA\xC1" => '&#29805;',
		"\xBA\xC2" => '&#29956;',
		"\xBA\xC3" => '&#30097;',
		"\xBA\xC4" => '&#30247;',
		"\xBA\xC5" => '&#30221;',
		"\xBA\xC6" => '&#30219;',
		"\xBA\xC7" => '&#30217;',
		"\xBA\xC8" => '&#30227;',
		"\xBA\xC9" => '&#30433;',
		"\xBA\xCA" => '&#30435;',
		"\xBA\xCB" => '&#30596;',
		"\xBA\xCC" => '&#30589;',
		"\xBA\xCD" => '&#30591;',
		"\xBA\xCE" => '&#30561;',
		"\xBA\xCF" => '&#30913;',
		"\xBA\xD0" => '&#30879;',
		"\xBA\xD1" => '&#30887;',
		"\xBA\xD2" => '&#30899;',
		"\xBA\xD3" => '&#30889;',
		"\xBA\xD4" => '&#30883;',
		"\xBA\xD5" => '&#31118;',
		"\xBA\xD6" => '&#31119;',
		"\xBA\xD7" => '&#31117;',
		"\xBA\xD8" => '&#31278;',
		"\xBA\xD9" => '&#31281;',
		"\xBA\xDA" => '&#31402;',
		"\xBA\xDB" => '&#31401;',
		"\xBA\xDC" => '&#31469;',
		"\xBA\xDD" => '&#31471;',
		"\xBA\xDE" => '&#31649;',
		"\xBA\xDF" => '&#31637;',
		"\xBA\xE0" => '&#31627;',
		"\xBA\xE1" => '&#31605;',
		"\xBA\xE2" => '&#31639;',
		"\xBA\xE3" => '&#31645;',
		"\xBA\xE4" => '&#31636;',
		"\xBA\xE5" => '&#31631;',
		"\xBA\xE6" => '&#31672;',
		"\xBA\xE7" => '&#31623;',
		"\xBA\xE8" => '&#31620;',
		"\xBA\xE9" => '&#31929;',
		"\xBA\xEA" => '&#31933;',
		"\xBA\xEB" => '&#31934;',
		"\xBA\xEC" => '&#32187;',
		"\xBA\xED" => '&#32176;',
		"\xBA\xEE" => '&#32156;',
		"\xBA\xEF" => '&#32189;',
		"\xBA\xF0" => '&#32190;',
		"\xBA\xF1" => '&#32160;',
		"\xBA\xF2" => '&#32202;',
		"\xBA\xF3" => '&#32180;',
		"\xBA\xF4" => '&#32178;',
		"\xBA\xF5" => '&#32177;',
		"\xBA\xF6" => '&#32186;',
		"\xBA\xF7" => '&#32162;',
		"\xBA\xF8" => '&#32191;',
		"\xBA\xF9" => '&#32181;',
		"\xBA\xFA" => '&#32184;',
		"\xBA\xFB" => '&#32173;',
		"\xBA\xFC" => '&#32210;',
		"\xBA\xFD" => '&#32199;',
		"\xBA\xFE" => '&#32172;',
		"\xBB\x40" => '&#32624;',
		"\xBB\x41" => '&#32736;',
		"\xBB\x42" => '&#32737;',
		"\xBB\x43" => '&#32735;',
		"\xBB\x44" => '&#32862;',
		"\xBB\x45" => '&#32858;',
		"\xBB\x46" => '&#32903;',
		"\xBB\x47" => '&#33104;',
		"\xBB\x48" => '&#33152;',
		"\xBB\x49" => '&#33167;',
		"\xBB\x4A" => '&#33160;',
		"\xBB\x4B" => '&#33162;',
		"\xBB\x4C" => '&#33151;',
		"\xBB\x4D" => '&#33154;',
		"\xBB\x4E" => '&#33255;',
		"\xBB\x4F" => '&#33274;',
		"\xBB\x50" => '&#33287;',
		"\xBB\x51" => '&#33300;',
		"\xBB\x52" => '&#33310;',
		"\xBB\x53" => '&#33355;',
		"\xBB\x54" => '&#33993;',
		"\xBB\x55" => '&#33983;',
		"\xBB\x56" => '&#33990;',
		"\xBB\x57" => '&#33988;',
		"\xBB\x58" => '&#33945;',
		"\xBB\x59" => '&#33950;',
		"\xBB\x5A" => '&#33970;',
		"\xBB\x5B" => '&#33948;',
		"\xBB\x5C" => '&#33995;',
		"\xBB\x5D" => '&#33976;',
		"\xBB\x5E" => '&#33984;',
		"\xBB\x5F" => '&#34003;',
		"\xBB\x60" => '&#33936;',
		"\xBB\x61" => '&#33980;',
		"\xBB\x62" => '&#34001;',
		"\xBB\x63" => '&#33994;',
		"\xBB\x64" => '&#34623;',
		"\xBB\x65" => '&#34588;',
		"\xBB\x66" => '&#34619;',
		"\xBB\x67" => '&#34594;',
		"\xBB\x68" => '&#34597;',
		"\xBB\x69" => '&#34612;',
		"\xBB\x6A" => '&#34584;',
		"\xBB\x6B" => '&#34645;',
		"\xBB\x6C" => '&#34615;',
		"\xBB\x6D" => '&#34601;',
		"\xBB\x6E" => '&#35059;',
		"\xBB\x6F" => '&#35074;',
		"\xBB\x70" => '&#35060;',
		"\xBB\x71" => '&#35065;',
		"\xBB\x72" => '&#35064;',
		"\xBB\x73" => '&#35069;',
		"\xBB\x74" => '&#35048;',
		"\xBB\x75" => '&#35098;',
		"\xBB\x76" => '&#35055;',
		"\xBB\x77" => '&#35494;',
		"\xBB\x78" => '&#35468;',
		"\xBB\x79" => '&#35486;',
		"\xBB\x7A" => '&#35491;',
		"\xBB\x7B" => '&#35469;',
		"\xBB\x7C" => '&#35489;',
		"\xBB\x7D" => '&#35475;',
		"\xBB\x7E" => '&#35492;',
		"\xBB\xA1" => '&#35498;',
		"\xBB\xA2" => '&#35493;',
		"\xBB\xA3" => '&#35496;',
		"\xBB\xA4" => '&#35480;',
		"\xBB\xA5" => '&#35473;',
		"\xBB\xA6" => '&#35482;',
		"\xBB\xA7" => '&#35495;',
		"\xBB\xA8" => '&#35946;',
		"\xBB\xA9" => '&#35981;',
		"\xBB\xAA" => '&#35980;',
		"\xBB\xAB" => '&#36051;',
		"\xBB\xAC" => '&#36049;',
		"\xBB\xAD" => '&#36050;',
		"\xBB\xAE" => '&#36203;',
		"\xBB\xAF" => '&#36249;',
		"\xBB\xB0" => '&#36245;',
		"\xBB\xB1" => '&#36348;',
		"\xBB\xB2" => '&#36628;',
		"\xBB\xB3" => '&#36626;',
		"\xBB\xB4" => '&#36629;',
		"\xBB\xB5" => '&#36627;',
		"\xBB\xB6" => '&#36771;',
		"\xBB\xB7" => '&#36960;',
		"\xBB\xB8" => '&#36952;',
		"\xBB\xB9" => '&#36956;',
		"\xBB\xBA" => '&#36963;',
		"\xBB\xBB" => '&#36953;',
		"\xBB\xBC" => '&#36958;',
		"\xBB\xBD" => '&#36962;',
		"\xBB\xBE" => '&#36957;',
		"\xBB\xBF" => '&#36955;',
		"\xBB\xC0" => '&#37145;',
		"\xBB\xC1" => '&#37144;',
		"\xBB\xC2" => '&#37150;',
		"\xBB\xC3" => '&#37237;',
		"\xBB\xC4" => '&#37240;',
		"\xBB\xC5" => '&#37239;',
		"\xBB\xC6" => '&#37236;',
		"\xBB\xC7" => '&#37496;',
		"\xBB\xC8" => '&#37504;',
		"\xBB\xC9" => '&#37509;',
		"\xBB\xCA" => '&#37528;',
		"\xBB\xCB" => '&#37526;',
		"\xBB\xCC" => '&#37499;',
		"\xBB\xCD" => '&#37523;',
		"\xBB\xCE" => '&#37532;',
		"\xBB\xCF" => '&#37544;',
		"\xBB\xD0" => '&#37500;',
		"\xBB\xD1" => '&#37521;',
		"\xBB\xD2" => '&#38305;',
		"\xBB\xD3" => '&#38312;',
		"\xBB\xD4" => '&#38313;',
		"\xBB\xD5" => '&#38307;',
		"\xBB\xD6" => '&#38309;',
		"\xBB\xD7" => '&#38308;',
		"\xBB\xD8" => '&#38553;',
		"\xBB\xD9" => '&#38556;',
		"\xBB\xDA" => '&#38555;',
		"\xBB\xDB" => '&#38604;',
		"\xBB\xDC" => '&#38610;',
		"\xBB\xDD" => '&#38656;',
		"\xBB\xDE" => '&#38780;',
		"\xBB\xDF" => '&#38789;',
		"\xBB\xE0" => '&#38902;',
		"\xBB\xE1" => '&#38935;',
		"\xBB\xE2" => '&#38936;',
		"\xBB\xE3" => '&#39087;',
		"\xBB\xE4" => '&#39089;',
		"\xBB\xE5" => '&#39171;',
		"\xBB\xE6" => '&#39173;',
		"\xBB\xE7" => '&#39180;',
		"\xBB\xE8" => '&#39177;',
		"\xBB\xE9" => '&#39361;',
		"\xBB\xEA" => '&#39599;',
		"\xBB\xEB" => '&#39600;',
		"\xBB\xEC" => '&#39654;',
		"\xBB\xED" => '&#39745;',
		"\xBB\xEE" => '&#39746;',
		"\xBB\xEF" => '&#40180;',
		"\xBB\xF0" => '&#40182;',
		"\xBB\xF1" => '&#40179;',
		"\xBB\xF2" => '&#40636;',
		"\xBB\xF3" => '&#40763;',
		"\xBB\xF4" => '&#40778;',
		"\xBB\xF5" => '&#20740;',
		"\xBB\xF6" => '&#20736;',
		"\xBB\xF7" => '&#20731;',
		"\xBB\xF8" => '&#20725;',
		"\xBB\xF9" => '&#20729;',
		"\xBB\xFA" => '&#20738;',
		"\xBB\xFB" => '&#20744;',
		"\xBB\xFC" => '&#20745;',
		"\xBB\xFD" => '&#20741;',
		"\xBB\xFE" => '&#20956;',
		"\xBC\x40" => '&#21127;',
		"\xBC\x41" => '&#21128;',
		"\xBC\x42" => '&#21129;',
		"\xBC\x43" => '&#21133;',
		"\xBC\x44" => '&#21130;',
		"\xBC\x45" => '&#21232;',
		"\xBC\x46" => '&#21426;',
		"\xBC\x47" => '&#22062;',
		"\xBC\x48" => '&#22075;',
		"\xBC\x49" => '&#22073;',
		"\xBC\x4A" => '&#22066;',
		"\xBC\x4B" => '&#22079;',
		"\xBC\x4C" => '&#22068;',
		"\xBC\x4D" => '&#22057;',
		"\xBC\x4E" => '&#22099;',
		"\xBC\x4F" => '&#22094;',
		"\xBC\x50" => '&#22103;',
		"\xBC\x51" => '&#22132;',
		"\xBC\x52" => '&#22070;',
		"\xBC\x53" => '&#22063;',
		"\xBC\x54" => '&#22064;',
		"\xBC\x55" => '&#22656;',
		"\xBC\x56" => '&#22687;',
		"\xBC\x57" => '&#22686;',
		"\xBC\x58" => '&#22707;',
		"\xBC\x59" => '&#22684;',
		"\xBC\x5A" => '&#22702;',
		"\xBC\x5B" => '&#22697;',
		"\xBC\x5C" => '&#22694;',
		"\xBC\x5D" => '&#22893;',
		"\xBC\x5E" => '&#23305;',
		"\xBC\x5F" => '&#23291;',
		"\xBC\x60" => '&#23307;',
		"\xBC\x61" => '&#23285;',
		"\xBC\x62" => '&#23308;',
		"\xBC\x63" => '&#23304;',
		"\xBC\x64" => '&#23534;',
		"\xBC\x65" => '&#23532;',
		"\xBC\x66" => '&#23529;',
		"\xBC\x67" => '&#23531;',
		"\xBC\x68" => '&#23652;',
		"\xBC\x69" => '&#23653;',
		"\xBC\x6A" => '&#23965;',
		"\xBC\x6B" => '&#23956;',
		"\xBC\x6C" => '&#24162;',
		"\xBC\x6D" => '&#24159;',
		"\xBC\x6E" => '&#24161;',
		"\xBC\x6F" => '&#24290;',
		"\xBC\x70" => '&#24282;',
		"\xBC\x71" => '&#24287;',
		"\xBC\x72" => '&#24285;',
		"\xBC\x73" => '&#24291;',
		"\xBC\x74" => '&#24288;',
		"\xBC\x75" => '&#24392;',
		"\xBC\x76" => '&#24433;',
		"\xBC\x77" => '&#24503;',
		"\xBC\x78" => '&#24501;',
		"\xBC\x79" => '&#24950;',
		"\xBC\x7A" => '&#24935;',
		"\xBC\x7B" => '&#24942;',
		"\xBC\x7C" => '&#24925;',
		"\xBC\x7D" => '&#24917;',
		"\xBC\x7E" => '&#24962;',
		"\xBC\xA1" => '&#24956;',
		"\xBC\xA2" => '&#24944;',
		"\xBC\xA3" => '&#24939;',
		"\xBC\xA4" => '&#24958;',
		"\xBC\xA5" => '&#24999;',
		"\xBC\xA6" => '&#24976;',
		"\xBC\xA7" => '&#25003;',
		"\xBC\xA8" => '&#24974;',
		"\xBC\xA9" => '&#25004;',
		"\xBC\xAA" => '&#24986;',
		"\xBC\xAB" => '&#24996;',
		"\xBC\xAC" => '&#24980;',
		"\xBC\xAD" => '&#25006;',
		"\xBC\xAE" => '&#25134;',
		"\xBC\xAF" => '&#25705;',
		"\xBC\xB0" => '&#25711;',
		"\xBC\xB1" => '&#25721;',
		"\xBC\xB2" => '&#25758;',
		"\xBC\xB3" => '&#25778;',
		"\xBC\xB4" => '&#25736;',
		"\xBC\xB5" => '&#25744;',
		"\xBC\xB6" => '&#25776;',
		"\xBC\xB7" => '&#25765;',
		"\xBC\xB8" => '&#25747;',
		"\xBC\xB9" => '&#25749;',
		"\xBC\xBA" => '&#25769;',
		"\xBC\xBB" => '&#25746;',
		"\xBC\xBC" => '&#25774;',
		"\xBC\xBD" => '&#25773;',
		"\xBC\xBE" => '&#25771;',
		"\xBC\xBF" => '&#25754;',
		"\xBC\xC0" => '&#25772;',
		"\xBC\xC1" => '&#25753;',
		"\xBC\xC2" => '&#25762;',
		"\xBC\xC3" => '&#25779;',
		"\xBC\xC4" => '&#25973;',
		"\xBC\xC5" => '&#25975;',
		"\xBC\xC6" => '&#25976;',
		"\xBC\xC7" => '&#26286;',
		"\xBC\xC8" => '&#26283;',
		"\xBC\xC9" => '&#26292;',
		"\xBC\xCA" => '&#26289;',
		"\xBC\xCB" => '&#27171;',
		"\xBC\xCC" => '&#27167;',
		"\xBC\xCD" => '&#27112;',
		"\xBC\xCE" => '&#27137;',
		"\xBC\xCF" => '&#27166;',
		"\xBC\xD0" => '&#27161;',
		"\xBC\xD1" => '&#27133;',
		"\xBC\xD2" => '&#27169;',
		"\xBC\xD3" => '&#27155;',
		"\xBC\xD4" => '&#27146;',
		"\xBC\xD5" => '&#27123;',
		"\xBC\xD6" => '&#27138;',
		"\xBC\xD7" => '&#27141;',
		"\xBC\xD8" => '&#27117;',
		"\xBC\xD9" => '&#27153;',
		"\xBC\xDA" => '&#27472;',
		"\xBC\xDB" => '&#27470;',
		"\xBC\xDC" => '&#27556;',
		"\xBC\xDD" => '&#27589;',
		"\xBC\xDE" => '&#27590;',
		"\xBC\xDF" => '&#28479;',
		"\xBC\xE0" => '&#28540;',
		"\xBC\xE1" => '&#28548;',
		"\xBC\xE2" => '&#28497;',
		"\xBC\xE3" => '&#28518;',
		"\xBC\xE4" => '&#28500;',
		"\xBC\xE5" => '&#28550;',
		"\xBC\xE6" => '&#28525;',
		"\xBC\xE7" => '&#28507;',
		"\xBC\xE8" => '&#28536;',
		"\xBC\xE9" => '&#28526;',
		"\xBC\xEA" => '&#28558;',
		"\xBC\xEB" => '&#28538;',
		"\xBC\xEC" => '&#28528;',
		"\xBC\xED" => '&#28516;',
		"\xBC\xEE" => '&#28567;',
		"\xBC\xEF" => '&#28504;',
		"\xBC\xF0" => '&#28373;',
		"\xBC\xF1" => '&#28527;',
		"\xBC\xF2" => '&#28512;',
		"\xBC\xF3" => '&#28511;',
		"\xBC\xF4" => '&#29087;',
		"\xBC\xF5" => '&#29100;',
		"\xBC\xF6" => '&#29105;',
		"\xBC\xF7" => '&#29096;',
		"\xBC\xF8" => '&#29270;',
		"\xBC\xF9" => '&#29339;',
		"\xBC\xFA" => '&#29518;',
		"\xBC\xFB" => '&#29527;',
		"\xBC\xFC" => '&#29801;',
		"\xBC\xFD" => '&#29835;',
		"\xBC\xFE" => '&#29827;',
		"\xBD\x40" => '&#29822;',
		"\xBD\x41" => '&#29824;',
		"\xBD\x42" => '&#30079;',
		"\xBD\x43" => '&#30240;',
		"\xBD\x44" => '&#30249;',
		"\xBD\x45" => '&#30239;',
		"\xBD\x46" => '&#30244;',
		"\xBD\x47" => '&#30246;',
		"\xBD\x48" => '&#30241;',
		"\xBD\x49" => '&#30242;',
		"\xBD\x4A" => '&#30362;',
		"\xBD\x4B" => '&#30394;',
		"\xBD\x4C" => '&#30436;',
		"\xBD\x4D" => '&#30606;',
		"\xBD\x4E" => '&#30599;',
		"\xBD\x4F" => '&#30604;',
		"\xBD\x50" => '&#30609;',
		"\xBD\x51" => '&#30603;',
		"\xBD\x52" => '&#30923;',
		"\xBD\x53" => '&#30917;',
		"\xBD\x54" => '&#30906;',
		"\xBD\x55" => '&#30922;',
		"\xBD\x56" => '&#30910;',
		"\xBD\x57" => '&#30933;',
		"\xBD\x58" => '&#30908;',
		"\xBD\x59" => '&#30928;',
		"\xBD\x5A" => '&#31295;',
		"\xBD\x5B" => '&#31292;',
		"\xBD\x5C" => '&#31296;',
		"\xBD\x5D" => '&#31293;',
		"\xBD\x5E" => '&#31287;',
		"\xBD\x5F" => '&#31291;',
		"\xBD\x60" => '&#31407;',
		"\xBD\x61" => '&#31406;',
		"\xBD\x62" => '&#31661;',
		"\xBD\x63" => '&#31665;',
		"\xBD\x64" => '&#31684;',
		"\xBD\x65" => '&#31668;',
		"\xBD\x66" => '&#31686;',
		"\xBD\x67" => '&#31687;',
		"\xBD\x68" => '&#31681;',
		"\xBD\x69" => '&#31648;',
		"\xBD\x6A" => '&#31692;',
		"\xBD\x6B" => '&#31946;',
		"\xBD\x6C" => '&#32224;',
		"\xBD\x6D" => '&#32244;',
		"\xBD\x6E" => '&#32239;',
		"\xBD\x6F" => '&#32251;',
		"\xBD\x70" => '&#32216;',
		"\xBD\x71" => '&#32236;',
		"\xBD\x72" => '&#32221;',
		"\xBD\x73" => '&#32232;',
		"\xBD\x74" => '&#32227;',
		"\xBD\x75" => '&#32218;',
		"\xBD\x76" => '&#32222;',
		"\xBD\x77" => '&#32233;',
		"\xBD\x78" => '&#32158;',
		"\xBD\x79" => '&#32217;',
		"\xBD\x7A" => '&#32242;',
		"\xBD\x7B" => '&#32249;',
		"\xBD\x7C" => '&#32629;',
		"\xBD\x7D" => '&#32631;',
		"\xBD\x7E" => '&#32687;',
		"\xBD\xA1" => '&#32745;',
		"\xBD\xA2" => '&#32806;',
		"\xBD\xA3" => '&#33179;',
		"\xBD\xA4" => '&#33180;',
		"\xBD\xA5" => '&#33181;',
		"\xBD\xA6" => '&#33184;',
		"\xBD\xA7" => '&#33178;',
		"\xBD\xA8" => '&#33176;',
		"\xBD\xA9" => '&#34071;',
		"\xBD\xAA" => '&#34109;',
		"\xBD\xAB" => '&#34074;',
		"\xBD\xAC" => '&#34030;',
		"\xBD\xAD" => '&#34092;',
		"\xBD\xAE" => '&#34093;',
		"\xBD\xAF" => '&#34067;',
		"\xBD\xB0" => '&#34065;',
		"\xBD\xB1" => '&#34083;',
		"\xBD\xB2" => '&#34081;',
		"\xBD\xB3" => '&#34068;',
		"\xBD\xB4" => '&#34028;',
		"\xBD\xB5" => '&#34085;',
		"\xBD\xB6" => '&#34047;',
		"\xBD\xB7" => '&#34054;',
		"\xBD\xB8" => '&#34690;',
		"\xBD\xB9" => '&#34676;',
		"\xBD\xBA" => '&#34678;',
		"\xBD\xBB" => '&#34656;',
		"\xBD\xBC" => '&#34662;',
		"\xBD\xBD" => '&#34680;',
		"\xBD\xBE" => '&#34664;',
		"\xBD\xBF" => '&#34649;',
		"\xBD\xC0" => '&#34647;',
		"\xBD\xC1" => '&#34636;',
		"\xBD\xC2" => '&#34643;',
		"\xBD\xC3" => '&#34907;',
		"\xBD\xC4" => '&#34909;',
		"\xBD\xC5" => '&#35088;',
		"\xBD\xC6" => '&#35079;',
		"\xBD\xC7" => '&#35090;',
		"\xBD\xC8" => '&#35091;',
		"\xBD\xC9" => '&#35093;',
		"\xBD\xCA" => '&#35082;',
		"\xBD\xCB" => '&#35516;',
		"\xBD\xCC" => '&#35538;',
		"\xBD\xCD" => '&#35527;',
		"\xBD\xCE" => '&#35524;',
		"\xBD\xCF" => '&#35477;',
		"\xBD\xD0" => '&#35531;',
		"\xBD\xD1" => '&#35576;',
		"\xBD\xD2" => '&#35506;',
		"\xBD\xD3" => '&#35529;',
		"\xBD\xD4" => '&#35522;',
		"\xBD\xD5" => '&#35519;',
		"\xBD\xD6" => '&#35504;',
		"\xBD\xD7" => '&#35542;',
		"\xBD\xD8" => '&#35533;',
		"\xBD\xD9" => '&#35510;',
		"\xBD\xDA" => '&#35513;',
		"\xBD\xDB" => '&#35547;',
		"\xBD\xDC" => '&#35916;',
		"\xBD\xDD" => '&#35918;',
		"\xBD\xDE" => '&#35948;',
		"\xBD\xDF" => '&#36064;',
		"\xBD\xE0" => '&#36062;',
		"\xBD\xE1" => '&#36070;',
		"\xBD\xE2" => '&#36068;',
		"\xBD\xE3" => '&#36076;',
		"\xBD\xE4" => '&#36077;',
		"\xBD\xE5" => '&#36066;',
		"\xBD\xE6" => '&#36067;',
		"\xBD\xE7" => '&#36060;',
		"\xBD\xE8" => '&#36074;',
		"\xBD\xE9" => '&#36065;',
		"\xBD\xEA" => '&#36205;',
		"\xBD\xEB" => '&#36255;',
		"\xBD\xEC" => '&#36259;',
		"\xBD\xED" => '&#36395;',
		"\xBD\xEE" => '&#36368;',
		"\xBD\xEF" => '&#36381;',
		"\xBD\xF0" => '&#36386;',
		"\xBD\xF1" => '&#36367;',
		"\xBD\xF2" => '&#36393;',
		"\xBD\xF3" => '&#36383;',
		"\xBD\xF4" => '&#36385;',
		"\xBD\xF5" => '&#36382;',
		"\xBD\xF6" => '&#36538;',
		"\xBD\xF7" => '&#36637;',
		"\xBD\xF8" => '&#36635;',
		"\xBD\xF9" => '&#36639;',
		"\xBD\xFA" => '&#36649;',
		"\xBD\xFB" => '&#36646;',
		"\xBD\xFC" => '&#36650;',
		"\xBD\xFD" => '&#36636;',
		"\xBD\xFE" => '&#36638;',
		"\xBE\x40" => '&#36645;',
		"\xBE\x41" => '&#36969;',
		"\xBE\x42" => '&#36974;',
		"\xBE\x43" => '&#36968;',
		"\xBE\x44" => '&#36973;',
		"\xBE\x45" => '&#36983;',
		"\xBE\x46" => '&#37168;',
		"\xBE\x47" => '&#37165;',
		"\xBE\x48" => '&#37159;',
		"\xBE\x49" => '&#37169;',
		"\xBE\x4A" => '&#37255;',
		"\xBE\x4B" => '&#37257;',
		"\xBE\x4C" => '&#37259;',
		"\xBE\x4D" => '&#37251;',
		"\xBE\x4E" => '&#37573;',
		"\xBE\x4F" => '&#37563;',
		"\xBE\x50" => '&#37559;',
		"\xBE\x51" => '&#37610;',
		"\xBE\x52" => '&#37548;',
		"\xBE\x53" => '&#37604;',
		"\xBE\x54" => '&#37569;',
		"\xBE\x55" => '&#37555;',
		"\xBE\x56" => '&#37564;',
		"\xBE\x57" => '&#37586;',
		"\xBE\x58" => '&#37575;',
		"\xBE\x59" => '&#37616;',
		"\xBE\x5A" => '&#37554;',
		"\xBE\x5B" => '&#38317;',
		"\xBE\x5C" => '&#38321;',
		"\xBE\x5D" => '&#38660;',
		"\xBE\x5E" => '&#38662;',
		"\xBE\x5F" => '&#38663;',
		"\xBE\x60" => '&#38665;',
		"\xBE\x61" => '&#38752;',
		"\xBE\x62" => '&#38797;',
		"\xBE\x63" => '&#38795;',
		"\xBE\x64" => '&#38799;',
		"\xBE\x65" => '&#38945;',
		"\xBE\x66" => '&#38955;',
		"\xBE\x67" => '&#38940;',
		"\xBE\x68" => '&#39091;',
		"\xBE\x69" => '&#39178;',
		"\xBE\x6A" => '&#39187;',
		"\xBE\x6B" => '&#39186;',
		"\xBE\x6C" => '&#39192;',
		"\xBE\x6D" => '&#39389;',
		"\xBE\x6E" => '&#39376;',
		"\xBE\x6F" => '&#39391;',
		"\xBE\x70" => '&#39387;',
		"\xBE\x71" => '&#39377;',
		"\xBE\x72" => '&#39381;',
		"\xBE\x73" => '&#39378;',
		"\xBE\x74" => '&#39385;',
		"\xBE\x75" => '&#39607;',
		"\xBE\x76" => '&#39662;',
		"\xBE\x77" => '&#39663;',
		"\xBE\x78" => '&#39719;',
		"\xBE\x79" => '&#39749;',
		"\xBE\x7A" => '&#39748;',
		"\xBE\x7B" => '&#39799;',
		"\xBE\x7C" => '&#39791;',
		"\xBE\x7D" => '&#40198;',
		"\xBE\x7E" => '&#40201;',
		"\xBE\xA1" => '&#40195;',
		"\xBE\xA2" => '&#40617;',
		"\xBE\xA3" => '&#40638;',
		"\xBE\xA4" => '&#40654;',
		"\xBE\xA5" => '&#22696;',
		"\xBE\xA6" => '&#40786;',
		"\xBE\xA7" => '&#20754;',
		"\xBE\xA8" => '&#20760;',
		"\xBE\xA9" => '&#20756;',
		"\xBE\xAA" => '&#20752;',
		"\xBE\xAB" => '&#20757;',
		"\xBE\xAC" => '&#20864;',
		"\xBE\xAD" => '&#20906;',
		"\xBE\xAE" => '&#20957;',
		"\xBE\xAF" => '&#21137;',
		"\xBE\xB0" => '&#21139;',
		"\xBE\xB1" => '&#21235;',
		"\xBE\xB2" => '&#22105;',
		"\xBE\xB3" => '&#22123;',
		"\xBE\xB4" => '&#22137;',
		"\xBE\xB5" => '&#22121;',
		"\xBE\xB6" => '&#22116;',
		"\xBE\xB7" => '&#22136;',
		"\xBE\xB8" => '&#22122;',
		"\xBE\xB9" => '&#22120;',
		"\xBE\xBA" => '&#22117;',
		"\xBE\xBB" => '&#22129;',
		"\xBE\xBC" => '&#22127;',
		"\xBE\xBD" => '&#22124;',
		"\xBE\xBE" => '&#22114;',
		"\xBE\xBF" => '&#22134;',
		"\xBE\xC0" => '&#22721;',
		"\xBE\xC1" => '&#22718;',
		"\xBE\xC2" => '&#22727;',
		"\xBE\xC3" => '&#22725;',
		"\xBE\xC4" => '&#22894;',
		"\xBE\xC5" => '&#23325;',
		"\xBE\xC6" => '&#23348;',
		"\xBE\xC7" => '&#23416;',
		"\xBE\xC8" => '&#23536;',
		"\xBE\xC9" => '&#23566;',
		"\xBE\xCA" => '&#24394;',
		"\xBE\xCB" => '&#25010;',
		"\xBE\xCC" => '&#24977;',
		"\xBE\xCD" => '&#25001;',
		"\xBE\xCE" => '&#24970;',
		"\xBE\xCF" => '&#25037;',
		"\xBE\xD0" => '&#25014;',
		"\xBE\xD1" => '&#25022;',
		"\xBE\xD2" => '&#25034;',
		"\xBE\xD3" => '&#25032;',
		"\xBE\xD4" => '&#25136;',
		"\xBE\xD5" => '&#25797;',
		"\xBE\xD6" => '&#25793;',
		"\xBE\xD7" => '&#25803;',
		"\xBE\xD8" => '&#25787;',
		"\xBE\xD9" => '&#25788;',
		"\xBE\xDA" => '&#25818;',
		"\xBE\xDB" => '&#25796;',
		"\xBE\xDC" => '&#25799;',
		"\xBE\xDD" => '&#25794;',
		"\xBE\xDE" => '&#25805;',
		"\xBE\xDF" => '&#25791;',
		"\xBE\xE0" => '&#25810;',
		"\xBE\xE1" => '&#25812;',
		"\xBE\xE2" => '&#25790;',
		"\xBE\xE3" => '&#25972;',
		"\xBE\xE4" => '&#26310;',
		"\xBE\xE5" => '&#26313;',
		"\xBE\xE6" => '&#26297;',
		"\xBE\xE7" => '&#26308;',
		"\xBE\xE8" => '&#26311;',
		"\xBE\xE9" => '&#26296;',
		"\xBE\xEA" => '&#27197;',
		"\xBE\xEB" => '&#27192;',
		"\xBE\xEC" => '&#27194;',
		"\xBE\xED" => '&#27225;',
		"\xBE\xEE" => '&#27243;',
		"\xBE\xEF" => '&#27224;',
		"\xBE\xF0" => '&#27193;',
		"\xBE\xF1" => '&#27204;',
		"\xBE\xF2" => '&#27234;',
		"\xBE\xF3" => '&#27233;',
		"\xBE\xF4" => '&#27211;',
		"\xBE\xF5" => '&#27207;',
		"\xBE\xF6" => '&#27189;',
		"\xBE\xF7" => '&#27231;',
		"\xBE\xF8" => '&#27208;',
		"\xBE\xF9" => '&#27481;',
		"\xBE\xFA" => '&#27511;',
		"\xBE\xFB" => '&#27653;',
		"\xBE\xFC" => '&#28610;',
		"\xBE\xFD" => '&#28593;',
		"\xBE\xFE" => '&#28577;',
		"\xBF\x40" => '&#28611;',
		"\xBF\x41" => '&#28580;',
		"\xBF\x42" => '&#28609;',
		"\xBF\x43" => '&#28583;',
		"\xBF\x44" => '&#28595;',
		"\xBF\x45" => '&#28608;',
		"\xBF\x46" => '&#28601;',
		"\xBF\x47" => '&#28598;',
		"\xBF\x48" => '&#28582;',
		"\xBF\x49" => '&#28576;',
		"\xBF\x4A" => '&#28596;',
		"\xBF\x4B" => '&#29118;',
		"\xBF\x4C" => '&#29129;',
		"\xBF\x4D" => '&#29136;',
		"\xBF\x4E" => '&#29138;',
		"\xBF\x4F" => '&#29128;',
		"\xBF\x50" => '&#29141;',
		"\xBF\x51" => '&#29113;',
		"\xBF\x52" => '&#29134;',
		"\xBF\x53" => '&#29145;',
		"\xBF\x54" => '&#29148;',
		"\xBF\x55" => '&#29123;',
		"\xBF\x56" => '&#29124;',
		"\xBF\x57" => '&#29544;',
		"\xBF\x58" => '&#29852;',
		"\xBF\x59" => '&#29859;',
		"\xBF\x5A" => '&#29848;',
		"\xBF\x5B" => '&#29855;',
		"\xBF\x5C" => '&#29854;',
		"\xBF\x5D" => '&#29922;',
		"\xBF\x5E" => '&#29964;',
		"\xBF\x5F" => '&#29965;',
		"\xBF\x60" => '&#30260;',
		"\xBF\x61" => '&#30264;',
		"\xBF\x62" => '&#30266;',
		"\xBF\x63" => '&#30439;',
		"\xBF\x64" => '&#30437;',
		"\xBF\x65" => '&#30624;',
		"\xBF\x66" => '&#30622;',
		"\xBF\x67" => '&#30623;',
		"\xBF\x68" => '&#30629;',
		"\xBF\x69" => '&#30952;',
		"\xBF\x6A" => '&#30938;',
		"\xBF\x6B" => '&#30956;',
		"\xBF\x6C" => '&#30951;',
		"\xBF\x6D" => '&#31142;',
		"\xBF\x6E" => '&#31309;',
		"\xBF\x6F" => '&#31310;',
		"\xBF\x70" => '&#31302;',
		"\xBF\x71" => '&#31308;',
		"\xBF\x72" => '&#31307;',
		"\xBF\x73" => '&#31418;',
		"\xBF\x74" => '&#31705;',
		"\xBF\x75" => '&#31761;',
		"\xBF\x76" => '&#31689;',
		"\xBF\x77" => '&#31716;',
		"\xBF\x78" => '&#31707;',
		"\xBF\x79" => '&#31713;',
		"\xBF\x7A" => '&#31721;',
		"\xBF\x7B" => '&#31718;',
		"\xBF\x7C" => '&#31957;',
		"\xBF\x7D" => '&#31958;',
		"\xBF\x7E" => '&#32266;',
		"\xBF\xA1" => '&#32273;',
		"\xBF\xA2" => '&#32264;',
		"\xBF\xA3" => '&#32283;',
		"\xBF\xA4" => '&#32291;',
		"\xBF\xA5" => '&#32286;',
		"\xBF\xA6" => '&#32285;',
		"\xBF\xA7" => '&#32265;',
		"\xBF\xA8" => '&#32272;',
		"\xBF\xA9" => '&#32633;',
		"\xBF\xAA" => '&#32690;',
		"\xBF\xAB" => '&#32752;',
		"\xBF\xAC" => '&#32753;',
		"\xBF\xAD" => '&#32750;',
		"\xBF\xAE" => '&#32808;',
		"\xBF\xAF" => '&#33203;',
		"\xBF\xB0" => '&#33193;',
		"\xBF\xB1" => '&#33192;',
		"\xBF\xB2" => '&#33275;',
		"\xBF\xB3" => '&#33288;',
		"\xBF\xB4" => '&#33368;',
		"\xBF\xB5" => '&#33369;',
		"\xBF\xB6" => '&#34122;',
		"\xBF\xB7" => '&#34137;',
		"\xBF\xB8" => '&#34120;',
		"\xBF\xB9" => '&#34152;',
		"\xBF\xBA" => '&#34153;',
		"\xBF\xBB" => '&#34115;',
		"\xBF\xBC" => '&#34121;',
		"\xBF\xBD" => '&#34157;',
		"\xBF\xBE" => '&#34154;',
		"\xBF\xBF" => '&#34142;',
		"\xBF\xC0" => '&#34691;',
		"\xBF\xC1" => '&#34719;',
		"\xBF\xC2" => '&#34718;',
		"\xBF\xC3" => '&#34722;',
		"\xBF\xC4" => '&#34701;',
		"\xBF\xC5" => '&#34913;',
		"\xBF\xC6" => '&#35114;',
		"\xBF\xC7" => '&#35122;',
		"\xBF\xC8" => '&#35109;',
		"\xBF\xC9" => '&#35115;',
		"\xBF\xCA" => '&#35105;',
		"\xBF\xCB" => '&#35242;',
		"\xBF\xCC" => '&#35238;',
		"\xBF\xCD" => '&#35558;',
		"\xBF\xCE" => '&#35578;',
		"\xBF\xCF" => '&#35563;',
		"\xBF\xD0" => '&#35569;',
		"\xBF\xD1" => '&#35584;',
		"\xBF\xD2" => '&#35548;',
		"\xBF\xD3" => '&#35559;',
		"\xBF\xD4" => '&#35566;',
		"\xBF\xD5" => '&#35582;',
		"\xBF\xD6" => '&#35585;',
		"\xBF\xD7" => '&#35586;',
		"\xBF\xD8" => '&#35575;',
		"\xBF\xD9" => '&#35565;',
		"\xBF\xDA" => '&#35571;',
		"\xBF\xDB" => '&#35574;',
		"\xBF\xDC" => '&#35580;',
		"\xBF\xDD" => '&#35947;',
		"\xBF\xDE" => '&#35949;',
		"\xBF\xDF" => '&#35987;',
		"\xBF\xE0" => '&#36084;',
		"\xBF\xE1" => '&#36420;',
		"\xBF\xE2" => '&#36401;',
		"\xBF\xE3" => '&#36404;',
		"\xBF\xE4" => '&#36418;',
		"\xBF\xE5" => '&#36409;',
		"\xBF\xE6" => '&#36405;',
		"\xBF\xE7" => '&#36667;',
		"\xBF\xE8" => '&#36655;',
		"\xBF\xE9" => '&#36664;',
		"\xBF\xEA" => '&#36659;',
		"\xBF\xEB" => '&#36776;',
		"\xBF\xEC" => '&#36774;',
		"\xBF\xED" => '&#36981;',
		"\xBF\xEE" => '&#36980;',
		"\xBF\xEF" => '&#36984;',
		"\xBF\xF0" => '&#36978;',
		"\xBF\xF1" => '&#36988;',
		"\xBF\xF2" => '&#36986;',
		"\xBF\xF3" => '&#37172;',
		"\xBF\xF4" => '&#37266;',
		"\xBF\xF5" => '&#37664;',
		"\xBF\xF6" => '&#37686;',
		"\xBF\xF7" => '&#37624;',
		"\xBF\xF8" => '&#37683;',
		"\xBF\xF9" => '&#37679;',
		"\xBF\xFA" => '&#37666;',
		"\xBF\xFB" => '&#37628;',
		"\xBF\xFC" => '&#37675;',
		"\xBF\xFD" => '&#37636;',
		"\xBF\xFE" => '&#37658;',
		"\xC0\x40" => '&#37648;',
		"\xC0\x41" => '&#37670;',
		"\xC0\x42" => '&#37665;',
		"\xC0\x43" => '&#37653;',
		"\xC0\x44" => '&#37678;',
		"\xC0\x45" => '&#37657;',
		"\xC0\x46" => '&#38331;',
		"\xC0\x47" => '&#38567;',
		"\xC0\x48" => '&#38568;',
		"\xC0\x49" => '&#38570;',
		"\xC0\x4A" => '&#38613;',
		"\xC0\x4B" => '&#38670;',
		"\xC0\x4C" => '&#38673;',
		"\xC0\x4D" => '&#38678;',
		"\xC0\x4E" => '&#38669;',
		"\xC0\x4F" => '&#38675;',
		"\xC0\x50" => '&#38671;',
		"\xC0\x51" => '&#38747;',
		"\xC0\x52" => '&#38748;',
		"\xC0\x53" => '&#38758;',
		"\xC0\x54" => '&#38808;',
		"\xC0\x55" => '&#38960;',
		"\xC0\x56" => '&#38968;',
		"\xC0\x57" => '&#38971;',
		"\xC0\x58" => '&#38967;',
		"\xC0\x59" => '&#38957;',
		"\xC0\x5A" => '&#38969;',
		"\xC0\x5B" => '&#38948;',
		"\xC0\x5C" => '&#39184;',
		"\xC0\x5D" => '&#39208;',
		"\xC0\x5E" => '&#39198;',
		"\xC0\x5F" => '&#39195;',
		"\xC0\x60" => '&#39201;',
		"\xC0\x61" => '&#39194;',
		"\xC0\x62" => '&#39405;',
		"\xC0\x63" => '&#39394;',
		"\xC0\x64" => '&#39409;',
		"\xC0\x65" => '&#39608;',
		"\xC0\x66" => '&#39612;',
		"\xC0\x67" => '&#39675;',
		"\xC0\x68" => '&#39661;',
		"\xC0\x69" => '&#39720;',
		"\xC0\x6A" => '&#39825;',
		"\xC0\x6B" => '&#40213;',
		"\xC0\x6C" => '&#40227;',
		"\xC0\x6D" => '&#40230;',
		"\xC0\x6E" => '&#40232;',
		"\xC0\x6F" => '&#40210;',
		"\xC0\x70" => '&#40219;',
		"\xC0\x71" => '&#40664;',
		"\xC0\x72" => '&#40660;',
		"\xC0\x73" => '&#40845;',
		"\xC0\x74" => '&#40860;',
		"\xC0\x75" => '&#20778;',
		"\xC0\x76" => '&#20767;',
		"\xC0\x77" => '&#20769;',
		"\xC0\x78" => '&#20786;',
		"\xC0\x79" => '&#21237;',
		"\xC0\x7A" => '&#22158;',
		"\xC0\x7B" => '&#22144;',
		"\xC0\x7C" => '&#22160;',
		"\xC0\x7D" => '&#22149;',
		"\xC0\x7E" => '&#22151;',
		"\xC0\xA1" => '&#22159;',
		"\xC0\xA2" => '&#22741;',
		"\xC0\xA3" => '&#22739;',
		"\xC0\xA4" => '&#22737;',
		"\xC0\xA5" => '&#22734;',
		"\xC0\xA6" => '&#23344;',
		"\xC0\xA7" => '&#23338;',
		"\xC0\xA8" => '&#23332;',
		"\xC0\xA9" => '&#23418;',
		"\xC0\xAA" => '&#23607;',
		"\xC0\xAB" => '&#23656;',
		"\xC0\xAC" => '&#23996;',
		"\xC0\xAD" => '&#23994;',
		"\xC0\xAE" => '&#23997;',
		"\xC0\xAF" => '&#23992;',
		"\xC0\xB0" => '&#24171;',
		"\xC0\xB1" => '&#24396;',
		"\xC0\xB2" => '&#24509;',
		"\xC0\xB3" => '&#25033;',
		"\xC0\xB4" => '&#25026;',
		"\xC0\xB5" => '&#25031;',
		"\xC0\xB6" => '&#25062;',
		"\xC0\xB7" => '&#25035;',
		"\xC0\xB8" => '&#25138;',
		"\xC0\xB9" => '&#25140;',
		"\xC0\xBA" => '&#25806;',
		"\xC0\xBB" => '&#25802;',
		"\xC0\xBC" => '&#25816;',
		"\xC0\xBD" => '&#25824;',
		"\xC0\xBE" => '&#25840;',
		"\xC0\xBF" => '&#25830;',
		"\xC0\xC0" => '&#25836;',
		"\xC0\xC1" => '&#25841;',
		"\xC0\xC2" => '&#25826;',
		"\xC0\xC3" => '&#25837;',
		"\xC0\xC4" => '&#25986;',
		"\xC0\xC5" => '&#25987;',
		"\xC0\xC6" => '&#26329;',
		"\xC0\xC7" => '&#26326;',
		"\xC0\xC8" => '&#27264;',
		"\xC0\xC9" => '&#27284;',
		"\xC0\xCA" => '&#27268;',
		"\xC0\xCB" => '&#27298;',
		"\xC0\xCC" => '&#27292;',
		"\xC0\xCD" => '&#27355;',
		"\xC0\xCE" => '&#27299;',
		"\xC0\xCF" => '&#27262;',
		"\xC0\xD0" => '&#27287;',
		"\xC0\xD1" => '&#27280;',
		"\xC0\xD2" => '&#27296;',
		"\xC0\xD3" => '&#27484;',
		"\xC0\xD4" => '&#27566;',
		"\xC0\xD5" => '&#27610;',
		"\xC0\xD6" => '&#27656;',
		"\xC0\xD7" => '&#28632;',
		"\xC0\xD8" => '&#28657;',
		"\xC0\xD9" => '&#28639;',
		"\xC0\xDA" => '&#28640;',
		"\xC0\xDB" => '&#28635;',
		"\xC0\xDC" => '&#28644;',
		"\xC0\xDD" => '&#28651;',
		"\xC0\xDE" => '&#28655;',
		"\xC0\xDF" => '&#28544;',
		"\xC0\xE0" => '&#28652;',
		"\xC0\xE1" => '&#28641;',
		"\xC0\xE2" => '&#28649;',
		"\xC0\xE3" => '&#28629;',
		"\xC0\xE4" => '&#28654;',
		"\xC0\xE5" => '&#28656;',
		"\xC0\xE6" => '&#29159;',
		"\xC0\xE7" => '&#29151;',
		"\xC0\xE8" => '&#29166;',
		"\xC0\xE9" => '&#29158;',
		"\xC0\xEA" => '&#29157;',
		"\xC0\xEB" => '&#29165;',
		"\xC0\xEC" => '&#29164;',
		"\xC0\xED" => '&#29172;',
		"\xC0\xEE" => '&#29152;',
		"\xC0\xEF" => '&#29237;',
		"\xC0\xF0" => '&#29254;',
		"\xC0\xF1" => '&#29552;',
		"\xC0\xF2" => '&#29554;',
		"\xC0\xF3" => '&#29865;',
		"\xC0\xF4" => '&#29872;',
		"\xC0\xF5" => '&#29862;',
		"\xC0\xF6" => '&#29864;',
		"\xC0\xF7" => '&#30278;',
		"\xC0\xF8" => '&#30274;',
		"\xC0\xF9" => '&#30284;',
		"\xC0\xFA" => '&#30442;',
		"\xC0\xFB" => '&#30643;',
		"\xC0\xFC" => '&#30634;',
		"\xC0\xFD" => '&#30640;',
		"\xC0\xFE" => '&#30636;',
		"\xC1\x40" => '&#30631;',
		"\xC1\x41" => '&#30637;',
		"\xC1\x42" => '&#30703;',
		"\xC1\x43" => '&#30967;',
		"\xC1\x44" => '&#30970;',
		"\xC1\x45" => '&#30964;',
		"\xC1\x46" => '&#30959;',
		"\xC1\x47" => '&#30977;',
		"\xC1\x48" => '&#31143;',
		"\xC1\x49" => '&#31146;',
		"\xC1\x4A" => '&#31319;',
		"\xC1\x4B" => '&#31423;',
		"\xC1\x4C" => '&#31751;',
		"\xC1\x4D" => '&#31757;',
		"\xC1\x4E" => '&#31742;',
		"\xC1\x4F" => '&#31735;',
		"\xC1\x50" => '&#31756;',
		"\xC1\x51" => '&#31712;',
		"\xC1\x52" => '&#31968;',
		"\xC1\x53" => '&#31964;',
		"\xC1\x54" => '&#31966;',
		"\xC1\x55" => '&#31970;',
		"\xC1\x56" => '&#31967;',
		"\xC1\x57" => '&#31961;',
		"\xC1\x58" => '&#31965;',
		"\xC1\x59" => '&#32302;',
		"\xC1\x5A" => '&#32318;',
		"\xC1\x5B" => '&#32326;',
		"\xC1\x5C" => '&#32311;',
		"\xC1\x5D" => '&#32306;',
		"\xC1\x5E" => '&#32323;',
		"\xC1\x5F" => '&#32299;',
		"\xC1\x60" => '&#32317;',
		"\xC1\x61" => '&#32305;',
		"\xC1\x62" => '&#32325;',
		"\xC1\x63" => '&#32321;',
		"\xC1\x64" => '&#32308;',
		"\xC1\x65" => '&#32313;',
		"\xC1\x66" => '&#32328;',
		"\xC1\x67" => '&#32309;',
		"\xC1\x68" => '&#32319;',
		"\xC1\x69" => '&#32303;',
		"\xC1\x6A" => '&#32580;',
		"\xC1\x6B" => '&#32755;',
		"\xC1\x6C" => '&#32764;',
		"\xC1\x6D" => '&#32881;',
		"\xC1\x6E" => '&#32882;',
		"\xC1\x6F" => '&#32880;',
		"\xC1\x70" => '&#32879;',
		"\xC1\x71" => '&#32883;',
		"\xC1\x72" => '&#33222;',
		"\xC1\x73" => '&#33219;',
		"\xC1\x74" => '&#33210;',
		"\xC1\x75" => '&#33218;',
		"\xC1\x76" => '&#33216;',
		"\xC1\x77" => '&#33215;',
		"\xC1\x78" => '&#33213;',
		"\xC1\x79" => '&#33225;',
		"\xC1\x7A" => '&#33214;',
		"\xC1\x7B" => '&#33256;',
		"\xC1\x7C" => '&#33289;',
		"\xC1\x7D" => '&#33393;',
		"\xC1\x7E" => '&#34218;',
		"\xC1\xA1" => '&#34180;',
		"\xC1\xA2" => '&#34174;',
		"\xC1\xA3" => '&#34204;',
		"\xC1\xA4" => '&#34193;',
		"\xC1\xA5" => '&#34196;',
		"\xC1\xA6" => '&#34223;',
		"\xC1\xA7" => '&#34203;',
		"\xC1\xA8" => '&#34183;',
		"\xC1\xA9" => '&#34216;',
		"\xC1\xAA" => '&#34186;',
		"\xC1\xAB" => '&#34407;',
		"\xC1\xAC" => '&#34752;',
		"\xC1\xAD" => '&#34769;',
		"\xC1\xAE" => '&#34739;',
		"\xC1\xAF" => '&#34770;',
		"\xC1\xB0" => '&#34758;',
		"\xC1\xB1" => '&#34731;',
		"\xC1\xB2" => '&#34747;',
		"\xC1\xB3" => '&#34746;',
		"\xC1\xB4" => '&#34760;',
		"\xC1\xB5" => '&#34763;',
		"\xC1\xB6" => '&#35131;',
		"\xC1\xB7" => '&#35126;',
		"\xC1\xB8" => '&#35140;',
		"\xC1\xB9" => '&#35128;',
		"\xC1\xBA" => '&#35133;',
		"\xC1\xBB" => '&#35244;',
		"\xC1\xBC" => '&#35598;',
		"\xC1\xBD" => '&#35607;',
		"\xC1\xBE" => '&#35609;',
		"\xC1\xBF" => '&#35611;',
		"\xC1\xC0" => '&#35594;',
		"\xC1\xC1" => '&#35616;',
		"\xC1\xC2" => '&#35613;',
		"\xC1\xC3" => '&#35588;',
		"\xC1\xC4" => '&#35600;',
		"\xC1\xC5" => '&#35905;',
		"\xC1\xC6" => '&#35903;',
		"\xC1\xC7" => '&#35955;',
		"\xC1\xC8" => '&#36090;',
		"\xC1\xC9" => '&#36093;',
		"\xC1\xCA" => '&#36092;',
		"\xC1\xCB" => '&#36088;',
		"\xC1\xCC" => '&#36091;',
		"\xC1\xCD" => '&#36264;',
		"\xC1\xCE" => '&#36425;',
		"\xC1\xCF" => '&#36427;',
		"\xC1\xD0" => '&#36424;',
		"\xC1\xD1" => '&#36426;',
		"\xC1\xD2" => '&#36676;',
		"\xC1\xD3" => '&#36670;',
		"\xC1\xD4" => '&#36674;',
		"\xC1\xD5" => '&#36677;',
		"\xC1\xD6" => '&#36671;',
		"\xC1\xD7" => '&#36991;',
		"\xC1\xD8" => '&#36989;',
		"\xC1\xD9" => '&#36996;',
		"\xC1\xDA" => '&#36993;',
		"\xC1\xDB" => '&#36994;',
		"\xC1\xDC" => '&#36992;',
		"\xC1\xDD" => '&#37177;',
		"\xC1\xDE" => '&#37283;',
		"\xC1\xDF" => '&#37278;',
		"\xC1\xE0" => '&#37276;',
		"\xC1\xE1" => '&#37709;',
		"\xC1\xE2" => '&#37762;',
		"\xC1\xE3" => '&#37672;',
		"\xC1\xE4" => '&#37749;',
		"\xC1\xE5" => '&#37706;',
		"\xC1\xE6" => '&#37733;',
		"\xC1\xE7" => '&#37707;',
		"\xC1\xE8" => '&#37656;',
		"\xC1\xE9" => '&#37758;',
		"\xC1\xEA" => '&#37740;',
		"\xC1\xEB" => '&#37723;',
		"\xC1\xEC" => '&#37744;',
		"\xC1\xED" => '&#37722;',
		"\xC1\xEE" => '&#37716;',
		"\xC1\xEF" => '&#38346;',
		"\xC1\xF0" => '&#38347;',
		"\xC1\xF1" => '&#38348;',
		"\xC1\xF2" => '&#38344;',
		"\xC1\xF3" => '&#38342;',
		"\xC1\xF4" => '&#38577;',
		"\xC1\xF5" => '&#38584;',
		"\xC1\xF6" => '&#38614;',
		"\xC1\xF7" => '&#38684;',
		"\xC1\xF8" => '&#38686;',
		"\xC1\xF9" => '&#38816;',
		"\xC1\xFA" => '&#38867;',
		"\xC1\xFB" => '&#38982;',
		"\xC1\xFC" => '&#39094;',
		"\xC1\xFD" => '&#39221;',
		"\xC1\xFE" => '&#39425;',
		"\xC2\x40" => '&#39423;',
		"\xC2\x41" => '&#39854;',
		"\xC2\x42" => '&#39851;',
		"\xC2\x43" => '&#39850;',
		"\xC2\x44" => '&#39853;',
		"\xC2\x45" => '&#40251;',
		"\xC2\x46" => '&#40255;',
		"\xC2\x47" => '&#40587;',
		"\xC2\x48" => '&#40655;',
		"\xC2\x49" => '&#40670;',
		"\xC2\x4A" => '&#40668;',
		"\xC2\x4B" => '&#40669;',
		"\xC2\x4C" => '&#40667;',
		"\xC2\x4D" => '&#40766;',
		"\xC2\x4E" => '&#40779;',
		"\xC2\x4F" => '&#21474;',
		"\xC2\x50" => '&#22165;',
		"\xC2\x51" => '&#22190;',
		"\xC2\x52" => '&#22745;',
		"\xC2\x53" => '&#22744;',
		"\xC2\x54" => '&#23352;',
		"\xC2\x55" => '&#24413;',
		"\xC2\x56" => '&#25059;',
		"\xC2\x57" => '&#25139;',
		"\xC2\x58" => '&#25844;',
		"\xC2\x59" => '&#25842;',
		"\xC2\x5A" => '&#25854;',
		"\xC2\x5B" => '&#25862;',
		"\xC2\x5C" => '&#25850;',
		"\xC2\x5D" => '&#25851;',
		"\xC2\x5E" => '&#25847;',
		"\xC2\x5F" => '&#26039;',
		"\xC2\x60" => '&#26332;',
		"\xC2\x61" => '&#26406;',
		"\xC2\x62" => '&#27315;',
		"\xC2\x63" => '&#27308;',
		"\xC2\x64" => '&#27331;',
		"\xC2\x65" => '&#27323;',
		"\xC2\x66" => '&#27320;',
		"\xC2\x67" => '&#27330;',
		"\xC2\x68" => '&#27310;',
		"\xC2\x69" => '&#27311;',
		"\xC2\x6A" => '&#27487;',
		"\xC2\x6B" => '&#27512;',
		"\xC2\x6C" => '&#27567;',
		"\xC2\x6D" => '&#28681;',
		"\xC2\x6E" => '&#28683;',
		"\xC2\x6F" => '&#28670;',
		"\xC2\x70" => '&#28678;',
		"\xC2\x71" => '&#28666;',
		"\xC2\x72" => '&#28689;',
		"\xC2\x73" => '&#28687;',
		"\xC2\x74" => '&#29179;',
		"\xC2\x75" => '&#29180;',
		"\xC2\x76" => '&#29182;',
		"\xC2\x77" => '&#29176;',
		"\xC2\x78" => '&#29559;',
		"\xC2\x79" => '&#29557;',
		"\xC2\x7A" => '&#29863;',
		"\xC2\x7B" => '&#29887;',
		"\xC2\x7C" => '&#29973;',
		"\xC2\x7D" => '&#30294;',
		"\xC2\x7E" => '&#30296;',
		"\xC2\xA1" => '&#30290;',
		"\xC2\xA2" => '&#30653;',
		"\xC2\xA3" => '&#30655;',
		"\xC2\xA4" => '&#30651;',
		"\xC2\xA5" => '&#30652;',
		"\xC2\xA6" => '&#30990;',
		"\xC2\xA7" => '&#31150;',
		"\xC2\xA8" => '&#31329;',
		"\xC2\xA9" => '&#31330;',
		"\xC2\xAA" => '&#31328;',
		"\xC2\xAB" => '&#31428;',
		"\xC2\xAC" => '&#31429;',
		"\xC2\xAD" => '&#31787;',
		"\xC2\xAE" => '&#31783;',
		"\xC2\xAF" => '&#31786;',
		"\xC2\xB0" => '&#31774;',
		"\xC2\xB1" => '&#31779;',
		"\xC2\xB2" => '&#31777;',
		"\xC2\xB3" => '&#31975;',
		"\xC2\xB4" => '&#32340;',
		"\xC2\xB5" => '&#32341;',
		"\xC2\xB6" => '&#32350;',
		"\xC2\xB7" => '&#32346;',
		"\xC2\xB8" => '&#32353;',
		"\xC2\xB9" => '&#32338;',
		"\xC2\xBA" => '&#32345;',
		"\xC2\xBB" => '&#32584;',
		"\xC2\xBC" => '&#32761;',
		"\xC2\xBD" => '&#32763;',
		"\xC2\xBE" => '&#32887;',
		"\xC2\xBF" => '&#32886;',
		"\xC2\xC0" => '&#33229;',
		"\xC2\xC1" => '&#33231;',
		"\xC2\xC2" => '&#33290;',
		"\xC2\xC3" => '&#34255;',
		"\xC2\xC4" => '&#34217;',
		"\xC2\xC5" => '&#34253;',
		"\xC2\xC6" => '&#34256;',
		"\xC2\xC7" => '&#34249;',
		"\xC2\xC8" => '&#34224;',
		"\xC2\xC9" => '&#34234;',
		"\xC2\xCA" => '&#34233;',
		"\xC2\xCB" => '&#34214;',
		"\xC2\xCC" => '&#34799;',
		"\xC2\xCD" => '&#34796;',
		"\xC2\xCE" => '&#34802;',
		"\xC2\xCF" => '&#34784;',
		"\xC2\xD0" => '&#35206;',
		"\xC2\xD1" => '&#35250;',
		"\xC2\xD2" => '&#35316;',
		"\xC2\xD3" => '&#35624;',
		"\xC2\xD4" => '&#35641;',
		"\xC2\xD5" => '&#35628;',
		"\xC2\xD6" => '&#35627;',
		"\xC2\xD7" => '&#35920;',
		"\xC2\xD8" => '&#36101;',
		"\xC2\xD9" => '&#36441;',
		"\xC2\xDA" => '&#36451;',
		"\xC2\xDB" => '&#36454;',
		"\xC2\xDC" => '&#36452;',
		"\xC2\xDD" => '&#36447;',
		"\xC2\xDE" => '&#36437;',
		"\xC2\xDF" => '&#36544;',
		"\xC2\xE0" => '&#36681;',
		"\xC2\xE1" => '&#36685;',
		"\xC2\xE2" => '&#36999;',
		"\xC2\xE3" => '&#36995;',
		"\xC2\xE4" => '&#37000;',
		"\xC2\xE5" => '&#37291;',
		"\xC2\xE6" => '&#37292;',
		"\xC2\xE7" => '&#37328;',
		"\xC2\xE8" => '&#37780;',
		"\xC2\xE9" => '&#37770;',
		"\xC2\xEA" => '&#37782;',
		"\xC2\xEB" => '&#37794;',
		"\xC2\xEC" => '&#37811;',
		"\xC2\xED" => '&#37806;',
		"\xC2\xEE" => '&#37804;',
		"\xC2\xEF" => '&#37808;',
		"\xC2\xF0" => '&#37784;',
		"\xC2\xF1" => '&#37786;',
		"\xC2\xF2" => '&#37783;',
		"\xC2\xF3" => '&#38356;',
		"\xC2\xF4" => '&#38358;',
		"\xC2\xF5" => '&#38352;',
		"\xC2\xF6" => '&#38357;',
		"\xC2\xF7" => '&#38626;',
		"\xC2\xF8" => '&#38620;',
		"\xC2\xF9" => '&#38617;',
		"\xC2\xFA" => '&#38619;',
		"\xC2\xFB" => '&#38622;',
		"\xC2\xFC" => '&#38692;',
		"\xC2\xFD" => '&#38819;',
		"\xC2\xFE" => '&#38822;',
		"\xC3\x40" => '&#38829;',
		"\xC3\x41" => '&#38905;',
		"\xC3\x42" => '&#38989;',
		"\xC3\x43" => '&#38991;',
		"\xC3\x44" => '&#38988;',
		"\xC3\x45" => '&#38990;',
		"\xC3\x46" => '&#38995;',
		"\xC3\x47" => '&#39098;',
		"\xC3\x48" => '&#39230;',
		"\xC3\x49" => '&#39231;',
		"\xC3\x4A" => '&#39229;',
		"\xC3\x4B" => '&#39214;',
		"\xC3\x4C" => '&#39333;',
		"\xC3\x4D" => '&#39438;',
		"\xC3\x4E" => '&#39617;',
		"\xC3\x4F" => '&#39683;',
		"\xC3\x50" => '&#39686;',
		"\xC3\x51" => '&#39759;',
		"\xC3\x52" => '&#39758;',
		"\xC3\x53" => '&#39757;',
		"\xC3\x54" => '&#39882;',
		"\xC3\x55" => '&#39881;',
		"\xC3\x56" => '&#39933;',
		"\xC3\x57" => '&#39880;',
		"\xC3\x58" => '&#39872;',
		"\xC3\x59" => '&#40273;',
		"\xC3\x5A" => '&#40285;',
		"\xC3\x5B" => '&#40288;',
		"\xC3\x5C" => '&#40672;',
		"\xC3\x5D" => '&#40725;',
		"\xC3\x5E" => '&#40748;',
		"\xC3\x5F" => '&#20787;',
		"\xC3\x60" => '&#22181;',
		"\xC3\x61" => '&#22750;',
		"\xC3\x62" => '&#22751;',
		"\xC3\x63" => '&#22754;',
		"\xC3\x64" => '&#23541;',
		"\xC3\x65" => '&#40848;',
		"\xC3\x66" => '&#24300;',
		"\xC3\x67" => '&#25074;',
		"\xC3\x68" => '&#25079;',
		"\xC3\x69" => '&#25078;',
		"\xC3\x6A" => '&#25077;',
		"\xC3\x6B" => '&#25856;',
		"\xC3\x6C" => '&#25871;',
		"\xC3\x6D" => '&#26336;',
		"\xC3\x6E" => '&#26333;',
		"\xC3\x6F" => '&#27365;',
		"\xC3\x70" => '&#27357;',
		"\xC3\x71" => '&#27354;',
		"\xC3\x72" => '&#27347;',
		"\xC3\x73" => '&#28699;',
		"\xC3\x74" => '&#28703;',
		"\xC3\x75" => '&#28712;',
		"\xC3\x76" => '&#28698;',
		"\xC3\x77" => '&#28701;',
		"\xC3\x78" => '&#28693;',
		"\xC3\x79" => '&#28696;',
		"\xC3\x7A" => '&#29190;',
		"\xC3\x7B" => '&#29197;',
		"\xC3\x7C" => '&#29272;',
		"\xC3\x7D" => '&#29346;',
		"\xC3\x7E" => '&#29560;',
		"\xC3\xA1" => '&#29562;',
		"\xC3\xA2" => '&#29885;',
		"\xC3\xA3" => '&#29898;',
		"\xC3\xA4" => '&#29923;',
		"\xC3\xA5" => '&#30087;',
		"\xC3\xA6" => '&#30086;',
		"\xC3\xA7" => '&#30303;',
		"\xC3\xA8" => '&#30305;',
		"\xC3\xA9" => '&#30663;',
		"\xC3\xAA" => '&#31001;',
		"\xC3\xAB" => '&#31153;',
		"\xC3\xAC" => '&#31339;',
		"\xC3\xAD" => '&#31337;',
		"\xC3\xAE" => '&#31806;',
		"\xC3\xAF" => '&#31807;',
		"\xC3\xB0" => '&#31800;',
		"\xC3\xB1" => '&#31805;',
		"\xC3\xB2" => '&#31799;',
		"\xC3\xB3" => '&#31808;',
		"\xC3\xB4" => '&#32363;',
		"\xC3\xB5" => '&#32365;',
		"\xC3\xB6" => '&#32377;',
		"\xC3\xB7" => '&#32361;',
		"\xC3\xB8" => '&#32362;',
		"\xC3\xB9" => '&#32645;',
		"\xC3\xBA" => '&#32371;',
		"\xC3\xBB" => '&#32694;',
		"\xC3\xBC" => '&#32697;',
		"\xC3\xBD" => '&#32696;',
		"\xC3\xBE" => '&#33240;',
		"\xC3\xBF" => '&#34281;',
		"\xC3\xC0" => '&#34269;',
		"\xC3\xC1" => '&#34282;',
		"\xC3\xC2" => '&#34261;',
		"\xC3\xC3" => '&#34276;',
		"\xC3\xC4" => '&#34277;',
		"\xC3\xC5" => '&#34295;',
		"\xC3\xC6" => '&#34811;',
		"\xC3\xC7" => '&#34821;',
		"\xC3\xC8" => '&#34829;',
		"\xC3\xC9" => '&#34809;',
		"\xC3\xCA" => '&#34814;',
		"\xC3\xCB" => '&#35168;',
		"\xC3\xCC" => '&#35167;',
		"\xC3\xCD" => '&#35158;',
		"\xC3\xCE" => '&#35166;',
		"\xC3\xCF" => '&#35649;',
		"\xC3\xD0" => '&#35676;',
		"\xC3\xD1" => '&#35672;',
		"\xC3\xD2" => '&#35657;',
		"\xC3\xD3" => '&#35674;',
		"\xC3\xD4" => '&#35662;',
		"\xC3\xD5" => '&#35663;',
		"\xC3\xD6" => '&#35654;',
		"\xC3\xD7" => '&#35673;',
		"\xC3\xD8" => '&#36104;',
		"\xC3\xD9" => '&#36106;',
		"\xC3\xDA" => '&#36476;',
		"\xC3\xDB" => '&#36466;',
		"\xC3\xDC" => '&#36487;',
		"\xC3\xDD" => '&#36470;',
		"\xC3\xDE" => '&#36460;',
		"\xC3\xDF" => '&#36474;',
		"\xC3\xE0" => '&#36468;',
		"\xC3\xE1" => '&#36692;',
		"\xC3\xE2" => '&#36686;',
		"\xC3\xE3" => '&#36781;',
		"\xC3\xE4" => '&#37002;',
		"\xC3\xE5" => '&#37003;',
		"\xC3\xE6" => '&#37297;',
		"\xC3\xE7" => '&#37294;',
		"\xC3\xE8" => '&#37857;',
		"\xC3\xE9" => '&#37841;',
		"\xC3\xEA" => '&#37855;',
		"\xC3\xEB" => '&#37827;',
		"\xC3\xEC" => '&#37832;',
		"\xC3\xED" => '&#37852;',
		"\xC3\xEE" => '&#37853;',
		"\xC3\xEF" => '&#37846;',
		"\xC3\xF0" => '&#37858;',
		"\xC3\xF1" => '&#37837;',
		"\xC3\xF2" => '&#37848;',
		"\xC3\xF3" => '&#37860;',
		"\xC3\xF4" => '&#37847;',
		"\xC3\xF5" => '&#37864;',
		"\xC3\xF6" => '&#38364;',
		"\xC3\xF7" => '&#38580;',
		"\xC3\xF8" => '&#38627;',
		"\xC3\xF9" => '&#38698;',
		"\xC3\xFA" => '&#38695;',
		"\xC3\xFB" => '&#38753;',
		"\xC3\xFC" => '&#38876;',
		"\xC3\xFD" => '&#38907;',
		"\xC3\xFE" => '&#39006;',
		"\xC4\x40" => '&#39000;',
		"\xC4\x41" => '&#39003;',
		"\xC4\x42" => '&#39100;',
		"\xC4\x43" => '&#39237;',
		"\xC4\x44" => '&#39241;',
		"\xC4\x45" => '&#39446;',
		"\xC4\x46" => '&#39449;',
		"\xC4\x47" => '&#39693;',
		"\xC4\x48" => '&#39912;',
		"\xC4\x49" => '&#39911;',
		"\xC4\x4A" => '&#39894;',
		"\xC4\x4B" => '&#39899;',
		"\xC4\x4C" => '&#40329;',
		"\xC4\x4D" => '&#40289;',
		"\xC4\x4E" => '&#40306;',
		"\xC4\x4F" => '&#40298;',
		"\xC4\x50" => '&#40300;',
		"\xC4\x51" => '&#40594;',
		"\xC4\x52" => '&#40599;',
		"\xC4\x53" => '&#40595;',
		"\xC4\x54" => '&#40628;',
		"\xC4\x55" => '&#21240;',
		"\xC4\x56" => '&#22184;',
		"\xC4\x57" => '&#22199;',
		"\xC4\x58" => '&#22198;',
		"\xC4\x59" => '&#22196;',
		"\xC4\x5A" => '&#22204;',
		"\xC4\x5B" => '&#22756;',
		"\xC4\x5C" => '&#23360;',
		"\xC4\x5D" => '&#23363;',
		"\xC4\x5E" => '&#23421;',
		"\xC4\x5F" => '&#23542;',
		"\xC4\x60" => '&#24009;',
		"\xC4\x61" => '&#25080;',
		"\xC4\x62" => '&#25082;',
		"\xC4\x63" => '&#25880;',
		"\xC4\x64" => '&#25876;',
		"\xC4\x65" => '&#25881;',
		"\xC4\x66" => '&#26342;',
		"\xC4\x67" => '&#26407;',
		"\xC4\x68" => '&#27372;',
		"\xC4\x69" => '&#28734;',
		"\xC4\x6A" => '&#28720;',
		"\xC4\x6B" => '&#28722;',
		"\xC4\x6C" => '&#29200;',
		"\xC4\x6D" => '&#29563;',
		"\xC4\x6E" => '&#29903;',
		"\xC4\x6F" => '&#30306;',
		"\xC4\x70" => '&#30309;',
		"\xC4\x71" => '&#31014;',
		"\xC4\x72" => '&#31018;',
		"\xC4\x73" => '&#31020;',
		"\xC4\x74" => '&#31019;',
		"\xC4\x75" => '&#31431;',
		"\xC4\x76" => '&#31478;',
		"\xC4\x77" => '&#31820;',
		"\xC4\x78" => '&#31811;',
		"\xC4\x79" => '&#31821;',
		"\xC4\x7A" => '&#31983;',
		"\xC4\x7B" => '&#31984;',
		"\xC4\x7C" => '&#36782;',
		"\xC4\x7D" => '&#32381;',
		"\xC4\x7E" => '&#32380;',
		"\xC4\xA1" => '&#32386;',
		"\xC4\xA2" => '&#32588;',
		"\xC4\xA3" => '&#32768;',
		"\xC4\xA4" => '&#33242;',
		"\xC4\xA5" => '&#33382;',
		"\xC4\xA6" => '&#34299;',
		"\xC4\xA7" => '&#34297;',
		"\xC4\xA8" => '&#34321;',
		"\xC4\xA9" => '&#34298;',
		"\xC4\xAA" => '&#34310;',
		"\xC4\xAB" => '&#34315;',
		"\xC4\xAC" => '&#34311;',
		"\xC4\xAD" => '&#34314;',
		"\xC4\xAE" => '&#34836;',
		"\xC4\xAF" => '&#34837;',
		"\xC4\xB0" => '&#35172;',
		"\xC4\xB1" => '&#35258;',
		"\xC4\xB2" => '&#35320;',
		"\xC4\xB3" => '&#35696;',
		"\xC4\xB4" => '&#35692;',
		"\xC4\xB5" => '&#35686;',
		"\xC4\xB6" => '&#35695;',
		"\xC4\xB7" => '&#35679;',
		"\xC4\xB8" => '&#35691;',
		"\xC4\xB9" => '&#36111;',
		"\xC4\xBA" => '&#36109;',
		"\xC4\xBB" => '&#36489;',
		"\xC4\xBC" => '&#36481;',
		"\xC4\xBD" => '&#36485;',
		"\xC4\xBE" => '&#36482;',
		"\xC4\xBF" => '&#37300;',
		"\xC4\xC0" => '&#37323;',
		"\xC4\xC1" => '&#37912;',
		"\xC4\xC2" => '&#37891;',
		"\xC4\xC3" => '&#37885;',
		"\xC4\xC4" => '&#38369;',
		"\xC4\xC5" => '&#38704;',
		"\xC4\xC6" => '&#39108;',
		"\xC4\xC7" => '&#39250;',
		"\xC4\xC8" => '&#39249;',
		"\xC4\xC9" => '&#39336;',
		"\xC4\xCA" => '&#39467;',
		"\xC4\xCB" => '&#39472;',
		"\xC4\xCC" => '&#39479;',
		"\xC4\xCD" => '&#39477;',
		"\xC4\xCE" => '&#39955;',
		"\xC4\xCF" => '&#39949;',
		"\xC4\xD0" => '&#40569;',
		"\xC4\xD1" => '&#40629;',
		"\xC4\xD2" => '&#40680;',
		"\xC4\xD3" => '&#40751;',
		"\xC4\xD4" => '&#40799;',
		"\xC4\xD5" => '&#40803;',
		"\xC4\xD6" => '&#40801;',
		"\xC4\xD7" => '&#20791;',
		"\xC4\xD8" => '&#20792;',
		"\xC4\xD9" => '&#22209;',
		"\xC4\xDA" => '&#22208;',
		"\xC4\xDB" => '&#22210;',
		"\xC4\xDC" => '&#22804;',
		"\xC4\xDD" => '&#23660;',
		"\xC4\xDE" => '&#24013;',
		"\xC4\xDF" => '&#25084;',
		"\xC4\xE0" => '&#25086;',
		"\xC4\xE1" => '&#25885;',
		"\xC4\xE2" => '&#25884;',
		"\xC4\xE3" => '&#26005;',
		"\xC4\xE4" => '&#26345;',
		"\xC4\xE5" => '&#27387;',
		"\xC4\xE6" => '&#27396;',
		"\xC4\xE7" => '&#27386;',
		"\xC4\xE8" => '&#27570;',
		"\xC4\xE9" => '&#28748;',
		"\xC4\xEA" => '&#29211;',
		"\xC4\xEB" => '&#29351;',
		"\xC4\xEC" => '&#29910;',
		"\xC4\xED" => '&#29908;',
		"\xC4\xEE" => '&#30313;',
		"\xC4\xEF" => '&#30675;',
		"\xC4\xF0" => '&#31824;',
		"\xC4\xF1" => '&#32399;',
		"\xC4\xF2" => '&#32396;',
		"\xC4\xF3" => '&#32700;',
		"\xC4\xF4" => '&#34327;',
		"\xC4\xF5" => '&#34349;',
		"\xC4\xF6" => '&#34330;',
		"\xC4\xF7" => '&#34851;',
		"\xC4\xF8" => '&#34850;',
		"\xC4\xF9" => '&#34849;',
		"\xC4\xFA" => '&#34847;',
		"\xC4\xFB" => '&#35178;',
		"\xC4\xFC" => '&#35180;',
		"\xC4\xFD" => '&#35261;',
		"\xC4\xFE" => '&#35700;',
		"\xC5\x40" => '&#35703;',
		"\xC5\x41" => '&#35709;',
		"\xC5\x42" => '&#36115;',
		"\xC5\x43" => '&#36490;',
		"\xC5\x44" => '&#36493;',
		"\xC5\x45" => '&#36491;',
		"\xC5\x46" => '&#36703;',
		"\xC5\x47" => '&#36783;',
		"\xC5\x48" => '&#37306;',
		"\xC5\x49" => '&#37934;',
		"\xC5\x4A" => '&#37939;',
		"\xC5\x4B" => '&#37941;',
		"\xC5\x4C" => '&#37946;',
		"\xC5\x4D" => '&#37944;',
		"\xC5\x4E" => '&#37938;',
		"\xC5\x4F" => '&#37931;',
		"\xC5\x50" => '&#38370;',
		"\xC5\x51" => '&#38712;',
		"\xC5\x52" => '&#38713;',
		"\xC5\x53" => '&#38706;',
		"\xC5\x54" => '&#38911;',
		"\xC5\x55" => '&#39015;',
		"\xC5\x56" => '&#39013;',
		"\xC5\x57" => '&#39255;',
		"\xC5\x58" => '&#39493;',
		"\xC5\x59" => '&#39491;',
		"\xC5\x5A" => '&#39488;',
		"\xC5\x5B" => '&#39486;',
		"\xC5\x5C" => '&#39631;',
		"\xC5\x5D" => '&#39764;',
		"\xC5\x5E" => '&#39761;',
		"\xC5\x5F" => '&#39981;',
		"\xC5\x60" => '&#39973;',
		"\xC5\x61" => '&#40367;',
		"\xC5\x62" => '&#40372;',
		"\xC5\x63" => '&#40386;',
		"\xC5\x64" => '&#40376;',
		"\xC5\x65" => '&#40605;',
		"\xC5\x66" => '&#40687;',
		"\xC5\x67" => '&#40729;',
		"\xC5\x68" => '&#40796;',
		"\xC5\x69" => '&#40806;',
		"\xC5\x6A" => '&#40807;',
		"\xC5\x6B" => '&#20796;',
		"\xC5\x6C" => '&#20795;',
		"\xC5\x6D" => '&#22216;',
		"\xC5\x6E" => '&#22218;',
		"\xC5\x6F" => '&#22217;',
		"\xC5\x70" => '&#23423;',
		"\xC5\x71" => '&#24020;',
		"\xC5\x72" => '&#24018;',
		"\xC5\x73" => '&#24398;',
		"\xC5\x74" => '&#25087;',
		"\xC5\x75" => '&#25892;',
		"\xC5\x76" => '&#27402;',
		"\xC5\x77" => '&#27489;',
		"\xC5\x78" => '&#28753;',
		"\xC5\x79" => '&#28760;',
		"\xC5\x7A" => '&#29568;',
		"\xC5\x7B" => '&#29924;',
		"\xC5\x7C" => '&#30090;',
		"\xC5\x7D" => '&#30318;',
		"\xC5\x7E" => '&#30316;',
		"\xC5\xA1" => '&#31155;',
		"\xC5\xA2" => '&#31840;',
		"\xC5\xA3" => '&#31839;',
		"\xC5\xA4" => '&#32894;',
		"\xC5\xA5" => '&#32893;',
		"\xC5\xA6" => '&#33247;',
		"\xC5\xA7" => '&#35186;',
		"\xC5\xA8" => '&#35183;',
		"\xC5\xA9" => '&#35324;',
		"\xC5\xAA" => '&#35712;',
		"\xC5\xAB" => '&#36118;',
		"\xC5\xAC" => '&#36119;',
		"\xC5\xAD" => '&#36497;',
		"\xC5\xAE" => '&#36499;',
		"\xC5\xAF" => '&#36705;',
		"\xC5\xB0" => '&#37192;',
		"\xC5\xB1" => '&#37956;',
		"\xC5\xB2" => '&#37969;',
		"\xC5\xB3" => '&#37970;',
		"\xC5\xB4" => '&#38717;',
		"\xC5\xB5" => '&#38718;',
		"\xC5\xB6" => '&#38851;',
		"\xC5\xB7" => '&#38849;',
		"\xC5\xB8" => '&#39019;',
		"\xC5\xB9" => '&#39253;',
		"\xC5\xBA" => '&#39509;',
		"\xC5\xBB" => '&#39501;',
		"\xC5\xBC" => '&#39634;',
		"\xC5\xBD" => '&#39706;',
		"\xC5\xBE" => '&#40009;',
		"\xC5\xBF" => '&#39985;',
		"\xC5\xC0" => '&#39998;',
		"\xC5\xC1" => '&#39995;',
		"\xC5\xC2" => '&#40403;',
		"\xC5\xC3" => '&#40407;',
		"\xC5\xC4" => '&#40756;',
		"\xC5\xC5" => '&#40812;',
		"\xC5\xC6" => '&#40810;',
		"\xC5\xC7" => '&#40852;',
		"\xC5\xC8" => '&#22220;',
		"\xC5\xC9" => '&#24022;',
		"\xC5\xCA" => '&#25088;',
		"\xC5\xCB" => '&#25891;',
		"\xC5\xCC" => '&#25899;',
		"\xC5\xCD" => '&#25898;',
		"\xC5\xCE" => '&#26348;',
		"\xC5\xCF" => '&#27408;',
		"\xC5\xD0" => '&#29914;',
		"\xC5\xD1" => '&#31434;',
		"\xC5\xD2" => '&#31844;',
		"\xC5\xD3" => '&#31843;',
		"\xC5\xD4" => '&#31845;',
		"\xC5\xD5" => '&#32403;',
		"\xC5\xD6" => '&#32406;',
		"\xC5\xD7" => '&#32404;',
		"\xC5\xD8" => '&#33250;',
		"\xC5\xD9" => '&#34360;',
		"\xC5\xDA" => '&#34367;',
		"\xC5\xDB" => '&#34865;',
		"\xC5\xDC" => '&#35722;',
		"\xC5\xDD" => '&#37008;',
		"\xC5\xDE" => '&#37007;',
		"\xC5\xDF" => '&#37987;',
		"\xC5\xE0" => '&#37984;',
		"\xC5\xE1" => '&#37988;',
		"\xC5\xE2" => '&#38760;',
		"\xC5\xE3" => '&#39023;',
		"\xC5\xE4" => '&#39260;',
		"\xC5\xE5" => '&#39514;',
		"\xC5\xE6" => '&#39515;',
		"\xC5\xE7" => '&#39511;',
		"\xC5\xE8" => '&#39635;',
		"\xC5\xE9" => '&#39636;',
		"\xC5\xEA" => '&#39633;',
		"\xC5\xEB" => '&#40020;',
		"\xC5\xEC" => '&#40023;',
		"\xC5\xED" => '&#40022;',
		"\xC5\xEE" => '&#40421;',
		"\xC5\xEF" => '&#40607;',
		"\xC5\xF0" => '&#40692;',
		"\xC5\xF1" => '&#22225;',
		"\xC5\xF2" => '&#22761;',
		"\xC5\xF3" => '&#25900;',
		"\xC5\xF4" => '&#28766;',
		"\xC5\xF5" => '&#30321;',
		"\xC5\xF6" => '&#30322;',
		"\xC5\xF7" => '&#30679;',
		"\xC5\xF8" => '&#32592;',
		"\xC5\xF9" => '&#32648;',
		"\xC5\xFA" => '&#34870;',
		"\xC5\xFB" => '&#34873;',
		"\xC5\xFC" => '&#34914;',
		"\xC5\xFD" => '&#35731;',
		"\xC5\xFE" => '&#35730;',
		"\xC6\x40" => '&#35734;',
		"\xC6\x41" => '&#33399;',
		"\xC6\x42" => '&#36123;',
		"\xC6\x43" => '&#37312;',
		"\xC6\x44" => '&#37994;',
		"\xC6\x45" => '&#38722;',
		"\xC6\x46" => '&#38728;',
		"\xC6\x47" => '&#38724;',
		"\xC6\x48" => '&#38854;',
		"\xC6\x49" => '&#39024;',
		"\xC6\x4A" => '&#39519;',
		"\xC6\x4B" => '&#39714;',
		"\xC6\x4C" => '&#39768;',
		"\xC6\x4D" => '&#40031;',
		"\xC6\x4E" => '&#40441;',
		"\xC6\x4F" => '&#40442;',
		"\xC6\x50" => '&#40572;',
		"\xC6\x51" => '&#40573;',
		"\xC6\x52" => '&#40711;',
		"\xC6\x53" => '&#40823;',
		"\xC6\x54" => '&#40818;',
		"\xC6\x55" => '&#24307;',
		"\xC6\x56" => '&#27414;',
		"\xC6\x57" => '&#28771;',
		"\xC6\x58" => '&#31852;',
		"\xC6\x59" => '&#31854;',
		"\xC6\x5A" => '&#34875;',
		"\xC6\x5B" => '&#35264;',
		"\xC6\x5C" => '&#36513;',
		"\xC6\x5D" => '&#37313;',
		"\xC6\x5E" => '&#38002;',
		"\xC6\x5F" => '&#38000;',
		"\xC6\x60" => '&#39025;',
		"\xC6\x61" => '&#39262;',
		"\xC6\x62" => '&#39638;',
		"\xC6\x63" => '&#39715;',
		"\xC6\x64" => '&#40652;',
		"\xC6\x65" => '&#28772;',
		"\xC6\x66" => '&#30682;',
		"\xC6\x67" => '&#35738;',
		"\xC6\x68" => '&#38007;',
		"\xC6\x69" => '&#38857;',
		"\xC6\x6A" => '&#39522;',
		"\xC6\x6B" => '&#39525;',
		"\xC6\x6C" => '&#32412;',
		"\xC6\x6D" => '&#35740;',
		"\xC6\x6E" => '&#36522;',
		"\xC6\x6F" => '&#37317;',
		"\xC6\x70" => '&#38013;',
		"\xC6\x71" => '&#38014;',
		"\xC6\x72" => '&#38012;',
		"\xC6\x73" => '&#40055;',
		"\xC6\x74" => '&#40056;',
		"\xC6\x75" => '&#40695;',
		"\xC6\x76" => '&#35924;',
		"\xC6\x77" => '&#38015;',
		"\xC6\x78" => '&#40474;',
		"\xC6\x79" => '&#29224;',
		"\xC6\x7A" => '&#39530;',
		"\xC6\x7B" => '&#39729;',
		"\xC6\x7C" => '&#40475;',
		"\xC6\x7D" => '&#40478;',
		"\xC6\x7E" => '&#31858;',
		"\xC6\xA1" => '&#12542;',
		"\xC6\xA2" => '&#12445;',
		"\xC6\xA3" => '&#12446;',
		"\xC6\xA4" => '&#12293;',
		"\xC6\xA5" => '&#12353;',
		"\xC6\xA6" => '&#12354;',
		"\xC6\xA7" => '&#12355;',
		"\xC6\xA8" => '&#12356;',
		"\xC6\xA9" => '&#12357;',
		"\xC6\xAA" => '&#12358;',
		"\xC6\xAB" => '&#12359;',
		"\xC6\xAC" => '&#12360;',
		"\xC6\xAD" => '&#12361;',
		"\xC6\xAE" => '&#12362;',
		"\xC6\xAF" => '&#12363;',
		"\xC6\xB0" => '&#12364;',
		"\xC6\xB1" => '&#12365;',
		"\xC6\xB2" => '&#12366;',
		"\xC6\xB3" => '&#12367;',
		"\xC6\xB4" => '&#12368;',
		"\xC6\xB5" => '&#12369;',
		"\xC6\xB6" => '&#12370;',
		"\xC6\xB7" => '&#12371;',
		"\xC6\xB8" => '&#12372;',
		"\xC6\xB9" => '&#12373;',
		"\xC6\xBA" => '&#12374;',
		"\xC6\xBB" => '&#12375;',
		"\xC6\xBC" => '&#12376;',
		"\xC6\xBD" => '&#12377;',
		"\xC6\xBE" => '&#12378;',
		"\xC6\xBF" => '&#12379;',
		"\xC6\xC0" => '&#12380;',
		"\xC6\xC1" => '&#12381;',
		"\xC6\xC2" => '&#12382;',
		"\xC6\xC3" => '&#12383;',
		"\xC6\xC4" => '&#12384;',
		"\xC6\xC5" => '&#12385;',
		"\xC6\xC6" => '&#12386;',
		"\xC6\xC7" => '&#12387;',
		"\xC6\xC8" => '&#12388;',
		"\xC6\xC9" => '&#12389;',
		"\xC6\xCA" => '&#12390;',
		"\xC6\xCB" => '&#12391;',
		"\xC6\xCC" => '&#12392;',
		"\xC6\xCD" => '&#12393;',
		"\xC6\xCE" => '&#12394;',
		"\xC6\xCF" => '&#12395;',
		"\xC6\xD0" => '&#12396;',
		"\xC6\xD1" => '&#12397;',
		"\xC6\xD2" => '&#12398;',
		"\xC6\xD3" => '&#12399;',
		"\xC6\xD4" => '&#12400;',
		"\xC6\xD5" => '&#12401;',
		"\xC6\xD6" => '&#12402;',
		"\xC6\xD7" => '&#12403;',
		"\xC6\xD8" => '&#12404;',
		"\xC6\xD9" => '&#12405;',
		"\xC6\xDA" => '&#12406;',
		"\xC6\xDB" => '&#12407;',
		"\xC6\xDC" => '&#12408;',
		"\xC6\xDD" => '&#12409;',
		"\xC6\xDE" => '&#12410;',
		"\xC6\xDF" => '&#12411;',
		"\xC6\xE0" => '&#12412;',
		"\xC6\xE1" => '&#12413;',
		"\xC6\xE2" => '&#12414;',
		"\xC6\xE3" => '&#12415;',
		"\xC6\xE4" => '&#12416;',
		"\xC6\xE5" => '&#12417;',
		"\xC6\xE6" => '&#12418;',
		"\xC6\xE7" => '&#12419;',
		"\xC6\xE8" => '&#12420;',
		"\xC6\xE9" => '&#12421;',
		"\xC6\xEA" => '&#12422;',
		"\xC6\xEB" => '&#12423;',
		"\xC6\xEC" => '&#12424;',
		"\xC6\xED" => '&#12425;',
		"\xC6\xEE" => '&#12426;',
		"\xC6\xEF" => '&#12427;',
		"\xC6\xF0" => '&#12428;',
		"\xC6\xF1" => '&#12429;',
		"\xC6\xF2" => '&#12430;',
		"\xC6\xF3" => '&#12431;',
		"\xC6\xF4" => '&#12432;',
		"\xC6\xF5" => '&#12433;',
		"\xC6\xF6" => '&#12434;',
		"\xC6\xF7" => '&#12435;',
		"\xC6\xF8" => '&#12449;',
		"\xC6\xF9" => '&#12450;',
		"\xC6\xFA" => '&#12451;',
		"\xC6\xFB" => '&#12452;',
		"\xC6\xFC" => '&#12453;',
		"\xC6\xFD" => '&#12454;',
		"\xC6\xFE" => '&#12455;',
		"\xC7\x40" => '&#12456;',
		"\xC7\x41" => '&#12457;',
		"\xC7\x42" => '&#12458;',
		"\xC7\x43" => '&#12459;',
		"\xC7\x44" => '&#12460;',
		"\xC7\x45" => '&#12461;',
		"\xC7\x46" => '&#12462;',
		"\xC7\x47" => '&#12463;',
		"\xC7\x48" => '&#12464;',
		"\xC7\x49" => '&#12465;',
		"\xC7\x4A" => '&#12466;',
		"\xC7\x4B" => '&#12467;',
		"\xC7\x4C" => '&#12468;',
		"\xC7\x4D" => '&#12469;',
		"\xC7\x4E" => '&#12470;',
		"\xC7\x4F" => '&#12471;',
		"\xC7\x50" => '&#12472;',
		"\xC7\x51" => '&#12473;',
		"\xC7\x52" => '&#12474;',
		"\xC7\x53" => '&#12475;',
		"\xC7\x54" => '&#12476;',
		"\xC7\x55" => '&#12477;',
		"\xC7\x56" => '&#12478;',
		"\xC7\x57" => '&#12479;',
		"\xC7\x58" => '&#12480;',
		"\xC7\x59" => '&#12481;',
		"\xC7\x5A" => '&#12482;',
		"\xC7\x5B" => '&#12483;',
		"\xC7\x5C" => '&#12484;',
		"\xC7\x5D" => '&#12485;',
		"\xC7\x5E" => '&#12486;',
		"\xC7\x5F" => '&#12487;',
		"\xC7\x60" => '&#12488;',
		"\xC7\x61" => '&#12489;',
		"\xC7\x62" => '&#12490;',
		"\xC7\x63" => '&#12491;',
		"\xC7\x64" => '&#12492;',
		"\xC7\x65" => '&#12493;',
		"\xC7\x66" => '&#12494;',
		"\xC7\x67" => '&#12495;',
		"\xC7\x68" => '&#12496;',
		"\xC7\x69" => '&#12497;',
		"\xC7\x6A" => '&#12498;',
		"\xC7\x6B" => '&#12499;',
		"\xC7\x6C" => '&#12500;',
		"\xC7\x6D" => '&#12501;',
		"\xC7\x6E" => '&#12502;',
		"\xC7\x6F" => '&#12503;',
		"\xC7\x70" => '&#12504;',
		"\xC7\x71" => '&#12505;',
		"\xC7\x72" => '&#12506;',
		"\xC7\x73" => '&#12507;',
		"\xC7\x74" => '&#12508;',
		"\xC7\x75" => '&#12509;',
		"\xC7\x76" => '&#12510;',
		"\xC7\x77" => '&#12511;',
		"\xC7\x78" => '&#12512;',
		"\xC7\x79" => '&#12513;',
		"\xC7\x7A" => '&#12514;',
		"\xC7\x7B" => '&#12515;',
		"\xC7\x7C" => '&#12516;',
		"\xC7\x7D" => '&#12517;',
		"\xC7\x7E" => '&#12518;',
		"\xC7\xA1" => '&#12519;',
		"\xC7\xA2" => '&#12520;',
		"\xC7\xA3" => '&#12521;',
		"\xC7\xA4" => '&#12522;',
		"\xC7\xA5" => '&#12523;',
		"\xC7\xA6" => '&#12524;',
		"\xC7\xA7" => '&#12525;',
		"\xC7\xA8" => '&#12526;',
		"\xC7\xA9" => '&#12527;',
		"\xC7\xAA" => '&#12528;',
		"\xC7\xAB" => '&#12529;',
		"\xC7\xAC" => '&#12530;',
		"\xC7\xAD" => '&#12531;',
		"\xC7\xAE" => '&#12532;',
		"\xC7\xAF" => '&#12533;',
		"\xC7\xB0" => '&#12534;',
		"\xC7\xB1" => '&#1044;',
		"\xC7\xB2" => '&#1045;',
		"\xC7\xB3" => '&#1025;',
		"\xC7\xB4" => '&#1046;',
		"\xC7\xB5" => '&#1047;',
		"\xC7\xB6" => '&#1048;',
		"\xC7\xB7" => '&#1049;',
		"\xC7\xB8" => '&#1050;',
		"\xC7\xB9" => '&#1051;',
		"\xC7\xBA" => '&#1052;',
		"\xC7\xBB" => '&#1059;',
		"\xC7\xBC" => '&#1060;',
		"\xC7\xBD" => '&#1061;',
		"\xC7\xBE" => '&#1062;',
		"\xC7\xBF" => '&#1063;',
		"\xC7\xC0" => '&#1064;',
		"\xC7\xC1" => '&#1065;',
		"\xC7\xC2" => '&#1066;',
		"\xC7\xC3" => '&#1067;',
		"\xC7\xC4" => '&#1068;',
		"\xC7\xC5" => '&#1069;',
		"\xC7\xC6" => '&#1070;',
		"\xC7\xC7" => '&#1071;',
		"\xC7\xC8" => '&#1072;',
		"\xC7\xC9" => '&#1073;',
		"\xC7\xCA" => '&#1074;',
		"\xC7\xCB" => '&#1075;',
		"\xC7\xCC" => '&#1076;',
		"\xC7\xCD" => '&#1077;',
		"\xC7\xCE" => '&#1105;',
		"\xC7\xCF" => '&#1078;',
		"\xC7\xD0" => '&#1079;',
		"\xC7\xD1" => '&#1080;',
		"\xC7\xD2" => '&#1081;',
		"\xC7\xD3" => '&#1082;',
		"\xC7\xD4" => '&#1083;',
		"\xC7\xD5" => '&#1084;',
		"\xC7\xD6" => '&#1085;',
		"\xC7\xD7" => '&#1086;',
		"\xC7\xD8" => '&#1087;',
		"\xC7\xD9" => '&#1088;',
		"\xC7\xDA" => '&#1089;',
		"\xC7\xDB" => '&#1090;',
		"\xC7\xDC" => '&#1091;',
		"\xC7\xDD" => '&#1092;',
		"\xC7\xDE" => '&#1093;',
		"\xC7\xDF" => '&#1094;',
		"\xC7\xE0" => '&#1095;',
		"\xC7\xE1" => '&#1096;',
		"\xC7\xE2" => '&#1097;',
		"\xC7\xE3" => '&#1098;',
		"\xC7\xE4" => '&#1099;',
		"\xC7\xE5" => '&#1100;',
		"\xC7\xE6" => '&#1101;',
		"\xC7\xE7" => '&#1102;',
		"\xC7\xE8" => '&#1103;',
		"\xC7\xE9" => '&#9312;',
		"\xC7\xEA" => '&#9313;',
		"\xC7\xEB" => '&#9314;',
		"\xC7\xEC" => '&#9315;',
		"\xC7\xED" => '&#9316;',
		"\xC7\xEE" => '&#9317;',
		"\xC7\xEF" => '&#9318;',
		"\xC7\xF0" => '&#9319;',
		"\xC7\xF1" => '&#9320;',
		"\xC7\xF2" => '&#9321;',
		"\xC7\xF3" => '&#9332;',
		"\xC7\xF4" => '&#9333;',
		"\xC7\xF5" => '&#9334;',
		"\xC7\xF6" => '&#9335;',
		"\xC7\xF7" => '&#9336;',
		"\xC7\xF8" => '&#9337;',
		"\xC7\xF9" => '&#9338;',
		"\xC7\xFA" => '&#9339;',
		"\xC7\xFB" => '&#9340;',
		"\xC7\xFC" => '&#9341;',
		"\xC9\x40" => '&#20034;',
		"\xC9\x41" => '&#20060;',
		"\xC9\x42" => '&#20981;',
		"\xC9\x43" => '&#21274;',
		"\xC9\x44" => '&#21378;',
		"\xC9\x45" => '&#19975;',
		"\xC9\x46" => '&#19980;',
		"\xC9\x47" => '&#20039;',
		"\xC9\x48" => '&#20109;',
		"\xC9\x49" => '&#22231;',
		"\xC9\x4A" => '&#64012;',
		"\xC9\x4B" => '&#23662;',
		"\xC9\x4C" => '&#24435;',
		"\xC9\x4D" => '&#19983;',
		"\xC9\x4E" => '&#20871;',
		"\xC9\x4F" => '&#19982;',
		"\xC9\x50" => '&#20014;',
		"\xC9\x51" => '&#20115;',
		"\xC9\x52" => '&#20162;',
		"\xC9\x53" => '&#20169;',
		"\xC9\x54" => '&#20168;',
		"\xC9\x55" => '&#20888;',
		"\xC9\x56" => '&#21244;',
		"\xC9\x57" => '&#21356;',
		"\xC9\x58" => '&#21433;',
		"\xC9\x59" => '&#22304;',
		"\xC9\x5A" => '&#22787;',
		"\xC9\x5B" => '&#22828;',
		"\xC9\x5C" => '&#23568;',
		"\xC9\x5D" => '&#24063;',
		"\xC9\x5E" => '&#26081;',
		"\xC9\x5F" => '&#27571;',
		"\xC9\x60" => '&#27596;',
		"\xC9\x61" => '&#27668;',
		"\xC9\x62" => '&#29247;',
		"\xC9\x63" => '&#20017;',
		"\xC9\x64" => '&#20028;',
		"\xC9\x65" => '&#20200;',
		"\xC9\x66" => '&#20188;',
		"\xC9\x67" => '&#20201;',
		"\xC9\x68" => '&#20193;',
		"\xC9\x69" => '&#20189;',
		"\xC9\x6A" => '&#20186;',
		"\xC9\x6B" => '&#21004;',
		"\xC9\x6C" => '&#21276;',
		"\xC9\x6D" => '&#21324;',
		"\xC9\x6E" => '&#22306;',
		"\xC9\x6F" => '&#22307;',
		"\xC9\x70" => '&#22807;',
		"\xC9\x71" => '&#22831;',
		"\xC9\x72" => '&#23425;',
		"\xC9\x73" => '&#23428;',
		"\xC9\x74" => '&#23570;',
		"\xC9\x75" => '&#23611;',
		"\xC9\x76" => '&#23668;',
		"\xC9\x77" => '&#23667;',
		"\xC9\x78" => '&#24068;',
		"\xC9\x79" => '&#24192;',
		"\xC9\x7A" => '&#24194;',
		"\xC9\x7B" => '&#24521;',
		"\xC9\x7C" => '&#25097;',
		"\xC9\x7D" => '&#25168;',
		"\xC9\x7E" => '&#27669;',
		"\xC9\xA1" => '&#27702;',
		"\xC9\xA2" => '&#27715;',
		"\xC9\xA3" => '&#27711;',
		"\xC9\xA4" => '&#27707;',
		"\xC9\xA5" => '&#29358;',
		"\xC9\xA6" => '&#29360;',
		"\xC9\xA7" => '&#29578;',
		"\xC9\xA8" => '&#31160;',
		"\xC9\xA9" => '&#32906;',
		"\xC9\xAA" => '&#38430;',
		"\xC9\xAB" => '&#20238;',
		"\xC9\xAC" => '&#20248;',
		"\xC9\xAD" => '&#20268;',
		"\xC9\xAE" => '&#20213;',
		"\xC9\xAF" => '&#20244;',
		"\xC9\xB0" => '&#20209;',
		"\xC9\xB1" => '&#20224;',
		"\xC9\xB2" => '&#20215;',
		"\xC9\xB3" => '&#20232;',
		"\xC9\xB4" => '&#20253;',
		"\xC9\xB5" => '&#20226;',
		"\xC9\xB6" => '&#20229;',
		"\xC9\xB7" => '&#20258;',
		"\xC9\xB8" => '&#20243;',
		"\xC9\xB9" => '&#20228;',
		"\xC9\xBA" => '&#20212;',
		"\xC9\xBB" => '&#20242;',
		"\xC9\xBC" => '&#20913;',
		"\xC9\xBD" => '&#21011;',
		"\xC9\xBE" => '&#21001;',
		"\xC9\xBF" => '&#21008;',
		"\xC9\xC0" => '&#21158;',
		"\xC9\xC1" => '&#21282;',
		"\xC9\xC2" => '&#21279;',
		"\xC9\xC3" => '&#21325;',
		"\xC9\xC4" => '&#21386;',
		"\xC9\xC5" => '&#21511;',
		"\xC9\xC6" => '&#22241;',
		"\xC9\xC7" => '&#22239;',
		"\xC9\xC8" => '&#22318;',
		"\xC9\xC9" => '&#22314;',
		"\xC9\xCA" => '&#22324;',
		"\xC9\xCB" => '&#22844;',
		"\xC9\xCC" => '&#22912;',
		"\xC9\xCD" => '&#22908;',
		"\xC9\xCE" => '&#22917;',
		"\xC9\xCF" => '&#22907;',
		"\xC9\xD0" => '&#22910;',
		"\xC9\xD1" => '&#22903;',
		"\xC9\xD2" => '&#22911;',
		"\xC9\xD3" => '&#23382;',
		"\xC9\xD4" => '&#23573;',
		"\xC9\xD5" => '&#23589;',
		"\xC9\xD6" => '&#23676;',
		"\xC9\xD7" => '&#23674;',
		"\xC9\xD8" => '&#23675;',
		"\xC9\xD9" => '&#23678;',
		"\xC9\xDA" => '&#24031;',
		"\xC9\xDB" => '&#24181;',
		"\xC9\xDC" => '&#24196;',
		"\xC9\xDD" => '&#24322;',
		"\xC9\xDE" => '&#24346;',
		"\xC9\xDF" => '&#24436;',
		"\xC9\xE0" => '&#24533;',
		"\xC9\xE1" => '&#24532;',
		"\xC9\xE2" => '&#24527;',
		"\xC9\xE3" => '&#25180;',
		"\xC9\xE4" => '&#25182;',
		"\xC9\xE5" => '&#25188;',
		"\xC9\xE6" => '&#25185;',
		"\xC9\xE7" => '&#25190;',
		"\xC9\xE8" => '&#25186;',
		"\xC9\xE9" => '&#25177;',
		"\xC9\xEA" => '&#25184;',
		"\xC9\xEB" => '&#25178;',
		"\xC9\xEC" => '&#25189;',
		"\xC9\xED" => '&#26095;',
		"\xC9\xEE" => '&#26094;',
		"\xC9\xEF" => '&#26430;',
		"\xC9\xF0" => '&#26425;',
		"\xC9\xF1" => '&#26424;',
		"\xC9\xF2" => '&#26427;',
		"\xC9\xF3" => '&#26426;',
		"\xC9\xF4" => '&#26431;',
		"\xC9\xF5" => '&#26428;',
		"\xC9\xF6" => '&#26419;',
		"\xC9\xF7" => '&#27672;',
		"\xC9\xF8" => '&#27718;',
		"\xC9\xF9" => '&#27730;',
		"\xC9\xFA" => '&#27740;',
		"\xC9\xFB" => '&#27727;',
		"\xC9\xFC" => '&#27722;',
		"\xC9\xFD" => '&#27732;',
		"\xC9\xFE" => '&#27723;',
		"\xCA\x40" => '&#27724;',
		"\xCA\x41" => '&#28785;',
		"\xCA\x42" => '&#29278;',
		"\xCA\x43" => '&#29364;',
		"\xCA\x44" => '&#29365;',
		"\xCA\x45" => '&#29582;',
		"\xCA\x46" => '&#29994;',
		"\xCA\x47" => '&#30335;',
		"\xCA\x48" => '&#31349;',
		"\xCA\x49" => '&#32593;',
		"\xCA\x4A" => '&#33400;',
		"\xCA\x4B" => '&#33404;',
		"\xCA\x4C" => '&#33408;',
		"\xCA\x4D" => '&#33405;',
		"\xCA\x4E" => '&#33407;',
		"\xCA\x4F" => '&#34381;',
		"\xCA\x50" => '&#35198;',
		"\xCA\x51" => '&#37017;',
		"\xCA\x52" => '&#37015;',
		"\xCA\x53" => '&#37016;',
		"\xCA\x54" => '&#37019;',
		"\xCA\x55" => '&#37012;',
		"\xCA\x56" => '&#38434;',
		"\xCA\x57" => '&#38436;',
		"\xCA\x58" => '&#38432;',
		"\xCA\x59" => '&#38435;',
		"\xCA\x5A" => '&#20310;',
		"\xCA\x5B" => '&#20283;',
		"\xCA\x5C" => '&#20322;',
		"\xCA\x5D" => '&#20297;',
		"\xCA\x5E" => '&#20307;',
		"\xCA\x5F" => '&#20324;',
		"\xCA\x60" => '&#20286;',
		"\xCA\x61" => '&#20327;',
		"\xCA\x62" => '&#20306;',
		"\xCA\x63" => '&#20319;',
		"\xCA\x64" => '&#20289;',
		"\xCA\x65" => '&#20312;',
		"\xCA\x66" => '&#20269;',
		"\xCA\x67" => '&#20275;',
		"\xCA\x68" => '&#20287;',
		"\xCA\x69" => '&#20321;',
		"\xCA\x6A" => '&#20879;',
		"\xCA\x6B" => '&#20921;',
		"\xCA\x6C" => '&#21020;',
		"\xCA\x6D" => '&#21022;',
		"\xCA\x6E" => '&#21025;',
		"\xCA\x6F" => '&#21165;',
		"\xCA\x70" => '&#21166;',
		"\xCA\x71" => '&#21257;',
		"\xCA\x72" => '&#21347;',
		"\xCA\x73" => '&#21362;',
		"\xCA\x74" => '&#21390;',
		"\xCA\x75" => '&#21391;',
		"\xCA\x76" => '&#21552;',
		"\xCA\x77" => '&#21559;',
		"\xCA\x78" => '&#21546;',
		"\xCA\x79" => '&#21588;',
		"\xCA\x7A" => '&#21573;',
		"\xCA\x7B" => '&#21529;',
		"\xCA\x7C" => '&#21532;',
		"\xCA\x7D" => '&#21541;',
		"\xCA\x7E" => '&#21528;',
		"\xCA\xA1" => '&#21565;',
		"\xCA\xA2" => '&#21583;',
		"\xCA\xA3" => '&#21569;',
		"\xCA\xA4" => '&#21544;',
		"\xCA\xA5" => '&#21540;',
		"\xCA\xA6" => '&#21575;',
		"\xCA\xA7" => '&#22254;',
		"\xCA\xA8" => '&#22247;',
		"\xCA\xA9" => '&#22245;',
		"\xCA\xAA" => '&#22337;',
		"\xCA\xAB" => '&#22341;',
		"\xCA\xAC" => '&#22348;',
		"\xCA\xAD" => '&#22345;',
		"\xCA\xAE" => '&#22347;',
		"\xCA\xAF" => '&#22354;',
		"\xCA\xB0" => '&#22790;',
		"\xCA\xB1" => '&#22848;',
		"\xCA\xB2" => '&#22950;',
		"\xCA\xB3" => '&#22936;',
		"\xCA\xB4" => '&#22944;',
		"\xCA\xB5" => '&#22935;',
		"\xCA\xB6" => '&#22926;',
		"\xCA\xB7" => '&#22946;',
		"\xCA\xB8" => '&#22928;',
		"\xCA\xB9" => '&#22927;',
		"\xCA\xBA" => '&#22951;',
		"\xCA\xBB" => '&#22945;',
		"\xCA\xBC" => '&#23438;',
		"\xCA\xBD" => '&#23442;',
		"\xCA\xBE" => '&#23592;',
		"\xCA\xBF" => '&#23594;',
		"\xCA\xC0" => '&#23693;',
		"\xCA\xC1" => '&#23695;',
		"\xCA\xC2" => '&#23688;',
		"\xCA\xC3" => '&#23691;',
		"\xCA\xC4" => '&#23689;',
		"\xCA\xC5" => '&#23698;',
		"\xCA\xC6" => '&#23690;',
		"\xCA\xC7" => '&#23686;',
		"\xCA\xC8" => '&#23699;',
		"\xCA\xC9" => '&#23701;',
		"\xCA\xCA" => '&#24032;',
		"\xCA\xCB" => '&#24074;',
		"\xCA\xCC" => '&#24078;',
		"\xCA\xCD" => '&#24203;',
		"\xCA\xCE" => '&#24201;',
		"\xCA\xCF" => '&#24204;',
		"\xCA\xD0" => '&#24200;',
		"\xCA\xD1" => '&#24205;',
		"\xCA\xD2" => '&#24325;',
		"\xCA\xD3" => '&#24349;',
		"\xCA\xD4" => '&#24440;',
		"\xCA\xD5" => '&#24438;',
		"\xCA\xD6" => '&#24530;',
		"\xCA\xD7" => '&#24529;',
		"\xCA\xD8" => '&#24528;',
		"\xCA\xD9" => '&#24557;',
		"\xCA\xDA" => '&#24552;',
		"\xCA\xDB" => '&#24558;',
		"\xCA\xDC" => '&#24563;',
		"\xCA\xDD" => '&#24545;',
		"\xCA\xDE" => '&#24548;',
		"\xCA\xDF" => '&#24547;',
		"\xCA\xE0" => '&#24570;',
		"\xCA\xE1" => '&#24559;',
		"\xCA\xE2" => '&#24567;',
		"\xCA\xE3" => '&#24571;',
		"\xCA\xE4" => '&#24576;',
		"\xCA\xE5" => '&#24564;',
		"\xCA\xE6" => '&#25146;',
		"\xCA\xE7" => '&#25219;',
		"\xCA\xE8" => '&#25228;',
		"\xCA\xE9" => '&#25230;',
		"\xCA\xEA" => '&#25231;',
		"\xCA\xEB" => '&#25236;',
		"\xCA\xEC" => '&#25223;',
		"\xCA\xED" => '&#25201;',
		"\xCA\xEE" => '&#25211;',
		"\xCA\xEF" => '&#25210;',
		"\xCA\xF0" => '&#25200;',
		"\xCA\xF1" => '&#25217;',
		"\xCA\xF2" => '&#25224;',
		"\xCA\xF3" => '&#25207;',
		"\xCA\xF4" => '&#25213;',
		"\xCA\xF5" => '&#25202;',
		"\xCA\xF6" => '&#25204;',
		"\xCA\xF7" => '&#25911;',
		"\xCA\xF8" => '&#26096;',
		"\xCA\xF9" => '&#26100;',
		"\xCA\xFA" => '&#26099;',
		"\xCA\xFB" => '&#26098;',
		"\xCA\xFC" => '&#26101;',
		"\xCA\xFD" => '&#26437;',
		"\xCA\xFE" => '&#26439;',
		"\xCB\x40" => '&#26457;',
		"\xCB\x41" => '&#26453;',
		"\xCB\x42" => '&#26444;',
		"\xCB\x43" => '&#26440;',
		"\xCB\x44" => '&#26461;',
		"\xCB\x45" => '&#26445;',
		"\xCB\x46" => '&#26458;',
		"\xCB\x47" => '&#26443;',
		"\xCB\x48" => '&#27600;',
		"\xCB\x49" => '&#27673;',
		"\xCB\x4A" => '&#27674;',
		"\xCB\x4B" => '&#27768;',
		"\xCB\x4C" => '&#27751;',
		"\xCB\x4D" => '&#27755;',
		"\xCB\x4E" => '&#27780;',
		"\xCB\x4F" => '&#27787;',
		"\xCB\x50" => '&#27791;',
		"\xCB\x51" => '&#27761;',
		"\xCB\x52" => '&#27759;',
		"\xCB\x53" => '&#27753;',
		"\xCB\x54" => '&#27802;',
		"\xCB\x55" => '&#27757;',
		"\xCB\x56" => '&#27783;',
		"\xCB\x57" => '&#27797;',
		"\xCB\x58" => '&#27804;',
		"\xCB\x59" => '&#27750;',
		"\xCB\x5A" => '&#27763;',
		"\xCB\x5B" => '&#27749;',
		"\xCB\x5C" => '&#27771;',
		"\xCB\x5D" => '&#27790;',
		"\xCB\x5E" => '&#28788;',
		"\xCB\x5F" => '&#28794;',
		"\xCB\x60" => '&#29283;',
		"\xCB\x61" => '&#29375;',
		"\xCB\x62" => '&#29373;',
		"\xCB\x63" => '&#29379;',
		"\xCB\x64" => '&#29382;',
		"\xCB\x65" => '&#29377;',
		"\xCB\x66" => '&#29370;',
		"\xCB\x67" => '&#29381;',
		"\xCB\x68" => '&#29589;',
		"\xCB\x69" => '&#29591;',
		"\xCB\x6A" => '&#29587;',
		"\xCB\x6B" => '&#29588;',
		"\xCB\x6C" => '&#29586;',
		"\xCB\x6D" => '&#30010;',
		"\xCB\x6E" => '&#30009;',
		"\xCB\x6F" => '&#30100;',
		"\xCB\x70" => '&#30101;',
		"\xCB\x71" => '&#30337;',
		"\xCB\x72" => '&#31037;',
		"\xCB\x73" => '&#32820;',
		"\xCB\x74" => '&#32917;',
		"\xCB\x75" => '&#32921;',
		"\xCB\x76" => '&#32912;',
		"\xCB\x77" => '&#32914;',
		"\xCB\x78" => '&#32924;',
		"\xCB\x79" => '&#33424;',
		"\xCB\x7A" => '&#33423;',
		"\xCB\x7B" => '&#33413;',
		"\xCB\x7C" => '&#33422;',
		"\xCB\x7D" => '&#33425;',
		"\xCB\x7E" => '&#33427;',
		"\xCB\xA1" => '&#33418;',
		"\xCB\xA2" => '&#33411;',
		"\xCB\xA3" => '&#33412;',
		"\xCB\xA4" => '&#35960;',
		"\xCB\xA5" => '&#36809;',
		"\xCB\xA6" => '&#36799;',
		"\xCB\xA7" => '&#37023;',
		"\xCB\xA8" => '&#37025;',
		"\xCB\xA9" => '&#37029;',
		"\xCB\xAA" => '&#37022;',
		"\xCB\xAB" => '&#37031;',
		"\xCB\xAC" => '&#37024;',
		"\xCB\xAD" => '&#38448;',
		"\xCB\xAE" => '&#38440;',
		"\xCB\xAF" => '&#38447;',
		"\xCB\xB0" => '&#38445;',
		"\xCB\xB1" => '&#20019;',
		"\xCB\xB2" => '&#20376;',
		"\xCB\xB3" => '&#20348;',
		"\xCB\xB4" => '&#20357;',
		"\xCB\xB5" => '&#20349;',
		"\xCB\xB6" => '&#20352;',
		"\xCB\xB7" => '&#20359;',
		"\xCB\xB8" => '&#20342;',
		"\xCB\xB9" => '&#20340;',
		"\xCB\xBA" => '&#20361;',
		"\xCB\xBB" => '&#20356;',
		"\xCB\xBC" => '&#20343;',
		"\xCB\xBD" => '&#20300;',
		"\xCB\xBE" => '&#20375;',
		"\xCB\xBF" => '&#20330;',
		"\xCB\xC0" => '&#20378;',
		"\xCB\xC1" => '&#20345;',
		"\xCB\xC2" => '&#20353;',
		"\xCB\xC3" => '&#20344;',
		"\xCB\xC4" => '&#20368;',
		"\xCB\xC5" => '&#20380;',
		"\xCB\xC6" => '&#20372;',
		"\xCB\xC7" => '&#20382;',
		"\xCB\xC8" => '&#20370;',
		"\xCB\xC9" => '&#20354;',
		"\xCB\xCA" => '&#20373;',
		"\xCB\xCB" => '&#20331;',
		"\xCB\xCC" => '&#20334;',
		"\xCB\xCD" => '&#20894;',
		"\xCB\xCE" => '&#20924;',
		"\xCB\xCF" => '&#20926;',
		"\xCB\xD0" => '&#21045;',
		"\xCB\xD1" => '&#21042;',
		"\xCB\xD2" => '&#21043;',
		"\xCB\xD3" => '&#21062;',
		"\xCB\xD4" => '&#21041;',
		"\xCB\xD5" => '&#21180;',
		"\xCB\xD6" => '&#21258;',
		"\xCB\xD7" => '&#21259;',
		"\xCB\xD8" => '&#21308;',
		"\xCB\xD9" => '&#21394;',
		"\xCB\xDA" => '&#21396;',
		"\xCB\xDB" => '&#21639;',
		"\xCB\xDC" => '&#21631;',
		"\xCB\xDD" => '&#21633;',
		"\xCB\xDE" => '&#21649;',
		"\xCB\xDF" => '&#21634;',
		"\xCB\xE0" => '&#21640;',
		"\xCB\xE1" => '&#21611;',
		"\xCB\xE2" => '&#21626;',
		"\xCB\xE3" => '&#21630;',
		"\xCB\xE4" => '&#21605;',
		"\xCB\xE5" => '&#21612;',
		"\xCB\xE6" => '&#21620;',
		"\xCB\xE7" => '&#21606;',
		"\xCB\xE8" => '&#21645;',
		"\xCB\xE9" => '&#21615;',
		"\xCB\xEA" => '&#21601;',
		"\xCB\xEB" => '&#21600;',
		"\xCB\xEC" => '&#21656;',
		"\xCB\xED" => '&#21603;',
		"\xCB\xEE" => '&#21607;',
		"\xCB\xEF" => '&#21604;',
		"\xCB\xF0" => '&#22263;',
		"\xCB\xF1" => '&#22265;',
		"\xCB\xF2" => '&#22383;',
		"\xCB\xF3" => '&#22386;',
		"\xCB\xF4" => '&#22381;',
		"\xCB\xF5" => '&#22379;',
		"\xCB\xF6" => '&#22385;',
		"\xCB\xF7" => '&#22384;',
		"\xCB\xF8" => '&#22390;',
		"\xCB\xF9" => '&#22400;',
		"\xCB\xFA" => '&#22389;',
		"\xCB\xFB" => '&#22395;',
		"\xCB\xFC" => '&#22387;',
		"\xCB\xFD" => '&#22388;',
		"\xCB\xFE" => '&#22370;',
		"\xCC\x40" => '&#22376;',
		"\xCC\x41" => '&#22397;',
		"\xCC\x42" => '&#22796;',
		"\xCC\x43" => '&#22853;',
		"\xCC\x44" => '&#22965;',
		"\xCC\x45" => '&#22970;',
		"\xCC\x46" => '&#22991;',
		"\xCC\x47" => '&#22990;',
		"\xCC\x48" => '&#22962;',
		"\xCC\x49" => '&#22988;',
		"\xCC\x4A" => '&#22977;',
		"\xCC\x4B" => '&#22966;',
		"\xCC\x4C" => '&#22972;',
		"\xCC\x4D" => '&#22979;',
		"\xCC\x4E" => '&#22998;',
		"\xCC\x4F" => '&#22961;',
		"\xCC\x50" => '&#22973;',
		"\xCC\x51" => '&#22976;',
		"\xCC\x52" => '&#22984;',
		"\xCC\x53" => '&#22964;',
		"\xCC\x54" => '&#22983;',
		"\xCC\x55" => '&#23394;',
		"\xCC\x56" => '&#23397;',
		"\xCC\x57" => '&#23443;',
		"\xCC\x58" => '&#23445;',
		"\xCC\x59" => '&#23620;',
		"\xCC\x5A" => '&#23623;',
		"\xCC\x5B" => '&#23726;',
		"\xCC\x5C" => '&#23716;',
		"\xCC\x5D" => '&#23712;',
		"\xCC\x5E" => '&#23733;',
		"\xCC\x5F" => '&#23727;',
		"\xCC\x60" => '&#23720;',
		"\xCC\x61" => '&#23724;',
		"\xCC\x62" => '&#23711;',
		"\xCC\x63" => '&#23715;',
		"\xCC\x64" => '&#23725;',
		"\xCC\x65" => '&#23714;',
		"\xCC\x66" => '&#23722;',
		"\xCC\x67" => '&#23719;',
		"\xCC\x68" => '&#23709;',
		"\xCC\x69" => '&#23717;',
		"\xCC\x6A" => '&#23734;',
		"\xCC\x6B" => '&#23728;',
		"\xCC\x6C" => '&#23718;',
		"\xCC\x6D" => '&#24087;',
		"\xCC\x6E" => '&#24084;',
		"\xCC\x6F" => '&#24089;',
		"\xCC\x70" => '&#24360;',
		"\xCC\x71" => '&#24354;',
		"\xCC\x72" => '&#24355;',
		"\xCC\x73" => '&#24356;',
		"\xCC\x74" => '&#24404;',
		"\xCC\x75" => '&#24450;',
		"\xCC\x76" => '&#24446;',
		"\xCC\x77" => '&#24445;',
		"\xCC\x78" => '&#24542;',
		"\xCC\x79" => '&#24549;',
		"\xCC\x7A" => '&#24621;',
		"\xCC\x7B" => '&#24614;',
		"\xCC\x7C" => '&#24601;',
		"\xCC\x7D" => '&#24626;',
		"\xCC\x7E" => '&#24587;',
		"\xCC\xA1" => '&#24628;',
		"\xCC\xA2" => '&#24586;',
		"\xCC\xA3" => '&#24599;',
		"\xCC\xA4" => '&#24627;',
		"\xCC\xA5" => '&#24602;',
		"\xCC\xA6" => '&#24606;',
		"\xCC\xA7" => '&#24620;',
		"\xCC\xA8" => '&#24610;',
		"\xCC\xA9" => '&#24589;',
		"\xCC\xAA" => '&#24592;',
		"\xCC\xAB" => '&#24622;',
		"\xCC\xAC" => '&#24595;',
		"\xCC\xAD" => '&#24593;',
		"\xCC\xAE" => '&#24588;',
		"\xCC\xAF" => '&#24585;',
		"\xCC\xB0" => '&#24604;',
		"\xCC\xB1" => '&#25108;',
		"\xCC\xB2" => '&#25149;',
		"\xCC\xB3" => '&#25261;',
		"\xCC\xB4" => '&#25268;',
		"\xCC\xB5" => '&#25297;',
		"\xCC\xB6" => '&#25278;',
		"\xCC\xB7" => '&#25258;',
		"\xCC\xB8" => '&#25270;',
		"\xCC\xB9" => '&#25290;',
		"\xCC\xBA" => '&#25262;',
		"\xCC\xBB" => '&#25267;',
		"\xCC\xBC" => '&#25263;',
		"\xCC\xBD" => '&#25275;',
		"\xCC\xBE" => '&#25257;',
		"\xCC\xBF" => '&#25264;',
		"\xCC\xC0" => '&#25272;',
		"\xCC\xC1" => '&#25917;',
		"\xCC\xC2" => '&#26024;',
		"\xCC\xC3" => '&#26043;',
		"\xCC\xC4" => '&#26121;',
		"\xCC\xC5" => '&#26108;',
		"\xCC\xC6" => '&#26116;',
		"\xCC\xC7" => '&#26130;',
		"\xCC\xC8" => '&#26120;',
		"\xCC\xC9" => '&#26107;',
		"\xCC\xCA" => '&#26115;',
		"\xCC\xCB" => '&#26123;',
		"\xCC\xCC" => '&#26125;',
		"\xCC\xCD" => '&#26117;',
		"\xCC\xCE" => '&#26109;',
		"\xCC\xCF" => '&#26129;',
		"\xCC\xD0" => '&#26128;',
		"\xCC\xD1" => '&#26358;',
		"\xCC\xD2" => '&#26378;',
		"\xCC\xD3" => '&#26501;',
		"\xCC\xD4" => '&#26476;',
		"\xCC\xD5" => '&#26510;',
		"\xCC\xD6" => '&#26514;',
		"\xCC\xD7" => '&#26486;',
		"\xCC\xD8" => '&#26491;',
		"\xCC\xD9" => '&#26520;',
		"\xCC\xDA" => '&#26502;',
		"\xCC\xDB" => '&#26500;',
		"\xCC\xDC" => '&#26484;',
		"\xCC\xDD" => '&#26509;',
		"\xCC\xDE" => '&#26508;',
		"\xCC\xDF" => '&#26490;',
		"\xCC\xE0" => '&#26527;',
		"\xCC\xE1" => '&#26513;',
		"\xCC\xE2" => '&#26521;',
		"\xCC\xE3" => '&#26499;',
		"\xCC\xE4" => '&#26493;',
		"\xCC\xE5" => '&#26497;',
		"\xCC\xE6" => '&#26488;',
		"\xCC\xE7" => '&#26489;',
		"\xCC\xE8" => '&#26516;',
		"\xCC\xE9" => '&#27429;',
		"\xCC\xEA" => '&#27520;',
		"\xCC\xEB" => '&#27518;',
		"\xCC\xEC" => '&#27614;',
		"\xCC\xED" => '&#27677;',
		"\xCC\xEE" => '&#27795;',
		"\xCC\xEF" => '&#27884;',
		"\xCC\xF0" => '&#27883;',
		"\xCC\xF1" => '&#27886;',
		"\xCC\xF2" => '&#27865;',
		"\xCC\xF3" => '&#27830;',
		"\xCC\xF4" => '&#27860;',
		"\xCC\xF5" => '&#27821;',
		"\xCC\xF6" => '&#27879;',
		"\xCC\xF7" => '&#27831;',
		"\xCC\xF8" => '&#27856;',
		"\xCC\xF9" => '&#27842;',
		"\xCC\xFA" => '&#27834;',
		"\xCC\xFB" => '&#27843;',
		"\xCC\xFC" => '&#27846;',
		"\xCC\xFD" => '&#27885;',
		"\xCC\xFE" => '&#27890;',
		"\xCD\x40" => '&#27858;',
		"\xCD\x41" => '&#27869;',
		"\xCD\x42" => '&#27828;',
		"\xCD\x43" => '&#27786;',
		"\xCD\x44" => '&#27805;',
		"\xCD\x45" => '&#27776;',
		"\xCD\x46" => '&#27870;',
		"\xCD\x47" => '&#27840;',
		"\xCD\x48" => '&#27952;',
		"\xCD\x49" => '&#27853;',
		"\xCD\x4A" => '&#27847;',
		"\xCD\x4B" => '&#27824;',
		"\xCD\x4C" => '&#27897;',
		"\xCD\x4D" => '&#27855;',
		"\xCD\x4E" => '&#27881;',
		"\xCD\x4F" => '&#27857;',
		"\xCD\x50" => '&#28820;',
		"\xCD\x51" => '&#28824;',
		"\xCD\x52" => '&#28805;',
		"\xCD\x53" => '&#28819;',
		"\xCD\x54" => '&#28806;',
		"\xCD\x55" => '&#28804;',
		"\xCD\x56" => '&#28817;',
		"\xCD\x57" => '&#28822;',
		"\xCD\x58" => '&#28802;',
		"\xCD\x59" => '&#28826;',
		"\xCD\x5A" => '&#28803;',
		"\xCD\x5B" => '&#29290;',
		"\xCD\x5C" => '&#29398;',
		"\xCD\x5D" => '&#29387;',
		"\xCD\x5E" => '&#29400;',
		"\xCD\x5F" => '&#29385;',
		"\xCD\x60" => '&#29404;',
		"\xCD\x61" => '&#29394;',
		"\xCD\x62" => '&#29396;',
		"\xCD\x63" => '&#29402;',
		"\xCD\x64" => '&#29388;',
		"\xCD\x65" => '&#29393;',
		"\xCD\x66" => '&#29604;',
		"\xCD\x67" => '&#29601;',
		"\xCD\x68" => '&#29613;',
		"\xCD\x69" => '&#29606;',
		"\xCD\x6A" => '&#29602;',
		"\xCD\x6B" => '&#29600;',
		"\xCD\x6C" => '&#29612;',
		"\xCD\x6D" => '&#29597;',
		"\xCD\x6E" => '&#29917;',
		"\xCD\x6F" => '&#29928;',
		"\xCD\x70" => '&#30015;',
		"\xCD\x71" => '&#30016;',
		"\xCD\x72" => '&#30014;',
		"\xCD\x73" => '&#30092;',
		"\xCD\x74" => '&#30104;',
		"\xCD\x75" => '&#30383;',
		"\xCD\x76" => '&#30451;',
		"\xCD\x77" => '&#30449;',
		"\xCD\x78" => '&#30448;',
		"\xCD\x79" => '&#30453;',
		"\xCD\x7A" => '&#30712;',
		"\xCD\x7B" => '&#30716;',
		"\xCD\x7C" => '&#30713;',
		"\xCD\x7D" => '&#30715;',
		"\xCD\x7E" => '&#30714;',
		"\xCD\xA1" => '&#30711;',
		"\xCD\xA2" => '&#31042;',
		"\xCD\xA3" => '&#31039;',
		"\xCD\xA4" => '&#31173;',
		"\xCD\xA5" => '&#31352;',
		"\xCD\xA6" => '&#31355;',
		"\xCD\xA7" => '&#31483;',
		"\xCD\xA8" => '&#31861;',
		"\xCD\xA9" => '&#31997;',
		"\xCD\xAA" => '&#32821;',
		"\xCD\xAB" => '&#32911;',
		"\xCD\xAC" => '&#32942;',
		"\xCD\xAD" => '&#32931;',
		"\xCD\xAE" => '&#32952;',
		"\xCD\xAF" => '&#32949;',
		"\xCD\xB0" => '&#32941;',
		"\xCD\xB1" => '&#33312;',
		"\xCD\xB2" => '&#33440;',
		"\xCD\xB3" => '&#33472;',
		"\xCD\xB4" => '&#33451;',
		"\xCD\xB5" => '&#33434;',
		"\xCD\xB6" => '&#33432;',
		"\xCD\xB7" => '&#33435;',
		"\xCD\xB8" => '&#33461;',
		"\xCD\xB9" => '&#33447;',
		"\xCD\xBA" => '&#33454;',
		"\xCD\xBB" => '&#33468;',
		"\xCD\xBC" => '&#33438;',
		"\xCD\xBD" => '&#33466;',
		"\xCD\xBE" => '&#33460;',
		"\xCD\xBF" => '&#33448;',
		"\xCD\xC0" => '&#33441;',
		"\xCD\xC1" => '&#33449;',
		"\xCD\xC2" => '&#33474;',
		"\xCD\xC3" => '&#33444;',
		"\xCD\xC4" => '&#33475;',
		"\xCD\xC5" => '&#33462;',
		"\xCD\xC6" => '&#33442;',
		"\xCD\xC7" => '&#34416;',
		"\xCD\xC8" => '&#34415;',
		"\xCD\xC9" => '&#34413;',
		"\xCD\xCA" => '&#34414;',
		"\xCD\xCB" => '&#35926;',
		"\xCD\xCC" => '&#36818;',
		"\xCD\xCD" => '&#36811;',
		"\xCD\xCE" => '&#36819;',
		"\xCD\xCF" => '&#36813;',
		"\xCD\xD0" => '&#36822;',
		"\xCD\xD1" => '&#36821;',
		"\xCD\xD2" => '&#36823;',
		"\xCD\xD3" => '&#37042;',
		"\xCD\xD4" => '&#37044;',
		"\xCD\xD5" => '&#37039;',
		"\xCD\xD6" => '&#37043;',
		"\xCD\xD7" => '&#37040;',
		"\xCD\xD8" => '&#38457;',
		"\xCD\xD9" => '&#38461;',
		"\xCD\xDA" => '&#38460;',
		"\xCD\xDB" => '&#38458;',
		"\xCD\xDC" => '&#38467;',
		"\xCD\xDD" => '&#20429;',
		"\xCD\xDE" => '&#20421;',
		"\xCD\xDF" => '&#20435;',
		"\xCD\xE0" => '&#20402;',
		"\xCD\xE1" => '&#20425;',
		"\xCD\xE2" => '&#20427;',
		"\xCD\xE3" => '&#20417;',
		"\xCD\xE4" => '&#20436;',
		"\xCD\xE5" => '&#20444;',
		"\xCD\xE6" => '&#20441;',
		"\xCD\xE7" => '&#20411;',
		"\xCD\xE8" => '&#20403;',
		"\xCD\xE9" => '&#20443;',
		"\xCD\xEA" => '&#20423;',
		"\xCD\xEB" => '&#20438;',
		"\xCD\xEC" => '&#20410;',
		"\xCD\xED" => '&#20416;',
		"\xCD\xEE" => '&#20409;',
		"\xCD\xEF" => '&#20460;',
		"\xCD\xF0" => '&#21060;',
		"\xCD\xF1" => '&#21065;',
		"\xCD\xF2" => '&#21184;',
		"\xCD\xF3" => '&#21186;',
		"\xCD\xF4" => '&#21309;',
		"\xCD\xF5" => '&#21372;',
		"\xCD\xF6" => '&#21399;',
		"\xCD\xF7" => '&#21398;',
		"\xCD\xF8" => '&#21401;',
		"\xCD\xF9" => '&#21400;',
		"\xCD\xFA" => '&#21690;',
		"\xCD\xFB" => '&#21665;',
		"\xCD\xFC" => '&#21677;',
		"\xCD\xFD" => '&#21669;',
		"\xCD\xFE" => '&#21711;',
		"\xCE\x40" => '&#21699;',
		"\xCE\x41" => '&#33549;',
		"\xCE\x42" => '&#21687;',
		"\xCE\x43" => '&#21678;',
		"\xCE\x44" => '&#21718;',
		"\xCE\x45" => '&#21686;',
		"\xCE\x46" => '&#21701;',
		"\xCE\x47" => '&#21702;',
		"\xCE\x48" => '&#21664;',
		"\xCE\x49" => '&#21616;',
		"\xCE\x4A" => '&#21692;',
		"\xCE\x4B" => '&#21666;',
		"\xCE\x4C" => '&#21694;',
		"\xCE\x4D" => '&#21618;',
		"\xCE\x4E" => '&#21726;',
		"\xCE\x4F" => '&#21680;',
		"\xCE\x50" => '&#22453;',
		"\xCE\x51" => '&#22430;',
		"\xCE\x52" => '&#22431;',
		"\xCE\x53" => '&#22436;',
		"\xCE\x54" => '&#22412;',
		"\xCE\x55" => '&#22423;',
		"\xCE\x56" => '&#22429;',
		"\xCE\x57" => '&#22427;',
		"\xCE\x58" => '&#22420;',
		"\xCE\x59" => '&#22424;',
		"\xCE\x5A" => '&#22415;',
		"\xCE\x5B" => '&#22425;',
		"\xCE\x5C" => '&#22437;',
		"\xCE\x5D" => '&#22426;',
		"\xCE\x5E" => '&#22421;',
		"\xCE\x5F" => '&#22772;',
		"\xCE\x60" => '&#22797;',
		"\xCE\x61" => '&#22867;',
		"\xCE\x62" => '&#23009;',
		"\xCE\x63" => '&#23006;',
		"\xCE\x64" => '&#23022;',
		"\xCE\x65" => '&#23040;',
		"\xCE\x66" => '&#23025;',
		"\xCE\x67" => '&#23005;',
		"\xCE\x68" => '&#23034;',
		"\xCE\x69" => '&#23037;',
		"\xCE\x6A" => '&#23036;',
		"\xCE\x6B" => '&#23030;',
		"\xCE\x6C" => '&#23012;',
		"\xCE\x6D" => '&#23026;',
		"\xCE\x6E" => '&#23031;',
		"\xCE\x6F" => '&#23003;',
		"\xCE\x70" => '&#23017;',
		"\xCE\x71" => '&#23027;',
		"\xCE\x72" => '&#23029;',
		"\xCE\x73" => '&#23008;',
		"\xCE\x74" => '&#23038;',
		"\xCE\x75" => '&#23028;',
		"\xCE\x76" => '&#23021;',
		"\xCE\x77" => '&#23464;',
		"\xCE\x78" => '&#23628;',
		"\xCE\x79" => '&#23760;',
		"\xCE\x7A" => '&#23768;',
		"\xCE\x7B" => '&#23756;',
		"\xCE\x7C" => '&#23767;',
		"\xCE\x7D" => '&#23755;',
		"\xCE\x7E" => '&#23771;',
		"\xCE\xA1" => '&#23774;',
		"\xCE\xA2" => '&#23770;',
		"\xCE\xA3" => '&#23753;',
		"\xCE\xA4" => '&#23751;',
		"\xCE\xA5" => '&#23754;',
		"\xCE\xA6" => '&#23766;',
		"\xCE\xA7" => '&#23763;',
		"\xCE\xA8" => '&#23764;',
		"\xCE\xA9" => '&#23759;',
		"\xCE\xAA" => '&#23752;',
		"\xCE\xAB" => '&#23750;',
		"\xCE\xAC" => '&#23758;',
		"\xCE\xAD" => '&#23775;',
		"\xCE\xAE" => '&#23800;',
		"\xCE\xAF" => '&#24057;',
		"\xCE\xB0" => '&#24097;',
		"\xCE\xB1" => '&#24098;',
		"\xCE\xB2" => '&#24099;',
		"\xCE\xB3" => '&#24096;',
		"\xCE\xB4" => '&#24100;',
		"\xCE\xB5" => '&#24240;',
		"\xCE\xB6" => '&#24228;',
		"\xCE\xB7" => '&#24226;',
		"\xCE\xB8" => '&#24219;',
		"\xCE\xB9" => '&#24227;',
		"\xCE\xBA" => '&#24229;',
		"\xCE\xBB" => '&#24327;',
		"\xCE\xBC" => '&#24366;',
		"\xCE\xBD" => '&#24406;',
		"\xCE\xBE" => '&#24454;',
		"\xCE\xBF" => '&#24631;',
		"\xCE\xC0" => '&#24633;',
		"\xCE\xC1" => '&#24660;',
		"\xCE\xC2" => '&#24690;',
		"\xCE\xC3" => '&#24670;',
		"\xCE\xC4" => '&#24645;',
		"\xCE\xC5" => '&#24659;',
		"\xCE\xC6" => '&#24647;',
		"\xCE\xC7" => '&#24649;',
		"\xCE\xC8" => '&#24667;',
		"\xCE\xC9" => '&#24652;',
		"\xCE\xCA" => '&#24640;',
		"\xCE\xCB" => '&#24642;',
		"\xCE\xCC" => '&#24671;',
		"\xCE\xCD" => '&#24612;',
		"\xCE\xCE" => '&#24644;',
		"\xCE\xCF" => '&#24664;',
		"\xCE\xD0" => '&#24678;',
		"\xCE\xD1" => '&#24686;',
		"\xCE\xD2" => '&#25154;',
		"\xCE\xD3" => '&#25155;',
		"\xCE\xD4" => '&#25295;',
		"\xCE\xD5" => '&#25357;',
		"\xCE\xD6" => '&#25355;',
		"\xCE\xD7" => '&#25333;',
		"\xCE\xD8" => '&#25358;',
		"\xCE\xD9" => '&#25347;',
		"\xCE\xDA" => '&#25323;',
		"\xCE\xDB" => '&#25337;',
		"\xCE\xDC" => '&#25359;',
		"\xCE\xDD" => '&#25356;',
		"\xCE\xDE" => '&#25336;',
		"\xCE\xDF" => '&#25334;',
		"\xCE\xE0" => '&#25344;',
		"\xCE\xE1" => '&#25363;',
		"\xCE\xE2" => '&#25364;',
		"\xCE\xE3" => '&#25338;',
		"\xCE\xE4" => '&#25365;',
		"\xCE\xE5" => '&#25339;',
		"\xCE\xE6" => '&#25328;',
		"\xCE\xE7" => '&#25921;',
		"\xCE\xE8" => '&#25923;',
		"\xCE\xE9" => '&#26026;',
		"\xCE\xEA" => '&#26047;',
		"\xCE\xEB" => '&#26166;',
		"\xCE\xEC" => '&#26145;',
		"\xCE\xED" => '&#26162;',
		"\xCE\xEE" => '&#26165;',
		"\xCE\xEF" => '&#26140;',
		"\xCE\xF0" => '&#26150;',
		"\xCE\xF1" => '&#26146;',
		"\xCE\xF2" => '&#26163;',
		"\xCE\xF3" => '&#26155;',
		"\xCE\xF4" => '&#26170;',
		"\xCE\xF5" => '&#26141;',
		"\xCE\xF6" => '&#26164;',
		"\xCE\xF7" => '&#26169;',
		"\xCE\xF8" => '&#26158;',
		"\xCE\xF9" => '&#26383;',
		"\xCE\xFA" => '&#26384;',
		"\xCE\xFB" => '&#26561;',
		"\xCE\xFC" => '&#26610;',
		"\xCE\xFD" => '&#26568;',
		"\xCE\xFE" => '&#26554;',
		"\xCF\x40" => '&#26588;',
		"\xCF\x41" => '&#26555;',
		"\xCF\x42" => '&#26616;',
		"\xCF\x43" => '&#26584;',
		"\xCF\x44" => '&#26560;',
		"\xCF\x45" => '&#26551;',
		"\xCF\x46" => '&#26565;',
		"\xCF\x47" => '&#26603;',
		"\xCF\x48" => '&#26596;',
		"\xCF\x49" => '&#26591;',
		"\xCF\x4A" => '&#26549;',
		"\xCF\x4B" => '&#26573;',
		"\xCF\x4C" => '&#26547;',
		"\xCF\x4D" => '&#26615;',
		"\xCF\x4E" => '&#26614;',
		"\xCF\x4F" => '&#26606;',
		"\xCF\x50" => '&#26595;',
		"\xCF\x51" => '&#26562;',
		"\xCF\x52" => '&#26553;',
		"\xCF\x53" => '&#26574;',
		"\xCF\x54" => '&#26599;',
		"\xCF\x55" => '&#26608;',
		"\xCF\x56" => '&#26546;',
		"\xCF\x57" => '&#26620;',
		"\xCF\x58" => '&#26566;',
		"\xCF\x59" => '&#26605;',
		"\xCF\x5A" => '&#26572;',
		"\xCF\x5B" => '&#26542;',
		"\xCF\x5C" => '&#26598;',
		"\xCF\x5D" => '&#26587;',
		"\xCF\x5E" => '&#26618;',
		"\xCF\x5F" => '&#26569;',
		"\xCF\x60" => '&#26570;',
		"\xCF\x61" => '&#26563;',
		"\xCF\x62" => '&#26602;',
		"\xCF\x63" => '&#26571;',
		"\xCF\x64" => '&#27432;',
		"\xCF\x65" => '&#27522;',
		"\xCF\x66" => '&#27524;',
		"\xCF\x67" => '&#27574;',
		"\xCF\x68" => '&#27606;',
		"\xCF\x69" => '&#27608;',
		"\xCF\x6A" => '&#27616;',
		"\xCF\x6B" => '&#27680;',
		"\xCF\x6C" => '&#27681;',
		"\xCF\x6D" => '&#27944;',
		"\xCF\x6E" => '&#27956;',
		"\xCF\x6F" => '&#27949;',
		"\xCF\x70" => '&#27935;',
		"\xCF\x71" => '&#27964;',
		"\xCF\x72" => '&#27967;',
		"\xCF\x73" => '&#27922;',
		"\xCF\x74" => '&#27914;',
		"\xCF\x75" => '&#27866;',
		"\xCF\x76" => '&#27955;',
		"\xCF\x77" => '&#27908;',
		"\xCF\x78" => '&#27929;',
		"\xCF\x79" => '&#27962;',
		"\xCF\x7A" => '&#27930;',
		"\xCF\x7B" => '&#27921;',
		"\xCF\x7C" => '&#27904;',
		"\xCF\x7D" => '&#27933;',
		"\xCF\x7E" => '&#27970;',
		"\xCF\xA1" => '&#27905;',
		"\xCF\xA2" => '&#27928;',
		"\xCF\xA3" => '&#27959;',
		"\xCF\xA4" => '&#27907;',
		"\xCF\xA5" => '&#27919;',
		"\xCF\xA6" => '&#27968;',
		"\xCF\xA7" => '&#27911;',
		"\xCF\xA8" => '&#27936;',
		"\xCF\xA9" => '&#27948;',
		"\xCF\xAA" => '&#27912;',
		"\xCF\xAB" => '&#27938;',
		"\xCF\xAC" => '&#27913;',
		"\xCF\xAD" => '&#27920;',
		"\xCF\xAE" => '&#28855;',
		"\xCF\xAF" => '&#28831;',
		"\xCF\xB0" => '&#28862;',
		"\xCF\xB1" => '&#28849;',
		"\xCF\xB2" => '&#28848;',
		"\xCF\xB3" => '&#28833;',
		"\xCF\xB4" => '&#28852;',
		"\xCF\xB5" => '&#28853;',
		"\xCF\xB6" => '&#28841;',
		"\xCF\xB7" => '&#29249;',
		"\xCF\xB8" => '&#29257;',
		"\xCF\xB9" => '&#29258;',
		"\xCF\xBA" => '&#29292;',
		"\xCF\xBB" => '&#29296;',
		"\xCF\xBC" => '&#29299;',
		"\xCF\xBD" => '&#29294;',
		"\xCF\xBE" => '&#29386;',
		"\xCF\xBF" => '&#29412;',
		"\xCF\xC0" => '&#29416;',
		"\xCF\xC1" => '&#29419;',
		"\xCF\xC2" => '&#29407;',
		"\xCF\xC3" => '&#29418;',
		"\xCF\xC4" => '&#29414;',
		"\xCF\xC5" => '&#29411;',
		"\xCF\xC6" => '&#29573;',
		"\xCF\xC7" => '&#29644;',
		"\xCF\xC8" => '&#29634;',
		"\xCF\xC9" => '&#29640;',
		"\xCF\xCA" => '&#29637;',
		"\xCF\xCB" => '&#29625;',
		"\xCF\xCC" => '&#29622;',
		"\xCF\xCD" => '&#29621;',
		"\xCF\xCE" => '&#29620;',
		"\xCF\xCF" => '&#29675;',
		"\xCF\xD0" => '&#29631;',
		"\xCF\xD1" => '&#29639;',
		"\xCF\xD2" => '&#29630;',
		"\xCF\xD3" => '&#29635;',
		"\xCF\xD4" => '&#29638;',
		"\xCF\xD5" => '&#29624;',
		"\xCF\xD6" => '&#29643;',
		"\xCF\xD7" => '&#29932;',
		"\xCF\xD8" => '&#29934;',
		"\xCF\xD9" => '&#29998;',
		"\xCF\xDA" => '&#30023;',
		"\xCF\xDB" => '&#30024;',
		"\xCF\xDC" => '&#30119;',
		"\xCF\xDD" => '&#30122;',
		"\xCF\xDE" => '&#30329;',
		"\xCF\xDF" => '&#30404;',
		"\xCF\xE0" => '&#30472;',
		"\xCF\xE1" => '&#30467;',
		"\xCF\xE2" => '&#30468;',
		"\xCF\xE3" => '&#30469;',
		"\xCF\xE4" => '&#30474;',
		"\xCF\xE5" => '&#30455;',
		"\xCF\xE6" => '&#30459;',
		"\xCF\xE7" => '&#30458;',
		"\xCF\xE8" => '&#30695;',
		"\xCF\xE9" => '&#30696;',
		"\xCF\xEA" => '&#30726;',
		"\xCF\xEB" => '&#30737;',
		"\xCF\xEC" => '&#30738;',
		"\xCF\xED" => '&#30725;',
		"\xCF\xEE" => '&#30736;',
		"\xCF\xEF" => '&#30735;',
		"\xCF\xF0" => '&#30734;',
		"\xCF\xF1" => '&#30729;',
		"\xCF\xF2" => '&#30723;',
		"\xCF\xF3" => '&#30739;',
		"\xCF\xF4" => '&#31050;',
		"\xCF\xF5" => '&#31052;',
		"\xCF\xF6" => '&#31051;',
		"\xCF\xF7" => '&#31045;',
		"\xCF\xF8" => '&#31044;',
		"\xCF\xF9" => '&#31189;',
		"\xCF\xFA" => '&#31181;',
		"\xCF\xFB" => '&#31183;',
		"\xCF\xFC" => '&#31190;',
		"\xCF\xFD" => '&#31182;',
		"\xCF\xFE" => '&#31360;',
		"\xD0\x40" => '&#31358;',
		"\xD0\x41" => '&#31441;',
		"\xD0\x42" => '&#31488;',
		"\xD0\x43" => '&#31489;',
		"\xD0\x44" => '&#31866;',
		"\xD0\x45" => '&#31864;',
		"\xD0\x46" => '&#31865;',
		"\xD0\x47" => '&#31871;',
		"\xD0\x48" => '&#31872;',
		"\xD0\x49" => '&#31873;',
		"\xD0\x4A" => '&#32003;',
		"\xD0\x4B" => '&#32008;',
		"\xD0\x4C" => '&#32001;',
		"\xD0\x4D" => '&#32600;',
		"\xD0\x4E" => '&#32657;',
		"\xD0\x4F" => '&#32653;',
		"\xD0\x50" => '&#32702;',
		"\xD0\x51" => '&#32775;',
		"\xD0\x52" => '&#32782;',
		"\xD0\x53" => '&#32783;',
		"\xD0\x54" => '&#32788;',
		"\xD0\x55" => '&#32823;',
		"\xD0\x56" => '&#32984;',
		"\xD0\x57" => '&#32967;',
		"\xD0\x58" => '&#32992;',
		"\xD0\x59" => '&#32977;',
		"\xD0\x5A" => '&#32968;',
		"\xD0\x5B" => '&#32962;',
		"\xD0\x5C" => '&#32976;',
		"\xD0\x5D" => '&#32965;',
		"\xD0\x5E" => '&#32995;',
		"\xD0\x5F" => '&#32985;',
		"\xD0\x60" => '&#32988;',
		"\xD0\x61" => '&#32970;',
		"\xD0\x62" => '&#32981;',
		"\xD0\x63" => '&#32969;',
		"\xD0\x64" => '&#32975;',
		"\xD0\x65" => '&#32983;',
		"\xD0\x66" => '&#32998;',
		"\xD0\x67" => '&#32973;',
		"\xD0\x68" => '&#33279;',
		"\xD0\x69" => '&#33313;',
		"\xD0\x6A" => '&#33428;',
		"\xD0\x6B" => '&#33497;',
		"\xD0\x6C" => '&#33534;',
		"\xD0\x6D" => '&#33529;',
		"\xD0\x6E" => '&#33543;',
		"\xD0\x6F" => '&#33512;',
		"\xD0\x70" => '&#33536;',
		"\xD0\x71" => '&#33493;',
		"\xD0\x72" => '&#33594;',
		"\xD0\x73" => '&#33515;',
		"\xD0\x74" => '&#33494;',
		"\xD0\x75" => '&#33524;',
		"\xD0\x76" => '&#33516;',
		"\xD0\x77" => '&#33505;',
		"\xD0\x78" => '&#33522;',
		"\xD0\x79" => '&#33525;',
		"\xD0\x7A" => '&#33548;',
		"\xD0\x7B" => '&#33531;',
		"\xD0\x7C" => '&#33526;',
		"\xD0\x7D" => '&#33520;',
		"\xD0\x7E" => '&#33514;',
		"\xD0\xA1" => '&#33508;',
		"\xD0\xA2" => '&#33504;',
		"\xD0\xA3" => '&#33530;',
		"\xD0\xA4" => '&#33523;',
		"\xD0\xA5" => '&#33517;',
		"\xD0\xA6" => '&#34423;',
		"\xD0\xA7" => '&#34420;',
		"\xD0\xA8" => '&#34428;',
		"\xD0\xA9" => '&#34419;',
		"\xD0\xAA" => '&#34881;',
		"\xD0\xAB" => '&#34894;',
		"\xD0\xAC" => '&#34919;',
		"\xD0\xAD" => '&#34922;',
		"\xD0\xAE" => '&#34921;',
		"\xD0\xAF" => '&#35283;',
		"\xD0\xB0" => '&#35332;',
		"\xD0\xB1" => '&#35335;',
		"\xD0\xB2" => '&#36210;',
		"\xD0\xB3" => '&#36835;',
		"\xD0\xB4" => '&#36833;',
		"\xD0\xB5" => '&#36846;',
		"\xD0\xB6" => '&#36832;',
		"\xD0\xB7" => '&#37105;',
		"\xD0\xB8" => '&#37053;',
		"\xD0\xB9" => '&#37055;',
		"\xD0\xBA" => '&#37077;',
		"\xD0\xBB" => '&#37061;',
		"\xD0\xBC" => '&#37054;',
		"\xD0\xBD" => '&#37063;',
		"\xD0\xBE" => '&#37067;',
		"\xD0\xBF" => '&#37064;',
		"\xD0\xC0" => '&#37332;',
		"\xD0\xC1" => '&#37331;',
		"\xD0\xC2" => '&#38484;',
		"\xD0\xC3" => '&#38479;',
		"\xD0\xC4" => '&#38481;',
		"\xD0\xC5" => '&#38483;',
		"\xD0\xC6" => '&#38474;',
		"\xD0\xC7" => '&#38478;',
		"\xD0\xC8" => '&#20510;',
		"\xD0\xC9" => '&#20485;',
		"\xD0\xCA" => '&#20487;',
		"\xD0\xCB" => '&#20499;',
		"\xD0\xCC" => '&#20514;',
		"\xD0\xCD" => '&#20528;',
		"\xD0\xCE" => '&#20507;',
		"\xD0\xCF" => '&#20469;',
		"\xD0\xD0" => '&#20468;',
		"\xD0\xD1" => '&#20531;',
		"\xD0\xD2" => '&#20535;',
		"\xD0\xD3" => '&#20524;',
		"\xD0\xD4" => '&#20470;',
		"\xD0\xD5" => '&#20471;',
		"\xD0\xD6" => '&#20503;',
		"\xD0\xD7" => '&#20508;',
		"\xD0\xD8" => '&#20512;',
		"\xD0\xD9" => '&#20519;',
		"\xD0\xDA" => '&#20533;',
		"\xD0\xDB" => '&#20527;',
		"\xD0\xDC" => '&#20529;',
		"\xD0\xDD" => '&#20494;',
		"\xD0\xDE" => '&#20826;',
		"\xD0\xDF" => '&#20884;',
		"\xD0\xE0" => '&#20883;',
		"\xD0\xE1" => '&#20938;',
		"\xD0\xE2" => '&#20932;',
		"\xD0\xE3" => '&#20933;',
		"\xD0\xE4" => '&#20936;',
		"\xD0\xE5" => '&#20942;',
		"\xD0\xE6" => '&#21089;',
		"\xD0\xE7" => '&#21082;',
		"\xD0\xE8" => '&#21074;',
		"\xD0\xE9" => '&#21086;',
		"\xD0\xEA" => '&#21087;',
		"\xD0\xEB" => '&#21077;',
		"\xD0\xEC" => '&#21090;',
		"\xD0\xED" => '&#21197;',
		"\xD0\xEE" => '&#21262;',
		"\xD0\xEF" => '&#21406;',
		"\xD0\xF0" => '&#21798;',
		"\xD0\xF1" => '&#21730;',
		"\xD0\xF2" => '&#21783;',
		"\xD0\xF3" => '&#21778;',
		"\xD0\xF4" => '&#21735;',
		"\xD0\xF5" => '&#21747;',
		"\xD0\xF6" => '&#21732;',
		"\xD0\xF7" => '&#21786;',
		"\xD0\xF8" => '&#21759;',
		"\xD0\xF9" => '&#21764;',
		"\xD0\xFA" => '&#21768;',
		"\xD0\xFB" => '&#21739;',
		"\xD0\xFC" => '&#21777;',
		"\xD0\xFD" => '&#21765;',
		"\xD0\xFE" => '&#21745;',
		"\xD1\x40" => '&#21770;',
		"\xD1\x41" => '&#21755;',
		"\xD1\x42" => '&#21751;',
		"\xD1\x43" => '&#21752;',
		"\xD1\x44" => '&#21728;',
		"\xD1\x45" => '&#21774;',
		"\xD1\x46" => '&#21763;',
		"\xD1\x47" => '&#21771;',
		"\xD1\x48" => '&#22273;',
		"\xD1\x49" => '&#22274;',
		"\xD1\x4A" => '&#22476;',
		"\xD1\x4B" => '&#22578;',
		"\xD1\x4C" => '&#22485;',
		"\xD1\x4D" => '&#22482;',
		"\xD1\x4E" => '&#22458;',
		"\xD1\x4F" => '&#22470;',
		"\xD1\x50" => '&#22461;',
		"\xD1\x51" => '&#22460;',
		"\xD1\x52" => '&#22456;',
		"\xD1\x53" => '&#22454;',
		"\xD1\x54" => '&#22463;',
		"\xD1\x55" => '&#22471;',
		"\xD1\x56" => '&#22480;',
		"\xD1\x57" => '&#22457;',
		"\xD1\x58" => '&#22465;',
		"\xD1\x59" => '&#22798;',
		"\xD1\x5A" => '&#22858;',
		"\xD1\x5B" => '&#23065;',
		"\xD1\x5C" => '&#23062;',
		"\xD1\x5D" => '&#23085;',
		"\xD1\x5E" => '&#23086;',
		"\xD1\x5F" => '&#23061;',
		"\xD1\x60" => '&#23055;',
		"\xD1\x61" => '&#23063;',
		"\xD1\x62" => '&#23050;',
		"\xD1\x63" => '&#23070;',
		"\xD1\x64" => '&#23091;',
		"\xD1\x65" => '&#23404;',
		"\xD1\x66" => '&#23463;',
		"\xD1\x67" => '&#23469;',
		"\xD1\x68" => '&#23468;',
		"\xD1\x69" => '&#23555;',
		"\xD1\x6A" => '&#23638;',
		"\xD1\x6B" => '&#23636;',
		"\xD1\x6C" => '&#23788;',
		"\xD1\x6D" => '&#23807;',
		"\xD1\x6E" => '&#23790;',
		"\xD1\x6F" => '&#23793;',
		"\xD1\x70" => '&#23799;',
		"\xD1\x71" => '&#23808;',
		"\xD1\x72" => '&#23801;',
		"\xD1\x73" => '&#24105;',
		"\xD1\x74" => '&#24104;',
		"\xD1\x75" => '&#24232;',
		"\xD1\x76" => '&#24238;',
		"\xD1\x77" => '&#24234;',
		"\xD1\x78" => '&#24236;',
		"\xD1\x79" => '&#24371;',
		"\xD1\x7A" => '&#24368;',
		"\xD1\x7B" => '&#24423;',
		"\xD1\x7C" => '&#24669;',
		"\xD1\x7D" => '&#24666;',
		"\xD1\x7E" => '&#24679;',
		"\xD1\xA1" => '&#24641;',
		"\xD1\xA2" => '&#24738;',
		"\xD1\xA3" => '&#24712;',
		"\xD1\xA4" => '&#24704;',
		"\xD1\xA5" => '&#24722;',
		"\xD1\xA6" => '&#24705;',
		"\xD1\xA7" => '&#24733;',
		"\xD1\xA8" => '&#24707;',
		"\xD1\xA9" => '&#24725;',
		"\xD1\xAA" => '&#24731;',
		"\xD1\xAB" => '&#24727;',
		"\xD1\xAC" => '&#24711;',
		"\xD1\xAD" => '&#24732;',
		"\xD1\xAE" => '&#24718;',
		"\xD1\xAF" => '&#25113;',
		"\xD1\xB0" => '&#25158;',
		"\xD1\xB1" => '&#25330;',
		"\xD1\xB2" => '&#25360;',
		"\xD1\xB3" => '&#25430;',
		"\xD1\xB4" => '&#25388;',
		"\xD1\xB5" => '&#25412;',
		"\xD1\xB6" => '&#25413;',
		"\xD1\xB7" => '&#25398;',
		"\xD1\xB8" => '&#25411;',
		"\xD1\xB9" => '&#25572;',
		"\xD1\xBA" => '&#25401;',
		"\xD1\xBB" => '&#25419;',
		"\xD1\xBC" => '&#25418;',
		"\xD1\xBD" => '&#25404;',
		"\xD1\xBE" => '&#25385;',
		"\xD1\xBF" => '&#25409;',
		"\xD1\xC0" => '&#25396;',
		"\xD1\xC1" => '&#25432;',
		"\xD1\xC2" => '&#25428;',
		"\xD1\xC3" => '&#25433;',
		"\xD1\xC4" => '&#25389;',
		"\xD1\xC5" => '&#25415;',
		"\xD1\xC6" => '&#25395;',
		"\xD1\xC7" => '&#25434;',
		"\xD1\xC8" => '&#25425;',
		"\xD1\xC9" => '&#25400;',
		"\xD1\xCA" => '&#25431;',
		"\xD1\xCB" => '&#25408;',
		"\xD1\xCC" => '&#25416;',
		"\xD1\xCD" => '&#25930;',
		"\xD1\xCE" => '&#25926;',
		"\xD1\xCF" => '&#26054;',
		"\xD1\xD0" => '&#26051;',
		"\xD1\xD1" => '&#26052;',
		"\xD1\xD2" => '&#26050;',
		"\xD1\xD3" => '&#26186;',
		"\xD1\xD4" => '&#26207;',
		"\xD1\xD5" => '&#26183;',
		"\xD1\xD6" => '&#26193;',
		"\xD1\xD7" => '&#26386;',
		"\xD1\xD8" => '&#26387;',
		"\xD1\xD9" => '&#26655;',
		"\xD1\xDA" => '&#26650;',
		"\xD1\xDB" => '&#26697;',
		"\xD1\xDC" => '&#26674;',
		"\xD1\xDD" => '&#26675;',
		"\xD1\xDE" => '&#26683;',
		"\xD1\xDF" => '&#26699;',
		"\xD1\xE0" => '&#26703;',
		"\xD1\xE1" => '&#26646;',
		"\xD1\xE2" => '&#26673;',
		"\xD1\xE3" => '&#26652;',
		"\xD1\xE4" => '&#26677;',
		"\xD1\xE5" => '&#26667;',
		"\xD1\xE6" => '&#26669;',
		"\xD1\xE7" => '&#26671;',
		"\xD1\xE8" => '&#26702;',
		"\xD1\xE9" => '&#26692;',
		"\xD1\xEA" => '&#26676;',
		"\xD1\xEB" => '&#26653;',
		"\xD1\xEC" => '&#26642;',
		"\xD1\xED" => '&#26644;',
		"\xD1\xEE" => '&#26662;',
		"\xD1\xEF" => '&#26664;',
		"\xD1\xF0" => '&#26670;',
		"\xD1\xF1" => '&#26701;',
		"\xD1\xF2" => '&#26682;',
		"\xD1\xF3" => '&#26661;',
		"\xD1\xF4" => '&#26656;',
		"\xD1\xF5" => '&#27436;',
		"\xD1\xF6" => '&#27439;',
		"\xD1\xF7" => '&#27437;',
		"\xD1\xF8" => '&#27441;',
		"\xD1\xF9" => '&#27444;',
		"\xD1\xFA" => '&#27501;',
		"\xD1\xFB" => '&#32898;',
		"\xD1\xFC" => '&#27528;',
		"\xD1\xFD" => '&#27622;',
		"\xD1\xFE" => '&#27620;',
		"\xD2\x40" => '&#27624;',
		"\xD2\x41" => '&#27619;',
		"\xD2\x42" => '&#27618;',
		"\xD2\x43" => '&#27623;',
		"\xD2\x44" => '&#27685;',
		"\xD2\x45" => '&#28026;',
		"\xD2\x46" => '&#28003;',
		"\xD2\x47" => '&#28004;',
		"\xD2\x48" => '&#28022;',
		"\xD2\x49" => '&#27917;',
		"\xD2\x4A" => '&#28001;',
		"\xD2\x4B" => '&#28050;',
		"\xD2\x4C" => '&#27992;',
		"\xD2\x4D" => '&#28002;',
		"\xD2\x4E" => '&#28013;',
		"\xD2\x4F" => '&#28015;',
		"\xD2\x50" => '&#28049;',
		"\xD2\x51" => '&#28045;',
		"\xD2\x52" => '&#28143;',
		"\xD2\x53" => '&#28031;',
		"\xD2\x54" => '&#28038;',
		"\xD2\x55" => '&#27998;',
		"\xD2\x56" => '&#28007;',
		"\xD2\x57" => '&#28000;',
		"\xD2\x58" => '&#28055;',
		"\xD2\x59" => '&#28016;',
		"\xD2\x5A" => '&#28028;',
		"\xD2\x5B" => '&#27999;',
		"\xD2\x5C" => '&#28034;',
		"\xD2\x5D" => '&#28056;',
		"\xD2\x5E" => '&#27951;',
		"\xD2\x5F" => '&#28008;',
		"\xD2\x60" => '&#28043;',
		"\xD2\x61" => '&#28030;',
		"\xD2\x62" => '&#28032;',
		"\xD2\x63" => '&#28036;',
		"\xD2\x64" => '&#27926;',
		"\xD2\x65" => '&#28035;',
		"\xD2\x66" => '&#28027;',
		"\xD2\x67" => '&#28029;',
		"\xD2\x68" => '&#28021;',
		"\xD2\x69" => '&#28048;',
		"\xD2\x6A" => '&#28892;',
		"\xD2\x6B" => '&#28883;',
		"\xD2\x6C" => '&#28881;',
		"\xD2\x6D" => '&#28893;',
		"\xD2\x6E" => '&#28875;',
		"\xD2\x6F" => '&#32569;',
		"\xD2\x70" => '&#28898;',
		"\xD2\x71" => '&#28887;',
		"\xD2\x72" => '&#28882;',
		"\xD2\x73" => '&#28894;',
		"\xD2\x74" => '&#28896;',
		"\xD2\x75" => '&#28884;',
		"\xD2\x76" => '&#28877;',
		"\xD2\x77" => '&#28869;',
		"\xD2\x78" => '&#28870;',
		"\xD2\x79" => '&#28871;',
		"\xD2\x7A" => '&#28890;',
		"\xD2\x7B" => '&#28878;',
		"\xD2\x7C" => '&#28897;',
		"\xD2\x7D" => '&#29250;',
		"\xD2\x7E" => '&#29304;',
		"\xD2\xA1" => '&#29303;',
		"\xD2\xA2" => '&#29302;',
		"\xD2\xA3" => '&#29440;',
		"\xD2\xA4" => '&#29434;',
		"\xD2\xA5" => '&#29428;',
		"\xD2\xA6" => '&#29438;',
		"\xD2\xA7" => '&#29430;',
		"\xD2\xA8" => '&#29427;',
		"\xD2\xA9" => '&#29435;',
		"\xD2\xAA" => '&#29441;',
		"\xD2\xAB" => '&#29651;',
		"\xD2\xAC" => '&#29657;',
		"\xD2\xAD" => '&#29669;',
		"\xD2\xAE" => '&#29654;',
		"\xD2\xAF" => '&#29628;',
		"\xD2\xB0" => '&#29671;',
		"\xD2\xB1" => '&#29667;',
		"\xD2\xB2" => '&#29673;',
		"\xD2\xB3" => '&#29660;',
		"\xD2\xB4" => '&#29650;',
		"\xD2\xB5" => '&#29659;',
		"\xD2\xB6" => '&#29652;',
		"\xD2\xB7" => '&#29661;',
		"\xD2\xB8" => '&#29658;',
		"\xD2\xB9" => '&#29655;',
		"\xD2\xBA" => '&#29656;',
		"\xD2\xBB" => '&#29672;',
		"\xD2\xBC" => '&#29918;',
		"\xD2\xBD" => '&#29919;',
		"\xD2\xBE" => '&#29940;',
		"\xD2\xBF" => '&#29941;',
		"\xD2\xC0" => '&#29985;',
		"\xD2\xC1" => '&#30043;',
		"\xD2\xC2" => '&#30047;',
		"\xD2\xC3" => '&#30128;',
		"\xD2\xC4" => '&#30145;',
		"\xD2\xC5" => '&#30139;',
		"\xD2\xC6" => '&#30148;',
		"\xD2\xC7" => '&#30144;',
		"\xD2\xC8" => '&#30143;',
		"\xD2\xC9" => '&#30134;',
		"\xD2\xCA" => '&#30138;',
		"\xD2\xCB" => '&#30346;',
		"\xD2\xCC" => '&#30409;',
		"\xD2\xCD" => '&#30493;',
		"\xD2\xCE" => '&#30491;',
		"\xD2\xCF" => '&#30480;',
		"\xD2\xD0" => '&#30483;',
		"\xD2\xD1" => '&#30482;',
		"\xD2\xD2" => '&#30499;',
		"\xD2\xD3" => '&#30481;',
		"\xD2\xD4" => '&#30485;',
		"\xD2\xD5" => '&#30489;',
		"\xD2\xD6" => '&#30490;',
		"\xD2\xD7" => '&#30498;',
		"\xD2\xD8" => '&#30503;',
		"\xD2\xD9" => '&#30755;',
		"\xD2\xDA" => '&#30764;',
		"\xD2\xDB" => '&#30754;',
		"\xD2\xDC" => '&#30773;',
		"\xD2\xDD" => '&#30767;',
		"\xD2\xDE" => '&#30760;',
		"\xD2\xDF" => '&#30766;',
		"\xD2\xE0" => '&#30763;',
		"\xD2\xE1" => '&#30753;',
		"\xD2\xE2" => '&#30761;',
		"\xD2\xE3" => '&#30771;',
		"\xD2\xE4" => '&#30762;',
		"\xD2\xE5" => '&#30769;',
		"\xD2\xE6" => '&#31060;',
		"\xD2\xE7" => '&#31067;',
		"\xD2\xE8" => '&#31055;',
		"\xD2\xE9" => '&#31068;',
		"\xD2\xEA" => '&#31059;',
		"\xD2\xEB" => '&#31058;',
		"\xD2\xEC" => '&#31057;',
		"\xD2\xED" => '&#31211;',
		"\xD2\xEE" => '&#31212;',
		"\xD2\xEF" => '&#31200;',
		"\xD2\xF0" => '&#31214;',
		"\xD2\xF1" => '&#31213;',
		"\xD2\xF2" => '&#31210;',
		"\xD2\xF3" => '&#31196;',
		"\xD2\xF4" => '&#31198;',
		"\xD2\xF5" => '&#31197;',
		"\xD2\xF6" => '&#31366;',
		"\xD2\xF7" => '&#31369;',
		"\xD2\xF8" => '&#31365;',
		"\xD2\xF9" => '&#31371;',
		"\xD2\xFA" => '&#31372;',
		"\xD2\xFB" => '&#31370;',
		"\xD2\xFC" => '&#31367;',
		"\xD2\xFD" => '&#31448;',
		"\xD2\xFE" => '&#31504;',
		"\xD3\x40" => '&#31492;',
		"\xD3\x41" => '&#31507;',
		"\xD3\x42" => '&#31493;',
		"\xD3\x43" => '&#31503;',
		"\xD3\x44" => '&#31496;',
		"\xD3\x45" => '&#31498;',
		"\xD3\x46" => '&#31502;',
		"\xD3\x47" => '&#31497;',
		"\xD3\x48" => '&#31506;',
		"\xD3\x49" => '&#31876;',
		"\xD3\x4A" => '&#31889;',
		"\xD3\x4B" => '&#31882;',
		"\xD3\x4C" => '&#31884;',
		"\xD3\x4D" => '&#31880;',
		"\xD3\x4E" => '&#31885;',
		"\xD3\x4F" => '&#31877;',
		"\xD3\x50" => '&#32030;',
		"\xD3\x51" => '&#32029;',
		"\xD3\x52" => '&#32017;',
		"\xD3\x53" => '&#32014;',
		"\xD3\x54" => '&#32024;',
		"\xD3\x55" => '&#32022;',
		"\xD3\x56" => '&#32019;',
		"\xD3\x57" => '&#32031;',
		"\xD3\x58" => '&#32018;',
		"\xD3\x59" => '&#32015;',
		"\xD3\x5A" => '&#32012;',
		"\xD3\x5B" => '&#32604;',
		"\xD3\x5C" => '&#32609;',
		"\xD3\x5D" => '&#32606;',
		"\xD3\x5E" => '&#32608;',
		"\xD3\x5F" => '&#32605;',
		"\xD3\x60" => '&#32603;',
		"\xD3\x61" => '&#32662;',
		"\xD3\x62" => '&#32658;',
		"\xD3\x63" => '&#32707;',
		"\xD3\x64" => '&#32706;',
		"\xD3\x65" => '&#32704;',
		"\xD3\x66" => '&#32790;',
		"\xD3\x67" => '&#32830;',
		"\xD3\x68" => '&#32825;',
		"\xD3\x69" => '&#33018;',
		"\xD3\x6A" => '&#33010;',
		"\xD3\x6B" => '&#33017;',
		"\xD3\x6C" => '&#33013;',
		"\xD3\x6D" => '&#33025;',
		"\xD3\x6E" => '&#33019;',
		"\xD3\x6F" => '&#33024;',
		"\xD3\x70" => '&#33281;',
		"\xD3\x71" => '&#33327;',
		"\xD3\x72" => '&#33317;',
		"\xD3\x73" => '&#33587;',
		"\xD3\x74" => '&#33581;',
		"\xD3\x75" => '&#33604;',
		"\xD3\x76" => '&#33561;',
		"\xD3\x77" => '&#33617;',
		"\xD3\x78" => '&#33573;',
		"\xD3\x79" => '&#33622;',
		"\xD3\x7A" => '&#33599;',
		"\xD3\x7B" => '&#33601;',
		"\xD3\x7C" => '&#33574;',
		"\xD3\x7D" => '&#33564;',
		"\xD3\x7E" => '&#33570;',
		"\xD3\xA1" => '&#33602;',
		"\xD3\xA2" => '&#33614;',
		"\xD3\xA3" => '&#33563;',
		"\xD3\xA4" => '&#33578;',
		"\xD3\xA5" => '&#33544;',
		"\xD3\xA6" => '&#33596;',
		"\xD3\xA7" => '&#33613;',
		"\xD3\xA8" => '&#33558;',
		"\xD3\xA9" => '&#33572;',
		"\xD3\xAA" => '&#33568;',
		"\xD3\xAB" => '&#33591;',
		"\xD3\xAC" => '&#33583;',
		"\xD3\xAD" => '&#33577;',
		"\xD3\xAE" => '&#33607;',
		"\xD3\xAF" => '&#33605;',
		"\xD3\xB0" => '&#33612;',
		"\xD3\xB1" => '&#33619;',
		"\xD3\xB2" => '&#33566;',
		"\xD3\xB3" => '&#33580;',
		"\xD3\xB4" => '&#33611;',
		"\xD3\xB5" => '&#33575;',
		"\xD3\xB6" => '&#33608;',
		"\xD3\xB7" => '&#34387;',
		"\xD3\xB8" => '&#34386;',
		"\xD3\xB9" => '&#34466;',
		"\xD3\xBA" => '&#34472;',
		"\xD3\xBB" => '&#34454;',
		"\xD3\xBC" => '&#34445;',
		"\xD3\xBD" => '&#34449;',
		"\xD3\xBE" => '&#34462;',
		"\xD3\xBF" => '&#34439;',
		"\xD3\xC0" => '&#34455;',
		"\xD3\xC1" => '&#34438;',
		"\xD3\xC2" => '&#34443;',
		"\xD3\xC3" => '&#34458;',
		"\xD3\xC4" => '&#34437;',
		"\xD3\xC5" => '&#34469;',
		"\xD3\xC6" => '&#34457;',
		"\xD3\xC7" => '&#34465;',
		"\xD3\xC8" => '&#34471;',
		"\xD3\xC9" => '&#34453;',
		"\xD3\xCA" => '&#34456;',
		"\xD3\xCB" => '&#34446;',
		"\xD3\xCC" => '&#34461;',
		"\xD3\xCD" => '&#34448;',
		"\xD3\xCE" => '&#34452;',
		"\xD3\xCF" => '&#34883;',
		"\xD3\xD0" => '&#34884;',
		"\xD3\xD1" => '&#34925;',
		"\xD3\xD2" => '&#34933;',
		"\xD3\xD3" => '&#34934;',
		"\xD3\xD4" => '&#34930;',
		"\xD3\xD5" => '&#34944;',
		"\xD3\xD6" => '&#34929;',
		"\xD3\xD7" => '&#34943;',
		"\xD3\xD8" => '&#34927;',
		"\xD3\xD9" => '&#34947;',
		"\xD3\xDA" => '&#34942;',
		"\xD3\xDB" => '&#34932;',
		"\xD3\xDC" => '&#34940;',
		"\xD3\xDD" => '&#35346;',
		"\xD3\xDE" => '&#35911;',
		"\xD3\xDF" => '&#35927;',
		"\xD3\xE0" => '&#35963;',
		"\xD3\xE1" => '&#36004;',
		"\xD3\xE2" => '&#36003;',
		"\xD3\xE3" => '&#36214;',
		"\xD3\xE4" => '&#36216;',
		"\xD3\xE5" => '&#36277;',
		"\xD3\xE6" => '&#36279;',
		"\xD3\xE7" => '&#36278;',
		"\xD3\xE8" => '&#36561;',
		"\xD3\xE9" => '&#36563;',
		"\xD3\xEA" => '&#36862;',
		"\xD3\xEB" => '&#36853;',
		"\xD3\xEC" => '&#36866;',
		"\xD3\xED" => '&#36863;',
		"\xD3\xEE" => '&#36859;',
		"\xD3\xEF" => '&#36868;',
		"\xD3\xF0" => '&#36860;',
		"\xD3\xF1" => '&#36854;',
		"\xD3\xF2" => '&#37078;',
		"\xD3\xF3" => '&#37088;',
		"\xD3\xF4" => '&#37081;',
		"\xD3\xF5" => '&#37082;',
		"\xD3\xF6" => '&#37091;',
		"\xD3\xF7" => '&#37087;',
		"\xD3\xF8" => '&#37093;',
		"\xD3\xF9" => '&#37080;',
		"\xD3\xFA" => '&#37083;',
		"\xD3\xFB" => '&#37079;',
		"\xD3\xFC" => '&#37084;',
		"\xD3\xFD" => '&#37092;',
		"\xD3\xFE" => '&#37200;',
		"\xD4\x40" => '&#37198;',
		"\xD4\x41" => '&#37199;',
		"\xD4\x42" => '&#37333;',
		"\xD4\x43" => '&#37346;',
		"\xD4\x44" => '&#37338;',
		"\xD4\x45" => '&#38492;',
		"\xD4\x46" => '&#38495;',
		"\xD4\x47" => '&#38588;',
		"\xD4\x48" => '&#39139;',
		"\xD4\x49" => '&#39647;',
		"\xD4\x4A" => '&#39727;',
		"\xD4\x4B" => '&#20095;',
		"\xD4\x4C" => '&#20592;',
		"\xD4\x4D" => '&#20586;',
		"\xD4\x4E" => '&#20577;',
		"\xD4\x4F" => '&#20574;',
		"\xD4\x50" => '&#20576;',
		"\xD4\x51" => '&#20563;',
		"\xD4\x52" => '&#20555;',
		"\xD4\x53" => '&#20573;',
		"\xD4\x54" => '&#20594;',
		"\xD4\x55" => '&#20552;',
		"\xD4\x56" => '&#20557;',
		"\xD4\x57" => '&#20545;',
		"\xD4\x58" => '&#20571;',
		"\xD4\x59" => '&#20554;',
		"\xD4\x5A" => '&#20578;',
		"\xD4\x5B" => '&#20501;',
		"\xD4\x5C" => '&#20549;',
		"\xD4\x5D" => '&#20575;',
		"\xD4\x5E" => '&#20585;',
		"\xD4\x5F" => '&#20587;',
		"\xD4\x60" => '&#20579;',
		"\xD4\x61" => '&#20580;',
		"\xD4\x62" => '&#20550;',
		"\xD4\x63" => '&#20544;',
		"\xD4\x64" => '&#20590;',
		"\xD4\x65" => '&#20595;',
		"\xD4\x66" => '&#20567;',
		"\xD4\x67" => '&#20561;',
		"\xD4\x68" => '&#20944;',
		"\xD4\x69" => '&#21099;',
		"\xD4\x6A" => '&#21101;',
		"\xD4\x6B" => '&#21100;',
		"\xD4\x6C" => '&#21102;',
		"\xD4\x6D" => '&#21206;',
		"\xD4\x6E" => '&#21203;',
		"\xD4\x6F" => '&#21293;',
		"\xD4\x70" => '&#21404;',
		"\xD4\x71" => '&#21877;',
		"\xD4\x72" => '&#21878;',
		"\xD4\x73" => '&#21820;',
		"\xD4\x74" => '&#21837;',
		"\xD4\x75" => '&#21840;',
		"\xD4\x76" => '&#21812;',
		"\xD4\x77" => '&#21802;',
		"\xD4\x78" => '&#21841;',
		"\xD4\x79" => '&#21858;',
		"\xD4\x7A" => '&#21814;',
		"\xD4\x7B" => '&#21813;',
		"\xD4\x7C" => '&#21808;',
		"\xD4\x7D" => '&#21842;',
		"\xD4\x7E" => '&#21829;',
		"\xD4\xA1" => '&#21772;',
		"\xD4\xA2" => '&#21810;',
		"\xD4\xA3" => '&#21861;',
		"\xD4\xA4" => '&#21838;',
		"\xD4\xA5" => '&#21817;',
		"\xD4\xA6" => '&#21832;',
		"\xD4\xA7" => '&#21805;',
		"\xD4\xA8" => '&#21819;',
		"\xD4\xA9" => '&#21824;',
		"\xD4\xAA" => '&#21835;',
		"\xD4\xAB" => '&#22282;',
		"\xD4\xAC" => '&#22279;',
		"\xD4\xAD" => '&#22523;',
		"\xD4\xAE" => '&#22548;',
		"\xD4\xAF" => '&#22498;',
		"\xD4\xB0" => '&#22518;',
		"\xD4\xB1" => '&#22492;',
		"\xD4\xB2" => '&#22516;',
		"\xD4\xB3" => '&#22528;',
		"\xD4\xB4" => '&#22509;',
		"\xD4\xB5" => '&#22525;',
		"\xD4\xB6" => '&#22536;',
		"\xD4\xB7" => '&#22520;',
		"\xD4\xB8" => '&#22539;',
		"\xD4\xB9" => '&#22515;',
		"\xD4\xBA" => '&#22479;',
		"\xD4\xBB" => '&#22535;',
		"\xD4\xBC" => '&#22510;',
		"\xD4\xBD" => '&#22499;',
		"\xD4\xBE" => '&#22514;',
		"\xD4\xBF" => '&#22501;',
		"\xD4\xC0" => '&#22508;',
		"\xD4\xC1" => '&#22497;',
		"\xD4\xC2" => '&#22542;',
		"\xD4\xC3" => '&#22524;',
		"\xD4\xC4" => '&#22544;',
		"\xD4\xC5" => '&#22503;',
		"\xD4\xC6" => '&#22529;',
		"\xD4\xC7" => '&#22540;',
		"\xD4\xC8" => '&#22513;',
		"\xD4\xC9" => '&#22505;',
		"\xD4\xCA" => '&#22512;',
		"\xD4\xCB" => '&#22541;',
		"\xD4\xCC" => '&#22532;',
		"\xD4\xCD" => '&#22876;',
		"\xD4\xCE" => '&#23136;',
		"\xD4\xCF" => '&#23128;',
		"\xD4\xD0" => '&#23125;',
		"\xD4\xD1" => '&#23143;',
		"\xD4\xD2" => '&#23134;',
		"\xD4\xD3" => '&#23096;',
		"\xD4\xD4" => '&#23093;',
		"\xD4\xD5" => '&#23149;',
		"\xD4\xD6" => '&#23120;',
		"\xD4\xD7" => '&#23135;',
		"\xD4\xD8" => '&#23141;',
		"\xD4\xD9" => '&#23148;',
		"\xD4\xDA" => '&#23123;',
		"\xD4\xDB" => '&#23140;',
		"\xD4\xDC" => '&#23127;',
		"\xD4\xDD" => '&#23107;',
		"\xD4\xDE" => '&#23133;',
		"\xD4\xDF" => '&#23122;',
		"\xD4\xE0" => '&#23108;',
		"\xD4\xE1" => '&#23131;',
		"\xD4\xE2" => '&#23112;',
		"\xD4\xE3" => '&#23182;',
		"\xD4\xE4" => '&#23102;',
		"\xD4\xE5" => '&#23117;',
		"\xD4\xE6" => '&#23097;',
		"\xD4\xE7" => '&#23116;',
		"\xD4\xE8" => '&#23152;',
		"\xD4\xE9" => '&#23145;',
		"\xD4\xEA" => '&#23111;',
		"\xD4\xEB" => '&#23121;',
		"\xD4\xEC" => '&#23126;',
		"\xD4\xED" => '&#23106;',
		"\xD4\xEE" => '&#23132;',
		"\xD4\xEF" => '&#23410;',
		"\xD4\xF0" => '&#23406;',
		"\xD4\xF1" => '&#23489;',
		"\xD4\xF2" => '&#23488;',
		"\xD4\xF3" => '&#23641;',
		"\xD4\xF4" => '&#23838;',
		"\xD4\xF5" => '&#23819;',
		"\xD4\xF6" => '&#23837;',
		"\xD4\xF7" => '&#23834;',
		"\xD4\xF8" => '&#23840;',
		"\xD4\xF9" => '&#23820;',
		"\xD4\xFA" => '&#23848;',
		"\xD4\xFB" => '&#23821;',
		"\xD4\xFC" => '&#23846;',
		"\xD4\xFD" => '&#23845;',
		"\xD4\xFE" => '&#23823;',
		"\xD5\x40" => '&#23856;',
		"\xD5\x41" => '&#23826;',
		"\xD5\x42" => '&#23843;',
		"\xD5\x43" => '&#23839;',
		"\xD5\x44" => '&#23854;',
		"\xD5\x45" => '&#24126;',
		"\xD5\x46" => '&#24116;',
		"\xD5\x47" => '&#24241;',
		"\xD5\x48" => '&#24244;',
		"\xD5\x49" => '&#24249;',
		"\xD5\x4A" => '&#24242;',
		"\xD5\x4B" => '&#24243;',
		"\xD5\x4C" => '&#24374;',
		"\xD5\x4D" => '&#24376;',
		"\xD5\x4E" => '&#24475;',
		"\xD5\x4F" => '&#24470;',
		"\xD5\x50" => '&#24479;',
		"\xD5\x51" => '&#24714;',
		"\xD5\x52" => '&#24720;',
		"\xD5\x53" => '&#24710;',
		"\xD5\x54" => '&#24766;',
		"\xD5\x55" => '&#24752;',
		"\xD5\x56" => '&#24762;',
		"\xD5\x57" => '&#24787;',
		"\xD5\x58" => '&#24788;',
		"\xD5\x59" => '&#24783;',
		"\xD5\x5A" => '&#24804;',
		"\xD5\x5B" => '&#24793;',
		"\xD5\x5C" => '&#24797;',
		"\xD5\x5D" => '&#24776;',
		"\xD5\x5E" => '&#24753;',
		"\xD5\x5F" => '&#24795;',
		"\xD5\x60" => '&#24759;',
		"\xD5\x61" => '&#24778;',
		"\xD5\x62" => '&#24767;',
		"\xD5\x63" => '&#24771;',
		"\xD5\x64" => '&#24781;',
		"\xD5\x65" => '&#24768;',
		"\xD5\x66" => '&#25394;',
		"\xD5\x67" => '&#25445;',
		"\xD5\x68" => '&#25482;',
		"\xD5\x69" => '&#25474;',
		"\xD5\x6A" => '&#25469;',
		"\xD5\x6B" => '&#25533;',
		"\xD5\x6C" => '&#25502;',
		"\xD5\x6D" => '&#25517;',
		"\xD5\x6E" => '&#25501;',
		"\xD5\x6F" => '&#25495;',
		"\xD5\x70" => '&#25515;',
		"\xD5\x71" => '&#25486;',
		"\xD5\x72" => '&#25455;',
		"\xD5\x73" => '&#25479;',
		"\xD5\x74" => '&#25488;',
		"\xD5\x75" => '&#25454;',
		"\xD5\x76" => '&#25519;',
		"\xD5\x77" => '&#25461;',
		"\xD5\x78" => '&#25500;',
		"\xD5\x79" => '&#25453;',
		"\xD5\x7A" => '&#25518;',
		"\xD5\x7B" => '&#25468;',
		"\xD5\x7C" => '&#25508;',
		"\xD5\x7D" => '&#25403;',
		"\xD5\x7E" => '&#25503;',
		"\xD5\xA1" => '&#25464;',
		"\xD5\xA2" => '&#25477;',
		"\xD5\xA3" => '&#25473;',
		"\xD5\xA4" => '&#25489;',
		"\xD5\xA5" => '&#25485;',
		"\xD5\xA6" => '&#25456;',
		"\xD5\xA7" => '&#25939;',
		"\xD5\xA8" => '&#26061;',
		"\xD5\xA9" => '&#26213;',
		"\xD5\xAA" => '&#26209;',
		"\xD5\xAB" => '&#26203;',
		"\xD5\xAC" => '&#26201;',
		"\xD5\xAD" => '&#26204;',
		"\xD5\xAE" => '&#26210;',
		"\xD5\xAF" => '&#26392;',
		"\xD5\xB0" => '&#26745;',
		"\xD5\xB1" => '&#26759;',
		"\xD5\xB2" => '&#26768;',
		"\xD5\xB3" => '&#26780;',
		"\xD5\xB4" => '&#26733;',
		"\xD5\xB5" => '&#26734;',
		"\xD5\xB6" => '&#26798;',
		"\xD5\xB7" => '&#26795;',
		"\xD5\xB8" => '&#26966;',
		"\xD5\xB9" => '&#26735;',
		"\xD5\xBA" => '&#26787;',
		"\xD5\xBB" => '&#26796;',
		"\xD5\xBC" => '&#26793;',
		"\xD5\xBD" => '&#26741;',
		"\xD5\xBE" => '&#26740;',
		"\xD5\xBF" => '&#26802;',
		"\xD5\xC0" => '&#26767;',
		"\xD5\xC1" => '&#26743;',
		"\xD5\xC2" => '&#26770;',
		"\xD5\xC3" => '&#26748;',
		"\xD5\xC4" => '&#26731;',
		"\xD5\xC5" => '&#26738;',
		"\xD5\xC6" => '&#26794;',
		"\xD5\xC7" => '&#26752;',
		"\xD5\xC8" => '&#26737;',
		"\xD5\xC9" => '&#26750;',
		"\xD5\xCA" => '&#26779;',
		"\xD5\xCB" => '&#26774;',
		"\xD5\xCC" => '&#26763;',
		"\xD5\xCD" => '&#26784;',
		"\xD5\xCE" => '&#26761;',
		"\xD5\xCF" => '&#26788;',
		"\xD5\xD0" => '&#26744;',
		"\xD5\xD1" => '&#26747;',
		"\xD5\xD2" => '&#26769;',
		"\xD5\xD3" => '&#26764;',
		"\xD5\xD4" => '&#26762;',
		"\xD5\xD5" => '&#26749;',
		"\xD5\xD6" => '&#27446;',
		"\xD5\xD7" => '&#27443;',
		"\xD5\xD8" => '&#27447;',
		"\xD5\xD9" => '&#27448;',
		"\xD5\xDA" => '&#27537;',
		"\xD5\xDB" => '&#27535;',
		"\xD5\xDC" => '&#27533;',
		"\xD5\xDD" => '&#27534;',
		"\xD5\xDE" => '&#27532;',
		"\xD5\xDF" => '&#27690;',
		"\xD5\xE0" => '&#28096;',
		"\xD5\xE1" => '&#28075;',
		"\xD5\xE2" => '&#28084;',
		"\xD5\xE3" => '&#28083;',
		"\xD5\xE4" => '&#28276;',
		"\xD5\xE5" => '&#28076;',
		"\xD5\xE6" => '&#28137;',
		"\xD5\xE7" => '&#28130;',
		"\xD5\xE8" => '&#28087;',
		"\xD5\xE9" => '&#28150;',
		"\xD5\xEA" => '&#28116;',
		"\xD5\xEB" => '&#28160;',
		"\xD5\xEC" => '&#28104;',
		"\xD5\xED" => '&#28128;',
		"\xD5\xEE" => '&#28127;',
		"\xD5\xEF" => '&#28118;',
		"\xD5\xF0" => '&#28094;',
		"\xD5\xF1" => '&#28133;',
		"\xD5\xF2" => '&#28124;',
		"\xD5\xF3" => '&#28125;',
		"\xD5\xF4" => '&#28123;',
		"\xD5\xF5" => '&#28148;',
		"\xD5\xF6" => '&#28106;',
		"\xD5\xF7" => '&#28093;',
		"\xD5\xF8" => '&#28141;',
		"\xD5\xF9" => '&#28144;',
		"\xD5\xFA" => '&#28090;',
		"\xD5\xFB" => '&#28117;',
		"\xD5\xFC" => '&#28098;',
		"\xD5\xFD" => '&#28111;',
		"\xD5\xFE" => '&#28105;',
		"\xD6\x40" => '&#28112;',
		"\xD6\x41" => '&#28146;',
		"\xD6\x42" => '&#28115;',
		"\xD6\x43" => '&#28157;',
		"\xD6\x44" => '&#28119;',
		"\xD6\x45" => '&#28109;',
		"\xD6\x46" => '&#28131;',
		"\xD6\x47" => '&#28091;',
		"\xD6\x48" => '&#28922;',
		"\xD6\x49" => '&#28941;',
		"\xD6\x4A" => '&#28919;',
		"\xD6\x4B" => '&#28951;',
		"\xD6\x4C" => '&#28916;',
		"\xD6\x4D" => '&#28940;',
		"\xD6\x4E" => '&#28912;',
		"\xD6\x4F" => '&#28932;',
		"\xD6\x50" => '&#28915;',
		"\xD6\x51" => '&#28944;',
		"\xD6\x52" => '&#28924;',
		"\xD6\x53" => '&#28927;',
		"\xD6\x54" => '&#28934;',
		"\xD6\x55" => '&#28947;',
		"\xD6\x56" => '&#28928;',
		"\xD6\x57" => '&#28920;',
		"\xD6\x58" => '&#28918;',
		"\xD6\x59" => '&#28939;',
		"\xD6\x5A" => '&#28930;',
		"\xD6\x5B" => '&#28942;',
		"\xD6\x5C" => '&#29310;',
		"\xD6\x5D" => '&#29307;',
		"\xD6\x5E" => '&#29308;',
		"\xD6\x5F" => '&#29311;',
		"\xD6\x60" => '&#29469;',
		"\xD6\x61" => '&#29463;',
		"\xD6\x62" => '&#29447;',
		"\xD6\x63" => '&#29457;',
		"\xD6\x64" => '&#29464;',
		"\xD6\x65" => '&#29450;',
		"\xD6\x66" => '&#29448;',
		"\xD6\x67" => '&#29439;',
		"\xD6\x68" => '&#29455;',
		"\xD6\x69" => '&#29470;',
		"\xD6\x6A" => '&#29576;',
		"\xD6\x6B" => '&#29686;',
		"\xD6\x6C" => '&#29688;',
		"\xD6\x6D" => '&#29685;',
		"\xD6\x6E" => '&#29700;',
		"\xD6\x6F" => '&#29697;',
		"\xD6\x70" => '&#29693;',
		"\xD6\x71" => '&#29703;',
		"\xD6\x72" => '&#29696;',
		"\xD6\x73" => '&#29690;',
		"\xD6\x74" => '&#29692;',
		"\xD6\x75" => '&#29695;',
		"\xD6\x76" => '&#29708;',
		"\xD6\x77" => '&#29707;',
		"\xD6\x78" => '&#29684;',
		"\xD6\x79" => '&#29704;',
		"\xD6\x7A" => '&#30052;',
		"\xD6\x7B" => '&#30051;',
		"\xD6\x7C" => '&#30158;',
		"\xD6\x7D" => '&#30162;',
		"\xD6\x7E" => '&#30159;',
		"\xD6\xA1" => '&#30155;',
		"\xD6\xA2" => '&#30156;',
		"\xD6\xA3" => '&#30161;',
		"\xD6\xA4" => '&#30160;',
		"\xD6\xA5" => '&#30351;',
		"\xD6\xA6" => '&#30345;',
		"\xD6\xA7" => '&#30419;',
		"\xD6\xA8" => '&#30521;',
		"\xD6\xA9" => '&#30511;',
		"\xD6\xAA" => '&#30509;',
		"\xD6\xAB" => '&#30513;',
		"\xD6\xAC" => '&#30514;',
		"\xD6\xAD" => '&#30516;',
		"\xD6\xAE" => '&#30515;',
		"\xD6\xAF" => '&#30525;',
		"\xD6\xB0" => '&#30501;',
		"\xD6\xB1" => '&#30523;',
		"\xD6\xB2" => '&#30517;',
		"\xD6\xB3" => '&#30792;',
		"\xD6\xB4" => '&#30802;',
		"\xD6\xB5" => '&#30793;',
		"\xD6\xB6" => '&#30797;',
		"\xD6\xB7" => '&#30794;',
		"\xD6\xB8" => '&#30796;',
		"\xD6\xB9" => '&#30758;',
		"\xD6\xBA" => '&#30789;',
		"\xD6\xBB" => '&#30800;',
		"\xD6\xBC" => '&#31076;',
		"\xD6\xBD" => '&#31079;',
		"\xD6\xBE" => '&#31081;',
		"\xD6\xBF" => '&#31082;',
		"\xD6\xC0" => '&#31075;',
		"\xD6\xC1" => '&#31083;',
		"\xD6\xC2" => '&#31073;',
		"\xD6\xC3" => '&#31163;',
		"\xD6\xC4" => '&#31226;',
		"\xD6\xC5" => '&#31224;',
		"\xD6\xC6" => '&#31222;',
		"\xD6\xC7" => '&#31223;',
		"\xD6\xC8" => '&#31375;',
		"\xD6\xC9" => '&#31380;',
		"\xD6\xCA" => '&#31376;',
		"\xD6\xCB" => '&#31541;',
		"\xD6\xCC" => '&#31559;',
		"\xD6\xCD" => '&#31540;',
		"\xD6\xCE" => '&#31525;',
		"\xD6\xCF" => '&#31536;',
		"\xD6\xD0" => '&#31522;',
		"\xD6\xD1" => '&#31524;',
		"\xD6\xD2" => '&#31539;',
		"\xD6\xD3" => '&#31512;',
		"\xD6\xD4" => '&#31530;',
		"\xD6\xD5" => '&#31517;',
		"\xD6\xD6" => '&#31537;',
		"\xD6\xD7" => '&#31531;',
		"\xD6\xD8" => '&#31533;',
		"\xD6\xD9" => '&#31535;',
		"\xD6\xDA" => '&#31538;',
		"\xD6\xDB" => '&#31544;',
		"\xD6\xDC" => '&#31514;',
		"\xD6\xDD" => '&#31523;',
		"\xD6\xDE" => '&#31892;',
		"\xD6\xDF" => '&#31896;',
		"\xD6\xE0" => '&#31894;',
		"\xD6\xE1" => '&#31907;',
		"\xD6\xE2" => '&#32053;',
		"\xD6\xE3" => '&#32061;',
		"\xD6\xE4" => '&#32056;',
		"\xD6\xE5" => '&#32054;',
		"\xD6\xE6" => '&#32058;',
		"\xD6\xE7" => '&#32069;',
		"\xD6\xE8" => '&#32044;',
		"\xD6\xE9" => '&#32041;',
		"\xD6\xEA" => '&#32065;',
		"\xD6\xEB" => '&#32071;',
		"\xD6\xEC" => '&#32062;',
		"\xD6\xED" => '&#32063;',
		"\xD6\xEE" => '&#32074;',
		"\xD6\xEF" => '&#32059;',
		"\xD6\xF0" => '&#32040;',
		"\xD6\xF1" => '&#32611;',
		"\xD6\xF2" => '&#32661;',
		"\xD6\xF3" => '&#32668;',
		"\xD6\xF4" => '&#32669;',
		"\xD6\xF5" => '&#32667;',
		"\xD6\xF6" => '&#32714;',
		"\xD6\xF7" => '&#32715;',
		"\xD6\xF8" => '&#32717;',
		"\xD6\xF9" => '&#32720;',
		"\xD6\xFA" => '&#32721;',
		"\xD6\xFB" => '&#32711;',
		"\xD6\xFC" => '&#32719;',
		"\xD6\xFD" => '&#32713;',
		"\xD6\xFE" => '&#32799;',
		"\xD7\x40" => '&#32798;',
		"\xD7\x41" => '&#32795;',
		"\xD7\x42" => '&#32839;',
		"\xD7\x43" => '&#32835;',
		"\xD7\x44" => '&#32840;',
		"\xD7\x45" => '&#33048;',
		"\xD7\x46" => '&#33061;',
		"\xD7\x47" => '&#33049;',
		"\xD7\x48" => '&#33051;',
		"\xD7\x49" => '&#33069;',
		"\xD7\x4A" => '&#33055;',
		"\xD7\x4B" => '&#33068;',
		"\xD7\x4C" => '&#33054;',
		"\xD7\x4D" => '&#33057;',
		"\xD7\x4E" => '&#33045;',
		"\xD7\x4F" => '&#33063;',
		"\xD7\x50" => '&#33053;',
		"\xD7\x51" => '&#33058;',
		"\xD7\x52" => '&#33297;',
		"\xD7\x53" => '&#33336;',
		"\xD7\x54" => '&#33331;',
		"\xD7\x55" => '&#33338;',
		"\xD7\x56" => '&#33332;',
		"\xD7\x57" => '&#33330;',
		"\xD7\x58" => '&#33396;',
		"\xD7\x59" => '&#33680;',
		"\xD7\x5A" => '&#33699;',
		"\xD7\x5B" => '&#33704;',
		"\xD7\x5C" => '&#33677;',
		"\xD7\x5D" => '&#33658;',
		"\xD7\x5E" => '&#33651;',
		"\xD7\x5F" => '&#33700;',
		"\xD7\x60" => '&#33652;',
		"\xD7\x61" => '&#33679;',
		"\xD7\x62" => '&#33665;',
		"\xD7\x63" => '&#33685;',
		"\xD7\x64" => '&#33689;',
		"\xD7\x65" => '&#33653;',
		"\xD7\x66" => '&#33684;',
		"\xD7\x67" => '&#33705;',
		"\xD7\x68" => '&#33661;',
		"\xD7\x69" => '&#33667;',
		"\xD7\x6A" => '&#33676;',
		"\xD7\x6B" => '&#33693;',
		"\xD7\x6C" => '&#33691;',
		"\xD7\x6D" => '&#33706;',
		"\xD7\x6E" => '&#33675;',
		"\xD7\x6F" => '&#33662;',
		"\xD7\x70" => '&#33701;',
		"\xD7\x71" => '&#33711;',
		"\xD7\x72" => '&#33672;',
		"\xD7\x73" => '&#33687;',
		"\xD7\x74" => '&#33712;',
		"\xD7\x75" => '&#33663;',
		"\xD7\x76" => '&#33702;',
		"\xD7\x77" => '&#33671;',
		"\xD7\x78" => '&#33710;',
		"\xD7\x79" => '&#33654;',
		"\xD7\x7A" => '&#33690;',
		"\xD7\x7B" => '&#34393;',
		"\xD7\x7C" => '&#34390;',
		"\xD7\x7D" => '&#34495;',
		"\xD7\x7E" => '&#34487;',
		"\xD7\xA1" => '&#34498;',
		"\xD7\xA2" => '&#34497;',
		"\xD7\xA3" => '&#34501;',
		"\xD7\xA4" => '&#34490;',
		"\xD7\xA5" => '&#34480;',
		"\xD7\xA6" => '&#34504;',
		"\xD7\xA7" => '&#34489;',
		"\xD7\xA8" => '&#34483;',
		"\xD7\xA9" => '&#34488;',
		"\xD7\xAA" => '&#34508;',
		"\xD7\xAB" => '&#34484;',
		"\xD7\xAC" => '&#34491;',
		"\xD7\xAD" => '&#34492;',
		"\xD7\xAE" => '&#34499;',
		"\xD7\xAF" => '&#34493;',
		"\xD7\xB0" => '&#34494;',
		"\xD7\xB1" => '&#34898;',
		"\xD7\xB2" => '&#34953;',
		"\xD7\xB3" => '&#34965;',
		"\xD7\xB4" => '&#34984;',
		"\xD7\xB5" => '&#34978;',
		"\xD7\xB6" => '&#34986;',
		"\xD7\xB7" => '&#34970;',
		"\xD7\xB8" => '&#34961;',
		"\xD7\xB9" => '&#34977;',
		"\xD7\xBA" => '&#34975;',
		"\xD7\xBB" => '&#34968;',
		"\xD7\xBC" => '&#34983;',
		"\xD7\xBD" => '&#34969;',
		"\xD7\xBE" => '&#34971;',
		"\xD7\xBF" => '&#34967;',
		"\xD7\xC0" => '&#34980;',
		"\xD7\xC1" => '&#34988;',
		"\xD7\xC2" => '&#34956;',
		"\xD7\xC3" => '&#34963;',
		"\xD7\xC4" => '&#34958;',
		"\xD7\xC5" => '&#35202;',
		"\xD7\xC6" => '&#35286;',
		"\xD7\xC7" => '&#35289;',
		"\xD7\xC8" => '&#35285;',
		"\xD7\xC9" => '&#35376;',
		"\xD7\xCA" => '&#35367;',
		"\xD7\xCB" => '&#35372;',
		"\xD7\xCC" => '&#35358;',
		"\xD7\xCD" => '&#35897;',
		"\xD7\xCE" => '&#35899;',
		"\xD7\xCF" => '&#35932;',
		"\xD7\xD0" => '&#35933;',
		"\xD7\xD1" => '&#35965;',
		"\xD7\xD2" => '&#36005;',
		"\xD7\xD3" => '&#36221;',
		"\xD7\xD4" => '&#36219;',
		"\xD7\xD5" => '&#36217;',
		"\xD7\xD6" => '&#36284;',
		"\xD7\xD7" => '&#36290;',
		"\xD7\xD8" => '&#36281;',
		"\xD7\xD9" => '&#36287;',
		"\xD7\xDA" => '&#36289;',
		"\xD7\xDB" => '&#36568;',
		"\xD7\xDC" => '&#36574;',
		"\xD7\xDD" => '&#36573;',
		"\xD7\xDE" => '&#36572;',
		"\xD7\xDF" => '&#36567;',
		"\xD7\xE0" => '&#36576;',
		"\xD7\xE1" => '&#36577;',
		"\xD7\xE2" => '&#36900;',
		"\xD7\xE3" => '&#36875;',
		"\xD7\xE4" => '&#36881;',
		"\xD7\xE5" => '&#36892;',
		"\xD7\xE6" => '&#36876;',
		"\xD7\xE7" => '&#36897;',
		"\xD7\xE8" => '&#37103;',
		"\xD7\xE9" => '&#37098;',
		"\xD7\xEA" => '&#37104;',
		"\xD7\xEB" => '&#37108;',
		"\xD7\xEC" => '&#37106;',
		"\xD7\xED" => '&#37107;',
		"\xD7\xEE" => '&#37076;',
		"\xD7\xEF" => '&#37099;',
		"\xD7\xF0" => '&#37100;',
		"\xD7\xF1" => '&#37097;',
		"\xD7\xF2" => '&#37206;',
		"\xD7\xF3" => '&#37208;',
		"\xD7\xF4" => '&#37210;',
		"\xD7\xF5" => '&#37203;',
		"\xD7\xF6" => '&#37205;',
		"\xD7\xF7" => '&#37356;',
		"\xD7\xF8" => '&#37364;',
		"\xD7\xF9" => '&#37361;',
		"\xD7\xFA" => '&#37363;',
		"\xD7\xFB" => '&#37368;',
		"\xD7\xFC" => '&#37348;',
		"\xD7\xFD" => '&#37369;',
		"\xD7\xFE" => '&#37354;',
		"\xD8\x40" => '&#37355;',
		"\xD8\x41" => '&#37367;',
		"\xD8\x42" => '&#37352;',
		"\xD8\x43" => '&#37358;',
		"\xD8\x44" => '&#38266;',
		"\xD8\x45" => '&#38278;',
		"\xD8\x46" => '&#38280;',
		"\xD8\x47" => '&#38524;',
		"\xD8\x48" => '&#38509;',
		"\xD8\x49" => '&#38507;',
		"\xD8\x4A" => '&#38513;',
		"\xD8\x4B" => '&#38511;',
		"\xD8\x4C" => '&#38591;',
		"\xD8\x4D" => '&#38762;',
		"\xD8\x4E" => '&#38916;',
		"\xD8\x4F" => '&#39141;',
		"\xD8\x50" => '&#39319;',
		"\xD8\x51" => '&#20635;',
		"\xD8\x52" => '&#20629;',
		"\xD8\x53" => '&#20628;',
		"\xD8\x54" => '&#20638;',
		"\xD8\x55" => '&#20619;',
		"\xD8\x56" => '&#20643;',
		"\xD8\x57" => '&#20611;',
		"\xD8\x58" => '&#20620;',
		"\xD8\x59" => '&#20622;',
		"\xD8\x5A" => '&#20637;',
		"\xD8\x5B" => '&#20584;',
		"\xD8\x5C" => '&#20636;',
		"\xD8\x5D" => '&#20626;',
		"\xD8\x5E" => '&#20610;',
		"\xD8\x5F" => '&#20615;',
		"\xD8\x60" => '&#20831;',
		"\xD8\x61" => '&#20948;',
		"\xD8\x62" => '&#21266;',
		"\xD8\x63" => '&#21265;',
		"\xD8\x64" => '&#21412;',
		"\xD8\x65" => '&#21415;',
		"\xD8\x66" => '&#21905;',
		"\xD8\x67" => '&#21928;',
		"\xD8\x68" => '&#21925;',
		"\xD8\x69" => '&#21933;',
		"\xD8\x6A" => '&#21879;',
		"\xD8\x6B" => '&#22085;',
		"\xD8\x6C" => '&#21922;',
		"\xD8\x6D" => '&#21907;',
		"\xD8\x6E" => '&#21896;',
		"\xD8\x6F" => '&#21903;',
		"\xD8\x70" => '&#21941;',
		"\xD8\x71" => '&#21889;',
		"\xD8\x72" => '&#21923;',
		"\xD8\x73" => '&#21906;',
		"\xD8\x74" => '&#21924;',
		"\xD8\x75" => '&#21885;',
		"\xD8\x76" => '&#21900;',
		"\xD8\x77" => '&#21926;',
		"\xD8\x78" => '&#21887;',
		"\xD8\x79" => '&#21909;',
		"\xD8\x7A" => '&#21921;',
		"\xD8\x7B" => '&#21902;',
		"\xD8\x7C" => '&#22284;',
		"\xD8\x7D" => '&#22569;',
		"\xD8\x7E" => '&#22583;',
		"\xD8\xA1" => '&#22553;',
		"\xD8\xA2" => '&#22558;',
		"\xD8\xA3" => '&#22567;',
		"\xD8\xA4" => '&#22563;',
		"\xD8\xA5" => '&#22568;',
		"\xD8\xA6" => '&#22517;',
		"\xD8\xA7" => '&#22600;',
		"\xD8\xA8" => '&#22565;',
		"\xD8\xA9" => '&#22556;',
		"\xD8\xAA" => '&#22555;',
		"\xD8\xAB" => '&#22579;',
		"\xD8\xAC" => '&#22591;',
		"\xD8\xAD" => '&#22582;',
		"\xD8\xAE" => '&#22574;',
		"\xD8\xAF" => '&#22585;',
		"\xD8\xB0" => '&#22584;',
		"\xD8\xB1" => '&#22573;',
		"\xD8\xB2" => '&#22572;',
		"\xD8\xB3" => '&#22587;',
		"\xD8\xB4" => '&#22881;',
		"\xD8\xB5" => '&#23215;',
		"\xD8\xB6" => '&#23188;',
		"\xD8\xB7" => '&#23199;',
		"\xD8\xB8" => '&#23162;',
		"\xD8\xB9" => '&#23202;',
		"\xD8\xBA" => '&#23198;',
		"\xD8\xBB" => '&#23160;',
		"\xD8\xBC" => '&#23206;',
		"\xD8\xBD" => '&#23164;',
		"\xD8\xBE" => '&#23205;',
		"\xD8\xBF" => '&#23212;',
		"\xD8\xC0" => '&#23189;',
		"\xD8\xC1" => '&#23214;',
		"\xD8\xC2" => '&#23095;',
		"\xD8\xC3" => '&#23172;',
		"\xD8\xC4" => '&#23178;',
		"\xD8\xC5" => '&#23191;',
		"\xD8\xC6" => '&#23171;',
		"\xD8\xC7" => '&#23179;',
		"\xD8\xC8" => '&#23209;',
		"\xD8\xC9" => '&#23163;',
		"\xD8\xCA" => '&#23165;',
		"\xD8\xCB" => '&#23180;',
		"\xD8\xCC" => '&#23196;',
		"\xD8\xCD" => '&#23183;',
		"\xD8\xCE" => '&#23187;',
		"\xD8\xCF" => '&#23197;',
		"\xD8\xD0" => '&#23530;',
		"\xD8\xD1" => '&#23501;',
		"\xD8\xD2" => '&#23499;',
		"\xD8\xD3" => '&#23508;',
		"\xD8\xD4" => '&#23505;',
		"\xD8\xD5" => '&#23498;',
		"\xD8\xD6" => '&#23502;',
		"\xD8\xD7" => '&#23564;',
		"\xD8\xD8" => '&#23600;',
		"\xD8\xD9" => '&#23863;',
		"\xD8\xDA" => '&#23875;',
		"\xD8\xDB" => '&#23915;',
		"\xD8\xDC" => '&#23873;',
		"\xD8\xDD" => '&#23883;',
		"\xD8\xDE" => '&#23871;',
		"\xD8\xDF" => '&#23861;',
		"\xD8\xE0" => '&#23889;',
		"\xD8\xE1" => '&#23886;',
		"\xD8\xE2" => '&#23893;',
		"\xD8\xE3" => '&#23859;',
		"\xD8\xE4" => '&#23866;',
		"\xD8\xE5" => '&#23890;',
		"\xD8\xE6" => '&#23869;',
		"\xD8\xE7" => '&#23857;',
		"\xD8\xE8" => '&#23897;',
		"\xD8\xE9" => '&#23874;',
		"\xD8\xEA" => '&#23865;',
		"\xD8\xEB" => '&#23881;',
		"\xD8\xEC" => '&#23864;',
		"\xD8\xED" => '&#23868;',
		"\xD8\xEE" => '&#23858;',
		"\xD8\xEF" => '&#23862;',
		"\xD8\xF0" => '&#23872;',
		"\xD8\xF1" => '&#23877;',
		"\xD8\xF2" => '&#24132;',
		"\xD8\xF3" => '&#24129;',
		"\xD8\xF4" => '&#24408;',
		"\xD8\xF5" => '&#24486;',
		"\xD8\xF6" => '&#24485;',
		"\xD8\xF7" => '&#24491;',
		"\xD8\xF8" => '&#24777;',
		"\xD8\xF9" => '&#24761;',
		"\xD8\xFA" => '&#24780;',
		"\xD8\xFB" => '&#24802;',
		"\xD8\xFC" => '&#24782;',
		"\xD8\xFD" => '&#24772;',
		"\xD8\xFE" => '&#24852;',
		"\xD9\x40" => '&#24818;',
		"\xD9\x41" => '&#24842;',
		"\xD9\x42" => '&#24854;',
		"\xD9\x43" => '&#24837;',
		"\xD9\x44" => '&#24821;',
		"\xD9\x45" => '&#24851;',
		"\xD9\x46" => '&#24824;',
		"\xD9\x47" => '&#24828;',
		"\xD9\x48" => '&#24830;',
		"\xD9\x49" => '&#24769;',
		"\xD9\x4A" => '&#24835;',
		"\xD9\x4B" => '&#24856;',
		"\xD9\x4C" => '&#24861;',
		"\xD9\x4D" => '&#24848;',
		"\xD9\x4E" => '&#24831;',
		"\xD9\x4F" => '&#24836;',
		"\xD9\x50" => '&#24843;',
		"\xD9\x51" => '&#25162;',
		"\xD9\x52" => '&#25492;',
		"\xD9\x53" => '&#25521;',
		"\xD9\x54" => '&#25520;',
		"\xD9\x55" => '&#25550;',
		"\xD9\x56" => '&#25573;',
		"\xD9\x57" => '&#25576;',
		"\xD9\x58" => '&#25583;',
		"\xD9\x59" => '&#25539;',
		"\xD9\x5A" => '&#25757;',
		"\xD9\x5B" => '&#25587;',
		"\xD9\x5C" => '&#25546;',
		"\xD9\x5D" => '&#25568;',
		"\xD9\x5E" => '&#25590;',
		"\xD9\x5F" => '&#25557;',
		"\xD9\x60" => '&#25586;',
		"\xD9\x61" => '&#25589;',
		"\xD9\x62" => '&#25697;',
		"\xD9\x63" => '&#25567;',
		"\xD9\x64" => '&#25534;',
		"\xD9\x65" => '&#25565;',
		"\xD9\x66" => '&#25564;',
		"\xD9\x67" => '&#25540;',
		"\xD9\x68" => '&#25560;',
		"\xD9\x69" => '&#25555;',
		"\xD9\x6A" => '&#25538;',
		"\xD9\x6B" => '&#25543;',
		"\xD9\x6C" => '&#25548;',
		"\xD9\x6D" => '&#25547;',
		"\xD9\x6E" => '&#25544;',
		"\xD9\x6F" => '&#25584;',
		"\xD9\x70" => '&#25559;',
		"\xD9\x71" => '&#25561;',
		"\xD9\x72" => '&#25906;',
		"\xD9\x73" => '&#25959;',
		"\xD9\x74" => '&#25962;',
		"\xD9\x75" => '&#25956;',
		"\xD9\x76" => '&#25948;',
		"\xD9\x77" => '&#25960;',
		"\xD9\x78" => '&#25957;',
		"\xD9\x79" => '&#25996;',
		"\xD9\x7A" => '&#26013;',
		"\xD9\x7B" => '&#26014;',
		"\xD9\x7C" => '&#26030;',
		"\xD9\x7D" => '&#26064;',
		"\xD9\x7E" => '&#26066;',
		"\xD9\xA1" => '&#26236;',
		"\xD9\xA2" => '&#26220;',
		"\xD9\xA3" => '&#26235;',
		"\xD9\xA4" => '&#26240;',
		"\xD9\xA5" => '&#26225;',
		"\xD9\xA6" => '&#26233;',
		"\xD9\xA7" => '&#26218;',
		"\xD9\xA8" => '&#26226;',
		"\xD9\xA9" => '&#26369;',
		"\xD9\xAA" => '&#26892;',
		"\xD9\xAB" => '&#26835;',
		"\xD9\xAC" => '&#26884;',
		"\xD9\xAD" => '&#26844;',
		"\xD9\xAE" => '&#26922;',
		"\xD9\xAF" => '&#26860;',
		"\xD9\xB0" => '&#26858;',
		"\xD9\xB1" => '&#26865;',
		"\xD9\xB2" => '&#26895;',
		"\xD9\xB3" => '&#26838;',
		"\xD9\xB4" => '&#26871;',
		"\xD9\xB5" => '&#26859;',
		"\xD9\xB6" => '&#26852;',
		"\xD9\xB7" => '&#26870;',
		"\xD9\xB8" => '&#26899;',
		"\xD9\xB9" => '&#26896;',
		"\xD9\xBA" => '&#26867;',
		"\xD9\xBB" => '&#26849;',
		"\xD9\xBC" => '&#26887;',
		"\xD9\xBD" => '&#26828;',
		"\xD9\xBE" => '&#26888;',
		"\xD9\xBF" => '&#26992;',
		"\xD9\xC0" => '&#26804;',
		"\xD9\xC1" => '&#26897;',
		"\xD9\xC2" => '&#26863;',
		"\xD9\xC3" => '&#26822;',
		"\xD9\xC4" => '&#26900;',
		"\xD9\xC5" => '&#26872;',
		"\xD9\xC6" => '&#26832;',
		"\xD9\xC7" => '&#26877;',
		"\xD9\xC8" => '&#26876;',
		"\xD9\xC9" => '&#26856;',
		"\xD9\xCA" => '&#26891;',
		"\xD9\xCB" => '&#26890;',
		"\xD9\xCC" => '&#26903;',
		"\xD9\xCD" => '&#26830;',
		"\xD9\xCE" => '&#26824;',
		"\xD9\xCF" => '&#26845;',
		"\xD9\xD0" => '&#26846;',
		"\xD9\xD1" => '&#26854;',
		"\xD9\xD2" => '&#26868;',
		"\xD9\xD3" => '&#26833;',
		"\xD9\xD4" => '&#26886;',
		"\xD9\xD5" => '&#26836;',
		"\xD9\xD6" => '&#26857;',
		"\xD9\xD7" => '&#26901;',
		"\xD9\xD8" => '&#26917;',
		"\xD9\xD9" => '&#26823;',
		"\xD9\xDA" => '&#27449;',
		"\xD9\xDB" => '&#27451;',
		"\xD9\xDC" => '&#27455;',
		"\xD9\xDD" => '&#27452;',
		"\xD9\xDE" => '&#27540;',
		"\xD9\xDF" => '&#27543;',
		"\xD9\xE0" => '&#27545;',
		"\xD9\xE1" => '&#27541;',
		"\xD9\xE2" => '&#27581;',
		"\xD9\xE3" => '&#27632;',
		"\xD9\xE4" => '&#27634;',
		"\xD9\xE5" => '&#27635;',
		"\xD9\xE6" => '&#27696;',
		"\xD9\xE7" => '&#28156;',
		"\xD9\xE8" => '&#28230;',
		"\xD9\xE9" => '&#28231;',
		"\xD9\xEA" => '&#28191;',
		"\xD9\xEB" => '&#28233;',
		"\xD9\xEC" => '&#28296;',
		"\xD9\xED" => '&#28220;',
		"\xD9\xEE" => '&#28221;',
		"\xD9\xEF" => '&#28229;',
		"\xD9\xF0" => '&#28258;',
		"\xD9\xF1" => '&#28203;',
		"\xD9\xF2" => '&#28223;',
		"\xD9\xF3" => '&#28225;',
		"\xD9\xF4" => '&#28253;',
		"\xD9\xF5" => '&#28275;',
		"\xD9\xF6" => '&#28188;',
		"\xD9\xF7" => '&#28211;',
		"\xD9\xF8" => '&#28235;',
		"\xD9\xF9" => '&#28224;',
		"\xD9\xFA" => '&#28241;',
		"\xD9\xFB" => '&#28219;',
		"\xD9\xFC" => '&#28163;',
		"\xD9\xFD" => '&#28206;',
		"\xD9\xFE" => '&#28254;',
		"\xDA\x40" => '&#28264;',
		"\xDA\x41" => '&#28252;',
		"\xDA\x42" => '&#28257;',
		"\xDA\x43" => '&#28209;',
		"\xDA\x44" => '&#28200;',
		"\xDA\x45" => '&#28256;',
		"\xDA\x46" => '&#28273;',
		"\xDA\x47" => '&#28267;',
		"\xDA\x48" => '&#28217;',
		"\xDA\x49" => '&#28194;',
		"\xDA\x4A" => '&#28208;',
		"\xDA\x4B" => '&#28243;',
		"\xDA\x4C" => '&#28261;',
		"\xDA\x4D" => '&#28199;',
		"\xDA\x4E" => '&#28280;',
		"\xDA\x4F" => '&#28260;',
		"\xDA\x50" => '&#28279;',
		"\xDA\x51" => '&#28245;',
		"\xDA\x52" => '&#28281;',
		"\xDA\x53" => '&#28242;',
		"\xDA\x54" => '&#28262;',
		"\xDA\x55" => '&#28213;',
		"\xDA\x56" => '&#28214;',
		"\xDA\x57" => '&#28250;',
		"\xDA\x58" => '&#28960;',
		"\xDA\x59" => '&#28958;',
		"\xDA\x5A" => '&#28975;',
		"\xDA\x5B" => '&#28923;',
		"\xDA\x5C" => '&#28974;',
		"\xDA\x5D" => '&#28977;',
		"\xDA\x5E" => '&#28963;',
		"\xDA\x5F" => '&#28965;',
		"\xDA\x60" => '&#28962;',
		"\xDA\x61" => '&#28978;',
		"\xDA\x62" => '&#28959;',
		"\xDA\x63" => '&#28968;',
		"\xDA\x64" => '&#28986;',
		"\xDA\x65" => '&#28955;',
		"\xDA\x66" => '&#29259;',
		"\xDA\x67" => '&#29274;',
		"\xDA\x68" => '&#29320;',
		"\xDA\x69" => '&#29321;',
		"\xDA\x6A" => '&#29318;',
		"\xDA\x6B" => '&#29317;',
		"\xDA\x6C" => '&#29323;',
		"\xDA\x6D" => '&#29458;',
		"\xDA\x6E" => '&#29451;',
		"\xDA\x6F" => '&#29488;',
		"\xDA\x70" => '&#29474;',
		"\xDA\x71" => '&#29489;',
		"\xDA\x72" => '&#29491;',
		"\xDA\x73" => '&#29479;',
		"\xDA\x74" => '&#29490;',
		"\xDA\x75" => '&#29485;',
		"\xDA\x76" => '&#29478;',
		"\xDA\x77" => '&#29475;',
		"\xDA\x78" => '&#29493;',
		"\xDA\x79" => '&#29452;',
		"\xDA\x7A" => '&#29742;',
		"\xDA\x7B" => '&#29740;',
		"\xDA\x7C" => '&#29744;',
		"\xDA\x7D" => '&#29739;',
		"\xDA\x7E" => '&#29718;',
		"\xDA\xA1" => '&#29722;',
		"\xDA\xA2" => '&#29729;',
		"\xDA\xA3" => '&#29741;',
		"\xDA\xA4" => '&#29745;',
		"\xDA\xA5" => '&#29732;',
		"\xDA\xA6" => '&#29731;',
		"\xDA\xA7" => '&#29725;',
		"\xDA\xA8" => '&#29737;',
		"\xDA\xA9" => '&#29728;',
		"\xDA\xAA" => '&#29746;',
		"\xDA\xAB" => '&#29947;',
		"\xDA\xAC" => '&#29999;',
		"\xDA\xAD" => '&#30063;',
		"\xDA\xAE" => '&#30060;',
		"\xDA\xAF" => '&#30183;',
		"\xDA\xB0" => '&#30170;',
		"\xDA\xB1" => '&#30177;',
		"\xDA\xB2" => '&#30182;',
		"\xDA\xB3" => '&#30173;',
		"\xDA\xB4" => '&#30175;',
		"\xDA\xB5" => '&#30180;',
		"\xDA\xB6" => '&#30167;',
		"\xDA\xB7" => '&#30357;',
		"\xDA\xB8" => '&#30354;',
		"\xDA\xB9" => '&#30426;',
		"\xDA\xBA" => '&#30534;',
		"\xDA\xBB" => '&#30535;',
		"\xDA\xBC" => '&#30532;',
		"\xDA\xBD" => '&#30541;',
		"\xDA\xBE" => '&#30533;',
		"\xDA\xBF" => '&#30538;',
		"\xDA\xC0" => '&#30542;',
		"\xDA\xC1" => '&#30539;',
		"\xDA\xC2" => '&#30540;',
		"\xDA\xC3" => '&#30686;',
		"\xDA\xC4" => '&#30700;',
		"\xDA\xC5" => '&#30816;',
		"\xDA\xC6" => '&#30820;',
		"\xDA\xC7" => '&#30821;',
		"\xDA\xC8" => '&#30812;',
		"\xDA\xC9" => '&#30829;',
		"\xDA\xCA" => '&#30833;',
		"\xDA\xCB" => '&#30826;',
		"\xDA\xCC" => '&#30830;',
		"\xDA\xCD" => '&#30832;',
		"\xDA\xCE" => '&#30825;',
		"\xDA\xCF" => '&#30824;',
		"\xDA\xD0" => '&#30814;',
		"\xDA\xD1" => '&#30818;',
		"\xDA\xD2" => '&#31092;',
		"\xDA\xD3" => '&#31091;',
		"\xDA\xD4" => '&#31090;',
		"\xDA\xD5" => '&#31088;',
		"\xDA\xD6" => '&#31234;',
		"\xDA\xD7" => '&#31242;',
		"\xDA\xD8" => '&#31235;',
		"\xDA\xD9" => '&#31244;',
		"\xDA\xDA" => '&#31236;',
		"\xDA\xDB" => '&#31385;',
		"\xDA\xDC" => '&#31462;',
		"\xDA\xDD" => '&#31460;',
		"\xDA\xDE" => '&#31562;',
		"\xDA\xDF" => '&#31547;',
		"\xDA\xE0" => '&#31556;',
		"\xDA\xE1" => '&#31560;',
		"\xDA\xE2" => '&#31564;',
		"\xDA\xE3" => '&#31566;',
		"\xDA\xE4" => '&#31552;',
		"\xDA\xE5" => '&#31576;',
		"\xDA\xE6" => '&#31557;',
		"\xDA\xE7" => '&#31906;',
		"\xDA\xE8" => '&#31902;',
		"\xDA\xE9" => '&#31912;',
		"\xDA\xEA" => '&#31905;',
		"\xDA\xEB" => '&#32088;',
		"\xDA\xEC" => '&#32111;',
		"\xDA\xED" => '&#32099;',
		"\xDA\xEE" => '&#32083;',
		"\xDA\xEF" => '&#32086;',
		"\xDA\xF0" => '&#32103;',
		"\xDA\xF1" => '&#32106;',
		"\xDA\xF2" => '&#32079;',
		"\xDA\xF3" => '&#32109;',
		"\xDA\xF4" => '&#32092;',
		"\xDA\xF5" => '&#32107;',
		"\xDA\xF6" => '&#32082;',
		"\xDA\xF7" => '&#32084;',
		"\xDA\xF8" => '&#32105;',
		"\xDA\xF9" => '&#32081;',
		"\xDA\xFA" => '&#32095;',
		"\xDA\xFB" => '&#32078;',
		"\xDA\xFC" => '&#32574;',
		"\xDA\xFD" => '&#32575;',
		"\xDA\xFE" => '&#32613;',
		"\xDB\x40" => '&#32614;',
		"\xDB\x41" => '&#32674;',
		"\xDB\x42" => '&#32672;',
		"\xDB\x43" => '&#32673;',
		"\xDB\x44" => '&#32727;',
		"\xDB\x45" => '&#32849;',
		"\xDB\x46" => '&#32847;',
		"\xDB\x47" => '&#32848;',
		"\xDB\x48" => '&#33022;',
		"\xDB\x49" => '&#32980;',
		"\xDB\x4A" => '&#33091;',
		"\xDB\x4B" => '&#33098;',
		"\xDB\x4C" => '&#33106;',
		"\xDB\x4D" => '&#33103;',
		"\xDB\x4E" => '&#33095;',
		"\xDB\x4F" => '&#33085;',
		"\xDB\x50" => '&#33101;',
		"\xDB\x51" => '&#33082;',
		"\xDB\x52" => '&#33254;',
		"\xDB\x53" => '&#33262;',
		"\xDB\x54" => '&#33271;',
		"\xDB\x55" => '&#33272;',
		"\xDB\x56" => '&#33273;',
		"\xDB\x57" => '&#33284;',
		"\xDB\x58" => '&#33340;',
		"\xDB\x59" => '&#33341;',
		"\xDB\x5A" => '&#33343;',
		"\xDB\x5B" => '&#33397;',
		"\xDB\x5C" => '&#33595;',
		"\xDB\x5D" => '&#33743;',
		"\xDB\x5E" => '&#33785;',
		"\xDB\x5F" => '&#33827;',
		"\xDB\x60" => '&#33728;',
		"\xDB\x61" => '&#33768;',
		"\xDB\x62" => '&#33810;',
		"\xDB\x63" => '&#33767;',
		"\xDB\x64" => '&#33764;',
		"\xDB\x65" => '&#33788;',
		"\xDB\x66" => '&#33782;',
		"\xDB\x67" => '&#33808;',
		"\xDB\x68" => '&#33734;',
		"\xDB\x69" => '&#33736;',
		"\xDB\x6A" => '&#33771;',
		"\xDB\x6B" => '&#33763;',
		"\xDB\x6C" => '&#33727;',
		"\xDB\x6D" => '&#33793;',
		"\xDB\x6E" => '&#33757;',
		"\xDB\x6F" => '&#33765;',
		"\xDB\x70" => '&#33752;',
		"\xDB\x71" => '&#33791;',
		"\xDB\x72" => '&#33761;',
		"\xDB\x73" => '&#33739;',
		"\xDB\x74" => '&#33742;',
		"\xDB\x75" => '&#33750;',
		"\xDB\x76" => '&#33781;',
		"\xDB\x77" => '&#33737;',
		"\xDB\x78" => '&#33801;',
		"\xDB\x79" => '&#33807;',
		"\xDB\x7A" => '&#33758;',
		"\xDB\x7B" => '&#33809;',
		"\xDB\x7C" => '&#33798;',
		"\xDB\x7D" => '&#33730;',
		"\xDB\x7E" => '&#33779;',
		"\xDB\xA1" => '&#33749;',
		"\xDB\xA2" => '&#33786;',
		"\xDB\xA3" => '&#33735;',
		"\xDB\xA4" => '&#33745;',
		"\xDB\xA5" => '&#33770;',
		"\xDB\xA6" => '&#33811;',
		"\xDB\xA7" => '&#33731;',
		"\xDB\xA8" => '&#33772;',
		"\xDB\xA9" => '&#33774;',
		"\xDB\xAA" => '&#33732;',
		"\xDB\xAB" => '&#33787;',
		"\xDB\xAC" => '&#33751;',
		"\xDB\xAD" => '&#33762;',
		"\xDB\xAE" => '&#33819;',
		"\xDB\xAF" => '&#33755;',
		"\xDB\xB0" => '&#33790;',
		"\xDB\xB1" => '&#34520;',
		"\xDB\xB2" => '&#34530;',
		"\xDB\xB3" => '&#34534;',
		"\xDB\xB4" => '&#34515;',
		"\xDB\xB5" => '&#34531;',
		"\xDB\xB6" => '&#34522;',
		"\xDB\xB7" => '&#34538;',
		"\xDB\xB8" => '&#34525;',
		"\xDB\xB9" => '&#34539;',
		"\xDB\xBA" => '&#34524;',
		"\xDB\xBB" => '&#34540;',
		"\xDB\xBC" => '&#34537;',
		"\xDB\xBD" => '&#34519;',
		"\xDB\xBE" => '&#34536;',
		"\xDB\xBF" => '&#34513;',
		"\xDB\xC0" => '&#34888;',
		"\xDB\xC1" => '&#34902;',
		"\xDB\xC2" => '&#34901;',
		"\xDB\xC3" => '&#35002;',
		"\xDB\xC4" => '&#35031;',
		"\xDB\xC5" => '&#35001;',
		"\xDB\xC6" => '&#35000;',
		"\xDB\xC7" => '&#35008;',
		"\xDB\xC8" => '&#35006;',
		"\xDB\xC9" => '&#34998;',
		"\xDB\xCA" => '&#35004;',
		"\xDB\xCB" => '&#34999;',
		"\xDB\xCC" => '&#35005;',
		"\xDB\xCD" => '&#34994;',
		"\xDB\xCE" => '&#35073;',
		"\xDB\xCF" => '&#35017;',
		"\xDB\xD0" => '&#35221;',
		"\xDB\xD1" => '&#35224;',
		"\xDB\xD2" => '&#35223;',
		"\xDB\xD3" => '&#35293;',
		"\xDB\xD4" => '&#35290;',
		"\xDB\xD5" => '&#35291;',
		"\xDB\xD6" => '&#35406;',
		"\xDB\xD7" => '&#35405;',
		"\xDB\xD8" => '&#35385;',
		"\xDB\xD9" => '&#35417;',
		"\xDB\xDA" => '&#35392;',
		"\xDB\xDB" => '&#35415;',
		"\xDB\xDC" => '&#35416;',
		"\xDB\xDD" => '&#35396;',
		"\xDB\xDE" => '&#35397;',
		"\xDB\xDF" => '&#35410;',
		"\xDB\xE0" => '&#35400;',
		"\xDB\xE1" => '&#35409;',
		"\xDB\xE2" => '&#35402;',
		"\xDB\xE3" => '&#35404;',
		"\xDB\xE4" => '&#35407;',
		"\xDB\xE5" => '&#35935;',
		"\xDB\xE6" => '&#35969;',
		"\xDB\xE7" => '&#35968;',
		"\xDB\xE8" => '&#36026;',
		"\xDB\xE9" => '&#36030;',
		"\xDB\xEA" => '&#36016;',
		"\xDB\xEB" => '&#36025;',
		"\xDB\xEC" => '&#36021;',
		"\xDB\xED" => '&#36228;',
		"\xDB\xEE" => '&#36224;',
		"\xDB\xEF" => '&#36233;',
		"\xDB\xF0" => '&#36312;',
		"\xDB\xF1" => '&#36307;',
		"\xDB\xF2" => '&#36301;',
		"\xDB\xF3" => '&#36295;',
		"\xDB\xF4" => '&#36310;',
		"\xDB\xF5" => '&#36316;',
		"\xDB\xF6" => '&#36303;',
		"\xDB\xF7" => '&#36309;',
		"\xDB\xF8" => '&#36313;',
		"\xDB\xF9" => '&#36296;',
		"\xDB\xFA" => '&#36311;',
		"\xDB\xFB" => '&#36293;',
		"\xDB\xFC" => '&#36591;',
		"\xDB\xFD" => '&#36599;',
		"\xDB\xFE" => '&#36602;',
		"\xDC\x40" => '&#36601;',
		"\xDC\x41" => '&#36582;',
		"\xDC\x42" => '&#36590;',
		"\xDC\x43" => '&#36581;',
		"\xDC\x44" => '&#36597;',
		"\xDC\x45" => '&#36583;',
		"\xDC\x46" => '&#36584;',
		"\xDC\x47" => '&#36598;',
		"\xDC\x48" => '&#36587;',
		"\xDC\x49" => '&#36593;',
		"\xDC\x4A" => '&#36588;',
		"\xDC\x4B" => '&#36596;',
		"\xDC\x4C" => '&#36585;',
		"\xDC\x4D" => '&#36909;',
		"\xDC\x4E" => '&#36916;',
		"\xDC\x4F" => '&#36911;',
		"\xDC\x50" => '&#37126;',
		"\xDC\x51" => '&#37164;',
		"\xDC\x52" => '&#37124;',
		"\xDC\x53" => '&#37119;',
		"\xDC\x54" => '&#37116;',
		"\xDC\x55" => '&#37128;',
		"\xDC\x56" => '&#37113;',
		"\xDC\x57" => '&#37115;',
		"\xDC\x58" => '&#37121;',
		"\xDC\x59" => '&#37120;',
		"\xDC\x5A" => '&#37127;',
		"\xDC\x5B" => '&#37125;',
		"\xDC\x5C" => '&#37123;',
		"\xDC\x5D" => '&#37217;',
		"\xDC\x5E" => '&#37220;',
		"\xDC\x5F" => '&#37215;',
		"\xDC\x60" => '&#37218;',
		"\xDC\x61" => '&#37216;',
		"\xDC\x62" => '&#37377;',
		"\xDC\x63" => '&#37386;',
		"\xDC\x64" => '&#37413;',
		"\xDC\x65" => '&#37379;',
		"\xDC\x66" => '&#37402;',
		"\xDC\x67" => '&#37414;',
		"\xDC\x68" => '&#37391;',
		"\xDC\x69" => '&#37388;',
		"\xDC\x6A" => '&#37376;',
		"\xDC\x6B" => '&#37394;',
		"\xDC\x6C" => '&#37375;',
		"\xDC\x6D" => '&#37373;',
		"\xDC\x6E" => '&#37382;',
		"\xDC\x6F" => '&#37380;',
		"\xDC\x70" => '&#37415;',
		"\xDC\x71" => '&#37378;',
		"\xDC\x72" => '&#37404;',
		"\xDC\x73" => '&#37412;',
		"\xDC\x74" => '&#37401;',
		"\xDC\x75" => '&#37399;',
		"\xDC\x76" => '&#37381;',
		"\xDC\x77" => '&#37398;',
		"\xDC\x78" => '&#38267;',
		"\xDC\x79" => '&#38285;',
		"\xDC\x7A" => '&#38284;',
		"\xDC\x7B" => '&#38288;',
		"\xDC\x7C" => '&#38535;',
		"\xDC\x7D" => '&#38526;',
		"\xDC\x7E" => '&#38536;',
		"\xDC\xA1" => '&#38537;',
		"\xDC\xA2" => '&#38531;',
		"\xDC\xA3" => '&#38528;',
		"\xDC\xA4" => '&#38594;',
		"\xDC\xA5" => '&#38600;',
		"\xDC\xA6" => '&#38595;',
		"\xDC\xA7" => '&#38641;',
		"\xDC\xA8" => '&#38640;',
		"\xDC\xA9" => '&#38764;',
		"\xDC\xAA" => '&#38768;',
		"\xDC\xAB" => '&#38766;',
		"\xDC\xAC" => '&#38919;',
		"\xDC\xAD" => '&#39081;',
		"\xDC\xAE" => '&#39147;',
		"\xDC\xAF" => '&#40166;',
		"\xDC\xB0" => '&#40697;',
		"\xDC\xB1" => '&#20099;',
		"\xDC\xB2" => '&#20100;',
		"\xDC\xB3" => '&#20150;',
		"\xDC\xB4" => '&#20669;',
		"\xDC\xB5" => '&#20671;',
		"\xDC\xB6" => '&#20678;',
		"\xDC\xB7" => '&#20654;',
		"\xDC\xB8" => '&#20676;',
		"\xDC\xB9" => '&#20682;',
		"\xDC\xBA" => '&#20660;',
		"\xDC\xBB" => '&#20680;',
		"\xDC\xBC" => '&#20674;',
		"\xDC\xBD" => '&#20656;',
		"\xDC\xBE" => '&#20673;',
		"\xDC\xBF" => '&#20666;',
		"\xDC\xC0" => '&#20657;',
		"\xDC\xC1" => '&#20683;',
		"\xDC\xC2" => '&#20681;',
		"\xDC\xC3" => '&#20662;',
		"\xDC\xC4" => '&#20664;',
		"\xDC\xC5" => '&#20951;',
		"\xDC\xC6" => '&#21114;',
		"\xDC\xC7" => '&#21112;',
		"\xDC\xC8" => '&#21115;',
		"\xDC\xC9" => '&#21116;',
		"\xDC\xCA" => '&#21955;',
		"\xDC\xCB" => '&#21979;',
		"\xDC\xCC" => '&#21964;',
		"\xDC\xCD" => '&#21968;',
		"\xDC\xCE" => '&#21963;',
		"\xDC\xCF" => '&#21962;',
		"\xDC\xD0" => '&#21981;',
		"\xDC\xD1" => '&#21952;',
		"\xDC\xD2" => '&#21972;',
		"\xDC\xD3" => '&#21956;',
		"\xDC\xD4" => '&#21993;',
		"\xDC\xD5" => '&#21951;',
		"\xDC\xD6" => '&#21970;',
		"\xDC\xD7" => '&#21901;',
		"\xDC\xD8" => '&#21967;',
		"\xDC\xD9" => '&#21973;',
		"\xDC\xDA" => '&#21986;',
		"\xDC\xDB" => '&#21974;',
		"\xDC\xDC" => '&#21960;',
		"\xDC\xDD" => '&#22002;',
		"\xDC\xDE" => '&#21965;',
		"\xDC\xDF" => '&#21977;',
		"\xDC\xE0" => '&#21954;',
		"\xDC\xE1" => '&#22292;',
		"\xDC\xE2" => '&#22611;',
		"\xDC\xE3" => '&#22632;',
		"\xDC\xE4" => '&#22628;',
		"\xDC\xE5" => '&#22607;',
		"\xDC\xE6" => '&#22605;',
		"\xDC\xE7" => '&#22601;',
		"\xDC\xE8" => '&#22639;',
		"\xDC\xE9" => '&#22613;',
		"\xDC\xEA" => '&#22606;',
		"\xDC\xEB" => '&#22621;',
		"\xDC\xEC" => '&#22617;',
		"\xDC\xED" => '&#22629;',
		"\xDC\xEE" => '&#22619;',
		"\xDC\xEF" => '&#22589;',
		"\xDC\xF0" => '&#22627;',
		"\xDC\xF1" => '&#22641;',
		"\xDC\xF2" => '&#22780;',
		"\xDC\xF3" => '&#23239;',
		"\xDC\xF4" => '&#23236;',
		"\xDC\xF5" => '&#23243;',
		"\xDC\xF6" => '&#23226;',
		"\xDC\xF7" => '&#23224;',
		"\xDC\xF8" => '&#23217;',
		"\xDC\xF9" => '&#23221;',
		"\xDC\xFA" => '&#23216;',
		"\xDC\xFB" => '&#23231;',
		"\xDC\xFC" => '&#23240;',
		"\xDC\xFD" => '&#23227;',
		"\xDC\xFE" => '&#23238;',
		"\xDD\x40" => '&#23223;',
		"\xDD\x41" => '&#23232;',
		"\xDD\x42" => '&#23242;',
		"\xDD\x43" => '&#23220;',
		"\xDD\x44" => '&#23222;',
		"\xDD\x45" => '&#23245;',
		"\xDD\x46" => '&#23225;',
		"\xDD\x47" => '&#23184;',
		"\xDD\x48" => '&#23510;',
		"\xDD\x49" => '&#23512;',
		"\xDD\x4A" => '&#23513;',
		"\xDD\x4B" => '&#23583;',
		"\xDD\x4C" => '&#23603;',
		"\xDD\x4D" => '&#23921;',
		"\xDD\x4E" => '&#23907;',
		"\xDD\x4F" => '&#23882;',
		"\xDD\x50" => '&#23909;',
		"\xDD\x51" => '&#23922;',
		"\xDD\x52" => '&#23916;',
		"\xDD\x53" => '&#23902;',
		"\xDD\x54" => '&#23912;',
		"\xDD\x55" => '&#23911;',
		"\xDD\x56" => '&#23906;',
		"\xDD\x57" => '&#24048;',
		"\xDD\x58" => '&#24143;',
		"\xDD\x59" => '&#24142;',
		"\xDD\x5A" => '&#24138;',
		"\xDD\x5B" => '&#24141;',
		"\xDD\x5C" => '&#24139;',
		"\xDD\x5D" => '&#24261;',
		"\xDD\x5E" => '&#24268;',
		"\xDD\x5F" => '&#24262;',
		"\xDD\x60" => '&#24267;',
		"\xDD\x61" => '&#24263;',
		"\xDD\x62" => '&#24384;',
		"\xDD\x63" => '&#24495;',
		"\xDD\x64" => '&#24493;',
		"\xDD\x65" => '&#24823;',
		"\xDD\x66" => '&#24905;',
		"\xDD\x67" => '&#24906;',
		"\xDD\x68" => '&#24875;',
		"\xDD\x69" => '&#24901;',
		"\xDD\x6A" => '&#24886;',
		"\xDD\x6B" => '&#24882;',
		"\xDD\x6C" => '&#24878;',
		"\xDD\x6D" => '&#24902;',
		"\xDD\x6E" => '&#24879;',
		"\xDD\x6F" => '&#24911;',
		"\xDD\x70" => '&#24873;',
		"\xDD\x71" => '&#24896;',
		"\xDD\x72" => '&#25120;',
		"\xDD\x73" => '&#37224;',
		"\xDD\x74" => '&#25123;',
		"\xDD\x75" => '&#25125;',
		"\xDD\x76" => '&#25124;',
		"\xDD\x77" => '&#25541;',
		"\xDD\x78" => '&#25585;',
		"\xDD\x79" => '&#25579;',
		"\xDD\x7A" => '&#25616;',
		"\xDD\x7B" => '&#25618;',
		"\xDD\x7C" => '&#25609;',
		"\xDD\x7D" => '&#25632;',
		"\xDD\x7E" => '&#25636;',
		"\xDD\xA1" => '&#25651;',
		"\xDD\xA2" => '&#25667;',
		"\xDD\xA3" => '&#25631;',
		"\xDD\xA4" => '&#25621;',
		"\xDD\xA5" => '&#25624;',
		"\xDD\xA6" => '&#25657;',
		"\xDD\xA7" => '&#25655;',
		"\xDD\xA8" => '&#25634;',
		"\xDD\xA9" => '&#25635;',
		"\xDD\xAA" => '&#25612;',
		"\xDD\xAB" => '&#25638;',
		"\xDD\xAC" => '&#25648;',
		"\xDD\xAD" => '&#25640;',
		"\xDD\xAE" => '&#25665;',
		"\xDD\xAF" => '&#25653;',
		"\xDD\xB0" => '&#25647;',
		"\xDD\xB1" => '&#25610;',
		"\xDD\xB2" => '&#25626;',
		"\xDD\xB3" => '&#25664;',
		"\xDD\xB4" => '&#25637;',
		"\xDD\xB5" => '&#25639;',
		"\xDD\xB6" => '&#25611;',
		"\xDD\xB7" => '&#25575;',
		"\xDD\xB8" => '&#25627;',
		"\xDD\xB9" => '&#25646;',
		"\xDD\xBA" => '&#25633;',
		"\xDD\xBB" => '&#25614;',
		"\xDD\xBC" => '&#25967;',
		"\xDD\xBD" => '&#26002;',
		"\xDD\xBE" => '&#26067;',
		"\xDD\xBF" => '&#26246;',
		"\xDD\xC0" => '&#26252;',
		"\xDD\xC1" => '&#26261;',
		"\xDD\xC2" => '&#26256;',
		"\xDD\xC3" => '&#26251;',
		"\xDD\xC4" => '&#26250;',
		"\xDD\xC5" => '&#26265;',
		"\xDD\xC6" => '&#26260;',
		"\xDD\xC7" => '&#26232;',
		"\xDD\xC8" => '&#26400;',
		"\xDD\xC9" => '&#26982;',
		"\xDD\xCA" => '&#26975;',
		"\xDD\xCB" => '&#26936;',
		"\xDD\xCC" => '&#26958;',
		"\xDD\xCD" => '&#26978;',
		"\xDD\xCE" => '&#26993;',
		"\xDD\xCF" => '&#26943;',
		"\xDD\xD0" => '&#26949;',
		"\xDD\xD1" => '&#26986;',
		"\xDD\xD2" => '&#26937;',
		"\xDD\xD3" => '&#26946;',
		"\xDD\xD4" => '&#26967;',
		"\xDD\xD5" => '&#26969;',
		"\xDD\xD6" => '&#27002;',
		"\xDD\xD7" => '&#26952;',
		"\xDD\xD8" => '&#26953;',
		"\xDD\xD9" => '&#26933;',
		"\xDD\xDA" => '&#26988;',
		"\xDD\xDB" => '&#26931;',
		"\xDD\xDC" => '&#26941;',
		"\xDD\xDD" => '&#26981;',
		"\xDD\xDE" => '&#26864;',
		"\xDD\xDF" => '&#27000;',
		"\xDD\xE0" => '&#26932;',
		"\xDD\xE1" => '&#26985;',
		"\xDD\xE2" => '&#26944;',
		"\xDD\xE3" => '&#26991;',
		"\xDD\xE4" => '&#26948;',
		"\xDD\xE5" => '&#26998;',
		"\xDD\xE6" => '&#26968;',
		"\xDD\xE7" => '&#26945;',
		"\xDD\xE8" => '&#26996;',
		"\xDD\xE9" => '&#26956;',
		"\xDD\xEA" => '&#26939;',
		"\xDD\xEB" => '&#26955;',
		"\xDD\xEC" => '&#26935;',
		"\xDD\xED" => '&#26972;',
		"\xDD\xEE" => '&#26959;',
		"\xDD\xEF" => '&#26961;',
		"\xDD\xF0" => '&#26930;',
		"\xDD\xF1" => '&#26962;',
		"\xDD\xF2" => '&#26927;',
		"\xDD\xF3" => '&#27003;',
		"\xDD\xF4" => '&#26940;',
		"\xDD\xF5" => '&#27462;',
		"\xDD\xF6" => '&#27461;',
		"\xDD\xF7" => '&#27459;',
		"\xDD\xF8" => '&#27458;',
		"\xDD\xF9" => '&#27464;',
		"\xDD\xFA" => '&#27457;',
		"\xDD\xFB" => '&#27547;',
		"\xDD\xFC" => '&#64013;',
		"\xDD\xFD" => '&#27643;',
		"\xDD\xFE" => '&#27644;',
		"\xDE\x40" => '&#27641;',
		"\xDE\x41" => '&#27639;',
		"\xDE\x42" => '&#27640;',
		"\xDE\x43" => '&#28315;',
		"\xDE\x44" => '&#28374;',
		"\xDE\x45" => '&#28360;',
		"\xDE\x46" => '&#28303;',
		"\xDE\x47" => '&#28352;',
		"\xDE\x48" => '&#28319;',
		"\xDE\x49" => '&#28307;',
		"\xDE\x4A" => '&#28308;',
		"\xDE\x4B" => '&#28320;',
		"\xDE\x4C" => '&#28337;',
		"\xDE\x4D" => '&#28345;',
		"\xDE\x4E" => '&#28358;',
		"\xDE\x4F" => '&#28370;',
		"\xDE\x50" => '&#28349;',
		"\xDE\x51" => '&#28353;',
		"\xDE\x52" => '&#28318;',
		"\xDE\x53" => '&#28361;',
		"\xDE\x54" => '&#28343;',
		"\xDE\x55" => '&#28336;',
		"\xDE\x56" => '&#28365;',
		"\xDE\x57" => '&#28326;',
		"\xDE\x58" => '&#28367;',
		"\xDE\x59" => '&#28338;',
		"\xDE\x5A" => '&#28350;',
		"\xDE\x5B" => '&#28355;',
		"\xDE\x5C" => '&#28380;',
		"\xDE\x5D" => '&#28376;',
		"\xDE\x5E" => '&#28313;',
		"\xDE\x5F" => '&#28306;',
		"\xDE\x60" => '&#28302;',
		"\xDE\x61" => '&#28301;',
		"\xDE\x62" => '&#28324;',
		"\xDE\x63" => '&#28321;',
		"\xDE\x64" => '&#28351;',
		"\xDE\x65" => '&#28339;',
		"\xDE\x66" => '&#28368;',
		"\xDE\x67" => '&#28362;',
		"\xDE\x68" => '&#28311;',
		"\xDE\x69" => '&#28334;',
		"\xDE\x6A" => '&#28323;',
		"\xDE\x6B" => '&#28999;',
		"\xDE\x6C" => '&#29012;',
		"\xDE\x6D" => '&#29010;',
		"\xDE\x6E" => '&#29027;',
		"\xDE\x6F" => '&#29024;',
		"\xDE\x70" => '&#28993;',
		"\xDE\x71" => '&#29021;',
		"\xDE\x72" => '&#29026;',
		"\xDE\x73" => '&#29042;',
		"\xDE\x74" => '&#29048;',
		"\xDE\x75" => '&#29034;',
		"\xDE\x76" => '&#29025;',
		"\xDE\x77" => '&#28994;',
		"\xDE\x78" => '&#29016;',
		"\xDE\x79" => '&#28995;',
		"\xDE\x7A" => '&#29003;',
		"\xDE\x7B" => '&#29040;',
		"\xDE\x7C" => '&#29023;',
		"\xDE\x7D" => '&#29008;',
		"\xDE\x7E" => '&#29011;',
		"\xDE\xA1" => '&#28996;',
		"\xDE\xA2" => '&#29005;',
		"\xDE\xA3" => '&#29018;',
		"\xDE\xA4" => '&#29263;',
		"\xDE\xA5" => '&#29325;',
		"\xDE\xA6" => '&#29324;',
		"\xDE\xA7" => '&#29329;',
		"\xDE\xA8" => '&#29328;',
		"\xDE\xA9" => '&#29326;',
		"\xDE\xAA" => '&#29500;',
		"\xDE\xAB" => '&#29506;',
		"\xDE\xAC" => '&#29499;',
		"\xDE\xAD" => '&#29498;',
		"\xDE\xAE" => '&#29504;',
		"\xDE\xAF" => '&#29514;',
		"\xDE\xB0" => '&#29513;',
		"\xDE\xB1" => '&#29764;',
		"\xDE\xB2" => '&#29770;',
		"\xDE\xB3" => '&#29771;',
		"\xDE\xB4" => '&#29778;',
		"\xDE\xB5" => '&#29777;',
		"\xDE\xB6" => '&#29783;',
		"\xDE\xB7" => '&#29760;',
		"\xDE\xB8" => '&#29775;',
		"\xDE\xB9" => '&#29776;',
		"\xDE\xBA" => '&#29774;',
		"\xDE\xBB" => '&#29762;',
		"\xDE\xBC" => '&#29766;',
		"\xDE\xBD" => '&#29773;',
		"\xDE\xBE" => '&#29780;',
		"\xDE\xBF" => '&#29921;',
		"\xDE\xC0" => '&#29951;',
		"\xDE\xC1" => '&#29950;',
		"\xDE\xC2" => '&#29949;',
		"\xDE\xC3" => '&#29981;',
		"\xDE\xC4" => '&#30073;',
		"\xDE\xC5" => '&#30071;',
		"\xDE\xC6" => '&#27011;',
		"\xDE\xC7" => '&#30191;',
		"\xDE\xC8" => '&#30223;',
		"\xDE\xC9" => '&#30211;',
		"\xDE\xCA" => '&#30199;',
		"\xDE\xCB" => '&#30206;',
		"\xDE\xCC" => '&#30204;',
		"\xDE\xCD" => '&#30201;',
		"\xDE\xCE" => '&#30200;',
		"\xDE\xCF" => '&#30224;',
		"\xDE\xD0" => '&#30203;',
		"\xDE\xD1" => '&#30198;',
		"\xDE\xD2" => '&#30189;',
		"\xDE\xD3" => '&#30197;',
		"\xDE\xD4" => '&#30205;',
		"\xDE\xD5" => '&#30361;',
		"\xDE\xD6" => '&#30389;',
		"\xDE\xD7" => '&#30429;',
		"\xDE\xD8" => '&#30549;',
		"\xDE\xD9" => '&#30559;',
		"\xDE\xDA" => '&#30560;',
		"\xDE\xDB" => '&#30546;',
		"\xDE\xDC" => '&#30550;',
		"\xDE\xDD" => '&#30554;',
		"\xDE\xDE" => '&#30569;',
		"\xDE\xDF" => '&#30567;',
		"\xDE\xE0" => '&#30548;',
		"\xDE\xE1" => '&#30553;',
		"\xDE\xE2" => '&#30573;',
		"\xDE\xE3" => '&#30688;',
		"\xDE\xE4" => '&#30855;',
		"\xDE\xE5" => '&#30874;',
		"\xDE\xE6" => '&#30868;',
		"\xDE\xE7" => '&#30863;',
		"\xDE\xE8" => '&#30852;',
		"\xDE\xE9" => '&#30869;',
		"\xDE\xEA" => '&#30853;',
		"\xDE\xEB" => '&#30854;',
		"\xDE\xEC" => '&#30881;',
		"\xDE\xED" => '&#30851;',
		"\xDE\xEE" => '&#30841;',
		"\xDE\xEF" => '&#30873;',
		"\xDE\xF0" => '&#30848;',
		"\xDE\xF1" => '&#30870;',
		"\xDE\xF2" => '&#30843;',
		"\xDE\xF3" => '&#31100;',
		"\xDE\xF4" => '&#31106;',
		"\xDE\xF5" => '&#31101;',
		"\xDE\xF6" => '&#31097;',
		"\xDE\xF7" => '&#31249;',
		"\xDE\xF8" => '&#31256;',
		"\xDE\xF9" => '&#31257;',
		"\xDE\xFA" => '&#31250;',
		"\xDE\xFB" => '&#31255;',
		"\xDE\xFC" => '&#31253;',
		"\xDE\xFD" => '&#31266;',
		"\xDE\xFE" => '&#31251;',
		"\xDF\x40" => '&#31259;',
		"\xDF\x41" => '&#31248;',
		"\xDF\x42" => '&#31395;',
		"\xDF\x43" => '&#31394;',
		"\xDF\x44" => '&#31390;',
		"\xDF\x45" => '&#31467;',
		"\xDF\x46" => '&#31590;',
		"\xDF\x47" => '&#31588;',
		"\xDF\x48" => '&#31597;',
		"\xDF\x49" => '&#31604;',
		"\xDF\x4A" => '&#31593;',
		"\xDF\x4B" => '&#31602;',
		"\xDF\x4C" => '&#31589;',
		"\xDF\x4D" => '&#31603;',
		"\xDF\x4E" => '&#31601;',
		"\xDF\x4F" => '&#31600;',
		"\xDF\x50" => '&#31585;',
		"\xDF\x51" => '&#31608;',
		"\xDF\x52" => '&#31606;',
		"\xDF\x53" => '&#31587;',
		"\xDF\x54" => '&#31922;',
		"\xDF\x55" => '&#31924;',
		"\xDF\x56" => '&#31919;',
		"\xDF\x57" => '&#32136;',
		"\xDF\x58" => '&#32134;',
		"\xDF\x59" => '&#32128;',
		"\xDF\x5A" => '&#32141;',
		"\xDF\x5B" => '&#32127;',
		"\xDF\x5C" => '&#32133;',
		"\xDF\x5D" => '&#32122;',
		"\xDF\x5E" => '&#32142;',
		"\xDF\x5F" => '&#32123;',
		"\xDF\x60" => '&#32131;',
		"\xDF\x61" => '&#32124;',
		"\xDF\x62" => '&#32140;',
		"\xDF\x63" => '&#32148;',
		"\xDF\x64" => '&#32132;',
		"\xDF\x65" => '&#32125;',
		"\xDF\x66" => '&#32146;',
		"\xDF\x67" => '&#32621;',
		"\xDF\x68" => '&#32619;',
		"\xDF\x69" => '&#32615;',
		"\xDF\x6A" => '&#32616;',
		"\xDF\x6B" => '&#32620;',
		"\xDF\x6C" => '&#32678;',
		"\xDF\x6D" => '&#32677;',
		"\xDF\x6E" => '&#32679;',
		"\xDF\x6F" => '&#32731;',
		"\xDF\x70" => '&#32732;',
		"\xDF\x71" => '&#32801;',
		"\xDF\x72" => '&#33124;',
		"\xDF\x73" => '&#33120;',
		"\xDF\x74" => '&#33143;',
		"\xDF\x75" => '&#33116;',
		"\xDF\x76" => '&#33129;',
		"\xDF\x77" => '&#33115;',
		"\xDF\x78" => '&#33122;',
		"\xDF\x79" => '&#33138;',
		"\xDF\x7A" => '&#26401;',
		"\xDF\x7B" => '&#33118;',
		"\xDF\x7C" => '&#33142;',
		"\xDF\x7D" => '&#33127;',
		"\xDF\x7E" => '&#33135;',
		"\xDF\xA1" => '&#33092;',
		"\xDF\xA2" => '&#33121;',
		"\xDF\xA3" => '&#33309;',
		"\xDF\xA4" => '&#33353;',
		"\xDF\xA5" => '&#33348;',
		"\xDF\xA6" => '&#33344;',
		"\xDF\xA7" => '&#33346;',
		"\xDF\xA8" => '&#33349;',
		"\xDF\xA9" => '&#34033;',
		"\xDF\xAA" => '&#33855;',
		"\xDF\xAB" => '&#33878;',
		"\xDF\xAC" => '&#33910;',
		"\xDF\xAD" => '&#33913;',
		"\xDF\xAE" => '&#33935;',
		"\xDF\xAF" => '&#33933;',
		"\xDF\xB0" => '&#33893;',
		"\xDF\xB1" => '&#33873;',
		"\xDF\xB2" => '&#33856;',
		"\xDF\xB3" => '&#33926;',
		"\xDF\xB4" => '&#33895;',
		"\xDF\xB5" => '&#33840;',
		"\xDF\xB6" => '&#33869;',
		"\xDF\xB7" => '&#33917;',
		"\xDF\xB8" => '&#33882;',
		"\xDF\xB9" => '&#33881;',
		"\xDF\xBA" => '&#33908;',
		"\xDF\xBB" => '&#33907;',
		"\xDF\xBC" => '&#33885;',
		"\xDF\xBD" => '&#34055;',
		"\xDF\xBE" => '&#33886;',
		"\xDF\xBF" => '&#33847;',
		"\xDF\xC0" => '&#33850;',
		"\xDF\xC1" => '&#33844;',
		"\xDF\xC2" => '&#33914;',
		"\xDF\xC3" => '&#33859;',
		"\xDF\xC4" => '&#33912;',
		"\xDF\xC5" => '&#33842;',
		"\xDF\xC6" => '&#33861;',
		"\xDF\xC7" => '&#33833;',
		"\xDF\xC8" => '&#33753;',
		"\xDF\xC9" => '&#33867;',
		"\xDF\xCA" => '&#33839;',
		"\xDF\xCB" => '&#33858;',
		"\xDF\xCC" => '&#33837;',
		"\xDF\xCD" => '&#33887;',
		"\xDF\xCE" => '&#33904;',
		"\xDF\xCF" => '&#33849;',
		"\xDF\xD0" => '&#33870;',
		"\xDF\xD1" => '&#33868;',
		"\xDF\xD2" => '&#33874;',
		"\xDF\xD3" => '&#33903;',
		"\xDF\xD4" => '&#33989;',
		"\xDF\xD5" => '&#33934;',
		"\xDF\xD6" => '&#33851;',
		"\xDF\xD7" => '&#33863;',
		"\xDF\xD8" => '&#33846;',
		"\xDF\xD9" => '&#33843;',
		"\xDF\xDA" => '&#33896;',
		"\xDF\xDB" => '&#33918;',
		"\xDF\xDC" => '&#33860;',
		"\xDF\xDD" => '&#33835;',
		"\xDF\xDE" => '&#33888;',
		"\xDF\xDF" => '&#33876;',
		"\xDF\xE0" => '&#33902;',
		"\xDF\xE1" => '&#33872;',
		"\xDF\xE2" => '&#34571;',
		"\xDF\xE3" => '&#34564;',
		"\xDF\xE4" => '&#34551;',
		"\xDF\xE5" => '&#34572;',
		"\xDF\xE6" => '&#34554;',
		"\xDF\xE7" => '&#34518;',
		"\xDF\xE8" => '&#34549;',
		"\xDF\xE9" => '&#34637;',
		"\xDF\xEA" => '&#34552;',
		"\xDF\xEB" => '&#34574;',
		"\xDF\xEC" => '&#34569;',
		"\xDF\xED" => '&#34561;',
		"\xDF\xEE" => '&#34550;',
		"\xDF\xEF" => '&#34573;',
		"\xDF\xF0" => '&#34565;',
		"\xDF\xF1" => '&#35030;',
		"\xDF\xF2" => '&#35019;',
		"\xDF\xF3" => '&#35021;',
		"\xDF\xF4" => '&#35022;',
		"\xDF\xF5" => '&#35038;',
		"\xDF\xF6" => '&#35035;',
		"\xDF\xF7" => '&#35034;',
		"\xDF\xF8" => '&#35020;',
		"\xDF\xF9" => '&#35024;',
		"\xDF\xFA" => '&#35205;',
		"\xDF\xFB" => '&#35227;',
		"\xDF\xFC" => '&#35295;',
		"\xDF\xFD" => '&#35301;',
		"\xDF\xFE" => '&#35300;',
		"\xE0\x40" => '&#35297;',
		"\xE0\x41" => '&#35296;',
		"\xE0\x42" => '&#35298;',
		"\xE0\x43" => '&#35292;',
		"\xE0\x44" => '&#35302;',
		"\xE0\x45" => '&#35446;',
		"\xE0\x46" => '&#35462;',
		"\xE0\x47" => '&#35455;',
		"\xE0\x48" => '&#35425;',
		"\xE0\x49" => '&#35391;',
		"\xE0\x4A" => '&#35447;',
		"\xE0\x4B" => '&#35458;',
		"\xE0\x4C" => '&#35460;',
		"\xE0\x4D" => '&#35445;',
		"\xE0\x4E" => '&#35459;',
		"\xE0\x4F" => '&#35457;',
		"\xE0\x50" => '&#35444;',
		"\xE0\x51" => '&#35450;',
		"\xE0\x52" => '&#35900;',
		"\xE0\x53" => '&#35915;',
		"\xE0\x54" => '&#35914;',
		"\xE0\x55" => '&#35941;',
		"\xE0\x56" => '&#35940;',
		"\xE0\x57" => '&#35942;',
		"\xE0\x58" => '&#35974;',
		"\xE0\x59" => '&#35972;',
		"\xE0\x5A" => '&#35973;',
		"\xE0\x5B" => '&#36044;',
		"\xE0\x5C" => '&#36200;',
		"\xE0\x5D" => '&#36201;',
		"\xE0\x5E" => '&#36241;',
		"\xE0\x5F" => '&#36236;',
		"\xE0\x60" => '&#36238;',
		"\xE0\x61" => '&#36239;',
		"\xE0\x62" => '&#36237;',
		"\xE0\x63" => '&#36243;',
		"\xE0\x64" => '&#36244;',
		"\xE0\x65" => '&#36240;',
		"\xE0\x66" => '&#36242;',
		"\xE0\x67" => '&#36336;',
		"\xE0\x68" => '&#36320;',
		"\xE0\x69" => '&#36332;',
		"\xE0\x6A" => '&#36337;',
		"\xE0\x6B" => '&#36334;',
		"\xE0\x6C" => '&#36304;',
		"\xE0\x6D" => '&#36329;',
		"\xE0\x6E" => '&#36323;',
		"\xE0\x6F" => '&#36322;',
		"\xE0\x70" => '&#36327;',
		"\xE0\x71" => '&#36338;',
		"\xE0\x72" => '&#36331;',
		"\xE0\x73" => '&#36340;',
		"\xE0\x74" => '&#36614;',
		"\xE0\x75" => '&#36607;',
		"\xE0\x76" => '&#36609;',
		"\xE0\x77" => '&#36608;',
		"\xE0\x78" => '&#36613;',
		"\xE0\x79" => '&#36615;',
		"\xE0\x7A" => '&#36616;',
		"\xE0\x7B" => '&#36610;',
		"\xE0\x7C" => '&#36619;',
		"\xE0\x7D" => '&#36946;',
		"\xE0\x7E" => '&#36927;',
		"\xE0\xA1" => '&#36932;',
		"\xE0\xA2" => '&#36937;',
		"\xE0\xA3" => '&#36925;',
		"\xE0\xA4" => '&#37136;',
		"\xE0\xA5" => '&#37133;',
		"\xE0\xA6" => '&#37135;',
		"\xE0\xA7" => '&#37137;',
		"\xE0\xA8" => '&#37142;',
		"\xE0\xA9" => '&#37140;',
		"\xE0\xAA" => '&#37131;',
		"\xE0\xAB" => '&#37134;',
		"\xE0\xAC" => '&#37230;',
		"\xE0\xAD" => '&#37231;',
		"\xE0\xAE" => '&#37448;',
		"\xE0\xAF" => '&#37458;',
		"\xE0\xB0" => '&#37424;',
		"\xE0\xB1" => '&#37434;',
		"\xE0\xB2" => '&#37478;',
		"\xE0\xB3" => '&#37427;',
		"\xE0\xB4" => '&#37477;',
		"\xE0\xB5" => '&#37470;',
		"\xE0\xB6" => '&#37507;',
		"\xE0\xB7" => '&#37422;',
		"\xE0\xB8" => '&#37450;',
		"\xE0\xB9" => '&#37446;',
		"\xE0\xBA" => '&#37485;',
		"\xE0\xBB" => '&#37484;',
		"\xE0\xBC" => '&#37455;',
		"\xE0\xBD" => '&#37472;',
		"\xE0\xBE" => '&#37479;',
		"\xE0\xBF" => '&#37487;',
		"\xE0\xC0" => '&#37430;',
		"\xE0\xC1" => '&#37473;',
		"\xE0\xC2" => '&#37488;',
		"\xE0\xC3" => '&#37425;',
		"\xE0\xC4" => '&#37460;',
		"\xE0\xC5" => '&#37475;',
		"\xE0\xC6" => '&#37456;',
		"\xE0\xC7" => '&#37490;',
		"\xE0\xC8" => '&#37454;',
		"\xE0\xC9" => '&#37459;',
		"\xE0\xCA" => '&#37452;',
		"\xE0\xCB" => '&#37462;',
		"\xE0\xCC" => '&#37426;',
		"\xE0\xCD" => '&#38303;',
		"\xE0\xCE" => '&#38300;',
		"\xE0\xCF" => '&#38302;',
		"\xE0\xD0" => '&#38299;',
		"\xE0\xD1" => '&#38546;',
		"\xE0\xD2" => '&#38547;',
		"\xE0\xD3" => '&#38545;',
		"\xE0\xD4" => '&#38551;',
		"\xE0\xD5" => '&#38606;',
		"\xE0\xD6" => '&#38650;',
		"\xE0\xD7" => '&#38653;',
		"\xE0\xD8" => '&#38648;',
		"\xE0\xD9" => '&#38645;',
		"\xE0\xDA" => '&#38771;',
		"\xE0\xDB" => '&#38775;',
		"\xE0\xDC" => '&#38776;',
		"\xE0\xDD" => '&#38770;',
		"\xE0\xDE" => '&#38927;',
		"\xE0\xDF" => '&#38925;',
		"\xE0\xE0" => '&#38926;',
		"\xE0\xE1" => '&#39084;',
		"\xE0\xE2" => '&#39158;',
		"\xE0\xE3" => '&#39161;',
		"\xE0\xE4" => '&#39343;',
		"\xE0\xE5" => '&#39346;',
		"\xE0\xE6" => '&#39344;',
		"\xE0\xE7" => '&#39349;',
		"\xE0\xE8" => '&#39597;',
		"\xE0\xE9" => '&#39595;',
		"\xE0\xEA" => '&#39771;',
		"\xE0\xEB" => '&#40170;',
		"\xE0\xEC" => '&#40173;',
		"\xE0\xED" => '&#40167;',
		"\xE0\xEE" => '&#40576;',
		"\xE0\xEF" => '&#40701;',
		"\xE0\xF0" => '&#20710;',
		"\xE0\xF1" => '&#20692;',
		"\xE0\xF2" => '&#20695;',
		"\xE0\xF3" => '&#20712;',
		"\xE0\xF4" => '&#20723;',
		"\xE0\xF5" => '&#20699;',
		"\xE0\xF6" => '&#20714;',
		"\xE0\xF7" => '&#20701;',
		"\xE0\xF8" => '&#20708;',
		"\xE0\xF9" => '&#20691;',
		"\xE0\xFA" => '&#20716;',
		"\xE0\xFB" => '&#20720;',
		"\xE0\xFC" => '&#20719;',
		"\xE0\xFD" => '&#20707;',
		"\xE0\xFE" => '&#20704;',
		"\xE1\x40" => '&#20952;',
		"\xE1\x41" => '&#21120;',
		"\xE1\x42" => '&#21121;',
		"\xE1\x43" => '&#21225;',
		"\xE1\x44" => '&#21227;',
		"\xE1\x45" => '&#21296;',
		"\xE1\x46" => '&#21420;',
		"\xE1\x47" => '&#22055;',
		"\xE1\x48" => '&#22037;',
		"\xE1\x49" => '&#22028;',
		"\xE1\x4A" => '&#22034;',
		"\xE1\x4B" => '&#22012;',
		"\xE1\x4C" => '&#22031;',
		"\xE1\x4D" => '&#22044;',
		"\xE1\x4E" => '&#22017;',
		"\xE1\x4F" => '&#22035;',
		"\xE1\x50" => '&#22018;',
		"\xE1\x51" => '&#22010;',
		"\xE1\x52" => '&#22045;',
		"\xE1\x53" => '&#22020;',
		"\xE1\x54" => '&#22015;',
		"\xE1\x55" => '&#22009;',
		"\xE1\x56" => '&#22665;',
		"\xE1\x57" => '&#22652;',
		"\xE1\x58" => '&#22672;',
		"\xE1\x59" => '&#22680;',
		"\xE1\x5A" => '&#22662;',
		"\xE1\x5B" => '&#22657;',
		"\xE1\x5C" => '&#22655;',
		"\xE1\x5D" => '&#22644;',
		"\xE1\x5E" => '&#22667;',
		"\xE1\x5F" => '&#22650;',
		"\xE1\x60" => '&#22663;',
		"\xE1\x61" => '&#22673;',
		"\xE1\x62" => '&#22670;',
		"\xE1\x63" => '&#22646;',
		"\xE1\x64" => '&#22658;',
		"\xE1\x65" => '&#22664;',
		"\xE1\x66" => '&#22651;',
		"\xE1\x67" => '&#22676;',
		"\xE1\x68" => '&#22671;',
		"\xE1\x69" => '&#22782;',
		"\xE1\x6A" => '&#22891;',
		"\xE1\x6B" => '&#23260;',
		"\xE1\x6C" => '&#23278;',
		"\xE1\x6D" => '&#23269;',
		"\xE1\x6E" => '&#23253;',
		"\xE1\x6F" => '&#23274;',
		"\xE1\x70" => '&#23258;',
		"\xE1\x71" => '&#23277;',
		"\xE1\x72" => '&#23275;',
		"\xE1\x73" => '&#23283;',
		"\xE1\x74" => '&#23266;',
		"\xE1\x75" => '&#23264;',
		"\xE1\x76" => '&#23259;',
		"\xE1\x77" => '&#23276;',
		"\xE1\x78" => '&#23262;',
		"\xE1\x79" => '&#23261;',
		"\xE1\x7A" => '&#23257;',
		"\xE1\x7B" => '&#23272;',
		"\xE1\x7C" => '&#23263;',
		"\xE1\x7D" => '&#23415;',
		"\xE1\x7E" => '&#23520;',
		"\xE1\xA1" => '&#23523;',
		"\xE1\xA2" => '&#23651;',
		"\xE1\xA3" => '&#23938;',
		"\xE1\xA4" => '&#23936;',
		"\xE1\xA5" => '&#23933;',
		"\xE1\xA6" => '&#23942;',
		"\xE1\xA7" => '&#23930;',
		"\xE1\xA8" => '&#23937;',
		"\xE1\xA9" => '&#23927;',
		"\xE1\xAA" => '&#23946;',
		"\xE1\xAB" => '&#23945;',
		"\xE1\xAC" => '&#23944;',
		"\xE1\xAD" => '&#23934;',
		"\xE1\xAE" => '&#23932;',
		"\xE1\xAF" => '&#23949;',
		"\xE1\xB0" => '&#23929;',
		"\xE1\xB1" => '&#23935;',
		"\xE1\xB2" => '&#24152;',
		"\xE1\xB3" => '&#24153;',
		"\xE1\xB4" => '&#24147;',
		"\xE1\xB5" => '&#24280;',
		"\xE1\xB6" => '&#24273;',
		"\xE1\xB7" => '&#24279;',
		"\xE1\xB8" => '&#24270;',
		"\xE1\xB9" => '&#24284;',
		"\xE1\xBA" => '&#24277;',
		"\xE1\xBB" => '&#24281;',
		"\xE1\xBC" => '&#24274;',
		"\xE1\xBD" => '&#24276;',
		"\xE1\xBE" => '&#24388;',
		"\xE1\xBF" => '&#24387;',
		"\xE1\xC0" => '&#24431;',
		"\xE1\xC1" => '&#24502;',
		"\xE1\xC2" => '&#24876;',
		"\xE1\xC3" => '&#24872;',
		"\xE1\xC4" => '&#24897;',
		"\xE1\xC5" => '&#24926;',
		"\xE1\xC6" => '&#24945;',
		"\xE1\xC7" => '&#24947;',
		"\xE1\xC8" => '&#24914;',
		"\xE1\xC9" => '&#24915;',
		"\xE1\xCA" => '&#24946;',
		"\xE1\xCB" => '&#24940;',
		"\xE1\xCC" => '&#24960;',
		"\xE1\xCD" => '&#24948;',
		"\xE1\xCE" => '&#24916;',
		"\xE1\xCF" => '&#24954;',
		"\xE1\xD0" => '&#24923;',
		"\xE1\xD1" => '&#24933;',
		"\xE1\xD2" => '&#24891;',
		"\xE1\xD3" => '&#24938;',
		"\xE1\xD4" => '&#24929;',
		"\xE1\xD5" => '&#24918;',
		"\xE1\xD6" => '&#25129;',
		"\xE1\xD7" => '&#25127;',
		"\xE1\xD8" => '&#25131;',
		"\xE1\xD9" => '&#25643;',
		"\xE1\xDA" => '&#25677;',
		"\xE1\xDB" => '&#25691;',
		"\xE1\xDC" => '&#25693;',
		"\xE1\xDD" => '&#25716;',
		"\xE1\xDE" => '&#25718;',
		"\xE1\xDF" => '&#25714;',
		"\xE1\xE0" => '&#25715;',
		"\xE1\xE1" => '&#25725;',
		"\xE1\xE2" => '&#25717;',
		"\xE1\xE3" => '&#25702;',
		"\xE1\xE4" => '&#25766;',
		"\xE1\xE5" => '&#25678;',
		"\xE1\xE6" => '&#25730;',
		"\xE1\xE7" => '&#25694;',
		"\xE1\xE8" => '&#25692;',
		"\xE1\xE9" => '&#25675;',
		"\xE1\xEA" => '&#25683;',
		"\xE1\xEB" => '&#25696;',
		"\xE1\xEC" => '&#25680;',
		"\xE1\xED" => '&#25727;',
		"\xE1\xEE" => '&#25663;',
		"\xE1\xEF" => '&#25708;',
		"\xE1\xF0" => '&#25707;',
		"\xE1\xF1" => '&#25689;',
		"\xE1\xF2" => '&#25701;',
		"\xE1\xF3" => '&#25719;',
		"\xE1\xF4" => '&#25971;',
		"\xE1\xF5" => '&#26016;',
		"\xE1\xF6" => '&#26273;',
		"\xE1\xF7" => '&#26272;',
		"\xE1\xF8" => '&#26271;',
		"\xE1\xF9" => '&#26373;',
		"\xE1\xFA" => '&#26372;',
		"\xE1\xFB" => '&#26402;',
		"\xE1\xFC" => '&#27057;',
		"\xE1\xFD" => '&#27062;',
		"\xE1\xFE" => '&#27081;',
		"\xE2\x40" => '&#27040;',
		"\xE2\x41" => '&#27086;',
		"\xE2\x42" => '&#27030;',
		"\xE2\x43" => '&#27056;',
		"\xE2\x44" => '&#27052;',
		"\xE2\x45" => '&#27068;',
		"\xE2\x46" => '&#27025;',
		"\xE2\x47" => '&#27033;',
		"\xE2\x48" => '&#27022;',
		"\xE2\x49" => '&#27047;',
		"\xE2\x4A" => '&#27021;',
		"\xE2\x4B" => '&#27049;',
		"\xE2\x4C" => '&#27070;',
		"\xE2\x4D" => '&#27055;',
		"\xE2\x4E" => '&#27071;',
		"\xE2\x4F" => '&#27076;',
		"\xE2\x50" => '&#27069;',
		"\xE2\x51" => '&#27044;',
		"\xE2\x52" => '&#27092;',
		"\xE2\x53" => '&#27065;',
		"\xE2\x54" => '&#27082;',
		"\xE2\x55" => '&#27034;',
		"\xE2\x56" => '&#27087;',
		"\xE2\x57" => '&#27059;',
		"\xE2\x58" => '&#27027;',
		"\xE2\x59" => '&#27050;',
		"\xE2\x5A" => '&#27041;',
		"\xE2\x5B" => '&#27038;',
		"\xE2\x5C" => '&#27097;',
		"\xE2\x5D" => '&#27031;',
		"\xE2\x5E" => '&#27024;',
		"\xE2\x5F" => '&#27074;',
		"\xE2\x60" => '&#27061;',
		"\xE2\x61" => '&#27045;',
		"\xE2\x62" => '&#27078;',
		"\xE2\x63" => '&#27466;',
		"\xE2\x64" => '&#27469;',
		"\xE2\x65" => '&#27467;',
		"\xE2\x66" => '&#27550;',
		"\xE2\x67" => '&#27551;',
		"\xE2\x68" => '&#27552;',
		"\xE2\x69" => '&#27587;',
		"\xE2\x6A" => '&#27588;',
		"\xE2\x6B" => '&#27646;',
		"\xE2\x6C" => '&#28366;',
		"\xE2\x6D" => '&#28405;',
		"\xE2\x6E" => '&#28401;',
		"\xE2\x6F" => '&#28419;',
		"\xE2\x70" => '&#28453;',
		"\xE2\x71" => '&#28408;',
		"\xE2\x72" => '&#28471;',
		"\xE2\x73" => '&#28411;',
		"\xE2\x74" => '&#28462;',
		"\xE2\x75" => '&#28425;',
		"\xE2\x76" => '&#28494;',
		"\xE2\x77" => '&#28441;',
		"\xE2\x78" => '&#28442;',
		"\xE2\x79" => '&#28455;',
		"\xE2\x7A" => '&#28440;',
		"\xE2\x7B" => '&#28475;',
		"\xE2\x7C" => '&#28434;',
		"\xE2\x7D" => '&#28397;',
		"\xE2\x7E" => '&#28426;',
		"\xE2\xA1" => '&#28470;',
		"\xE2\xA2" => '&#28531;',
		"\xE2\xA3" => '&#28409;',
		"\xE2\xA4" => '&#28398;',
		"\xE2\xA5" => '&#28461;',
		"\xE2\xA6" => '&#28480;',
		"\xE2\xA7" => '&#28464;',
		"\xE2\xA8" => '&#28476;',
		"\xE2\xA9" => '&#28469;',
		"\xE2\xAA" => '&#28395;',
		"\xE2\xAB" => '&#28423;',
		"\xE2\xAC" => '&#28430;',
		"\xE2\xAD" => '&#28483;',
		"\xE2\xAE" => '&#28421;',
		"\xE2\xAF" => '&#28413;',
		"\xE2\xB0" => '&#28406;',
		"\xE2\xB1" => '&#28473;',
		"\xE2\xB2" => '&#28444;',
		"\xE2\xB3" => '&#28412;',
		"\xE2\xB4" => '&#28474;',
		"\xE2\xB5" => '&#28447;',
		"\xE2\xB6" => '&#28429;',
		"\xE2\xB7" => '&#28446;',
		"\xE2\xB8" => '&#28424;',
		"\xE2\xB9" => '&#28449;',
		"\xE2\xBA" => '&#29063;',
		"\xE2\xBB" => '&#29072;',
		"\xE2\xBC" => '&#29065;',
		"\xE2\xBD" => '&#29056;',
		"\xE2\xBE" => '&#29061;',
		"\xE2\xBF" => '&#29058;',
		"\xE2\xC0" => '&#29071;',
		"\xE2\xC1" => '&#29051;',
		"\xE2\xC2" => '&#29062;',
		"\xE2\xC3" => '&#29057;',
		"\xE2\xC4" => '&#29079;',
		"\xE2\xC5" => '&#29252;',
		"\xE2\xC6" => '&#29267;',
		"\xE2\xC7" => '&#29335;',
		"\xE2\xC8" => '&#29333;',
		"\xE2\xC9" => '&#29331;',
		"\xE2\xCA" => '&#29507;',
		"\xE2\xCB" => '&#29517;',
		"\xE2\xCC" => '&#29521;',
		"\xE2\xCD" => '&#29516;',
		"\xE2\xCE" => '&#29794;',
		"\xE2\xCF" => '&#29811;',
		"\xE2\xD0" => '&#29809;',
		"\xE2\xD1" => '&#29813;',
		"\xE2\xD2" => '&#29810;',
		"\xE2\xD3" => '&#29799;',
		"\xE2\xD4" => '&#29806;',
		"\xE2\xD5" => '&#29952;',
		"\xE2\xD6" => '&#29954;',
		"\xE2\xD7" => '&#29955;',
		"\xE2\xD8" => '&#30077;',
		"\xE2\xD9" => '&#30096;',
		"\xE2\xDA" => '&#30230;',
		"\xE2\xDB" => '&#30216;',
		"\xE2\xDC" => '&#30220;',
		"\xE2\xDD" => '&#30229;',
		"\xE2\xDE" => '&#30225;',
		"\xE2\xDF" => '&#30218;',
		"\xE2\xE0" => '&#30228;',
		"\xE2\xE1" => '&#30392;',
		"\xE2\xE2" => '&#30593;',
		"\xE2\xE3" => '&#30588;',
		"\xE2\xE4" => '&#30597;',
		"\xE2\xE5" => '&#30594;',
		"\xE2\xE6" => '&#30574;',
		"\xE2\xE7" => '&#30592;',
		"\xE2\xE8" => '&#30575;',
		"\xE2\xE9" => '&#30590;',
		"\xE2\xEA" => '&#30595;',
		"\xE2\xEB" => '&#30898;',
		"\xE2\xEC" => '&#30890;',
		"\xE2\xED" => '&#30900;',
		"\xE2\xEE" => '&#30893;',
		"\xE2\xEF" => '&#30888;',
		"\xE2\xF0" => '&#30846;',
		"\xE2\xF1" => '&#30891;',
		"\xE2\xF2" => '&#30878;',
		"\xE2\xF3" => '&#30885;',
		"\xE2\xF4" => '&#30880;',
		"\xE2\xF5" => '&#30892;',
		"\xE2\xF6" => '&#30882;',
		"\xE2\xF7" => '&#30884;',
		"\xE2\xF8" => '&#31128;',
		"\xE2\xF9" => '&#31114;',
		"\xE2\xFA" => '&#31115;',
		"\xE2\xFB" => '&#31126;',
		"\xE2\xFC" => '&#31125;',
		"\xE2\xFD" => '&#31124;',
		"\xE2\xFE" => '&#31123;',
		"\xE3\x40" => '&#31127;',
		"\xE3\x41" => '&#31112;',
		"\xE3\x42" => '&#31122;',
		"\xE3\x43" => '&#31120;',
		"\xE3\x44" => '&#31275;',
		"\xE3\x45" => '&#31306;',
		"\xE3\x46" => '&#31280;',
		"\xE3\x47" => '&#31279;',
		"\xE3\x48" => '&#31272;',
		"\xE3\x49" => '&#31270;',
		"\xE3\x4A" => '&#31400;',
		"\xE3\x4B" => '&#31403;',
		"\xE3\x4C" => '&#31404;',
		"\xE3\x4D" => '&#31470;',
		"\xE3\x4E" => '&#31624;',
		"\xE3\x4F" => '&#31644;',
		"\xE3\x50" => '&#31626;',
		"\xE3\x51" => '&#31633;',
		"\xE3\x52" => '&#31632;',
		"\xE3\x53" => '&#31638;',
		"\xE3\x54" => '&#31629;',
		"\xE3\x55" => '&#31628;',
		"\xE3\x56" => '&#31643;',
		"\xE3\x57" => '&#31630;',
		"\xE3\x58" => '&#31621;',
		"\xE3\x59" => '&#31640;',
		"\xE3\x5A" => '&#21124;',
		"\xE3\x5B" => '&#31641;',
		"\xE3\x5C" => '&#31652;',
		"\xE3\x5D" => '&#31618;',
		"\xE3\x5E" => '&#31931;',
		"\xE3\x5F" => '&#31935;',
		"\xE3\x60" => '&#31932;',
		"\xE3\x61" => '&#31930;',
		"\xE3\x62" => '&#32167;',
		"\xE3\x63" => '&#32183;',
		"\xE3\x64" => '&#32194;',
		"\xE3\x65" => '&#32163;',
		"\xE3\x66" => '&#32170;',
		"\xE3\x67" => '&#32193;',
		"\xE3\x68" => '&#32192;',
		"\xE3\x69" => '&#32197;',
		"\xE3\x6A" => '&#32157;',
		"\xE3\x6B" => '&#32206;',
		"\xE3\x6C" => '&#32196;',
		"\xE3\x6D" => '&#32198;',
		"\xE3\x6E" => '&#32203;',
		"\xE3\x6F" => '&#32204;',
		"\xE3\x70" => '&#32175;',
		"\xE3\x71" => '&#32185;',
		"\xE3\x72" => '&#32150;',
		"\xE3\x73" => '&#32188;',
		"\xE3\x74" => '&#32159;',
		"\xE3\x75" => '&#32166;',
		"\xE3\x76" => '&#32174;',
		"\xE3\x77" => '&#32169;',
		"\xE3\x78" => '&#32161;',
		"\xE3\x79" => '&#32201;',
		"\xE3\x7A" => '&#32627;',
		"\xE3\x7B" => '&#32738;',
		"\xE3\x7C" => '&#32739;',
		"\xE3\x7D" => '&#32741;',
		"\xE3\x7E" => '&#32734;',
		"\xE3\xA1" => '&#32804;',
		"\xE3\xA2" => '&#32861;',
		"\xE3\xA3" => '&#32860;',
		"\xE3\xA4" => '&#33161;',
		"\xE3\xA5" => '&#33158;',
		"\xE3\xA6" => '&#33155;',
		"\xE3\xA7" => '&#33159;',
		"\xE3\xA8" => '&#33165;',
		"\xE3\xA9" => '&#33164;',
		"\xE3\xAA" => '&#33163;',
		"\xE3\xAB" => '&#33301;',
		"\xE3\xAC" => '&#33943;',
		"\xE3\xAD" => '&#33956;',
		"\xE3\xAE" => '&#33953;',
		"\xE3\xAF" => '&#33951;',
		"\xE3\xB0" => '&#33978;',
		"\xE3\xB1" => '&#33998;',
		"\xE3\xB2" => '&#33986;',
		"\xE3\xB3" => '&#33964;',
		"\xE3\xB4" => '&#33966;',
		"\xE3\xB5" => '&#33963;',
		"\xE3\xB6" => '&#33977;',
		"\xE3\xB7" => '&#33972;',
		"\xE3\xB8" => '&#33985;',
		"\xE3\xB9" => '&#33997;',
		"\xE3\xBA" => '&#33962;',
		"\xE3\xBB" => '&#33946;',
		"\xE3\xBC" => '&#33969;',
		"\xE3\xBD" => '&#34000;',
		"\xE3\xBE" => '&#33949;',
		"\xE3\xBF" => '&#33959;',
		"\xE3\xC0" => '&#33979;',
		"\xE3\xC1" => '&#33954;',
		"\xE3\xC2" => '&#33940;',
		"\xE3\xC3" => '&#33991;',
		"\xE3\xC4" => '&#33996;',
		"\xE3\xC5" => '&#33947;',
		"\xE3\xC6" => '&#33961;',
		"\xE3\xC7" => '&#33967;',
		"\xE3\xC8" => '&#33960;',
		"\xE3\xC9" => '&#34006;',
		"\xE3\xCA" => '&#33944;',
		"\xE3\xCB" => '&#33974;',
		"\xE3\xCC" => '&#33999;',
		"\xE3\xCD" => '&#33952;',
		"\xE3\xCE" => '&#34007;',
		"\xE3\xCF" => '&#34004;',
		"\xE3\xD0" => '&#34002;',
		"\xE3\xD1" => '&#34011;',
		"\xE3\xD2" => '&#33968;',
		"\xE3\xD3" => '&#33937;',
		"\xE3\xD4" => '&#34401;',
		"\xE3\xD5" => '&#34611;',
		"\xE3\xD6" => '&#34595;',
		"\xE3\xD7" => '&#34600;',
		"\xE3\xD8" => '&#34667;',
		"\xE3\xD9" => '&#34624;',
		"\xE3\xDA" => '&#34606;',
		"\xE3\xDB" => '&#34590;',
		"\xE3\xDC" => '&#34593;',
		"\xE3\xDD" => '&#34585;',
		"\xE3\xDE" => '&#34587;',
		"\xE3\xDF" => '&#34627;',
		"\xE3\xE0" => '&#34604;',
		"\xE3\xE1" => '&#34625;',
		"\xE3\xE2" => '&#34622;',
		"\xE3\xE3" => '&#34630;',
		"\xE3\xE4" => '&#34592;',
		"\xE3\xE5" => '&#34610;',
		"\xE3\xE6" => '&#34602;',
		"\xE3\xE7" => '&#34605;',
		"\xE3\xE8" => '&#34620;',
		"\xE3\xE9" => '&#34578;',
		"\xE3\xEA" => '&#34618;',
		"\xE3\xEB" => '&#34609;',
		"\xE3\xEC" => '&#34613;',
		"\xE3\xED" => '&#34626;',
		"\xE3\xEE" => '&#34598;',
		"\xE3\xEF" => '&#34599;',
		"\xE3\xF0" => '&#34616;',
		"\xE3\xF1" => '&#34596;',
		"\xE3\xF2" => '&#34586;',
		"\xE3\xF3" => '&#34608;',
		"\xE3\xF4" => '&#34577;',
		"\xE3\xF5" => '&#35063;',
		"\xE3\xF6" => '&#35047;',
		"\xE3\xF7" => '&#35057;',
		"\xE3\xF8" => '&#35058;',
		"\xE3\xF9" => '&#35066;',
		"\xE3\xFA" => '&#35070;',
		"\xE3\xFB" => '&#35054;',
		"\xE3\xFC" => '&#35068;',
		"\xE3\xFD" => '&#35062;',
		"\xE3\xFE" => '&#35067;',
		"\xE4\x40" => '&#35056;',
		"\xE4\x41" => '&#35052;',
		"\xE4\x42" => '&#35051;',
		"\xE4\x43" => '&#35229;',
		"\xE4\x44" => '&#35233;',
		"\xE4\x45" => '&#35231;',
		"\xE4\x46" => '&#35230;',
		"\xE4\x47" => '&#35305;',
		"\xE4\x48" => '&#35307;',
		"\xE4\x49" => '&#35304;',
		"\xE4\x4A" => '&#35499;',
		"\xE4\x4B" => '&#35481;',
		"\xE4\x4C" => '&#35467;',
		"\xE4\x4D" => '&#35474;',
		"\xE4\x4E" => '&#35471;',
		"\xE4\x4F" => '&#35478;',
		"\xE4\x50" => '&#35901;',
		"\xE4\x51" => '&#35944;',
		"\xE4\x52" => '&#35945;',
		"\xE4\x53" => '&#36053;',
		"\xE4\x54" => '&#36047;',
		"\xE4\x55" => '&#36055;',
		"\xE4\x56" => '&#36246;',
		"\xE4\x57" => '&#36361;',
		"\xE4\x58" => '&#36354;',
		"\xE4\x59" => '&#36351;',
		"\xE4\x5A" => '&#36365;',
		"\xE4\x5B" => '&#36349;',
		"\xE4\x5C" => '&#36362;',
		"\xE4\x5D" => '&#36355;',
		"\xE4\x5E" => '&#36359;',
		"\xE4\x5F" => '&#36358;',
		"\xE4\x60" => '&#36357;',
		"\xE4\x61" => '&#36350;',
		"\xE4\x62" => '&#36352;',
		"\xE4\x63" => '&#36356;',
		"\xE4\x64" => '&#36624;',
		"\xE4\x65" => '&#36625;',
		"\xE4\x66" => '&#36622;',
		"\xE4\x67" => '&#36621;',
		"\xE4\x68" => '&#37155;',
		"\xE4\x69" => '&#37148;',
		"\xE4\x6A" => '&#37152;',
		"\xE4\x6B" => '&#37154;',
		"\xE4\x6C" => '&#37151;',
		"\xE4\x6D" => '&#37149;',
		"\xE4\x6E" => '&#37146;',
		"\xE4\x6F" => '&#37156;',
		"\xE4\x70" => '&#37153;',
		"\xE4\x71" => '&#37147;',
		"\xE4\x72" => '&#37242;',
		"\xE4\x73" => '&#37234;',
		"\xE4\x74" => '&#37241;',
		"\xE4\x75" => '&#37235;',
		"\xE4\x76" => '&#37541;',
		"\xE4\x77" => '&#37540;',
		"\xE4\x78" => '&#37494;',
		"\xE4\x79" => '&#37531;',
		"\xE4\x7A" => '&#37498;',
		"\xE4\x7B" => '&#37536;',
		"\xE4\x7C" => '&#37524;',
		"\xE4\x7D" => '&#37546;',
		"\xE4\x7E" => '&#37517;',
		"\xE4\xA1" => '&#37542;',
		"\xE4\xA2" => '&#37530;',
		"\xE4\xA3" => '&#37547;',
		"\xE4\xA4" => '&#37497;',
		"\xE4\xA5" => '&#37527;',
		"\xE4\xA6" => '&#37503;',
		"\xE4\xA7" => '&#37539;',
		"\xE4\xA8" => '&#37614;',
		"\xE4\xA9" => '&#37518;',
		"\xE4\xAA" => '&#37506;',
		"\xE4\xAB" => '&#37525;',
		"\xE4\xAC" => '&#37538;',
		"\xE4\xAD" => '&#37501;',
		"\xE4\xAE" => '&#37512;',
		"\xE4\xAF" => '&#37537;',
		"\xE4\xB0" => '&#37514;',
		"\xE4\xB1" => '&#37510;',
		"\xE4\xB2" => '&#37516;',
		"\xE4\xB3" => '&#37529;',
		"\xE4\xB4" => '&#37543;',
		"\xE4\xB5" => '&#37502;',
		"\xE4\xB6" => '&#37511;',
		"\xE4\xB7" => '&#37545;',
		"\xE4\xB8" => '&#37533;',
		"\xE4\xB9" => '&#37515;',
		"\xE4\xBA" => '&#37421;',
		"\xE4\xBB" => '&#38558;',
		"\xE4\xBC" => '&#38561;',
		"\xE4\xBD" => '&#38655;',
		"\xE4\xBE" => '&#38744;',
		"\xE4\xBF" => '&#38781;',
		"\xE4\xC0" => '&#38778;',
		"\xE4\xC1" => '&#38782;',
		"\xE4\xC2" => '&#38787;',
		"\xE4\xC3" => '&#38784;',
		"\xE4\xC4" => '&#38786;',
		"\xE4\xC5" => '&#38779;',
		"\xE4\xC6" => '&#38788;',
		"\xE4\xC7" => '&#38785;',
		"\xE4\xC8" => '&#38783;',
		"\xE4\xC9" => '&#38862;',
		"\xE4\xCA" => '&#38861;',
		"\xE4\xCB" => '&#38934;',
		"\xE4\xCC" => '&#39085;',
		"\xE4\xCD" => '&#39086;',
		"\xE4\xCE" => '&#39170;',
		"\xE4\xCF" => '&#39168;',
		"\xE4\xD0" => '&#39175;',
		"\xE4\xD1" => '&#39325;',
		"\xE4\xD2" => '&#39324;',
		"\xE4\xD3" => '&#39363;',
		"\xE4\xD4" => '&#39353;',
		"\xE4\xD5" => '&#39355;',
		"\xE4\xD6" => '&#39354;',
		"\xE4\xD7" => '&#39362;',
		"\xE4\xD8" => '&#39357;',
		"\xE4\xD9" => '&#39367;',
		"\xE4\xDA" => '&#39601;',
		"\xE4\xDB" => '&#39651;',
		"\xE4\xDC" => '&#39655;',
		"\xE4\xDD" => '&#39742;',
		"\xE4\xDE" => '&#39743;',
		"\xE4\xDF" => '&#39776;',
		"\xE4\xE0" => '&#39777;',
		"\xE4\xE1" => '&#39775;',
		"\xE4\xE2" => '&#40177;',
		"\xE4\xE3" => '&#40178;',
		"\xE4\xE4" => '&#40181;',
		"\xE4\xE5" => '&#40615;',
		"\xE4\xE6" => '&#20735;',
		"\xE4\xE7" => '&#20739;',
		"\xE4\xE8" => '&#20784;',
		"\xE4\xE9" => '&#20728;',
		"\xE4\xEA" => '&#20742;',
		"\xE4\xEB" => '&#20743;',
		"\xE4\xEC" => '&#20726;',
		"\xE4\xED" => '&#20734;',
		"\xE4\xEE" => '&#20747;',
		"\xE4\xEF" => '&#20748;',
		"\xE4\xF0" => '&#20733;',
		"\xE4\xF1" => '&#20746;',
		"\xE4\xF2" => '&#21131;',
		"\xE4\xF3" => '&#21132;',
		"\xE4\xF4" => '&#21233;',
		"\xE4\xF5" => '&#21231;',
		"\xE4\xF6" => '&#22088;',
		"\xE4\xF7" => '&#22082;',
		"\xE4\xF8" => '&#22092;',
		"\xE4\xF9" => '&#22069;',
		"\xE4\xFA" => '&#22081;',
		"\xE4\xFB" => '&#22090;',
		"\xE4\xFC" => '&#22089;',
		"\xE4\xFD" => '&#22086;',
		"\xE4\xFE" => '&#22104;',
		"\xE5\x40" => '&#22106;',
		"\xE5\x41" => '&#22080;',
		"\xE5\x42" => '&#22067;',
		"\xE5\x43" => '&#22077;',
		"\xE5\x44" => '&#22060;',
		"\xE5\x45" => '&#22078;',
		"\xE5\x46" => '&#22072;',
		"\xE5\x47" => '&#22058;',
		"\xE5\x48" => '&#22074;',
		"\xE5\x49" => '&#22298;',
		"\xE5\x4A" => '&#22699;',
		"\xE5\x4B" => '&#22685;',
		"\xE5\x4C" => '&#22705;',
		"\xE5\x4D" => '&#22688;',
		"\xE5\x4E" => '&#22691;',
		"\xE5\x4F" => '&#22703;',
		"\xE5\x50" => '&#22700;',
		"\xE5\x51" => '&#22693;',
		"\xE5\x52" => '&#22689;',
		"\xE5\x53" => '&#22783;',
		"\xE5\x54" => '&#23295;',
		"\xE5\x55" => '&#23284;',
		"\xE5\x56" => '&#23293;',
		"\xE5\x57" => '&#23287;',
		"\xE5\x58" => '&#23286;',
		"\xE5\x59" => '&#23299;',
		"\xE5\x5A" => '&#23288;',
		"\xE5\x5B" => '&#23298;',
		"\xE5\x5C" => '&#23289;',
		"\xE5\x5D" => '&#23297;',
		"\xE5\x5E" => '&#23303;',
		"\xE5\x5F" => '&#23301;',
		"\xE5\x60" => '&#23311;',
		"\xE5\x61" => '&#23655;',
		"\xE5\x62" => '&#23961;',
		"\xE5\x63" => '&#23959;',
		"\xE5\x64" => '&#23967;',
		"\xE5\x65" => '&#23954;',
		"\xE5\x66" => '&#23970;',
		"\xE5\x67" => '&#23955;',
		"\xE5\x68" => '&#23957;',
		"\xE5\x69" => '&#23968;',
		"\xE5\x6A" => '&#23964;',
		"\xE5\x6B" => '&#23969;',
		"\xE5\x6C" => '&#23962;',
		"\xE5\x6D" => '&#23966;',
		"\xE5\x6E" => '&#24169;',
		"\xE5\x6F" => '&#24157;',
		"\xE5\x70" => '&#24160;',
		"\xE5\x71" => '&#24156;',
		"\xE5\x72" => '&#32243;',
		"\xE5\x73" => '&#24283;',
		"\xE5\x74" => '&#24286;',
		"\xE5\x75" => '&#24289;',
		"\xE5\x76" => '&#24393;',
		"\xE5\x77" => '&#24498;',
		"\xE5\x78" => '&#24971;',
		"\xE5\x79" => '&#24963;',
		"\xE5\x7A" => '&#24953;',
		"\xE5\x7B" => '&#25009;',
		"\xE5\x7C" => '&#25008;',
		"\xE5\x7D" => '&#24994;',
		"\xE5\x7E" => '&#24969;',
		"\xE5\xA1" => '&#24987;',
		"\xE5\xA2" => '&#24979;',
		"\xE5\xA3" => '&#25007;',
		"\xE5\xA4" => '&#25005;',
		"\xE5\xA5" => '&#24991;',
		"\xE5\xA6" => '&#24978;',
		"\xE5\xA7" => '&#25002;',
		"\xE5\xA8" => '&#24993;',
		"\xE5\xA9" => '&#24973;',
		"\xE5\xAA" => '&#24934;',
		"\xE5\xAB" => '&#25011;',
		"\xE5\xAC" => '&#25133;',
		"\xE5\xAD" => '&#25710;',
		"\xE5\xAE" => '&#25712;',
		"\xE5\xAF" => '&#25750;',
		"\xE5\xB0" => '&#25760;',
		"\xE5\xB1" => '&#25733;',
		"\xE5\xB2" => '&#25751;',
		"\xE5\xB3" => '&#25756;',
		"\xE5\xB4" => '&#25743;',
		"\xE5\xB5" => '&#25739;',
		"\xE5\xB6" => '&#25738;',
		"\xE5\xB7" => '&#25740;',
		"\xE5\xB8" => '&#25763;',
		"\xE5\xB9" => '&#25759;',
		"\xE5\xBA" => '&#25704;',
		"\xE5\xBB" => '&#25777;',
		"\xE5\xBC" => '&#25752;',
		"\xE5\xBD" => '&#25974;',
		"\xE5\xBE" => '&#25978;',
		"\xE5\xBF" => '&#25977;',
		"\xE5\xC0" => '&#25979;',
		"\xE5\xC1" => '&#26034;',
		"\xE5\xC2" => '&#26035;',
		"\xE5\xC3" => '&#26293;',
		"\xE5\xC4" => '&#26288;',
		"\xE5\xC5" => '&#26281;',
		"\xE5\xC6" => '&#26290;',
		"\xE5\xC7" => '&#26295;',
		"\xE5\xC8" => '&#26282;',
		"\xE5\xC9" => '&#26287;',
		"\xE5\xCA" => '&#27136;',
		"\xE5\xCB" => '&#27142;',
		"\xE5\xCC" => '&#27159;',
		"\xE5\xCD" => '&#27109;',
		"\xE5\xCE" => '&#27128;',
		"\xE5\xCF" => '&#27157;',
		"\xE5\xD0" => '&#27121;',
		"\xE5\xD1" => '&#27108;',
		"\xE5\xD2" => '&#27168;',
		"\xE5\xD3" => '&#27135;',
		"\xE5\xD4" => '&#27116;',
		"\xE5\xD5" => '&#27106;',
		"\xE5\xD6" => '&#27163;',
		"\xE5\xD7" => '&#27165;',
		"\xE5\xD8" => '&#27134;',
		"\xE5\xD9" => '&#27175;',
		"\xE5\xDA" => '&#27122;',
		"\xE5\xDB" => '&#27118;',
		"\xE5\xDC" => '&#27156;',
		"\xE5\xDD" => '&#27127;',
		"\xE5\xDE" => '&#27111;',
		"\xE5\xDF" => '&#27200;',
		"\xE5\xE0" => '&#27144;',
		"\xE5\xE1" => '&#27110;',
		"\xE5\xE2" => '&#27131;',
		"\xE5\xE3" => '&#27149;',
		"\xE5\xE4" => '&#27132;',
		"\xE5\xE5" => '&#27115;',
		"\xE5\xE6" => '&#27145;',
		"\xE5\xE7" => '&#27140;',
		"\xE5\xE8" => '&#27160;',
		"\xE5\xE9" => '&#27173;',
		"\xE5\xEA" => '&#27151;',
		"\xE5\xEB" => '&#27126;',
		"\xE5\xEC" => '&#27174;',
		"\xE5\xED" => '&#27143;',
		"\xE5\xEE" => '&#27124;',
		"\xE5\xEF" => '&#27158;',
		"\xE5\xF0" => '&#27473;',
		"\xE5\xF1" => '&#27557;',
		"\xE5\xF2" => '&#27555;',
		"\xE5\xF3" => '&#27554;',
		"\xE5\xF4" => '&#27558;',
		"\xE5\xF5" => '&#27649;',
		"\xE5\xF6" => '&#27648;',
		"\xE5\xF7" => '&#27647;',
		"\xE5\xF8" => '&#27650;',
		"\xE5\xF9" => '&#28481;',
		"\xE5\xFA" => '&#28454;',
		"\xE5\xFB" => '&#28542;',
		"\xE5\xFC" => '&#28551;',
		"\xE5\xFD" => '&#28614;',
		"\xE5\xFE" => '&#28562;',
		"\xE6\x40" => '&#28557;',
		"\xE6\x41" => '&#28553;',
		"\xE6\x42" => '&#28556;',
		"\xE6\x43" => '&#28514;',
		"\xE6\x44" => '&#28495;',
		"\xE6\x45" => '&#28549;',
		"\xE6\x46" => '&#28506;',
		"\xE6\x47" => '&#28566;',
		"\xE6\x48" => '&#28534;',
		"\xE6\x49" => '&#28524;',
		"\xE6\x4A" => '&#28546;',
		"\xE6\x4B" => '&#28501;',
		"\xE6\x4C" => '&#28530;',
		"\xE6\x4D" => '&#28498;',
		"\xE6\x4E" => '&#28496;',
		"\xE6\x4F" => '&#28503;',
		"\xE6\x50" => '&#28564;',
		"\xE6\x51" => '&#28563;',
		"\xE6\x52" => '&#28509;',
		"\xE6\x53" => '&#28416;',
		"\xE6\x54" => '&#28513;',
		"\xE6\x55" => '&#28523;',
		"\xE6\x56" => '&#28541;',
		"\xE6\x57" => '&#28519;',
		"\xE6\x58" => '&#28560;',
		"\xE6\x59" => '&#28499;',
		"\xE6\x5A" => '&#28555;',
		"\xE6\x5B" => '&#28521;',
		"\xE6\x5C" => '&#28543;',
		"\xE6\x5D" => '&#28565;',
		"\xE6\x5E" => '&#28515;',
		"\xE6\x5F" => '&#28535;',
		"\xE6\x60" => '&#28522;',
		"\xE6\x61" => '&#28539;',
		"\xE6\x62" => '&#29106;',
		"\xE6\x63" => '&#29103;',
		"\xE6\x64" => '&#29083;',
		"\xE6\x65" => '&#29104;',
		"\xE6\x66" => '&#29088;',
		"\xE6\x67" => '&#29082;',
		"\xE6\x68" => '&#29097;',
		"\xE6\x69" => '&#29109;',
		"\xE6\x6A" => '&#29085;',
		"\xE6\x6B" => '&#29093;',
		"\xE6\x6C" => '&#29086;',
		"\xE6\x6D" => '&#29092;',
		"\xE6\x6E" => '&#29089;',
		"\xE6\x6F" => '&#29098;',
		"\xE6\x70" => '&#29084;',
		"\xE6\x71" => '&#29095;',
		"\xE6\x72" => '&#29107;',
		"\xE6\x73" => '&#29336;',
		"\xE6\x74" => '&#29338;',
		"\xE6\x75" => '&#29528;',
		"\xE6\x76" => '&#29522;',
		"\xE6\x77" => '&#29534;',
		"\xE6\x78" => '&#29535;',
		"\xE6\x79" => '&#29536;',
		"\xE6\x7A" => '&#29533;',
		"\xE6\x7B" => '&#29531;',
		"\xE6\x7C" => '&#29537;',
		"\xE6\x7D" => '&#29530;',
		"\xE6\x7E" => '&#29529;',
		"\xE6\xA1" => '&#29538;',
		"\xE6\xA2" => '&#29831;',
		"\xE6\xA3" => '&#29833;',
		"\xE6\xA4" => '&#29834;',
		"\xE6\xA5" => '&#29830;',
		"\xE6\xA6" => '&#29825;',
		"\xE6\xA7" => '&#29821;',
		"\xE6\xA8" => '&#29829;',
		"\xE6\xA9" => '&#29832;',
		"\xE6\xAA" => '&#29820;',
		"\xE6\xAB" => '&#29817;',
		"\xE6\xAC" => '&#29960;',
		"\xE6\xAD" => '&#29959;',
		"\xE6\xAE" => '&#30078;',
		"\xE6\xAF" => '&#30245;',
		"\xE6\xB0" => '&#30238;',
		"\xE6\xB1" => '&#30233;',
		"\xE6\xB2" => '&#30237;',
		"\xE6\xB3" => '&#30236;',
		"\xE6\xB4" => '&#30243;',
		"\xE6\xB5" => '&#30234;',
		"\xE6\xB6" => '&#30248;',
		"\xE6\xB7" => '&#30235;',
		"\xE6\xB8" => '&#30364;',
		"\xE6\xB9" => '&#30365;',
		"\xE6\xBA" => '&#30366;',
		"\xE6\xBB" => '&#30363;',
		"\xE6\xBC" => '&#30605;',
		"\xE6\xBD" => '&#30607;',
		"\xE6\xBE" => '&#30601;',
		"\xE6\xBF" => '&#30600;',
		"\xE6\xC0" => '&#30925;',
		"\xE6\xC1" => '&#30907;',
		"\xE6\xC2" => '&#30927;',
		"\xE6\xC3" => '&#30924;',
		"\xE6\xC4" => '&#30929;',
		"\xE6\xC5" => '&#30926;',
		"\xE6\xC6" => '&#30932;',
		"\xE6\xC7" => '&#30920;',
		"\xE6\xC8" => '&#30915;',
		"\xE6\xC9" => '&#30916;',
		"\xE6\xCA" => '&#30921;',
		"\xE6\xCB" => '&#31130;',
		"\xE6\xCC" => '&#31137;',
		"\xE6\xCD" => '&#31136;',
		"\xE6\xCE" => '&#31132;',
		"\xE6\xCF" => '&#31138;',
		"\xE6\xD0" => '&#31131;',
		"\xE6\xD1" => '&#27510;',
		"\xE6\xD2" => '&#31289;',
		"\xE6\xD3" => '&#31410;',
		"\xE6\xD4" => '&#31412;',
		"\xE6\xD5" => '&#31411;',
		"\xE6\xD6" => '&#31671;',
		"\xE6\xD7" => '&#31691;',
		"\xE6\xD8" => '&#31678;',
		"\xE6\xD9" => '&#31660;',
		"\xE6\xDA" => '&#31694;',
		"\xE6\xDB" => '&#31663;',
		"\xE6\xDC" => '&#31673;',
		"\xE6\xDD" => '&#31690;',
		"\xE6\xDE" => '&#31669;',
		"\xE6\xDF" => '&#31941;',
		"\xE6\xE0" => '&#31944;',
		"\xE6\xE1" => '&#31948;',
		"\xE6\xE2" => '&#31947;',
		"\xE6\xE3" => '&#32247;',
		"\xE6\xE4" => '&#32219;',
		"\xE6\xE5" => '&#32234;',
		"\xE6\xE6" => '&#32231;',
		"\xE6\xE7" => '&#32215;',
		"\xE6\xE8" => '&#32225;',
		"\xE6\xE9" => '&#32259;',
		"\xE6\xEA" => '&#32250;',
		"\xE6\xEB" => '&#32230;',
		"\xE6\xEC" => '&#32246;',
		"\xE6\xED" => '&#32241;',
		"\xE6\xEE" => '&#32240;',
		"\xE6\xEF" => '&#32238;',
		"\xE6\xF0" => '&#32223;',
		"\xE6\xF1" => '&#32630;',
		"\xE6\xF2" => '&#32684;',
		"\xE6\xF3" => '&#32688;',
		"\xE6\xF4" => '&#32685;',
		"\xE6\xF5" => '&#32749;',
		"\xE6\xF6" => '&#32747;',
		"\xE6\xF7" => '&#32746;',
		"\xE6\xF8" => '&#32748;',
		"\xE6\xF9" => '&#32742;',
		"\xE6\xFA" => '&#32744;',
		"\xE6\xFB" => '&#32868;',
		"\xE6\xFC" => '&#32871;',
		"\xE6\xFD" => '&#33187;',
		"\xE6\xFE" => '&#33183;',
		"\xE7\x40" => '&#33182;',
		"\xE7\x41" => '&#33173;',
		"\xE7\x42" => '&#33186;',
		"\xE7\x43" => '&#33177;',
		"\xE7\x44" => '&#33175;',
		"\xE7\x45" => '&#33302;',
		"\xE7\x46" => '&#33359;',
		"\xE7\x47" => '&#33363;',
		"\xE7\x48" => '&#33362;',
		"\xE7\x49" => '&#33360;',
		"\xE7\x4A" => '&#33358;',
		"\xE7\x4B" => '&#33361;',
		"\xE7\x4C" => '&#34084;',
		"\xE7\x4D" => '&#34107;',
		"\xE7\x4E" => '&#34063;',
		"\xE7\x4F" => '&#34048;',
		"\xE7\x50" => '&#34089;',
		"\xE7\x51" => '&#34062;',
		"\xE7\x52" => '&#34057;',
		"\xE7\x53" => '&#34061;',
		"\xE7\x54" => '&#34079;',
		"\xE7\x55" => '&#34058;',
		"\xE7\x56" => '&#34087;',
		"\xE7\x57" => '&#34076;',
		"\xE7\x58" => '&#34043;',
		"\xE7\x59" => '&#34091;',
		"\xE7\x5A" => '&#34042;',
		"\xE7\x5B" => '&#34056;',
		"\xE7\x5C" => '&#34060;',
		"\xE7\x5D" => '&#34036;',
		"\xE7\x5E" => '&#34090;',
		"\xE7\x5F" => '&#34034;',
		"\xE7\x60" => '&#34069;',
		"\xE7\x61" => '&#34039;',
		"\xE7\x62" => '&#34027;',
		"\xE7\x63" => '&#34035;',
		"\xE7\x64" => '&#34044;',
		"\xE7\x65" => '&#34066;',
		"\xE7\x66" => '&#34026;',
		"\xE7\x67" => '&#34025;',
		"\xE7\x68" => '&#34070;',
		"\xE7\x69" => '&#34046;',
		"\xE7\x6A" => '&#34088;',
		"\xE7\x6B" => '&#34077;',
		"\xE7\x6C" => '&#34094;',
		"\xE7\x6D" => '&#34050;',
		"\xE7\x6E" => '&#34045;',
		"\xE7\x6F" => '&#34078;',
		"\xE7\x70" => '&#34038;',
		"\xE7\x71" => '&#34097;',
		"\xE7\x72" => '&#34086;',
		"\xE7\x73" => '&#34023;',
		"\xE7\x74" => '&#34024;',
		"\xE7\x75" => '&#34032;',
		"\xE7\x76" => '&#34031;',
		"\xE7\x77" => '&#34041;',
		"\xE7\x78" => '&#34072;',
		"\xE7\x79" => '&#34080;',
		"\xE7\x7A" => '&#34096;',
		"\xE7\x7B" => '&#34059;',
		"\xE7\x7C" => '&#34073;',
		"\xE7\x7D" => '&#34095;',
		"\xE7\x7E" => '&#34402;',
		"\xE7\xA1" => '&#34646;',
		"\xE7\xA2" => '&#34659;',
		"\xE7\xA3" => '&#34660;',
		"\xE7\xA4" => '&#34679;',
		"\xE7\xA5" => '&#34785;',
		"\xE7\xA6" => '&#34675;',
		"\xE7\xA7" => '&#34648;',
		"\xE7\xA8" => '&#34644;',
		"\xE7\xA9" => '&#34651;',
		"\xE7\xAA" => '&#34642;',
		"\xE7\xAB" => '&#34657;',
		"\xE7\xAC" => '&#34650;',
		"\xE7\xAD" => '&#34641;',
		"\xE7\xAE" => '&#34654;',
		"\xE7\xAF" => '&#34669;',
		"\xE7\xB0" => '&#34666;',
		"\xE7\xB1" => '&#34640;',
		"\xE7\xB2" => '&#34638;',
		"\xE7\xB3" => '&#34655;',
		"\xE7\xB4" => '&#34653;',
		"\xE7\xB5" => '&#34671;',
		"\xE7\xB6" => '&#34668;',
		"\xE7\xB7" => '&#34682;',
		"\xE7\xB8" => '&#34670;',
		"\xE7\xB9" => '&#34652;',
		"\xE7\xBA" => '&#34661;',
		"\xE7\xBB" => '&#34639;',
		"\xE7\xBC" => '&#34683;',
		"\xE7\xBD" => '&#34677;',
		"\xE7\xBE" => '&#34658;',
		"\xE7\xBF" => '&#34663;',
		"\xE7\xC0" => '&#34665;',
		"\xE7\xC1" => '&#34906;',
		"\xE7\xC2" => '&#35077;',
		"\xE7\xC3" => '&#35084;',
		"\xE7\xC4" => '&#35092;',
		"\xE7\xC5" => '&#35083;',
		"\xE7\xC6" => '&#35095;',
		"\xE7\xC7" => '&#35096;',
		"\xE7\xC8" => '&#35097;',
		"\xE7\xC9" => '&#35078;',
		"\xE7\xCA" => '&#35094;',
		"\xE7\xCB" => '&#35089;',
		"\xE7\xCC" => '&#35086;',
		"\xE7\xCD" => '&#35081;',
		"\xE7\xCE" => '&#35234;',
		"\xE7\xCF" => '&#35236;',
		"\xE7\xD0" => '&#35235;',
		"\xE7\xD1" => '&#35309;',
		"\xE7\xD2" => '&#35312;',
		"\xE7\xD3" => '&#35308;',
		"\xE7\xD4" => '&#35535;',
		"\xE7\xD5" => '&#35526;',
		"\xE7\xD6" => '&#35512;',
		"\xE7\xD7" => '&#35539;',
		"\xE7\xD8" => '&#35537;',
		"\xE7\xD9" => '&#35540;',
		"\xE7\xDA" => '&#35541;',
		"\xE7\xDB" => '&#35515;',
		"\xE7\xDC" => '&#35543;',
		"\xE7\xDD" => '&#35518;',
		"\xE7\xDE" => '&#35520;',
		"\xE7\xDF" => '&#35525;',
		"\xE7\xE0" => '&#35544;',
		"\xE7\xE1" => '&#35523;',
		"\xE7\xE2" => '&#35514;',
		"\xE7\xE3" => '&#35517;',
		"\xE7\xE4" => '&#35545;',
		"\xE7\xE5" => '&#35902;',
		"\xE7\xE6" => '&#35917;',
		"\xE7\xE7" => '&#35983;',
		"\xE7\xE8" => '&#36069;',
		"\xE7\xE9" => '&#36063;',
		"\xE7\xEA" => '&#36057;',
		"\xE7\xEB" => '&#36072;',
		"\xE7\xEC" => '&#36058;',
		"\xE7\xED" => '&#36061;',
		"\xE7\xEE" => '&#36071;',
		"\xE7\xEF" => '&#36256;',
		"\xE7\xF0" => '&#36252;',
		"\xE7\xF1" => '&#36257;',
		"\xE7\xF2" => '&#36251;',
		"\xE7\xF3" => '&#36384;',
		"\xE7\xF4" => '&#36387;',
		"\xE7\xF5" => '&#36389;',
		"\xE7\xF6" => '&#36388;',
		"\xE7\xF7" => '&#36398;',
		"\xE7\xF8" => '&#36373;',
		"\xE7\xF9" => '&#36379;',
		"\xE7\xFA" => '&#36374;',
		"\xE7\xFB" => '&#36369;',
		"\xE7\xFC" => '&#36377;',
		"\xE7\xFD" => '&#36390;',
		"\xE7\xFE" => '&#36391;',
		"\xE8\x40" => '&#36372;',
		"\xE8\x41" => '&#36370;',
		"\xE8\x42" => '&#36376;',
		"\xE8\x43" => '&#36371;',
		"\xE8\x44" => '&#36380;',
		"\xE8\x45" => '&#36375;',
		"\xE8\x46" => '&#36378;',
		"\xE8\x47" => '&#36652;',
		"\xE8\x48" => '&#36644;',
		"\xE8\x49" => '&#36632;',
		"\xE8\x4A" => '&#36634;',
		"\xE8\x4B" => '&#36640;',
		"\xE8\x4C" => '&#36643;',
		"\xE8\x4D" => '&#36630;',
		"\xE8\x4E" => '&#36631;',
		"\xE8\x4F" => '&#36979;',
		"\xE8\x50" => '&#36976;',
		"\xE8\x51" => '&#36975;',
		"\xE8\x52" => '&#36967;',
		"\xE8\x53" => '&#36971;',
		"\xE8\x54" => '&#37167;',
		"\xE8\x55" => '&#37163;',
		"\xE8\x56" => '&#37161;',
		"\xE8\x57" => '&#37162;',
		"\xE8\x58" => '&#37170;',
		"\xE8\x59" => '&#37158;',
		"\xE8\x5A" => '&#37166;',
		"\xE8\x5B" => '&#37253;',
		"\xE8\x5C" => '&#37254;',
		"\xE8\x5D" => '&#37258;',
		"\xE8\x5E" => '&#37249;',
		"\xE8\x5F" => '&#37250;',
		"\xE8\x60" => '&#37252;',
		"\xE8\x61" => '&#37248;',
		"\xE8\x62" => '&#37584;',
		"\xE8\x63" => '&#37571;',
		"\xE8\x64" => '&#37572;',
		"\xE8\x65" => '&#37568;',
		"\xE8\x66" => '&#37593;',
		"\xE8\x67" => '&#37558;',
		"\xE8\x68" => '&#37583;',
		"\xE8\x69" => '&#37617;',
		"\xE8\x6A" => '&#37599;',
		"\xE8\x6B" => '&#37592;',
		"\xE8\x6C" => '&#37609;',
		"\xE8\x6D" => '&#37591;',
		"\xE8\x6E" => '&#37597;',
		"\xE8\x6F" => '&#37580;',
		"\xE8\x70" => '&#37615;',
		"\xE8\x71" => '&#37570;',
		"\xE8\x72" => '&#37608;',
		"\xE8\x73" => '&#37578;',
		"\xE8\x74" => '&#37576;',
		"\xE8\x75" => '&#37582;',
		"\xE8\x76" => '&#37606;',
		"\xE8\x77" => '&#37581;',
		"\xE8\x78" => '&#37589;',
		"\xE8\x79" => '&#37577;',
		"\xE8\x7A" => '&#37600;',
		"\xE8\x7B" => '&#37598;',
		"\xE8\x7C" => '&#37607;',
		"\xE8\x7D" => '&#37585;',
		"\xE8\x7E" => '&#37587;',
		"\xE8\xA1" => '&#37557;',
		"\xE8\xA2" => '&#37601;',
		"\xE8\xA3" => '&#37574;',
		"\xE8\xA4" => '&#37556;',
		"\xE8\xA5" => '&#38268;',
		"\xE8\xA6" => '&#38316;',
		"\xE8\xA7" => '&#38315;',
		"\xE8\xA8" => '&#38318;',
		"\xE8\xA9" => '&#38320;',
		"\xE8\xAA" => '&#38564;',
		"\xE8\xAB" => '&#38562;',
		"\xE8\xAC" => '&#38611;',
		"\xE8\xAD" => '&#38661;',
		"\xE8\xAE" => '&#38664;',
		"\xE8\xAF" => '&#38658;',
		"\xE8\xB0" => '&#38746;',
		"\xE8\xB1" => '&#38794;',
		"\xE8\xB2" => '&#38798;',
		"\xE8\xB3" => '&#38792;',
		"\xE8\xB4" => '&#38864;',
		"\xE8\xB5" => '&#38863;',
		"\xE8\xB6" => '&#38942;',
		"\xE8\xB7" => '&#38941;',
		"\xE8\xB8" => '&#38950;',
		"\xE8\xB9" => '&#38953;',
		"\xE8\xBA" => '&#38952;',
		"\xE8\xBB" => '&#38944;',
		"\xE8\xBC" => '&#38939;',
		"\xE8\xBD" => '&#38951;',
		"\xE8\xBE" => '&#39090;',
		"\xE8\xBF" => '&#39176;',
		"\xE8\xC0" => '&#39162;',
		"\xE8\xC1" => '&#39185;',
		"\xE8\xC2" => '&#39188;',
		"\xE8\xC3" => '&#39190;',
		"\xE8\xC4" => '&#39191;',
		"\xE8\xC5" => '&#39189;',
		"\xE8\xC6" => '&#39388;',
		"\xE8\xC7" => '&#39373;',
		"\xE8\xC8" => '&#39375;',
		"\xE8\xC9" => '&#39379;',
		"\xE8\xCA" => '&#39380;',
		"\xE8\xCB" => '&#39374;',
		"\xE8\xCC" => '&#39369;',
		"\xE8\xCD" => '&#39382;',
		"\xE8\xCE" => '&#39384;',
		"\xE8\xCF" => '&#39371;',
		"\xE8\xD0" => '&#39383;',
		"\xE8\xD1" => '&#39372;',
		"\xE8\xD2" => '&#39603;',
		"\xE8\xD3" => '&#39660;',
		"\xE8\xD4" => '&#39659;',
		"\xE8\xD5" => '&#39667;',
		"\xE8\xD6" => '&#39666;',
		"\xE8\xD7" => '&#39665;',
		"\xE8\xD8" => '&#39750;',
		"\xE8\xD9" => '&#39747;',
		"\xE8\xDA" => '&#39783;',
		"\xE8\xDB" => '&#39796;',
		"\xE8\xDC" => '&#39793;',
		"\xE8\xDD" => '&#39782;',
		"\xE8\xDE" => '&#39798;',
		"\xE8\xDF" => '&#39797;',
		"\xE8\xE0" => '&#39792;',
		"\xE8\xE1" => '&#39784;',
		"\xE8\xE2" => '&#39780;',
		"\xE8\xE3" => '&#39788;',
		"\xE8\xE4" => '&#40188;',
		"\xE8\xE5" => '&#40186;',
		"\xE8\xE6" => '&#40189;',
		"\xE8\xE7" => '&#40191;',
		"\xE8\xE8" => '&#40183;',
		"\xE8\xE9" => '&#40199;',
		"\xE8\xEA" => '&#40192;',
		"\xE8\xEB" => '&#40185;',
		"\xE8\xEC" => '&#40187;',
		"\xE8\xED" => '&#40200;',
		"\xE8\xEE" => '&#40197;',
		"\xE8\xEF" => '&#40196;',
		"\xE8\xF0" => '&#40579;',
		"\xE8\xF1" => '&#40659;',
		"\xE8\xF2" => '&#40719;',
		"\xE8\xF3" => '&#40720;',
		"\xE8\xF4" => '&#20764;',
		"\xE8\xF5" => '&#20755;',
		"\xE8\xF6" => '&#20759;',
		"\xE8\xF7" => '&#20762;',
		"\xE8\xF8" => '&#20753;',
		"\xE8\xF9" => '&#20958;',
		"\xE8\xFA" => '&#21300;',
		"\xE8\xFB" => '&#21473;',
		"\xE8\xFC" => '&#22128;',
		"\xE8\xFD" => '&#22112;',
		"\xE8\xFE" => '&#22126;',
		"\xE9\x40" => '&#22131;',
		"\xE9\x41" => '&#22118;',
		"\xE9\x42" => '&#22115;',
		"\xE9\x43" => '&#22125;',
		"\xE9\x44" => '&#22130;',
		"\xE9\x45" => '&#22110;',
		"\xE9\x46" => '&#22135;',
		"\xE9\x47" => '&#22300;',
		"\xE9\x48" => '&#22299;',
		"\xE9\x49" => '&#22728;',
		"\xE9\x4A" => '&#22717;',
		"\xE9\x4B" => '&#22729;',
		"\xE9\x4C" => '&#22719;',
		"\xE9\x4D" => '&#22714;',
		"\xE9\x4E" => '&#22722;',
		"\xE9\x4F" => '&#22716;',
		"\xE9\x50" => '&#22726;',
		"\xE9\x51" => '&#23319;',
		"\xE9\x52" => '&#23321;',
		"\xE9\x53" => '&#23323;',
		"\xE9\x54" => '&#23329;',
		"\xE9\x55" => '&#23316;',
		"\xE9\x56" => '&#23315;',
		"\xE9\x57" => '&#23312;',
		"\xE9\x58" => '&#23318;',
		"\xE9\x59" => '&#23336;',
		"\xE9\x5A" => '&#23322;',
		"\xE9\x5B" => '&#23328;',
		"\xE9\x5C" => '&#23326;',
		"\xE9\x5D" => '&#23535;',
		"\xE9\x5E" => '&#23980;',
		"\xE9\x5F" => '&#23985;',
		"\xE9\x60" => '&#23977;',
		"\xE9\x61" => '&#23975;',
		"\xE9\x62" => '&#23989;',
		"\xE9\x63" => '&#23984;',
		"\xE9\x64" => '&#23982;',
		"\xE9\x65" => '&#23978;',
		"\xE9\x66" => '&#23976;',
		"\xE9\x67" => '&#23986;',
		"\xE9\x68" => '&#23981;',
		"\xE9\x69" => '&#23983;',
		"\xE9\x6A" => '&#23988;',
		"\xE9\x6B" => '&#24167;',
		"\xE9\x6C" => '&#24168;',
		"\xE9\x6D" => '&#24166;',
		"\xE9\x6E" => '&#24175;',
		"\xE9\x6F" => '&#24297;',
		"\xE9\x70" => '&#24295;',
		"\xE9\x71" => '&#24294;',
		"\xE9\x72" => '&#24296;',
		"\xE9\x73" => '&#24293;',
		"\xE9\x74" => '&#24395;',
		"\xE9\x75" => '&#24508;',
		"\xE9\x76" => '&#24989;',
		"\xE9\x77" => '&#25000;',
		"\xE9\x78" => '&#24982;',
		"\xE9\x79" => '&#25029;',
		"\xE9\x7A" => '&#25012;',
		"\xE9\x7B" => '&#25030;',
		"\xE9\x7C" => '&#25025;',
		"\xE9\x7D" => '&#25036;',
		"\xE9\x7E" => '&#25018;',
		"\xE9\xA1" => '&#25023;',
		"\xE9\xA2" => '&#25016;',
		"\xE9\xA3" => '&#24972;',
		"\xE9\xA4" => '&#25815;',
		"\xE9\xA5" => '&#25814;',
		"\xE9\xA6" => '&#25808;',
		"\xE9\xA7" => '&#25807;',
		"\xE9\xA8" => '&#25801;',
		"\xE9\xA9" => '&#25789;',
		"\xE9\xAA" => '&#25737;',
		"\xE9\xAB" => '&#25795;',
		"\xE9\xAC" => '&#25819;',
		"\xE9\xAD" => '&#25843;',
		"\xE9\xAE" => '&#25817;',
		"\xE9\xAF" => '&#25907;',
		"\xE9\xB0" => '&#25983;',
		"\xE9\xB1" => '&#25980;',
		"\xE9\xB2" => '&#26018;',
		"\xE9\xB3" => '&#26312;',
		"\xE9\xB4" => '&#26302;',
		"\xE9\xB5" => '&#26304;',
		"\xE9\xB6" => '&#26314;',
		"\xE9\xB7" => '&#26315;',
		"\xE9\xB8" => '&#26319;',
		"\xE9\xB9" => '&#26301;',
		"\xE9\xBA" => '&#26299;',
		"\xE9\xBB" => '&#26298;',
		"\xE9\xBC" => '&#26316;',
		"\xE9\xBD" => '&#26403;',
		"\xE9\xBE" => '&#27188;',
		"\xE9\xBF" => '&#27238;',
		"\xE9\xC0" => '&#27209;',
		"\xE9\xC1" => '&#27239;',
		"\xE9\xC2" => '&#27186;',
		"\xE9\xC3" => '&#27240;',
		"\xE9\xC4" => '&#27198;',
		"\xE9\xC5" => '&#27229;',
		"\xE9\xC6" => '&#27245;',
		"\xE9\xC7" => '&#27254;',
		"\xE9\xC8" => '&#27227;',
		"\xE9\xC9" => '&#27217;',
		"\xE9\xCA" => '&#27176;',
		"\xE9\xCB" => '&#27226;',
		"\xE9\xCC" => '&#27195;',
		"\xE9\xCD" => '&#27199;',
		"\xE9\xCE" => '&#27201;',
		"\xE9\xCF" => '&#27242;',
		"\xE9\xD0" => '&#27236;',
		"\xE9\xD1" => '&#27216;',
		"\xE9\xD2" => '&#27215;',
		"\xE9\xD3" => '&#27220;',
		"\xE9\xD4" => '&#27247;',
		"\xE9\xD5" => '&#27241;',
		"\xE9\xD6" => '&#27232;',
		"\xE9\xD7" => '&#27196;',
		"\xE9\xD8" => '&#27230;',
		"\xE9\xD9" => '&#27222;',
		"\xE9\xDA" => '&#27221;',
		"\xE9\xDB" => '&#27213;',
		"\xE9\xDC" => '&#27214;',
		"\xE9\xDD" => '&#27206;',
		"\xE9\xDE" => '&#27477;',
		"\xE9\xDF" => '&#27476;',
		"\xE9\xE0" => '&#27478;',
		"\xE9\xE1" => '&#27559;',
		"\xE9\xE2" => '&#27562;',
		"\xE9\xE3" => '&#27563;',
		"\xE9\xE4" => '&#27592;',
		"\xE9\xE5" => '&#27591;',
		"\xE9\xE6" => '&#27652;',
		"\xE9\xE7" => '&#27651;',
		"\xE9\xE8" => '&#27654;',
		"\xE9\xE9" => '&#28589;',
		"\xE9\xEA" => '&#28619;',
		"\xE9\xEB" => '&#28579;',
		"\xE9\xEC" => '&#28615;',
		"\xE9\xED" => '&#28604;',
		"\xE9\xEE" => '&#28622;',
		"\xE9\xEF" => '&#28616;',
		"\xE9\xF0" => '&#28510;',
		"\xE9\xF1" => '&#28612;',
		"\xE9\xF2" => '&#28605;',
		"\xE9\xF3" => '&#28574;',
		"\xE9\xF4" => '&#28618;',
		"\xE9\xF5" => '&#28584;',
		"\xE9\xF6" => '&#28676;',
		"\xE9\xF7" => '&#28581;',
		"\xE9\xF8" => '&#28590;',
		"\xE9\xF9" => '&#28602;',
		"\xE9\xFA" => '&#28588;',
		"\xE9\xFB" => '&#28586;',
		"\xE9\xFC" => '&#28623;',
		"\xE9\xFD" => '&#28607;',
		"\xE9\xFE" => '&#28600;',
		"\xEA\x40" => '&#28578;',
		"\xEA\x41" => '&#28617;',
		"\xEA\x42" => '&#28587;',
		"\xEA\x43" => '&#28621;',
		"\xEA\x44" => '&#28591;',
		"\xEA\x45" => '&#28594;',
		"\xEA\x46" => '&#28592;',
		"\xEA\x47" => '&#29125;',
		"\xEA\x48" => '&#29122;',
		"\xEA\x49" => '&#29119;',
		"\xEA\x4A" => '&#29112;',
		"\xEA\x4B" => '&#29142;',
		"\xEA\x4C" => '&#29120;',
		"\xEA\x4D" => '&#29121;',
		"\xEA\x4E" => '&#29131;',
		"\xEA\x4F" => '&#29140;',
		"\xEA\x50" => '&#29130;',
		"\xEA\x51" => '&#29127;',
		"\xEA\x52" => '&#29135;',
		"\xEA\x53" => '&#29117;',
		"\xEA\x54" => '&#29144;',
		"\xEA\x55" => '&#29116;',
		"\xEA\x56" => '&#29126;',
		"\xEA\x57" => '&#29146;',
		"\xEA\x58" => '&#29147;',
		"\xEA\x59" => '&#29341;',
		"\xEA\x5A" => '&#29342;',
		"\xEA\x5B" => '&#29545;',
		"\xEA\x5C" => '&#29542;',
		"\xEA\x5D" => '&#29543;',
		"\xEA\x5E" => '&#29548;',
		"\xEA\x5F" => '&#29541;',
		"\xEA\x60" => '&#29547;',
		"\xEA\x61" => '&#29546;',
		"\xEA\x62" => '&#29823;',
		"\xEA\x63" => '&#29850;',
		"\xEA\x64" => '&#29856;',
		"\xEA\x65" => '&#29844;',
		"\xEA\x66" => '&#29842;',
		"\xEA\x67" => '&#29845;',
		"\xEA\x68" => '&#29857;',
		"\xEA\x69" => '&#29963;',
		"\xEA\x6A" => '&#30080;',
		"\xEA\x6B" => '&#30255;',
		"\xEA\x6C" => '&#30253;',
		"\xEA\x6D" => '&#30257;',
		"\xEA\x6E" => '&#30269;',
		"\xEA\x6F" => '&#30259;',
		"\xEA\x70" => '&#30268;',
		"\xEA\x71" => '&#30261;',
		"\xEA\x72" => '&#30258;',
		"\xEA\x73" => '&#30256;',
		"\xEA\x74" => '&#30395;',
		"\xEA\x75" => '&#30438;',
		"\xEA\x76" => '&#30618;',
		"\xEA\x77" => '&#30621;',
		"\xEA\x78" => '&#30625;',
		"\xEA\x79" => '&#30620;',
		"\xEA\x7A" => '&#30619;',
		"\xEA\x7B" => '&#30626;',
		"\xEA\x7C" => '&#30627;',
		"\xEA\x7D" => '&#30613;',
		"\xEA\x7E" => '&#30617;',
		"\xEA\xA1" => '&#30615;',
		"\xEA\xA2" => '&#30941;',
		"\xEA\xA3" => '&#30953;',
		"\xEA\xA4" => '&#30949;',
		"\xEA\xA5" => '&#30954;',
		"\xEA\xA6" => '&#30942;',
		"\xEA\xA7" => '&#30947;',
		"\xEA\xA8" => '&#30939;',
		"\xEA\xA9" => '&#30945;',
		"\xEA\xAA" => '&#30946;',
		"\xEA\xAB" => '&#30957;',
		"\xEA\xAC" => '&#30943;',
		"\xEA\xAD" => '&#30944;',
		"\xEA\xAE" => '&#31140;',
		"\xEA\xAF" => '&#31300;',
		"\xEA\xB0" => '&#31304;',
		"\xEA\xB1" => '&#31303;',
		"\xEA\xB2" => '&#31414;',
		"\xEA\xB3" => '&#31416;',
		"\xEA\xB4" => '&#31413;',
		"\xEA\xB5" => '&#31409;',
		"\xEA\xB6" => '&#31415;',
		"\xEA\xB7" => '&#31710;',
		"\xEA\xB8" => '&#31715;',
		"\xEA\xB9" => '&#31719;',
		"\xEA\xBA" => '&#31709;',
		"\xEA\xBB" => '&#31701;',
		"\xEA\xBC" => '&#31717;',
		"\xEA\xBD" => '&#31706;',
		"\xEA\xBE" => '&#31720;',
		"\xEA\xBF" => '&#31737;',
		"\xEA\xC0" => '&#31700;',
		"\xEA\xC1" => '&#31722;',
		"\xEA\xC2" => '&#31714;',
		"\xEA\xC3" => '&#31708;',
		"\xEA\xC4" => '&#31723;',
		"\xEA\xC5" => '&#31704;',
		"\xEA\xC6" => '&#31711;',
		"\xEA\xC7" => '&#31954;',
		"\xEA\xC8" => '&#31956;',
		"\xEA\xC9" => '&#31959;',
		"\xEA\xCA" => '&#31952;',
		"\xEA\xCB" => '&#31953;',
		"\xEA\xCC" => '&#32274;',
		"\xEA\xCD" => '&#32289;',
		"\xEA\xCE" => '&#32279;',
		"\xEA\xCF" => '&#32268;',
		"\xEA\xD0" => '&#32287;',
		"\xEA\xD1" => '&#32288;',
		"\xEA\xD2" => '&#32275;',
		"\xEA\xD3" => '&#32270;',
		"\xEA\xD4" => '&#32284;',
		"\xEA\xD5" => '&#32277;',
		"\xEA\xD6" => '&#32282;',
		"\xEA\xD7" => '&#32290;',
		"\xEA\xD8" => '&#32267;',
		"\xEA\xD9" => '&#32271;',
		"\xEA\xDA" => '&#32278;',
		"\xEA\xDB" => '&#32269;',
		"\xEA\xDC" => '&#32276;',
		"\xEA\xDD" => '&#32293;',
		"\xEA\xDE" => '&#32292;',
		"\xEA\xDF" => '&#32579;',
		"\xEA\xE0" => '&#32635;',
		"\xEA\xE1" => '&#32636;',
		"\xEA\xE2" => '&#32634;',
		"\xEA\xE3" => '&#32689;',
		"\xEA\xE4" => '&#32751;',
		"\xEA\xE5" => '&#32810;',
		"\xEA\xE6" => '&#32809;',
		"\xEA\xE7" => '&#32876;',
		"\xEA\xE8" => '&#33201;',
		"\xEA\xE9" => '&#33190;',
		"\xEA\xEA" => '&#33198;',
		"\xEA\xEB" => '&#33209;',
		"\xEA\xEC" => '&#33205;',
		"\xEA\xED" => '&#33195;',
		"\xEA\xEE" => '&#33200;',
		"\xEA\xEF" => '&#33196;',
		"\xEA\xF0" => '&#33204;',
		"\xEA\xF1" => '&#33202;',
		"\xEA\xF2" => '&#33207;',
		"\xEA\xF3" => '&#33191;',
		"\xEA\xF4" => '&#33266;',
		"\xEA\xF5" => '&#33365;',
		"\xEA\xF6" => '&#33366;',
		"\xEA\xF7" => '&#33367;',
		"\xEA\xF8" => '&#34134;',
		"\xEA\xF9" => '&#34117;',
		"\xEA\xFA" => '&#34155;',
		"\xEA\xFB" => '&#34125;',
		"\xEA\xFC" => '&#34131;',
		"\xEA\xFD" => '&#34145;',
		"\xEA\xFE" => '&#34136;',
		"\xEB\x40" => '&#34112;',
		"\xEB\x41" => '&#34118;',
		"\xEB\x42" => '&#34148;',
		"\xEB\x43" => '&#34113;',
		"\xEB\x44" => '&#34146;',
		"\xEB\x45" => '&#34116;',
		"\xEB\x46" => '&#34129;',
		"\xEB\x47" => '&#34119;',
		"\xEB\x48" => '&#34147;',
		"\xEB\x49" => '&#34110;',
		"\xEB\x4A" => '&#34139;',
		"\xEB\x4B" => '&#34161;',
		"\xEB\x4C" => '&#34126;',
		"\xEB\x4D" => '&#34158;',
		"\xEB\x4E" => '&#34165;',
		"\xEB\x4F" => '&#34133;',
		"\xEB\x50" => '&#34151;',
		"\xEB\x51" => '&#34144;',
		"\xEB\x52" => '&#34188;',
		"\xEB\x53" => '&#34150;',
		"\xEB\x54" => '&#34141;',
		"\xEB\x55" => '&#34132;',
		"\xEB\x56" => '&#34149;',
		"\xEB\x57" => '&#34156;',
		"\xEB\x58" => '&#34403;',
		"\xEB\x59" => '&#34405;',
		"\xEB\x5A" => '&#34404;',
		"\xEB\x5B" => '&#34715;',
		"\xEB\x5C" => '&#34703;',
		"\xEB\x5D" => '&#34711;',
		"\xEB\x5E" => '&#34707;',
		"\xEB\x5F" => '&#34706;',
		"\xEB\x60" => '&#34696;',
		"\xEB\x61" => '&#34689;',
		"\xEB\x62" => '&#34710;',
		"\xEB\x63" => '&#34712;',
		"\xEB\x64" => '&#34681;',
		"\xEB\x65" => '&#34695;',
		"\xEB\x66" => '&#34723;',
		"\xEB\x67" => '&#34693;',
		"\xEB\x68" => '&#34704;',
		"\xEB\x69" => '&#34705;',
		"\xEB\x6A" => '&#34717;',
		"\xEB\x6B" => '&#34692;',
		"\xEB\x6C" => '&#34708;',
		"\xEB\x6D" => '&#34716;',
		"\xEB\x6E" => '&#34714;',
		"\xEB\x6F" => '&#34697;',
		"\xEB\x70" => '&#35102;',
		"\xEB\x71" => '&#35110;',
		"\xEB\x72" => '&#35120;',
		"\xEB\x73" => '&#35117;',
		"\xEB\x74" => '&#35118;',
		"\xEB\x75" => '&#35111;',
		"\xEB\x76" => '&#35121;',
		"\xEB\x77" => '&#35106;',
		"\xEB\x78" => '&#35113;',
		"\xEB\x79" => '&#35107;',
		"\xEB\x7A" => '&#35119;',
		"\xEB\x7B" => '&#35116;',
		"\xEB\x7C" => '&#35103;',
		"\xEB\x7D" => '&#35313;',
		"\xEB\x7E" => '&#35552;',
		"\xEB\xA1" => '&#35554;',
		"\xEB\xA2" => '&#35570;',
		"\xEB\xA3" => '&#35572;',
		"\xEB\xA4" => '&#35573;',
		"\xEB\xA5" => '&#35549;',
		"\xEB\xA6" => '&#35604;',
		"\xEB\xA7" => '&#35556;',
		"\xEB\xA8" => '&#35551;',
		"\xEB\xA9" => '&#35568;',
		"\xEB\xAA" => '&#35528;',
		"\xEB\xAB" => '&#35550;',
		"\xEB\xAC" => '&#35553;',
		"\xEB\xAD" => '&#35560;',
		"\xEB\xAE" => '&#35583;',
		"\xEB\xAF" => '&#35567;',
		"\xEB\xB0" => '&#35579;',
		"\xEB\xB1" => '&#35985;',
		"\xEB\xB2" => '&#35986;',
		"\xEB\xB3" => '&#35984;',
		"\xEB\xB4" => '&#36085;',
		"\xEB\xB5" => '&#36078;',
		"\xEB\xB6" => '&#36081;',
		"\xEB\xB7" => '&#36080;',
		"\xEB\xB8" => '&#36083;',
		"\xEB\xB9" => '&#36204;',
		"\xEB\xBA" => '&#36206;',
		"\xEB\xBB" => '&#36261;',
		"\xEB\xBC" => '&#36263;',
		"\xEB\xBD" => '&#36403;',
		"\xEB\xBE" => '&#36414;',
		"\xEB\xBF" => '&#36408;',
		"\xEB\xC0" => '&#36416;',
		"\xEB\xC1" => '&#36421;',
		"\xEB\xC2" => '&#36406;',
		"\xEB\xC3" => '&#36412;',
		"\xEB\xC4" => '&#36413;',
		"\xEB\xC5" => '&#36417;',
		"\xEB\xC6" => '&#36400;',
		"\xEB\xC7" => '&#36415;',
		"\xEB\xC8" => '&#36541;',
		"\xEB\xC9" => '&#36662;',
		"\xEB\xCA" => '&#36654;',
		"\xEB\xCB" => '&#36661;',
		"\xEB\xCC" => '&#36658;',
		"\xEB\xCD" => '&#36665;',
		"\xEB\xCE" => '&#36663;',
		"\xEB\xCF" => '&#36660;',
		"\xEB\xD0" => '&#36982;',
		"\xEB\xD1" => '&#36985;',
		"\xEB\xD2" => '&#36987;',
		"\xEB\xD3" => '&#36998;',
		"\xEB\xD4" => '&#37114;',
		"\xEB\xD5" => '&#37171;',
		"\xEB\xD6" => '&#37173;',
		"\xEB\xD7" => '&#37174;',
		"\xEB\xD8" => '&#37267;',
		"\xEB\xD9" => '&#37264;',
		"\xEB\xDA" => '&#37265;',
		"\xEB\xDB" => '&#37261;',
		"\xEB\xDC" => '&#37263;',
		"\xEB\xDD" => '&#37671;',
		"\xEB\xDE" => '&#37662;',
		"\xEB\xDF" => '&#37640;',
		"\xEB\xE0" => '&#37663;',
		"\xEB\xE1" => '&#37638;',
		"\xEB\xE2" => '&#37647;',
		"\xEB\xE3" => '&#37754;',
		"\xEB\xE4" => '&#37688;',
		"\xEB\xE5" => '&#37692;',
		"\xEB\xE6" => '&#37659;',
		"\xEB\xE7" => '&#37667;',
		"\xEB\xE8" => '&#37650;',
		"\xEB\xE9" => '&#37633;',
		"\xEB\xEA" => '&#37702;',
		"\xEB\xEB" => '&#37677;',
		"\xEB\xEC" => '&#37646;',
		"\xEB\xED" => '&#37645;',
		"\xEB\xEE" => '&#37579;',
		"\xEB\xEF" => '&#37661;',
		"\xEB\xF0" => '&#37626;',
		"\xEB\xF1" => '&#37669;',
		"\xEB\xF2" => '&#37651;',
		"\xEB\xF3" => '&#37625;',
		"\xEB\xF4" => '&#37623;',
		"\xEB\xF5" => '&#37684;',
		"\xEB\xF6" => '&#37634;',
		"\xEB\xF7" => '&#37668;',
		"\xEB\xF8" => '&#37631;',
		"\xEB\xF9" => '&#37673;',
		"\xEB\xFA" => '&#37689;',
		"\xEB\xFB" => '&#37685;',
		"\xEB\xFC" => '&#37674;',
		"\xEB\xFD" => '&#37652;',
		"\xEB\xFE" => '&#37644;',
		"\xEC\x40" => '&#37643;',
		"\xEC\x41" => '&#37630;',
		"\xEC\x42" => '&#37641;',
		"\xEC\x43" => '&#37632;',
		"\xEC\x44" => '&#37627;',
		"\xEC\x45" => '&#37654;',
		"\xEC\x46" => '&#38332;',
		"\xEC\x47" => '&#38349;',
		"\xEC\x48" => '&#38334;',
		"\xEC\x49" => '&#38329;',
		"\xEC\x4A" => '&#38330;',
		"\xEC\x4B" => '&#38326;',
		"\xEC\x4C" => '&#38335;',
		"\xEC\x4D" => '&#38325;',
		"\xEC\x4E" => '&#38333;',
		"\xEC\x4F" => '&#38569;',
		"\xEC\x50" => '&#38612;',
		"\xEC\x51" => '&#38667;',
		"\xEC\x52" => '&#38674;',
		"\xEC\x53" => '&#38672;',
		"\xEC\x54" => '&#38809;',
		"\xEC\x55" => '&#38807;',
		"\xEC\x56" => '&#38804;',
		"\xEC\x57" => '&#38896;',
		"\xEC\x58" => '&#38904;',
		"\xEC\x59" => '&#38965;',
		"\xEC\x5A" => '&#38959;',
		"\xEC\x5B" => '&#38962;',
		"\xEC\x5C" => '&#39204;',
		"\xEC\x5D" => '&#39199;',
		"\xEC\x5E" => '&#39207;',
		"\xEC\x5F" => '&#39209;',
		"\xEC\x60" => '&#39326;',
		"\xEC\x61" => '&#39406;',
		"\xEC\x62" => '&#39404;',
		"\xEC\x63" => '&#39397;',
		"\xEC\x64" => '&#39396;',
		"\xEC\x65" => '&#39408;',
		"\xEC\x66" => '&#39395;',
		"\xEC\x67" => '&#39402;',
		"\xEC\x68" => '&#39401;',
		"\xEC\x69" => '&#39399;',
		"\xEC\x6A" => '&#39609;',
		"\xEC\x6B" => '&#39615;',
		"\xEC\x6C" => '&#39604;',
		"\xEC\x6D" => '&#39611;',
		"\xEC\x6E" => '&#39670;',
		"\xEC\x6F" => '&#39674;',
		"\xEC\x70" => '&#39673;',
		"\xEC\x71" => '&#39671;',
		"\xEC\x72" => '&#39731;',
		"\xEC\x73" => '&#39808;',
		"\xEC\x74" => '&#39813;',
		"\xEC\x75" => '&#39815;',
		"\xEC\x76" => '&#39804;',
		"\xEC\x77" => '&#39806;',
		"\xEC\x78" => '&#39803;',
		"\xEC\x79" => '&#39810;',
		"\xEC\x7A" => '&#39827;',
		"\xEC\x7B" => '&#39826;',
		"\xEC\x7C" => '&#39824;',
		"\xEC\x7D" => '&#39802;',
		"\xEC\x7E" => '&#39829;',
		"\xEC\xA1" => '&#39805;',
		"\xEC\xA2" => '&#39816;',
		"\xEC\xA3" => '&#40229;',
		"\xEC\xA4" => '&#40215;',
		"\xEC\xA5" => '&#40224;',
		"\xEC\xA6" => '&#40222;',
		"\xEC\xA7" => '&#40212;',
		"\xEC\xA8" => '&#40233;',
		"\xEC\xA9" => '&#40221;',
		"\xEC\xAA" => '&#40216;',
		"\xEC\xAB" => '&#40226;',
		"\xEC\xAC" => '&#40208;',
		"\xEC\xAD" => '&#40217;',
		"\xEC\xAE" => '&#40223;',
		"\xEC\xAF" => '&#40584;',
		"\xEC\xB0" => '&#40582;',
		"\xEC\xB1" => '&#40583;',
		"\xEC\xB2" => '&#40622;',
		"\xEC\xB3" => '&#40621;',
		"\xEC\xB4" => '&#40661;',
		"\xEC\xB5" => '&#40662;',
		"\xEC\xB6" => '&#40698;',
		"\xEC\xB7" => '&#40722;',
		"\xEC\xB8" => '&#40765;',
		"\xEC\xB9" => '&#20774;',
		"\xEC\xBA" => '&#20773;',
		"\xEC\xBB" => '&#20770;',
		"\xEC\xBC" => '&#20772;',
		"\xEC\xBD" => '&#20768;',
		"\xEC\xBE" => '&#20777;',
		"\xEC\xBF" => '&#21236;',
		"\xEC\xC0" => '&#22163;',
		"\xEC\xC1" => '&#22156;',
		"\xEC\xC2" => '&#22157;',
		"\xEC\xC3" => '&#22150;',
		"\xEC\xC4" => '&#22148;',
		"\xEC\xC5" => '&#22147;',
		"\xEC\xC6" => '&#22142;',
		"\xEC\xC7" => '&#22146;',
		"\xEC\xC8" => '&#22143;',
		"\xEC\xC9" => '&#22145;',
		"\xEC\xCA" => '&#22742;',
		"\xEC\xCB" => '&#22740;',
		"\xEC\xCC" => '&#22735;',
		"\xEC\xCD" => '&#22738;',
		"\xEC\xCE" => '&#23341;',
		"\xEC\xCF" => '&#23333;',
		"\xEC\xD0" => '&#23346;',
		"\xEC\xD1" => '&#23331;',
		"\xEC\xD2" => '&#23340;',
		"\xEC\xD3" => '&#23335;',
		"\xEC\xD4" => '&#23334;',
		"\xEC\xD5" => '&#23343;',
		"\xEC\xD6" => '&#23342;',
		"\xEC\xD7" => '&#23419;',
		"\xEC\xD8" => '&#23537;',
		"\xEC\xD9" => '&#23538;',
		"\xEC\xDA" => '&#23991;',
		"\xEC\xDB" => '&#24172;',
		"\xEC\xDC" => '&#24170;',
		"\xEC\xDD" => '&#24510;',
		"\xEC\xDE" => '&#24507;',
		"\xEC\xDF" => '&#25027;',
		"\xEC\xE0" => '&#25013;',
		"\xEC\xE1" => '&#25020;',
		"\xEC\xE2" => '&#25063;',
		"\xEC\xE3" => '&#25056;',
		"\xEC\xE4" => '&#25061;',
		"\xEC\xE5" => '&#25060;',
		"\xEC\xE6" => '&#25064;',
		"\xEC\xE7" => '&#25054;',
		"\xEC\xE8" => '&#25839;',
		"\xEC\xE9" => '&#25833;',
		"\xEC\xEA" => '&#25827;',
		"\xEC\xEB" => '&#25835;',
		"\xEC\xEC" => '&#25828;',
		"\xEC\xED" => '&#25832;',
		"\xEC\xEE" => '&#25985;',
		"\xEC\xEF" => '&#25984;',
		"\xEC\xF0" => '&#26038;',
		"\xEC\xF1" => '&#26074;',
		"\xEC\xF2" => '&#26322;',
		"\xEC\xF3" => '&#27277;',
		"\xEC\xF4" => '&#27286;',
		"\xEC\xF5" => '&#27265;',
		"\xEC\xF6" => '&#27301;',
		"\xEC\xF7" => '&#27273;',
		"\xEC\xF8" => '&#27295;',
		"\xEC\xF9" => '&#27291;',
		"\xEC\xFA" => '&#27297;',
		"\xEC\xFB" => '&#27294;',
		"\xEC\xFC" => '&#27271;',
		"\xEC\xFD" => '&#27283;',
		"\xEC\xFE" => '&#27278;',
		"\xED\x40" => '&#27285;',
		"\xED\x41" => '&#27267;',
		"\xED\x42" => '&#27304;',
		"\xED\x43" => '&#27300;',
		"\xED\x44" => '&#27281;',
		"\xED\x45" => '&#27263;',
		"\xED\x46" => '&#27302;',
		"\xED\x47" => '&#27290;',
		"\xED\x48" => '&#27269;',
		"\xED\x49" => '&#27276;',
		"\xED\x4A" => '&#27282;',
		"\xED\x4B" => '&#27483;',
		"\xED\x4C" => '&#27565;',
		"\xED\x4D" => '&#27657;',
		"\xED\x4E" => '&#28620;',
		"\xED\x4F" => '&#28585;',
		"\xED\x50" => '&#28660;',
		"\xED\x51" => '&#28628;',
		"\xED\x52" => '&#28643;',
		"\xED\x53" => '&#28636;',
		"\xED\x54" => '&#28653;',
		"\xED\x55" => '&#28647;',
		"\xED\x56" => '&#28646;',
		"\xED\x57" => '&#28638;',
		"\xED\x58" => '&#28658;',
		"\xED\x59" => '&#28637;',
		"\xED\x5A" => '&#28642;',
		"\xED\x5B" => '&#28648;',
		"\xED\x5C" => '&#29153;',
		"\xED\x5D" => '&#29169;',
		"\xED\x5E" => '&#29160;',
		"\xED\x5F" => '&#29170;',
		"\xED\x60" => '&#29156;',
		"\xED\x61" => '&#29168;',
		"\xED\x62" => '&#29154;',
		"\xED\x63" => '&#29555;',
		"\xED\x64" => '&#29550;',
		"\xED\x65" => '&#29551;',
		"\xED\x66" => '&#29847;',
		"\xED\x67" => '&#29874;',
		"\xED\x68" => '&#29867;',
		"\xED\x69" => '&#29840;',
		"\xED\x6A" => '&#29866;',
		"\xED\x6B" => '&#29869;',
		"\xED\x6C" => '&#29873;',
		"\xED\x6D" => '&#29861;',
		"\xED\x6E" => '&#29871;',
		"\xED\x6F" => '&#29968;',
		"\xED\x70" => '&#29969;',
		"\xED\x71" => '&#29970;',
		"\xED\x72" => '&#29967;',
		"\xED\x73" => '&#30084;',
		"\xED\x74" => '&#30275;',
		"\xED\x75" => '&#30280;',
		"\xED\x76" => '&#30281;',
		"\xED\x77" => '&#30279;',
		"\xED\x78" => '&#30372;',
		"\xED\x79" => '&#30441;',
		"\xED\x7A" => '&#30645;',
		"\xED\x7B" => '&#30635;',
		"\xED\x7C" => '&#30642;',
		"\xED\x7D" => '&#30647;',
		"\xED\x7E" => '&#30646;',
		"\xED\xA1" => '&#30644;',
		"\xED\xA2" => '&#30641;',
		"\xED\xA3" => '&#30632;',
		"\xED\xA4" => '&#30704;',
		"\xED\xA5" => '&#30963;',
		"\xED\xA6" => '&#30973;',
		"\xED\xA7" => '&#30978;',
		"\xED\xA8" => '&#30971;',
		"\xED\xA9" => '&#30972;',
		"\xED\xAA" => '&#30962;',
		"\xED\xAB" => '&#30981;',
		"\xED\xAC" => '&#30969;',
		"\xED\xAD" => '&#30974;',
		"\xED\xAE" => '&#30980;',
		"\xED\xAF" => '&#31147;',
		"\xED\xB0" => '&#31144;',
		"\xED\xB1" => '&#31324;',
		"\xED\xB2" => '&#31323;',
		"\xED\xB3" => '&#31318;',
		"\xED\xB4" => '&#31320;',
		"\xED\xB5" => '&#31316;',
		"\xED\xB6" => '&#31322;',
		"\xED\xB7" => '&#31422;',
		"\xED\xB8" => '&#31424;',
		"\xED\xB9" => '&#31425;',
		"\xED\xBA" => '&#31749;',
		"\xED\xBB" => '&#31759;',
		"\xED\xBC" => '&#31730;',
		"\xED\xBD" => '&#31744;',
		"\xED\xBE" => '&#31743;',
		"\xED\xBF" => '&#31739;',
		"\xED\xC0" => '&#31758;',
		"\xED\xC1" => '&#31732;',
		"\xED\xC2" => '&#31755;',
		"\xED\xC3" => '&#31731;',
		"\xED\xC4" => '&#31746;',
		"\xED\xC5" => '&#31753;',
		"\xED\xC6" => '&#31747;',
		"\xED\xC7" => '&#31745;',
		"\xED\xC8" => '&#31736;',
		"\xED\xC9" => '&#31741;',
		"\xED\xCA" => '&#31750;',
		"\xED\xCB" => '&#31728;',
		"\xED\xCC" => '&#31729;',
		"\xED\xCD" => '&#31760;',
		"\xED\xCE" => '&#31754;',
		"\xED\xCF" => '&#31976;',
		"\xED\xD0" => '&#32301;',
		"\xED\xD1" => '&#32316;',
		"\xED\xD2" => '&#32322;',
		"\xED\xD3" => '&#32307;',
		"\xED\xD4" => '&#38984;',
		"\xED\xD5" => '&#32312;',
		"\xED\xD6" => '&#32298;',
		"\xED\xD7" => '&#32329;',
		"\xED\xD8" => '&#32320;',
		"\xED\xD9" => '&#32327;',
		"\xED\xDA" => '&#32297;',
		"\xED\xDB" => '&#32332;',
		"\xED\xDC" => '&#32304;',
		"\xED\xDD" => '&#32315;',
		"\xED\xDE" => '&#32310;',
		"\xED\xDF" => '&#32324;',
		"\xED\xE0" => '&#32314;',
		"\xED\xE1" => '&#32581;',
		"\xED\xE2" => '&#32639;',
		"\xED\xE3" => '&#32638;',
		"\xED\xE4" => '&#32637;',
		"\xED\xE5" => '&#32756;',
		"\xED\xE6" => '&#32754;',
		"\xED\xE7" => '&#32812;',
		"\xED\xE8" => '&#33211;',
		"\xED\xE9" => '&#33220;',
		"\xED\xEA" => '&#33228;',
		"\xED\xEB" => '&#33226;',
		"\xED\xEC" => '&#33221;',
		"\xED\xED" => '&#33223;',
		"\xED\xEE" => '&#33212;',
		"\xED\xEF" => '&#33257;',
		"\xED\xF0" => '&#33371;',
		"\xED\xF1" => '&#33370;',
		"\xED\xF2" => '&#33372;',
		"\xED\xF3" => '&#34179;',
		"\xED\xF4" => '&#34176;',
		"\xED\xF5" => '&#34191;',
		"\xED\xF6" => '&#34215;',
		"\xED\xF7" => '&#34197;',
		"\xED\xF8" => '&#34208;',
		"\xED\xF9" => '&#34187;',
		"\xED\xFA" => '&#34211;',
		"\xED\xFB" => '&#34171;',
		"\xED\xFC" => '&#34212;',
		"\xED\xFD" => '&#34202;',
		"\xED\xFE" => '&#34206;',
		"\xEE\x40" => '&#34167;',
		"\xEE\x41" => '&#34172;',
		"\xEE\x42" => '&#34185;',
		"\xEE\x43" => '&#34209;',
		"\xEE\x44" => '&#34170;',
		"\xEE\x45" => '&#34168;',
		"\xEE\x46" => '&#34135;',
		"\xEE\x47" => '&#34190;',
		"\xEE\x48" => '&#34198;',
		"\xEE\x49" => '&#34182;',
		"\xEE\x4A" => '&#34189;',
		"\xEE\x4B" => '&#34201;',
		"\xEE\x4C" => '&#34205;',
		"\xEE\x4D" => '&#34177;',
		"\xEE\x4E" => '&#34210;',
		"\xEE\x4F" => '&#34178;',
		"\xEE\x50" => '&#34184;',
		"\xEE\x51" => '&#34181;',
		"\xEE\x52" => '&#34169;',
		"\xEE\x53" => '&#34166;',
		"\xEE\x54" => '&#34200;',
		"\xEE\x55" => '&#34192;',
		"\xEE\x56" => '&#34207;',
		"\xEE\x57" => '&#34408;',
		"\xEE\x58" => '&#34750;',
		"\xEE\x59" => '&#34730;',
		"\xEE\x5A" => '&#34733;',
		"\xEE\x5B" => '&#34757;',
		"\xEE\x5C" => '&#34736;',
		"\xEE\x5D" => '&#34732;',
		"\xEE\x5E" => '&#34745;',
		"\xEE\x5F" => '&#34741;',
		"\xEE\x60" => '&#34748;',
		"\xEE\x61" => '&#34734;',
		"\xEE\x62" => '&#34761;',
		"\xEE\x63" => '&#34755;',
		"\xEE\x64" => '&#34754;',
		"\xEE\x65" => '&#34764;',
		"\xEE\x66" => '&#34743;',
		"\xEE\x67" => '&#34735;',
		"\xEE\x68" => '&#34756;',
		"\xEE\x69" => '&#34762;',
		"\xEE\x6A" => '&#34740;',
		"\xEE\x6B" => '&#34742;',
		"\xEE\x6C" => '&#34751;',
		"\xEE\x6D" => '&#34744;',
		"\xEE\x6E" => '&#34749;',
		"\xEE\x6F" => '&#34782;',
		"\xEE\x70" => '&#34738;',
		"\xEE\x71" => '&#35125;',
		"\xEE\x72" => '&#35123;',
		"\xEE\x73" => '&#35132;',
		"\xEE\x74" => '&#35134;',
		"\xEE\x75" => '&#35137;',
		"\xEE\x76" => '&#35154;',
		"\xEE\x77" => '&#35127;',
		"\xEE\x78" => '&#35138;',
		"\xEE\x79" => '&#35245;',
		"\xEE\x7A" => '&#35247;',
		"\xEE\x7B" => '&#35246;',
		"\xEE\x7C" => '&#35314;',
		"\xEE\x7D" => '&#35315;',
		"\xEE\x7E" => '&#35614;',
		"\xEE\xA1" => '&#35608;',
		"\xEE\xA2" => '&#35606;',
		"\xEE\xA3" => '&#35601;',
		"\xEE\xA4" => '&#35589;',
		"\xEE\xA5" => '&#35595;',
		"\xEE\xA6" => '&#35618;',
		"\xEE\xA7" => '&#35599;',
		"\xEE\xA8" => '&#35602;',
		"\xEE\xA9" => '&#35605;',
		"\xEE\xAA" => '&#35591;',
		"\xEE\xAB" => '&#35597;',
		"\xEE\xAC" => '&#35592;',
		"\xEE\xAD" => '&#35590;',
		"\xEE\xAE" => '&#35612;',
		"\xEE\xAF" => '&#35603;',
		"\xEE\xB0" => '&#35610;',
		"\xEE\xB1" => '&#35919;',
		"\xEE\xB2" => '&#35952;',
		"\xEE\xB3" => '&#35954;',
		"\xEE\xB4" => '&#35953;',
		"\xEE\xB5" => '&#35951;',
		"\xEE\xB6" => '&#35989;',
		"\xEE\xB7" => '&#35988;',
		"\xEE\xB8" => '&#36089;',
		"\xEE\xB9" => '&#36207;',
		"\xEE\xBA" => '&#36430;',
		"\xEE\xBB" => '&#36429;',
		"\xEE\xBC" => '&#36435;',
		"\xEE\xBD" => '&#36432;',
		"\xEE\xBE" => '&#36428;',
		"\xEE\xBF" => '&#36423;',
		"\xEE\xC0" => '&#36675;',
		"\xEE\xC1" => '&#36672;',
		"\xEE\xC2" => '&#36997;',
		"\xEE\xC3" => '&#36990;',
		"\xEE\xC4" => '&#37176;',
		"\xEE\xC5" => '&#37274;',
		"\xEE\xC6" => '&#37282;',
		"\xEE\xC7" => '&#37275;',
		"\xEE\xC8" => '&#37273;',
		"\xEE\xC9" => '&#37279;',
		"\xEE\xCA" => '&#37281;',
		"\xEE\xCB" => '&#37277;',
		"\xEE\xCC" => '&#37280;',
		"\xEE\xCD" => '&#37793;',
		"\xEE\xCE" => '&#37763;',
		"\xEE\xCF" => '&#37807;',
		"\xEE\xD0" => '&#37732;',
		"\xEE\xD1" => '&#37718;',
		"\xEE\xD2" => '&#37703;',
		"\xEE\xD3" => '&#37756;',
		"\xEE\xD4" => '&#37720;',
		"\xEE\xD5" => '&#37724;',
		"\xEE\xD6" => '&#37750;',
		"\xEE\xD7" => '&#37705;',
		"\xEE\xD8" => '&#37712;',
		"\xEE\xD9" => '&#37713;',
		"\xEE\xDA" => '&#37728;',
		"\xEE\xDB" => '&#37741;',
		"\xEE\xDC" => '&#37775;',
		"\xEE\xDD" => '&#37708;',
		"\xEE\xDE" => '&#37738;',
		"\xEE\xDF" => '&#37753;',
		"\xEE\xE0" => '&#37719;',
		"\xEE\xE1" => '&#37717;',
		"\xEE\xE2" => '&#37714;',
		"\xEE\xE3" => '&#37711;',
		"\xEE\xE4" => '&#37745;',
		"\xEE\xE5" => '&#37751;',
		"\xEE\xE6" => '&#37755;',
		"\xEE\xE7" => '&#37729;',
		"\xEE\xE8" => '&#37726;',
		"\xEE\xE9" => '&#37731;',
		"\xEE\xEA" => '&#37735;',
		"\xEE\xEB" => '&#37760;',
		"\xEE\xEC" => '&#37710;',
		"\xEE\xED" => '&#37721;',
		"\xEE\xEE" => '&#38343;',
		"\xEE\xEF" => '&#38336;',
		"\xEE\xF0" => '&#38345;',
		"\xEE\xF1" => '&#38339;',
		"\xEE\xF2" => '&#38341;',
		"\xEE\xF3" => '&#38327;',
		"\xEE\xF4" => '&#38574;',
		"\xEE\xF5" => '&#38576;',
		"\xEE\xF6" => '&#38572;',
		"\xEE\xF7" => '&#38688;',
		"\xEE\xF8" => '&#38687;',
		"\xEE\xF9" => '&#38680;',
		"\xEE\xFA" => '&#38685;',
		"\xEE\xFB" => '&#38681;',
		"\xEE\xFC" => '&#38810;',
		"\xEE\xFD" => '&#38817;',
		"\xEE\xFE" => '&#38812;',
		"\xEF\x40" => '&#38814;',
		"\xEF\x41" => '&#38813;',
		"\xEF\x42" => '&#38869;',
		"\xEF\x43" => '&#38868;',
		"\xEF\x44" => '&#38897;',
		"\xEF\x45" => '&#38977;',
		"\xEF\x46" => '&#38980;',
		"\xEF\x47" => '&#38986;',
		"\xEF\x48" => '&#38985;',
		"\xEF\x49" => '&#38981;',
		"\xEF\x4A" => '&#38979;',
		"\xEF\x4B" => '&#39205;',
		"\xEF\x4C" => '&#39211;',
		"\xEF\x4D" => '&#39212;',
		"\xEF\x4E" => '&#39210;',
		"\xEF\x4F" => '&#39219;',
		"\xEF\x50" => '&#39218;',
		"\xEF\x51" => '&#39215;',
		"\xEF\x52" => '&#39213;',
		"\xEF\x53" => '&#39217;',
		"\xEF\x54" => '&#39216;',
		"\xEF\x55" => '&#39320;',
		"\xEF\x56" => '&#39331;',
		"\xEF\x57" => '&#39329;',
		"\xEF\x58" => '&#39426;',
		"\xEF\x59" => '&#39418;',
		"\xEF\x5A" => '&#39412;',
		"\xEF\x5B" => '&#39415;',
		"\xEF\x5C" => '&#39417;',
		"\xEF\x5D" => '&#39416;',
		"\xEF\x5E" => '&#39414;',
		"\xEF\x5F" => '&#39419;',
		"\xEF\x60" => '&#39421;',
		"\xEF\x61" => '&#39422;',
		"\xEF\x62" => '&#39420;',
		"\xEF\x63" => '&#39427;',
		"\xEF\x64" => '&#39614;',
		"\xEF\x65" => '&#39678;',
		"\xEF\x66" => '&#39677;',
		"\xEF\x67" => '&#39681;',
		"\xEF\x68" => '&#39676;',
		"\xEF\x69" => '&#39752;',
		"\xEF\x6A" => '&#39834;',
		"\xEF\x6B" => '&#39848;',
		"\xEF\x6C" => '&#39838;',
		"\xEF\x6D" => '&#39835;',
		"\xEF\x6E" => '&#39846;',
		"\xEF\x6F" => '&#39841;',
		"\xEF\x70" => '&#39845;',
		"\xEF\x71" => '&#39844;',
		"\xEF\x72" => '&#39814;',
		"\xEF\x73" => '&#39842;',
		"\xEF\x74" => '&#39840;',
		"\xEF\x75" => '&#39855;',
		"\xEF\x76" => '&#40243;',
		"\xEF\x77" => '&#40257;',
		"\xEF\x78" => '&#40295;',
		"\xEF\x79" => '&#40246;',
		"\xEF\x7A" => '&#40238;',
		"\xEF\x7B" => '&#40239;',
		"\xEF\x7C" => '&#40241;',
		"\xEF\x7D" => '&#40248;',
		"\xEF\x7E" => '&#40240;',
		"\xEF\xA1" => '&#40261;',
		"\xEF\xA2" => '&#40258;',
		"\xEF\xA3" => '&#40259;',
		"\xEF\xA4" => '&#40254;',
		"\xEF\xA5" => '&#40247;',
		"\xEF\xA6" => '&#40256;',
		"\xEF\xA7" => '&#40253;',
		"\xEF\xA8" => '&#32757;',
		"\xEF\xA9" => '&#40237;',
		"\xEF\xAA" => '&#40586;',
		"\xEF\xAB" => '&#40585;',
		"\xEF\xAC" => '&#40589;',
		"\xEF\xAD" => '&#40624;',
		"\xEF\xAE" => '&#40648;',
		"\xEF\xAF" => '&#40666;',
		"\xEF\xB0" => '&#40699;',
		"\xEF\xB1" => '&#40703;',
		"\xEF\xB2" => '&#40740;',
		"\xEF\xB3" => '&#40739;',
		"\xEF\xB4" => '&#40738;',
		"\xEF\xB5" => '&#40788;',
		"\xEF\xB6" => '&#40864;',
		"\xEF\xB7" => '&#20785;',
		"\xEF\xB8" => '&#20781;',
		"\xEF\xB9" => '&#20782;',
		"\xEF\xBA" => '&#22168;',
		"\xEF\xBB" => '&#22172;',
		"\xEF\xBC" => '&#22167;',
		"\xEF\xBD" => '&#22170;',
		"\xEF\xBE" => '&#22173;',
		"\xEF\xBF" => '&#22169;',
		"\xEF\xC0" => '&#22896;',
		"\xEF\xC1" => '&#23356;',
		"\xEF\xC2" => '&#23657;',
		"\xEF\xC3" => '&#23658;',
		"\xEF\xC4" => '&#24000;',
		"\xEF\xC5" => '&#24173;',
		"\xEF\xC6" => '&#24174;',
		"\xEF\xC7" => '&#25048;',
		"\xEF\xC8" => '&#25055;',
		"\xEF\xC9" => '&#25069;',
		"\xEF\xCA" => '&#25070;',
		"\xEF\xCB" => '&#25073;',
		"\xEF\xCC" => '&#25066;',
		"\xEF\xCD" => '&#25072;',
		"\xEF\xCE" => '&#25067;',
		"\xEF\xCF" => '&#25046;',
		"\xEF\xD0" => '&#25065;',
		"\xEF\xD1" => '&#25855;',
		"\xEF\xD2" => '&#25860;',
		"\xEF\xD3" => '&#25853;',
		"\xEF\xD4" => '&#25848;',
		"\xEF\xD5" => '&#25857;',
		"\xEF\xD6" => '&#25859;',
		"\xEF\xD7" => '&#25852;',
		"\xEF\xD8" => '&#26004;',
		"\xEF\xD9" => '&#26075;',
		"\xEF\xDA" => '&#26330;',
		"\xEF\xDB" => '&#26331;',
		"\xEF\xDC" => '&#26328;',
		"\xEF\xDD" => '&#27333;',
		"\xEF\xDE" => '&#27321;',
		"\xEF\xDF" => '&#27325;',
		"\xEF\xE0" => '&#27361;',
		"\xEF\xE1" => '&#27334;',
		"\xEF\xE2" => '&#27322;',
		"\xEF\xE3" => '&#27318;',
		"\xEF\xE4" => '&#27319;',
		"\xEF\xE5" => '&#27335;',
		"\xEF\xE6" => '&#27316;',
		"\xEF\xE7" => '&#27309;',
		"\xEF\xE8" => '&#27486;',
		"\xEF\xE9" => '&#27593;',
		"\xEF\xEA" => '&#27659;',
		"\xEF\xEB" => '&#28679;',
		"\xEF\xEC" => '&#28684;',
		"\xEF\xED" => '&#28685;',
		"\xEF\xEE" => '&#28673;',
		"\xEF\xEF" => '&#28677;',
		"\xEF\xF0" => '&#28692;',
		"\xEF\xF1" => '&#28686;',
		"\xEF\xF2" => '&#28671;',
		"\xEF\xF3" => '&#28672;',
		"\xEF\xF4" => '&#28667;',
		"\xEF\xF5" => '&#28710;',
		"\xEF\xF6" => '&#28668;',
		"\xEF\xF7" => '&#28663;',
		"\xEF\xF8" => '&#28682;',
		"\xEF\xF9" => '&#29185;',
		"\xEF\xFA" => '&#29183;',
		"\xEF\xFB" => '&#29177;',
		"\xEF\xFC" => '&#29187;',
		"\xEF\xFD" => '&#29181;',
		"\xEF\xFE" => '&#29558;',
		"\xF0\x40" => '&#29880;',
		"\xF0\x41" => '&#29888;',
		"\xF0\x42" => '&#29877;',
		"\xF0\x43" => '&#29889;',
		"\xF0\x44" => '&#29886;',
		"\xF0\x45" => '&#29878;',
		"\xF0\x46" => '&#29883;',
		"\xF0\x47" => '&#29890;',
		"\xF0\x48" => '&#29972;',
		"\xF0\x49" => '&#29971;',
		"\xF0\x4A" => '&#30300;',
		"\xF0\x4B" => '&#30308;',
		"\xF0\x4C" => '&#30297;',
		"\xF0\x4D" => '&#30288;',
		"\xF0\x4E" => '&#30291;',
		"\xF0\x4F" => '&#30295;',
		"\xF0\x50" => '&#30298;',
		"\xF0\x51" => '&#30374;',
		"\xF0\x52" => '&#30397;',
		"\xF0\x53" => '&#30444;',
		"\xF0\x54" => '&#30658;',
		"\xF0\x55" => '&#30650;',
		"\xF0\x56" => '&#30975;',
		"\xF0\x57" => '&#30988;',
		"\xF0\x58" => '&#30995;',
		"\xF0\x59" => '&#30996;',
		"\xF0\x5A" => '&#30985;',
		"\xF0\x5B" => '&#30992;',
		"\xF0\x5C" => '&#30994;',
		"\xF0\x5D" => '&#30993;',
		"\xF0\x5E" => '&#31149;',
		"\xF0\x5F" => '&#31148;',
		"\xF0\x60" => '&#31327;',
		"\xF0\x61" => '&#31772;',
		"\xF0\x62" => '&#31785;',
		"\xF0\x63" => '&#31769;',
		"\xF0\x64" => '&#31776;',
		"\xF0\x65" => '&#31775;',
		"\xF0\x66" => '&#31789;',
		"\xF0\x67" => '&#31773;',
		"\xF0\x68" => '&#31782;',
		"\xF0\x69" => '&#31784;',
		"\xF0\x6A" => '&#31778;',
		"\xF0\x6B" => '&#31781;',
		"\xF0\x6C" => '&#31792;',
		"\xF0\x6D" => '&#32348;',
		"\xF0\x6E" => '&#32336;',
		"\xF0\x6F" => '&#32342;',
		"\xF0\x70" => '&#32355;',
		"\xF0\x71" => '&#32344;',
		"\xF0\x72" => '&#32354;',
		"\xF0\x73" => '&#32351;',
		"\xF0\x74" => '&#32337;',
		"\xF0\x75" => '&#32352;',
		"\xF0\x76" => '&#32343;',
		"\xF0\x77" => '&#32339;',
		"\xF0\x78" => '&#32693;',
		"\xF0\x79" => '&#32691;',
		"\xF0\x7A" => '&#32759;',
		"\xF0\x7B" => '&#32760;',
		"\xF0\x7C" => '&#32885;',
		"\xF0\x7D" => '&#33233;',
		"\xF0\x7E" => '&#33234;',
		"\xF0\xA1" => '&#33232;',
		"\xF0\xA2" => '&#33375;',
		"\xF0\xA3" => '&#33374;',
		"\xF0\xA4" => '&#34228;',
		"\xF0\xA5" => '&#34246;',
		"\xF0\xA6" => '&#34240;',
		"\xF0\xA7" => '&#34243;',
		"\xF0\xA8" => '&#34242;',
		"\xF0\xA9" => '&#34227;',
		"\xF0\xAA" => '&#34229;',
		"\xF0\xAB" => '&#34237;',
		"\xF0\xAC" => '&#34247;',
		"\xF0\xAD" => '&#34244;',
		"\xF0\xAE" => '&#34239;',
		"\xF0\xAF" => '&#34251;',
		"\xF0\xB0" => '&#34254;',
		"\xF0\xB1" => '&#34248;',
		"\xF0\xB2" => '&#34245;',
		"\xF0\xB3" => '&#34225;',
		"\xF0\xB4" => '&#34230;',
		"\xF0\xB5" => '&#34258;',
		"\xF0\xB6" => '&#34340;',
		"\xF0\xB7" => '&#34232;',
		"\xF0\xB8" => '&#34231;',
		"\xF0\xB9" => '&#34238;',
		"\xF0\xBA" => '&#34409;',
		"\xF0\xBB" => '&#34791;',
		"\xF0\xBC" => '&#34790;',
		"\xF0\xBD" => '&#34786;',
		"\xF0\xBE" => '&#34779;',
		"\xF0\xBF" => '&#34795;',
		"\xF0\xC0" => '&#34794;',
		"\xF0\xC1" => '&#34789;',
		"\xF0\xC2" => '&#34783;',
		"\xF0\xC3" => '&#34803;',
		"\xF0\xC4" => '&#34788;',
		"\xF0\xC5" => '&#34772;',
		"\xF0\xC6" => '&#34780;',
		"\xF0\xC7" => '&#34771;',
		"\xF0\xC8" => '&#34797;',
		"\xF0\xC9" => '&#34776;',
		"\xF0\xCA" => '&#34787;',
		"\xF0\xCB" => '&#34724;',
		"\xF0\xCC" => '&#34775;',
		"\xF0\xCD" => '&#34777;',
		"\xF0\xCE" => '&#34817;',
		"\xF0\xCF" => '&#34804;',
		"\xF0\xD0" => '&#34792;',
		"\xF0\xD1" => '&#34781;',
		"\xF0\xD2" => '&#35155;',
		"\xF0\xD3" => '&#35147;',
		"\xF0\xD4" => '&#35151;',
		"\xF0\xD5" => '&#35148;',
		"\xF0\xD6" => '&#35142;',
		"\xF0\xD7" => '&#35152;',
		"\xF0\xD8" => '&#35153;',
		"\xF0\xD9" => '&#35145;',
		"\xF0\xDA" => '&#35626;',
		"\xF0\xDB" => '&#35623;',
		"\xF0\xDC" => '&#35619;',
		"\xF0\xDD" => '&#35635;',
		"\xF0\xDE" => '&#35632;',
		"\xF0\xDF" => '&#35637;',
		"\xF0\xE0" => '&#35655;',
		"\xF0\xE1" => '&#35631;',
		"\xF0\xE2" => '&#35644;',
		"\xF0\xE3" => '&#35646;',
		"\xF0\xE4" => '&#35633;',
		"\xF0\xE5" => '&#35621;',
		"\xF0\xE6" => '&#35639;',
		"\xF0\xE7" => '&#35622;',
		"\xF0\xE8" => '&#35638;',
		"\xF0\xE9" => '&#35630;',
		"\xF0\xEA" => '&#35620;',
		"\xF0\xEB" => '&#35643;',
		"\xF0\xEC" => '&#35645;',
		"\xF0\xED" => '&#35642;',
		"\xF0\xEE" => '&#35906;',
		"\xF0\xEF" => '&#35957;',
		"\xF0\xF0" => '&#35993;',
		"\xF0\xF1" => '&#35992;',
		"\xF0\xF2" => '&#35991;',
		"\xF0\xF3" => '&#36094;',
		"\xF0\xF4" => '&#36100;',
		"\xF0\xF5" => '&#36098;',
		"\xF0\xF6" => '&#36096;',
		"\xF0\xF7" => '&#36444;',
		"\xF0\xF8" => '&#36450;',
		"\xF0\xF9" => '&#36448;',
		"\xF0\xFA" => '&#36439;',
		"\xF0\xFB" => '&#36438;',
		"\xF0\xFC" => '&#36446;',
		"\xF0\xFD" => '&#36453;',
		"\xF0\xFE" => '&#36455;',
		"\xF1\x40" => '&#36443;',
		"\xF1\x41" => '&#36442;',
		"\xF1\x42" => '&#36449;',
		"\xF1\x43" => '&#36445;',
		"\xF1\x44" => '&#36457;',
		"\xF1\x45" => '&#36436;',
		"\xF1\x46" => '&#36678;',
		"\xF1\x47" => '&#36679;',
		"\xF1\x48" => '&#36680;',
		"\xF1\x49" => '&#36683;',
		"\xF1\x4A" => '&#37160;',
		"\xF1\x4B" => '&#37178;',
		"\xF1\x4C" => '&#37179;',
		"\xF1\x4D" => '&#37182;',
		"\xF1\x4E" => '&#37288;',
		"\xF1\x4F" => '&#37285;',
		"\xF1\x50" => '&#37287;',
		"\xF1\x51" => '&#37295;',
		"\xF1\x52" => '&#37290;',
		"\xF1\x53" => '&#37813;',
		"\xF1\x54" => '&#37772;',
		"\xF1\x55" => '&#37778;',
		"\xF1\x56" => '&#37815;',
		"\xF1\x57" => '&#37787;',
		"\xF1\x58" => '&#37789;',
		"\xF1\x59" => '&#37769;',
		"\xF1\x5A" => '&#37799;',
		"\xF1\x5B" => '&#37774;',
		"\xF1\x5C" => '&#37802;',
		"\xF1\x5D" => '&#37790;',
		"\xF1\x5E" => '&#37798;',
		"\xF1\x5F" => '&#37781;',
		"\xF1\x60" => '&#37768;',
		"\xF1\x61" => '&#37785;',
		"\xF1\x62" => '&#37791;',
		"\xF1\x63" => '&#37773;',
		"\xF1\x64" => '&#37809;',
		"\xF1\x65" => '&#37777;',
		"\xF1\x66" => '&#37810;',
		"\xF1\x67" => '&#37796;',
		"\xF1\x68" => '&#37800;',
		"\xF1\x69" => '&#37812;',
		"\xF1\x6A" => '&#37795;',
		"\xF1\x6B" => '&#37797;',
		"\xF1\x6C" => '&#38354;',
		"\xF1\x6D" => '&#38355;',
		"\xF1\x6E" => '&#38353;',
		"\xF1\x6F" => '&#38579;',
		"\xF1\x70" => '&#38615;',
		"\xF1\x71" => '&#38618;',
		"\xF1\x72" => '&#24002;',
		"\xF1\x73" => '&#38623;',
		"\xF1\x74" => '&#38616;',
		"\xF1\x75" => '&#38621;',
		"\xF1\x76" => '&#38691;',
		"\xF1\x77" => '&#38690;',
		"\xF1\x78" => '&#38693;',
		"\xF1\x79" => '&#38828;',
		"\xF1\x7A" => '&#38830;',
		"\xF1\x7B" => '&#38824;',
		"\xF1\x7C" => '&#38827;',
		"\xF1\x7D" => '&#38820;',
		"\xF1\x7E" => '&#38826;',
		"\xF1\xA1" => '&#38818;',
		"\xF1\xA2" => '&#38821;',
		"\xF1\xA3" => '&#38871;',
		"\xF1\xA4" => '&#38873;',
		"\xF1\xA5" => '&#38870;',
		"\xF1\xA6" => '&#38872;',
		"\xF1\xA7" => '&#38906;',
		"\xF1\xA8" => '&#38992;',
		"\xF1\xA9" => '&#38993;',
		"\xF1\xAA" => '&#38994;',
		"\xF1\xAB" => '&#39096;',
		"\xF1\xAC" => '&#39233;',
		"\xF1\xAD" => '&#39228;',
		"\xF1\xAE" => '&#39226;',
		"\xF1\xAF" => '&#39439;',
		"\xF1\xB0" => '&#39435;',
		"\xF1\xB1" => '&#39433;',
		"\xF1\xB2" => '&#39437;',
		"\xF1\xB3" => '&#39428;',
		"\xF1\xB4" => '&#39441;',
		"\xF1\xB5" => '&#39434;',
		"\xF1\xB6" => '&#39429;',
		"\xF1\xB7" => '&#39431;',
		"\xF1\xB8" => '&#39430;',
		"\xF1\xB9" => '&#39616;',
		"\xF1\xBA" => '&#39644;',
		"\xF1\xBB" => '&#39688;',
		"\xF1\xBC" => '&#39684;',
		"\xF1\xBD" => '&#39685;',
		"\xF1\xBE" => '&#39721;',
		"\xF1\xBF" => '&#39733;',
		"\xF1\xC0" => '&#39754;',
		"\xF1\xC1" => '&#39756;',
		"\xF1\xC2" => '&#39755;',
		"\xF1\xC3" => '&#39879;',
		"\xF1\xC4" => '&#39878;',
		"\xF1\xC5" => '&#39875;',
		"\xF1\xC6" => '&#39871;',
		"\xF1\xC7" => '&#39873;',
		"\xF1\xC8" => '&#39861;',
		"\xF1\xC9" => '&#39864;',
		"\xF1\xCA" => '&#39891;',
		"\xF1\xCB" => '&#39862;',
		"\xF1\xCC" => '&#39876;',
		"\xF1\xCD" => '&#39865;',
		"\xF1\xCE" => '&#39869;',
		"\xF1\xCF" => '&#40284;',
		"\xF1\xD0" => '&#40275;',
		"\xF1\xD1" => '&#40271;',
		"\xF1\xD2" => '&#40266;',
		"\xF1\xD3" => '&#40283;',
		"\xF1\xD4" => '&#40267;',
		"\xF1\xD5" => '&#40281;',
		"\xF1\xD6" => '&#40278;',
		"\xF1\xD7" => '&#40268;',
		"\xF1\xD8" => '&#40279;',
		"\xF1\xD9" => '&#40274;',
		"\xF1\xDA" => '&#40276;',
		"\xF1\xDB" => '&#40287;',
		"\xF1\xDC" => '&#40280;',
		"\xF1\xDD" => '&#40282;',
		"\xF1\xDE" => '&#40590;',
		"\xF1\xDF" => '&#40588;',
		"\xF1\xE0" => '&#40671;',
		"\xF1\xE1" => '&#40705;',
		"\xF1\xE2" => '&#40704;',
		"\xF1\xE3" => '&#40726;',
		"\xF1\xE4" => '&#40741;',
		"\xF1\xE5" => '&#40747;',
		"\xF1\xE6" => '&#40746;',
		"\xF1\xE7" => '&#40745;',
		"\xF1\xE8" => '&#40744;',
		"\xF1\xE9" => '&#40780;',
		"\xF1\xEA" => '&#40789;',
		"\xF1\xEB" => '&#20788;',
		"\xF1\xEC" => '&#20789;',
		"\xF1\xED" => '&#21142;',
		"\xF1\xEE" => '&#21239;',
		"\xF1\xEF" => '&#21428;',
		"\xF1\xF0" => '&#22187;',
		"\xF1\xF1" => '&#22189;',
		"\xF1\xF2" => '&#22182;',
		"\xF1\xF3" => '&#22183;',
		"\xF1\xF4" => '&#22186;',
		"\xF1\xF5" => '&#22188;',
		"\xF1\xF6" => '&#22746;',
		"\xF1\xF7" => '&#22749;',
		"\xF1\xF8" => '&#22747;',
		"\xF1\xF9" => '&#22802;',
		"\xF1\xFA" => '&#23357;',
		"\xF1\xFB" => '&#23358;',
		"\xF1\xFC" => '&#23359;',
		"\xF1\xFD" => '&#24003;',
		"\xF1\xFE" => '&#24176;',
		"\xF2\x40" => '&#24511;',
		"\xF2\x41" => '&#25083;',
		"\xF2\x42" => '&#25863;',
		"\xF2\x43" => '&#25872;',
		"\xF2\x44" => '&#25869;',
		"\xF2\x45" => '&#25865;',
		"\xF2\x46" => '&#25868;',
		"\xF2\x47" => '&#25870;',
		"\xF2\x48" => '&#25988;',
		"\xF2\x49" => '&#26078;',
		"\xF2\x4A" => '&#26077;',
		"\xF2\x4B" => '&#26334;',
		"\xF2\x4C" => '&#27367;',
		"\xF2\x4D" => '&#27360;',
		"\xF2\x4E" => '&#27340;',
		"\xF2\x4F" => '&#27345;',
		"\xF2\x50" => '&#27353;',
		"\xF2\x51" => '&#27339;',
		"\xF2\x52" => '&#27359;',
		"\xF2\x53" => '&#27356;',
		"\xF2\x54" => '&#27344;',
		"\xF2\x55" => '&#27371;',
		"\xF2\x56" => '&#27343;',
		"\xF2\x57" => '&#27341;',
		"\xF2\x58" => '&#27358;',
		"\xF2\x59" => '&#27488;',
		"\xF2\x5A" => '&#27568;',
		"\xF2\x5B" => '&#27660;',
		"\xF2\x5C" => '&#28697;',
		"\xF2\x5D" => '&#28711;',
		"\xF2\x5E" => '&#28704;',
		"\xF2\x5F" => '&#28694;',
		"\xF2\x60" => '&#28715;',
		"\xF2\x61" => '&#28705;',
		"\xF2\x62" => '&#28706;',
		"\xF2\x63" => '&#28707;',
		"\xF2\x64" => '&#28713;',
		"\xF2\x65" => '&#28695;',
		"\xF2\x66" => '&#28708;',
		"\xF2\x67" => '&#28700;',
		"\xF2\x68" => '&#28714;',
		"\xF2\x69" => '&#29196;',
		"\xF2\x6A" => '&#29194;',
		"\xF2\x6B" => '&#29191;',
		"\xF2\x6C" => '&#29186;',
		"\xF2\x6D" => '&#29189;',
		"\xF2\x6E" => '&#29349;',
		"\xF2\x6F" => '&#29350;',
		"\xF2\x70" => '&#29348;',
		"\xF2\x71" => '&#29347;',
		"\xF2\x72" => '&#29345;',
		"\xF2\x73" => '&#29899;',
		"\xF2\x74" => '&#29893;',
		"\xF2\x75" => '&#29879;',
		"\xF2\x76" => '&#29891;',
		"\xF2\x77" => '&#29974;',
		"\xF2\x78" => '&#30304;',
		"\xF2\x79" => '&#30665;',
		"\xF2\x7A" => '&#30666;',
		"\xF2\x7B" => '&#30660;',
		"\xF2\x7C" => '&#30705;',
		"\xF2\x7D" => '&#31005;',
		"\xF2\x7E" => '&#31003;',
		"\xF2\xA1" => '&#31009;',
		"\xF2\xA2" => '&#31004;',
		"\xF2\xA3" => '&#30999;',
		"\xF2\xA4" => '&#31006;',
		"\xF2\xA5" => '&#31152;',
		"\xF2\xA6" => '&#31335;',
		"\xF2\xA7" => '&#31336;',
		"\xF2\xA8" => '&#31795;',
		"\xF2\xA9" => '&#31804;',
		"\xF2\xAA" => '&#31801;',
		"\xF2\xAB" => '&#31788;',
		"\xF2\xAC" => '&#31803;',
		"\xF2\xAD" => '&#31980;',
		"\xF2\xAE" => '&#31978;',
		"\xF2\xAF" => '&#32374;',
		"\xF2\xB0" => '&#32373;',
		"\xF2\xB1" => '&#32376;',
		"\xF2\xB2" => '&#32368;',
		"\xF2\xB3" => '&#32375;',
		"\xF2\xB4" => '&#32367;',
		"\xF2\xB5" => '&#32378;',
		"\xF2\xB6" => '&#32370;',
		"\xF2\xB7" => '&#32372;',
		"\xF2\xB8" => '&#32360;',
		"\xF2\xB9" => '&#32587;',
		"\xF2\xBA" => '&#32586;',
		"\xF2\xBB" => '&#32643;',
		"\xF2\xBC" => '&#32646;',
		"\xF2\xBD" => '&#32695;',
		"\xF2\xBE" => '&#32765;',
		"\xF2\xBF" => '&#32766;',
		"\xF2\xC0" => '&#32888;',
		"\xF2\xC1" => '&#33239;',
		"\xF2\xC2" => '&#33237;',
		"\xF2\xC3" => '&#33380;',
		"\xF2\xC4" => '&#33377;',
		"\xF2\xC5" => '&#33379;',
		"\xF2\xC6" => '&#34283;',
		"\xF2\xC7" => '&#34289;',
		"\xF2\xC8" => '&#34285;',
		"\xF2\xC9" => '&#34265;',
		"\xF2\xCA" => '&#34273;',
		"\xF2\xCB" => '&#34280;',
		"\xF2\xCC" => '&#34266;',
		"\xF2\xCD" => '&#34263;',
		"\xF2\xCE" => '&#34284;',
		"\xF2\xCF" => '&#34290;',
		"\xF2\xD0" => '&#34296;',
		"\xF2\xD1" => '&#34264;',
		"\xF2\xD2" => '&#34271;',
		"\xF2\xD3" => '&#34275;',
		"\xF2\xD4" => '&#34268;',
		"\xF2\xD5" => '&#34257;',
		"\xF2\xD6" => '&#34288;',
		"\xF2\xD7" => '&#34278;',
		"\xF2\xD8" => '&#34287;',
		"\xF2\xD9" => '&#34270;',
		"\xF2\xDA" => '&#34274;',
		"\xF2\xDB" => '&#34816;',
		"\xF2\xDC" => '&#34810;',
		"\xF2\xDD" => '&#34819;',
		"\xF2\xDE" => '&#34806;',
		"\xF2\xDF" => '&#34807;',
		"\xF2\xE0" => '&#34825;',
		"\xF2\xE1" => '&#34828;',
		"\xF2\xE2" => '&#34827;',
		"\xF2\xE3" => '&#34822;',
		"\xF2\xE4" => '&#34812;',
		"\xF2\xE5" => '&#34824;',
		"\xF2\xE6" => '&#34815;',
		"\xF2\xE7" => '&#34826;',
		"\xF2\xE8" => '&#34818;',
		"\xF2\xE9" => '&#35170;',
		"\xF2\xEA" => '&#35162;',
		"\xF2\xEB" => '&#35163;',
		"\xF2\xEC" => '&#35159;',
		"\xF2\xED" => '&#35169;',
		"\xF2\xEE" => '&#35164;',
		"\xF2\xEF" => '&#35160;',
		"\xF2\xF0" => '&#35165;',
		"\xF2\xF1" => '&#35161;',
		"\xF2\xF2" => '&#35208;',
		"\xF2\xF3" => '&#35255;',
		"\xF2\xF4" => '&#35254;',
		"\xF2\xF5" => '&#35318;',
		"\xF2\xF6" => '&#35664;',
		"\xF2\xF7" => '&#35656;',
		"\xF2\xF8" => '&#35658;',
		"\xF2\xF9" => '&#35648;',
		"\xF2\xFA" => '&#35667;',
		"\xF2\xFB" => '&#35670;',
		"\xF2\xFC" => '&#35668;',
		"\xF2\xFD" => '&#35659;',
		"\xF2\xFE" => '&#35669;',
		"\xF3\x40" => '&#35665;',
		"\xF3\x41" => '&#35650;',
		"\xF3\x42" => '&#35666;',
		"\xF3\x43" => '&#35671;',
		"\xF3\x44" => '&#35907;',
		"\xF3\x45" => '&#35959;',
		"\xF3\x46" => '&#35958;',
		"\xF3\x47" => '&#35994;',
		"\xF3\x48" => '&#36102;',
		"\xF3\x49" => '&#36103;',
		"\xF3\x4A" => '&#36105;',
		"\xF3\x4B" => '&#36268;',
		"\xF3\x4C" => '&#36266;',
		"\xF3\x4D" => '&#36269;',
		"\xF3\x4E" => '&#36267;',
		"\xF3\x4F" => '&#36461;',
		"\xF3\x50" => '&#36472;',
		"\xF3\x51" => '&#36467;',
		"\xF3\x52" => '&#36458;',
		"\xF3\x53" => '&#36463;',
		"\xF3\x54" => '&#36475;',
		"\xF3\x55" => '&#36546;',
		"\xF3\x56" => '&#36690;',
		"\xF3\x57" => '&#36689;',
		"\xF3\x58" => '&#36687;',
		"\xF3\x59" => '&#36688;',
		"\xF3\x5A" => '&#36691;',
		"\xF3\x5B" => '&#36788;',
		"\xF3\x5C" => '&#37184;',
		"\xF3\x5D" => '&#37183;',
		"\xF3\x5E" => '&#37296;',
		"\xF3\x5F" => '&#37293;',
		"\xF3\x60" => '&#37854;',
		"\xF3\x61" => '&#37831;',
		"\xF3\x62" => '&#37839;',
		"\xF3\x63" => '&#37826;',
		"\xF3\x64" => '&#37850;',
		"\xF3\x65" => '&#37840;',
		"\xF3\x66" => '&#37881;',
		"\xF3\x67" => '&#37868;',
		"\xF3\x68" => '&#37836;',
		"\xF3\x69" => '&#37849;',
		"\xF3\x6A" => '&#37801;',
		"\xF3\x6B" => '&#37862;',
		"\xF3\x6C" => '&#37834;',
		"\xF3\x6D" => '&#37844;',
		"\xF3\x6E" => '&#37870;',
		"\xF3\x6F" => '&#37859;',
		"\xF3\x70" => '&#37845;',
		"\xF3\x71" => '&#37828;',
		"\xF3\x72" => '&#37838;',
		"\xF3\x73" => '&#37824;',
		"\xF3\x74" => '&#37842;',
		"\xF3\x75" => '&#37863;',
		"\xF3\x76" => '&#38269;',
		"\xF3\x77" => '&#38362;',
		"\xF3\x78" => '&#38363;',
		"\xF3\x79" => '&#38625;',
		"\xF3\x7A" => '&#38697;',
		"\xF3\x7B" => '&#38699;',
		"\xF3\x7C" => '&#38700;',
		"\xF3\x7D" => '&#38696;',
		"\xF3\x7E" => '&#38694;',
		"\xF3\xA1" => '&#38835;',
		"\xF3\xA2" => '&#38839;',
		"\xF3\xA3" => '&#38838;',
		"\xF3\xA4" => '&#38877;',
		"\xF3\xA5" => '&#38878;',
		"\xF3\xA6" => '&#38879;',
		"\xF3\xA7" => '&#39004;',
		"\xF3\xA8" => '&#39001;',
		"\xF3\xA9" => '&#39005;',
		"\xF3\xAA" => '&#38999;',
		"\xF3\xAB" => '&#39103;',
		"\xF3\xAC" => '&#39101;',
		"\xF3\xAD" => '&#39099;',
		"\xF3\xAE" => '&#39102;',
		"\xF3\xAF" => '&#39240;',
		"\xF3\xB0" => '&#39239;',
		"\xF3\xB1" => '&#39235;',
		"\xF3\xB2" => '&#39334;',
		"\xF3\xB3" => '&#39335;',
		"\xF3\xB4" => '&#39450;',
		"\xF3\xB5" => '&#39445;',
		"\xF3\xB6" => '&#39461;',
		"\xF3\xB7" => '&#39453;',
		"\xF3\xB8" => '&#39460;',
		"\xF3\xB9" => '&#39451;',
		"\xF3\xBA" => '&#39458;',
		"\xF3\xBB" => '&#39456;',
		"\xF3\xBC" => '&#39463;',
		"\xF3\xBD" => '&#39459;',
		"\xF3\xBE" => '&#39454;',
		"\xF3\xBF" => '&#39452;',
		"\xF3\xC0" => '&#39444;',
		"\xF3\xC1" => '&#39618;',
		"\xF3\xC2" => '&#39691;',
		"\xF3\xC3" => '&#39690;',
		"\xF3\xC4" => '&#39694;',
		"\xF3\xC5" => '&#39692;',
		"\xF3\xC6" => '&#39735;',
		"\xF3\xC7" => '&#39914;',
		"\xF3\xC8" => '&#39915;',
		"\xF3\xC9" => '&#39904;',
		"\xF3\xCA" => '&#39902;',
		"\xF3\xCB" => '&#39908;',
		"\xF3\xCC" => '&#39910;',
		"\xF3\xCD" => '&#39906;',
		"\xF3\xCE" => '&#39920;',
		"\xF3\xCF" => '&#39892;',
		"\xF3\xD0" => '&#39895;',
		"\xF3\xD1" => '&#39916;',
		"\xF3\xD2" => '&#39900;',
		"\xF3\xD3" => '&#39897;',
		"\xF3\xD4" => '&#39909;',
		"\xF3\xD5" => '&#39893;',
		"\xF3\xD6" => '&#39905;',
		"\xF3\xD7" => '&#39898;',
		"\xF3\xD8" => '&#40311;',
		"\xF3\xD9" => '&#40321;',
		"\xF3\xDA" => '&#40330;',
		"\xF3\xDB" => '&#40324;',
		"\xF3\xDC" => '&#40328;',
		"\xF3\xDD" => '&#40305;',
		"\xF3\xDE" => '&#40320;',
		"\xF3\xDF" => '&#40312;',
		"\xF3\xE0" => '&#40326;',
		"\xF3\xE1" => '&#40331;',
		"\xF3\xE2" => '&#40332;',
		"\xF3\xE3" => '&#40317;',
		"\xF3\xE4" => '&#40299;',
		"\xF3\xE5" => '&#40308;',
		"\xF3\xE6" => '&#40309;',
		"\xF3\xE7" => '&#40304;',
		"\xF3\xE8" => '&#40297;',
		"\xF3\xE9" => '&#40325;',
		"\xF3\xEA" => '&#40307;',
		"\xF3\xEB" => '&#40315;',
		"\xF3\xEC" => '&#40322;',
		"\xF3\xED" => '&#40303;',
		"\xF3\xEE" => '&#40313;',
		"\xF3\xEF" => '&#40319;',
		"\xF3\xF0" => '&#40327;',
		"\xF3\xF1" => '&#40296;',
		"\xF3\xF2" => '&#40596;',
		"\xF3\xF3" => '&#40593;',
		"\xF3\xF4" => '&#40640;',
		"\xF3\xF5" => '&#40700;',
		"\xF3\xF6" => '&#40749;',
		"\xF3\xF7" => '&#40768;',
		"\xF3\xF8" => '&#40769;',
		"\xF3\xF9" => '&#40781;',
		"\xF3\xFA" => '&#40790;',
		"\xF3\xFB" => '&#40791;',
		"\xF3\xFC" => '&#40792;',
		"\xF3\xFD" => '&#21303;',
		"\xF3\xFE" => '&#22194;',
		"\xF4\x40" => '&#22197;',
		"\xF4\x41" => '&#22195;',
		"\xF4\x42" => '&#22755;',
		"\xF4\x43" => '&#23365;',
		"\xF4\x44" => '&#24006;',
		"\xF4\x45" => '&#24007;',
		"\xF4\x46" => '&#24302;',
		"\xF4\x47" => '&#24303;',
		"\xF4\x48" => '&#24512;',
		"\xF4\x49" => '&#24513;',
		"\xF4\x4A" => '&#25081;',
		"\xF4\x4B" => '&#25879;',
		"\xF4\x4C" => '&#25878;',
		"\xF4\x4D" => '&#25877;',
		"\xF4\x4E" => '&#25875;',
		"\xF4\x4F" => '&#26079;',
		"\xF4\x50" => '&#26344;',
		"\xF4\x51" => '&#26339;',
		"\xF4\x52" => '&#26340;',
		"\xF4\x53" => '&#27379;',
		"\xF4\x54" => '&#27376;',
		"\xF4\x55" => '&#27370;',
		"\xF4\x56" => '&#27368;',
		"\xF4\x57" => '&#27385;',
		"\xF4\x58" => '&#27377;',
		"\xF4\x59" => '&#27374;',
		"\xF4\x5A" => '&#27375;',
		"\xF4\x5B" => '&#28732;',
		"\xF4\x5C" => '&#28725;',
		"\xF4\x5D" => '&#28719;',
		"\xF4\x5E" => '&#28727;',
		"\xF4\x5F" => '&#28724;',
		"\xF4\x60" => '&#28721;',
		"\xF4\x61" => '&#28738;',
		"\xF4\x62" => '&#28728;',
		"\xF4\x63" => '&#28735;',
		"\xF4\x64" => '&#28730;',
		"\xF4\x65" => '&#28729;',
		"\xF4\x66" => '&#28736;',
		"\xF4\x67" => '&#28731;',
		"\xF4\x68" => '&#28723;',
		"\xF4\x69" => '&#28737;',
		"\xF4\x6A" => '&#29203;',
		"\xF4\x6B" => '&#29204;',
		"\xF4\x6C" => '&#29352;',
		"\xF4\x6D" => '&#29565;',
		"\xF4\x6E" => '&#29564;',
		"\xF4\x6F" => '&#29882;',
		"\xF4\x70" => '&#30379;',
		"\xF4\x71" => '&#30378;',
		"\xF4\x72" => '&#30398;',
		"\xF4\x73" => '&#30445;',
		"\xF4\x74" => '&#30668;',
		"\xF4\x75" => '&#30670;',
		"\xF4\x76" => '&#30671;',
		"\xF4\x77" => '&#30669;',
		"\xF4\x78" => '&#30706;',
		"\xF4\x79" => '&#31013;',
		"\xF4\x7A" => '&#31011;',
		"\xF4\x7B" => '&#31015;',
		"\xF4\x7C" => '&#31016;',
		"\xF4\x7D" => '&#31012;',
		"\xF4\x7E" => '&#31017;',
		"\xF4\xA1" => '&#31154;',
		"\xF4\xA2" => '&#31342;',
		"\xF4\xA3" => '&#31340;',
		"\xF4\xA4" => '&#31341;',
		"\xF4\xA5" => '&#31479;',
		"\xF4\xA6" => '&#31817;',
		"\xF4\xA7" => '&#31816;',
		"\xF4\xA8" => '&#31818;',
		"\xF4\xA9" => '&#31815;',
		"\xF4\xAA" => '&#31813;',
		"\xF4\xAB" => '&#31982;',
		"\xF4\xAC" => '&#32379;',
		"\xF4\xAD" => '&#32382;',
		"\xF4\xAE" => '&#32385;',
		"\xF4\xAF" => '&#32384;',
		"\xF4\xB0" => '&#32698;',
		"\xF4\xB1" => '&#32767;',
		"\xF4\xB2" => '&#32889;',
		"\xF4\xB3" => '&#33243;',
		"\xF4\xB4" => '&#33241;',
		"\xF4\xB5" => '&#33291;',
		"\xF4\xB6" => '&#33384;',
		"\xF4\xB7" => '&#33385;',
		"\xF4\xB8" => '&#34338;',
		"\xF4\xB9" => '&#34303;',
		"\xF4\xBA" => '&#34305;',
		"\xF4\xBB" => '&#34302;',
		"\xF4\xBC" => '&#34331;',
		"\xF4\xBD" => '&#34304;',
		"\xF4\xBE" => '&#34294;',
		"\xF4\xBF" => '&#34308;',
		"\xF4\xC0" => '&#34313;',
		"\xF4\xC1" => '&#34309;',
		"\xF4\xC2" => '&#34316;',
		"\xF4\xC3" => '&#34301;',
		"\xF4\xC4" => '&#34841;',
		"\xF4\xC5" => '&#34832;',
		"\xF4\xC6" => '&#34833;',
		"\xF4\xC7" => '&#34839;',
		"\xF4\xC8" => '&#34835;',
		"\xF4\xC9" => '&#34838;',
		"\xF4\xCA" => '&#35171;',
		"\xF4\xCB" => '&#35174;',
		"\xF4\xCC" => '&#35257;',
		"\xF4\xCD" => '&#35319;',
		"\xF4\xCE" => '&#35680;',
		"\xF4\xCF" => '&#35690;',
		"\xF4\xD0" => '&#35677;',
		"\xF4\xD1" => '&#35688;',
		"\xF4\xD2" => '&#35683;',
		"\xF4\xD3" => '&#35685;',
		"\xF4\xD4" => '&#35687;',
		"\xF4\xD5" => '&#35693;',
		"\xF4\xD6" => '&#36270;',
		"\xF4\xD7" => '&#36486;',
		"\xF4\xD8" => '&#36488;',
		"\xF4\xD9" => '&#36484;',
		"\xF4\xDA" => '&#36697;',
		"\xF4\xDB" => '&#36694;',
		"\xF4\xDC" => '&#36695;',
		"\xF4\xDD" => '&#36693;',
		"\xF4\xDE" => '&#36696;',
		"\xF4\xDF" => '&#36698;',
		"\xF4\xE0" => '&#37005;',
		"\xF4\xE1" => '&#37187;',
		"\xF4\xE2" => '&#37185;',
		"\xF4\xE3" => '&#37303;',
		"\xF4\xE4" => '&#37301;',
		"\xF4\xE5" => '&#37298;',
		"\xF4\xE6" => '&#37299;',
		"\xF4\xE7" => '&#37899;',
		"\xF4\xE8" => '&#37907;',
		"\xF4\xE9" => '&#37883;',
		"\xF4\xEA" => '&#37920;',
		"\xF4\xEB" => '&#37903;',
		"\xF4\xEC" => '&#37908;',
		"\xF4\xED" => '&#37886;',
		"\xF4\xEE" => '&#37909;',
		"\xF4\xEF" => '&#37904;',
		"\xF4\xF0" => '&#37928;',
		"\xF4\xF1" => '&#37913;',
		"\xF4\xF2" => '&#37901;',
		"\xF4\xF3" => '&#37877;',
		"\xF4\xF4" => '&#37888;',
		"\xF4\xF5" => '&#37879;',
		"\xF4\xF6" => '&#37895;',
		"\xF4\xF7" => '&#37902;',
		"\xF4\xF8" => '&#37910;',
		"\xF4\xF9" => '&#37906;',
		"\xF4\xFA" => '&#37882;',
		"\xF4\xFB" => '&#37897;',
		"\xF4\xFC" => '&#37880;',
		"\xF4\xFD" => '&#37898;',
		"\xF4\xFE" => '&#37887;',
		"\xF5\x40" => '&#37884;',
		"\xF5\x41" => '&#37900;',
		"\xF5\x42" => '&#37878;',
		"\xF5\x43" => '&#37905;',
		"\xF5\x44" => '&#37894;',
		"\xF5\x45" => '&#38366;',
		"\xF5\x46" => '&#38368;',
		"\xF5\x47" => '&#38367;',
		"\xF5\x48" => '&#38702;',
		"\xF5\x49" => '&#38703;',
		"\xF5\x4A" => '&#38841;',
		"\xF5\x4B" => '&#38843;',
		"\xF5\x4C" => '&#38909;',
		"\xF5\x4D" => '&#38910;',
		"\xF5\x4E" => '&#39008;',
		"\xF5\x4F" => '&#39010;',
		"\xF5\x50" => '&#39011;',
		"\xF5\x51" => '&#39007;',
		"\xF5\x52" => '&#39105;',
		"\xF5\x53" => '&#39106;',
		"\xF5\x54" => '&#39248;',
		"\xF5\x55" => '&#39246;',
		"\xF5\x56" => '&#39257;',
		"\xF5\x57" => '&#39244;',
		"\xF5\x58" => '&#39243;',
		"\xF5\x59" => '&#39251;',
		"\xF5\x5A" => '&#39474;',
		"\xF5\x5B" => '&#39476;',
		"\xF5\x5C" => '&#39473;',
		"\xF5\x5D" => '&#39468;',
		"\xF5\x5E" => '&#39466;',
		"\xF5\x5F" => '&#39478;',
		"\xF5\x60" => '&#39465;',
		"\xF5\x61" => '&#39470;',
		"\xF5\x62" => '&#39480;',
		"\xF5\x63" => '&#39469;',
		"\xF5\x64" => '&#39623;',
		"\xF5\x65" => '&#39626;',
		"\xF5\x66" => '&#39622;',
		"\xF5\x67" => '&#39696;',
		"\xF5\x68" => '&#39698;',
		"\xF5\x69" => '&#39697;',
		"\xF5\x6A" => '&#39947;',
		"\xF5\x6B" => '&#39944;',
		"\xF5\x6C" => '&#39927;',
		"\xF5\x6D" => '&#39941;',
		"\xF5\x6E" => '&#39954;',
		"\xF5\x6F" => '&#39928;',
		"\xF5\x70" => '&#40000;',
		"\xF5\x71" => '&#39943;',
		"\xF5\x72" => '&#39950;',
		"\xF5\x73" => '&#39942;',
		"\xF5\x74" => '&#39959;',
		"\xF5\x75" => '&#39956;',
		"\xF5\x76" => '&#39945;',
		"\xF5\x77" => '&#40351;',
		"\xF5\x78" => '&#40345;',
		"\xF5\x79" => '&#40356;',
		"\xF5\x7A" => '&#40349;',
		"\xF5\x7B" => '&#40338;',
		"\xF5\x7C" => '&#40344;',
		"\xF5\x7D" => '&#40336;',
		"\xF5\x7E" => '&#40347;',
		"\xF5\xA1" => '&#40352;',
		"\xF5\xA2" => '&#40340;',
		"\xF5\xA3" => '&#40348;',
		"\xF5\xA4" => '&#40362;',
		"\xF5\xA5" => '&#40343;',
		"\xF5\xA6" => '&#40353;',
		"\xF5\xA7" => '&#40346;',
		"\xF5\xA8" => '&#40354;',
		"\xF5\xA9" => '&#40360;',
		"\xF5\xAA" => '&#40350;',
		"\xF5\xAB" => '&#40355;',
		"\xF5\xAC" => '&#40383;',
		"\xF5\xAD" => '&#40361;',
		"\xF5\xAE" => '&#40342;',
		"\xF5\xAF" => '&#40358;',
		"\xF5\xB0" => '&#40359;',
		"\xF5\xB1" => '&#40601;',
		"\xF5\xB2" => '&#40603;',
		"\xF5\xB3" => '&#40602;',
		"\xF5\xB4" => '&#40677;',
		"\xF5\xB5" => '&#40676;',
		"\xF5\xB6" => '&#40679;',
		"\xF5\xB7" => '&#40678;',
		"\xF5\xB8" => '&#40752;',
		"\xF5\xB9" => '&#40750;',
		"\xF5\xBA" => '&#40795;',
		"\xF5\xBB" => '&#40800;',
		"\xF5\xBC" => '&#40798;',
		"\xF5\xBD" => '&#40797;',
		"\xF5\xBE" => '&#40793;',
		"\xF5\xBF" => '&#40849;',
		"\xF5\xC0" => '&#20794;',
		"\xF5\xC1" => '&#20793;',
		"\xF5\xC2" => '&#21144;',
		"\xF5\xC3" => '&#21143;',
		"\xF5\xC4" => '&#22211;',
		"\xF5\xC5" => '&#22205;',
		"\xF5\xC6" => '&#22206;',
		"\xF5\xC7" => '&#23368;',
		"\xF5\xC8" => '&#23367;',
		"\xF5\xC9" => '&#24011;',
		"\xF5\xCA" => '&#24015;',
		"\xF5\xCB" => '&#24305;',
		"\xF5\xCC" => '&#25085;',
		"\xF5\xCD" => '&#25883;',
		"\xF5\xCE" => '&#27394;',
		"\xF5\xCF" => '&#27388;',
		"\xF5\xD0" => '&#27395;',
		"\xF5\xD1" => '&#27384;',
		"\xF5\xD2" => '&#27392;',
		"\xF5\xD3" => '&#28739;',
		"\xF5\xD4" => '&#28740;',
		"\xF5\xD5" => '&#28746;',
		"\xF5\xD6" => '&#28744;',
		"\xF5\xD7" => '&#28745;',
		"\xF5\xD8" => '&#28741;',
		"\xF5\xD9" => '&#28742;',
		"\xF5\xDA" => '&#29213;',
		"\xF5\xDB" => '&#29210;',
		"\xF5\xDC" => '&#29209;',
		"\xF5\xDD" => '&#29566;',
		"\xF5\xDE" => '&#29975;',
		"\xF5\xDF" => '&#30314;',
		"\xF5\xE0" => '&#30672;',
		"\xF5\xE1" => '&#31021;',
		"\xF5\xE2" => '&#31025;',
		"\xF5\xE3" => '&#31023;',
		"\xF5\xE4" => '&#31828;',
		"\xF5\xE5" => '&#31827;',
		"\xF5\xE6" => '&#31986;',
		"\xF5\xE7" => '&#32394;',
		"\xF5\xE8" => '&#32391;',
		"\xF5\xE9" => '&#32392;',
		"\xF5\xEA" => '&#32395;',
		"\xF5\xEB" => '&#32390;',
		"\xF5\xEC" => '&#32397;',
		"\xF5\xED" => '&#32589;',
		"\xF5\xEE" => '&#32699;',
		"\xF5\xEF" => '&#32816;',
		"\xF5\xF0" => '&#33245;',
		"\xF5\xF1" => '&#34328;',
		"\xF5\xF2" => '&#34346;',
		"\xF5\xF3" => '&#34342;',
		"\xF5\xF4" => '&#34335;',
		"\xF5\xF5" => '&#34339;',
		"\xF5\xF6" => '&#34332;',
		"\xF5\xF7" => '&#34329;',
		"\xF5\xF8" => '&#34343;',
		"\xF5\xF9" => '&#34350;',
		"\xF5\xFA" => '&#34337;',
		"\xF5\xFB" => '&#34336;',
		"\xF5\xFC" => '&#34345;',
		"\xF5\xFD" => '&#34334;',
		"\xF5\xFE" => '&#34341;',
		"\xF6\x40" => '&#34857;',
		"\xF6\x41" => '&#34845;',
		"\xF6\x42" => '&#34843;',
		"\xF6\x43" => '&#34848;',
		"\xF6\x44" => '&#34852;',
		"\xF6\x45" => '&#34844;',
		"\xF6\x46" => '&#34859;',
		"\xF6\x47" => '&#34890;',
		"\xF6\x48" => '&#35181;',
		"\xF6\x49" => '&#35177;',
		"\xF6\x4A" => '&#35182;',
		"\xF6\x4B" => '&#35179;',
		"\xF6\x4C" => '&#35322;',
		"\xF6\x4D" => '&#35705;',
		"\xF6\x4E" => '&#35704;',
		"\xF6\x4F" => '&#35653;',
		"\xF6\x50" => '&#35706;',
		"\xF6\x51" => '&#35707;',
		"\xF6\x52" => '&#36112;',
		"\xF6\x53" => '&#36116;',
		"\xF6\x54" => '&#36271;',
		"\xF6\x55" => '&#36494;',
		"\xF6\x56" => '&#36492;',
		"\xF6\x57" => '&#36702;',
		"\xF6\x58" => '&#36699;',
		"\xF6\x59" => '&#36701;',
		"\xF6\x5A" => '&#37190;',
		"\xF6\x5B" => '&#37188;',
		"\xF6\x5C" => '&#37189;',
		"\xF6\x5D" => '&#37305;',
		"\xF6\x5E" => '&#37951;',
		"\xF6\x5F" => '&#37947;',
		"\xF6\x60" => '&#37942;',
		"\xF6\x61" => '&#37929;',
		"\xF6\x62" => '&#37949;',
		"\xF6\x63" => '&#37948;',
		"\xF6\x64" => '&#37936;',
		"\xF6\x65" => '&#37945;',
		"\xF6\x66" => '&#37930;',
		"\xF6\x67" => '&#37943;',
		"\xF6\x68" => '&#37932;',
		"\xF6\x69" => '&#37952;',
		"\xF6\x6A" => '&#37937;',
		"\xF6\x6B" => '&#38373;',
		"\xF6\x6C" => '&#38372;',
		"\xF6\x6D" => '&#38371;',
		"\xF6\x6E" => '&#38709;',
		"\xF6\x6F" => '&#38714;',
		"\xF6\x70" => '&#38847;',
		"\xF6\x71" => '&#38881;',
		"\xF6\x72" => '&#39012;',
		"\xF6\x73" => '&#39113;',
		"\xF6\x74" => '&#39110;',
		"\xF6\x75" => '&#39104;',
		"\xF6\x76" => '&#39256;',
		"\xF6\x77" => '&#39254;',
		"\xF6\x78" => '&#39481;',
		"\xF6\x79" => '&#39485;',
		"\xF6\x7A" => '&#39494;',
		"\xF6\x7B" => '&#39492;',
		"\xF6\x7C" => '&#39490;',
		"\xF6\x7D" => '&#39489;',
		"\xF6\x7E" => '&#39482;',
		"\xF6\xA1" => '&#39487;',
		"\xF6\xA2" => '&#39629;',
		"\xF6\xA3" => '&#39701;',
		"\xF6\xA4" => '&#39703;',
		"\xF6\xA5" => '&#39704;',
		"\xF6\xA6" => '&#39702;',
		"\xF6\xA7" => '&#39738;',
		"\xF6\xA8" => '&#39762;',
		"\xF6\xA9" => '&#39979;',
		"\xF6\xAA" => '&#39965;',
		"\xF6\xAB" => '&#39964;',
		"\xF6\xAC" => '&#39980;',
		"\xF6\xAD" => '&#39971;',
		"\xF6\xAE" => '&#39976;',
		"\xF6\xAF" => '&#39977;',
		"\xF6\xB0" => '&#39972;',
		"\xF6\xB1" => '&#39969;',
		"\xF6\xB2" => '&#40375;',
		"\xF6\xB3" => '&#40374;',
		"\xF6\xB4" => '&#40380;',
		"\xF6\xB5" => '&#40385;',
		"\xF6\xB6" => '&#40391;',
		"\xF6\xB7" => '&#40394;',
		"\xF6\xB8" => '&#40399;',
		"\xF6\xB9" => '&#40382;',
		"\xF6\xBA" => '&#40389;',
		"\xF6\xBB" => '&#40387;',
		"\xF6\xBC" => '&#40379;',
		"\xF6\xBD" => '&#40373;',
		"\xF6\xBE" => '&#40398;',
		"\xF6\xBF" => '&#40377;',
		"\xF6\xC0" => '&#40378;',
		"\xF6\xC1" => '&#40364;',
		"\xF6\xC2" => '&#40392;',
		"\xF6\xC3" => '&#40369;',
		"\xF6\xC4" => '&#40365;',
		"\xF6\xC5" => '&#40396;',
		"\xF6\xC6" => '&#40371;',
		"\xF6\xC7" => '&#40397;',
		"\xF6\xC8" => '&#40370;',
		"\xF6\xC9" => '&#40570;',
		"\xF6\xCA" => '&#40604;',
		"\xF6\xCB" => '&#40683;',
		"\xF6\xCC" => '&#40686;',
		"\xF6\xCD" => '&#40685;',
		"\xF6\xCE" => '&#40731;',
		"\xF6\xCF" => '&#40728;',
		"\xF6\xD0" => '&#40730;',
		"\xF6\xD1" => '&#40753;',
		"\xF6\xD2" => '&#40782;',
		"\xF6\xD3" => '&#40805;',
		"\xF6\xD4" => '&#40804;',
		"\xF6\xD5" => '&#40850;',
		"\xF6\xD6" => '&#20153;',
		"\xF6\xD7" => '&#22214;',
		"\xF6\xD8" => '&#22213;',
		"\xF6\xD9" => '&#22219;',
		"\xF6\xDA" => '&#22897;',
		"\xF6\xDB" => '&#23371;',
		"\xF6\xDC" => '&#23372;',
		"\xF6\xDD" => '&#24021;',
		"\xF6\xDE" => '&#24017;',
		"\xF6\xDF" => '&#24306;',
		"\xF6\xE0" => '&#25889;',
		"\xF6\xE1" => '&#25888;',
		"\xF6\xE2" => '&#25894;',
		"\xF6\xE3" => '&#25890;',
		"\xF6\xE4" => '&#27403;',
		"\xF6\xE5" => '&#27400;',
		"\xF6\xE6" => '&#27401;',
		"\xF6\xE7" => '&#27661;',
		"\xF6\xE8" => '&#28757;',
		"\xF6\xE9" => '&#28758;',
		"\xF6\xEA" => '&#28759;',
		"\xF6\xEB" => '&#28754;',
		"\xF6\xEC" => '&#29214;',
		"\xF6\xED" => '&#29215;',
		"\xF6\xEE" => '&#29353;',
		"\xF6\xEF" => '&#29567;',
		"\xF6\xF0" => '&#29912;',
		"\xF6\xF1" => '&#29909;',
		"\xF6\xF2" => '&#29913;',
		"\xF6\xF3" => '&#29911;',
		"\xF6\xF4" => '&#30317;',
		"\xF6\xF5" => '&#30381;',
		"\xF6\xF6" => '&#31029;',
		"\xF6\xF7" => '&#31156;',
		"\xF6\xF8" => '&#31344;',
		"\xF6\xF9" => '&#31345;',
		"\xF6\xFA" => '&#31831;',
		"\xF6\xFB" => '&#31836;',
		"\xF6\xFC" => '&#31833;',
		"\xF6\xFD" => '&#31835;',
		"\xF6\xFE" => '&#31834;',
		"\xF7\x40" => '&#31988;',
		"\xF7\x41" => '&#31985;',
		"\xF7\x42" => '&#32401;',
		"\xF7\x43" => '&#32591;',
		"\xF7\x44" => '&#32647;',
		"\xF7\x45" => '&#33246;',
		"\xF7\x46" => '&#33387;',
		"\xF7\x47" => '&#34356;',
		"\xF7\x48" => '&#34357;',
		"\xF7\x49" => '&#34355;',
		"\xF7\x4A" => '&#34348;',
		"\xF7\x4B" => '&#34354;',
		"\xF7\x4C" => '&#34358;',
		"\xF7\x4D" => '&#34860;',
		"\xF7\x4E" => '&#34856;',
		"\xF7\x4F" => '&#34854;',
		"\xF7\x50" => '&#34858;',
		"\xF7\x51" => '&#34853;',
		"\xF7\x52" => '&#35185;',
		"\xF7\x53" => '&#35263;',
		"\xF7\x54" => '&#35262;',
		"\xF7\x55" => '&#35323;',
		"\xF7\x56" => '&#35710;',
		"\xF7\x57" => '&#35716;',
		"\xF7\x58" => '&#35714;',
		"\xF7\x59" => '&#35718;',
		"\xF7\x5A" => '&#35717;',
		"\xF7\x5B" => '&#35711;',
		"\xF7\x5C" => '&#36117;',
		"\xF7\x5D" => '&#36501;',
		"\xF7\x5E" => '&#36500;',
		"\xF7\x5F" => '&#36506;',
		"\xF7\x60" => '&#36498;',
		"\xF7\x61" => '&#36496;',
		"\xF7\x62" => '&#36502;',
		"\xF7\x63" => '&#36503;',
		"\xF7\x64" => '&#36704;',
		"\xF7\x65" => '&#36706;',
		"\xF7\x66" => '&#37191;',
		"\xF7\x67" => '&#37964;',
		"\xF7\x68" => '&#37968;',
		"\xF7\x69" => '&#37962;',
		"\xF7\x6A" => '&#37963;',
		"\xF7\x6B" => '&#37967;',
		"\xF7\x6C" => '&#37959;',
		"\xF7\x6D" => '&#37957;',
		"\xF7\x6E" => '&#37960;',
		"\xF7\x6F" => '&#37961;',
		"\xF7\x70" => '&#37958;',
		"\xF7\x71" => '&#38719;',
		"\xF7\x72" => '&#38883;',
		"\xF7\x73" => '&#39018;',
		"\xF7\x74" => '&#39017;',
		"\xF7\x75" => '&#39115;',
		"\xF7\x76" => '&#39252;',
		"\xF7\x77" => '&#39259;',
		"\xF7\x78" => '&#39502;',
		"\xF7\x79" => '&#39507;',
		"\xF7\x7A" => '&#39508;',
		"\xF7\x7B" => '&#39500;',
		"\xF7\x7C" => '&#39503;',
		"\xF7\x7D" => '&#39496;',
		"\xF7\x7E" => '&#39498;',
		"\xF7\xA1" => '&#39497;',
		"\xF7\xA2" => '&#39506;',
		"\xF7\xA3" => '&#39504;',
		"\xF7\xA4" => '&#39632;',
		"\xF7\xA5" => '&#39705;',
		"\xF7\xA6" => '&#39723;',
		"\xF7\xA7" => '&#39739;',
		"\xF7\xA8" => '&#39766;',
		"\xF7\xA9" => '&#39765;',
		"\xF7\xAA" => '&#40006;',
		"\xF7\xAB" => '&#40008;',
		"\xF7\xAC" => '&#39999;',
		"\xF7\xAD" => '&#40004;',
		"\xF7\xAE" => '&#39993;',
		"\xF7\xAF" => '&#39987;',
		"\xF7\xB0" => '&#40001;',
		"\xF7\xB1" => '&#39996;',
		"\xF7\xB2" => '&#39991;',
		"\xF7\xB3" => '&#39988;',
		"\xF7\xB4" => '&#39986;',
		"\xF7\xB5" => '&#39997;',
		"\xF7\xB6" => '&#39990;',
		"\xF7\xB7" => '&#40411;',
		"\xF7\xB8" => '&#40402;',
		"\xF7\xB9" => '&#40414;',
		"\xF7\xBA" => '&#40410;',
		"\xF7\xBB" => '&#40395;',
		"\xF7\xBC" => '&#40400;',
		"\xF7\xBD" => '&#40412;',
		"\xF7\xBE" => '&#40401;',
		"\xF7\xBF" => '&#40415;',
		"\xF7\xC0" => '&#40425;',
		"\xF7\xC1" => '&#40409;',
		"\xF7\xC2" => '&#40408;',
		"\xF7\xC3" => '&#40406;',
		"\xF7\xC4" => '&#40437;',
		"\xF7\xC5" => '&#40405;',
		"\xF7\xC6" => '&#40413;',
		"\xF7\xC7" => '&#40630;',
		"\xF7\xC8" => '&#40688;',
		"\xF7\xC9" => '&#40757;',
		"\xF7\xCA" => '&#40755;',
		"\xF7\xCB" => '&#40754;',
		"\xF7\xCC" => '&#40770;',
		"\xF7\xCD" => '&#40811;',
		"\xF7\xCE" => '&#40853;',
		"\xF7\xCF" => '&#40866;',
		"\xF7\xD0" => '&#20797;',
		"\xF7\xD1" => '&#21145;',
		"\xF7\xD2" => '&#22760;',
		"\xF7\xD3" => '&#22759;',
		"\xF7\xD4" => '&#22898;',
		"\xF7\xD5" => '&#23373;',
		"\xF7\xD6" => '&#24024;',
		"\xF7\xD7" => '&#34863;',
		"\xF7\xD8" => '&#24399;',
		"\xF7\xD9" => '&#25089;',
		"\xF7\xDA" => '&#25091;',
		"\xF7\xDB" => '&#25092;',
		"\xF7\xDC" => '&#25897;',
		"\xF7\xDD" => '&#25893;',
		"\xF7\xDE" => '&#26006;',
		"\xF7\xDF" => '&#26347;',
		"\xF7\xE0" => '&#27409;',
		"\xF7\xE1" => '&#27410;',
		"\xF7\xE2" => '&#27407;',
		"\xF7\xE3" => '&#27594;',
		"\xF7\xE4" => '&#28763;',
		"\xF7\xE5" => '&#28762;',
		"\xF7\xE6" => '&#29218;',
		"\xF7\xE7" => '&#29570;',
		"\xF7\xE8" => '&#29569;',
		"\xF7\xE9" => '&#29571;',
		"\xF7\xEA" => '&#30320;',
		"\xF7\xEB" => '&#30676;',
		"\xF7\xEC" => '&#31847;',
		"\xF7\xED" => '&#31846;',
		"\xF7\xEE" => '&#32405;',
		"\xF7\xEF" => '&#33388;',
		"\xF7\xF0" => '&#34362;',
		"\xF7\xF1" => '&#34368;',
		"\xF7\xF2" => '&#34361;',
		"\xF7\xF3" => '&#34364;',
		"\xF7\xF4" => '&#34353;',
		"\xF7\xF5" => '&#34363;',
		"\xF7\xF6" => '&#34366;',
		"\xF7\xF7" => '&#34864;',
		"\xF7\xF8" => '&#34866;',
		"\xF7\xF9" => '&#34862;',
		"\xF7\xFA" => '&#34867;',
		"\xF7\xFB" => '&#35190;',
		"\xF7\xFC" => '&#35188;',
		"\xF7\xFD" => '&#35187;',
		"\xF7\xFE" => '&#35326;',
		"\xF8\x40" => '&#35724;',
		"\xF8\x41" => '&#35726;',
		"\xF8\x42" => '&#35723;',
		"\xF8\x43" => '&#35720;',
		"\xF8\x44" => '&#35909;',
		"\xF8\x45" => '&#36121;',
		"\xF8\x46" => '&#36504;',
		"\xF8\x47" => '&#36708;',
		"\xF8\x48" => '&#36707;',
		"\xF8\x49" => '&#37308;',
		"\xF8\x4A" => '&#37986;',
		"\xF8\x4B" => '&#37973;',
		"\xF8\x4C" => '&#37981;',
		"\xF8\x4D" => '&#37975;',
		"\xF8\x4E" => '&#37982;',
		"\xF8\x4F" => '&#38852;',
		"\xF8\x50" => '&#38853;',
		"\xF8\x51" => '&#38912;',
		"\xF8\x52" => '&#39510;',
		"\xF8\x53" => '&#39513;',
		"\xF8\x54" => '&#39710;',
		"\xF8\x55" => '&#39711;',
		"\xF8\x56" => '&#39712;',
		"\xF8\x57" => '&#40018;',
		"\xF8\x58" => '&#40024;',
		"\xF8\x59" => '&#40016;',
		"\xF8\x5A" => '&#40010;',
		"\xF8\x5B" => '&#40013;',
		"\xF8\x5C" => '&#40011;',
		"\xF8\x5D" => '&#40021;',
		"\xF8\x5E" => '&#40025;',
		"\xF8\x5F" => '&#40012;',
		"\xF8\x60" => '&#40014;',
		"\xF8\x61" => '&#40443;',
		"\xF8\x62" => '&#40439;',
		"\xF8\x63" => '&#40431;',
		"\xF8\x64" => '&#40419;',
		"\xF8\x65" => '&#40427;',
		"\xF8\x66" => '&#40440;',
		"\xF8\x67" => '&#40420;',
		"\xF8\x68" => '&#40438;',
		"\xF8\x69" => '&#40417;',
		"\xF8\x6A" => '&#40430;',
		"\xF8\x6B" => '&#40422;',
		"\xF8\x6C" => '&#40434;',
		"\xF8\x6D" => '&#40432;',
		"\xF8\x6E" => '&#40418;',
		"\xF8\x6F" => '&#40428;',
		"\xF8\x70" => '&#40436;',
		"\xF8\x71" => '&#40435;',
		"\xF8\x72" => '&#40424;',
		"\xF8\x73" => '&#40429;',
		"\xF8\x74" => '&#40642;',
		"\xF8\x75" => '&#40656;',
		"\xF8\x76" => '&#40690;',
		"\xF8\x77" => '&#40691;',
		"\xF8\x78" => '&#40710;',
		"\xF8\x79" => '&#40732;',
		"\xF8\x7A" => '&#40760;',
		"\xF8\x7B" => '&#40759;',
		"\xF8\x7C" => '&#40758;',
		"\xF8\x7D" => '&#40771;',
		"\xF8\x7E" => '&#40783;',
		"\xF8\xA1" => '&#40817;',
		"\xF8\xA2" => '&#40816;',
		"\xF8\xA3" => '&#40814;',
		"\xF8\xA4" => '&#40815;',
		"\xF8\xA5" => '&#22227;',
		"\xF8\xA6" => '&#22221;',
		"\xF8\xA7" => '&#23374;',
		"\xF8\xA8" => '&#23661;',
		"\xF8\xA9" => '&#25901;',
		"\xF8\xAA" => '&#26349;',
		"\xF8\xAB" => '&#26350;',
		"\xF8\xAC" => '&#27411;',
		"\xF8\xAD" => '&#28767;',
		"\xF8\xAE" => '&#28769;',
		"\xF8\xAF" => '&#28765;',
		"\xF8\xB0" => '&#28768;',
		"\xF8\xB1" => '&#29219;',
		"\xF8\xB2" => '&#29915;',
		"\xF8\xB3" => '&#29925;',
		"\xF8\xB4" => '&#30677;',
		"\xF8\xB5" => '&#31032;',
		"\xF8\xB6" => '&#31159;',
		"\xF8\xB7" => '&#31158;',
		"\xF8\xB8" => '&#31850;',
		"\xF8\xB9" => '&#32407;',
		"\xF8\xBA" => '&#32649;',
		"\xF8\xBB" => '&#33389;',
		"\xF8\xBC" => '&#34371;',
		"\xF8\xBD" => '&#34872;',
		"\xF8\xBE" => '&#34871;',
		"\xF8\xBF" => '&#34869;',
		"\xF8\xC0" => '&#34891;',
		"\xF8\xC1" => '&#35732;',
		"\xF8\xC2" => '&#35733;',
		"\xF8\xC3" => '&#36510;',
		"\xF8\xC4" => '&#36511;',
		"\xF8\xC5" => '&#36512;',
		"\xF8\xC6" => '&#36509;',
		"\xF8\xC7" => '&#37310;',
		"\xF8\xC8" => '&#37309;',
		"\xF8\xC9" => '&#37314;',
		"\xF8\xCA" => '&#37995;',
		"\xF8\xCB" => '&#37992;',
		"\xF8\xCC" => '&#37993;',
		"\xF8\xCD" => '&#38629;',
		"\xF8\xCE" => '&#38726;',
		"\xF8\xCF" => '&#38723;',
		"\xF8\xD0" => '&#38727;',
		"\xF8\xD1" => '&#38855;',
		"\xF8\xD2" => '&#38885;',
		"\xF8\xD3" => '&#39518;',
		"\xF8\xD4" => '&#39637;',
		"\xF8\xD5" => '&#39769;',
		"\xF8\xD6" => '&#40035;',
		"\xF8\xD7" => '&#40039;',
		"\xF8\xD8" => '&#40038;',
		"\xF8\xD9" => '&#40034;',
		"\xF8\xDA" => '&#40030;',
		"\xF8\xDB" => '&#40032;',
		"\xF8\xDC" => '&#40450;',
		"\xF8\xDD" => '&#40446;',
		"\xF8\xDE" => '&#40455;',
		"\xF8\xDF" => '&#40451;',
		"\xF8\xE0" => '&#40454;',
		"\xF8\xE1" => '&#40453;',
		"\xF8\xE2" => '&#40448;',
		"\xF8\xE3" => '&#40449;',
		"\xF8\xE4" => '&#40457;',
		"\xF8\xE5" => '&#40447;',
		"\xF8\xE6" => '&#40445;',
		"\xF8\xE7" => '&#40452;',
		"\xF8\xE8" => '&#40608;',
		"\xF8\xE9" => '&#40734;',
		"\xF8\xEA" => '&#40774;',
		"\xF8\xEB" => '&#40820;',
		"\xF8\xEC" => '&#40821;',
		"\xF8\xED" => '&#40822;',
		"\xF8\xEE" => '&#22228;',
		"\xF8\xEF" => '&#25902;',
		"\xF8\xF0" => '&#26040;',
		"\xF8\xF1" => '&#27416;',
		"\xF8\xF2" => '&#27417;',
		"\xF8\xF3" => '&#27415;',
		"\xF8\xF4" => '&#27418;',
		"\xF8\xF5" => '&#28770;',
		"\xF8\xF6" => '&#29222;',
		"\xF8\xF7" => '&#29354;',
		"\xF8\xF8" => '&#30680;',
		"\xF8\xF9" => '&#30681;',
		"\xF8\xFA" => '&#31033;',
		"\xF8\xFB" => '&#31849;',
		"\xF8\xFC" => '&#31851;',
		"\xF8\xFD" => '&#31990;',
		"\xF8\xFE" => '&#32410;',
		"\xF9\x40" => '&#32408;',
		"\xF9\x41" => '&#32411;',
		"\xF9\x42" => '&#32409;',
		"\xF9\x43" => '&#33248;',
		"\xF9\x44" => '&#33249;',
		"\xF9\x45" => '&#34374;',
		"\xF9\x46" => '&#34375;',
		"\xF9\x47" => '&#34376;',
		"\xF9\x48" => '&#35193;',
		"\xF9\x49" => '&#35194;',
		"\xF9\x4A" => '&#35196;',
		"\xF9\x4B" => '&#35195;',
		"\xF9\x4C" => '&#35327;',
		"\xF9\x4D" => '&#35736;',
		"\xF9\x4E" => '&#35737;',
		"\xF9\x4F" => '&#36517;',
		"\xF9\x50" => '&#36516;',
		"\xF9\x51" => '&#36515;',
		"\xF9\x52" => '&#37998;',
		"\xF9\x53" => '&#37997;',
		"\xF9\x54" => '&#37999;',
		"\xF9\x55" => '&#38001;',
		"\xF9\x56" => '&#38003;',
		"\xF9\x57" => '&#38729;',
		"\xF9\x58" => '&#39026;',
		"\xF9\x59" => '&#39263;',
		"\xF9\x5A" => '&#40040;',
		"\xF9\x5B" => '&#40046;',
		"\xF9\x5C" => '&#40045;',
		"\xF9\x5D" => '&#40459;',
		"\xF9\x5E" => '&#40461;',
		"\xF9\x5F" => '&#40464;',
		"\xF9\x60" => '&#40463;',
		"\xF9\x61" => '&#40466;',
		"\xF9\x62" => '&#40465;',
		"\xF9\x63" => '&#40609;',
		"\xF9\x64" => '&#40693;',
		"\xF9\x65" => '&#40713;',
		"\xF9\x66" => '&#40775;',
		"\xF9\x67" => '&#40824;',
		"\xF9\x68" => '&#40827;',
		"\xF9\x69" => '&#40826;',
		"\xF9\x6A" => '&#40825;',
		"\xF9\x6B" => '&#22302;',
		"\xF9\x6C" => '&#28774;',
		"\xF9\x6D" => '&#31855;',
		"\xF9\x6E" => '&#34876;',
		"\xF9\x6F" => '&#36274;',
		"\xF9\x70" => '&#36518;',
		"\xF9\x71" => '&#37315;',
		"\xF9\x72" => '&#38004;',
		"\xF9\x73" => '&#38008;',
		"\xF9\x74" => '&#38006;',
		"\xF9\x75" => '&#38005;',
		"\xF9\x76" => '&#39520;',
		"\xF9\x77" => '&#40052;',
		"\xF9\x78" => '&#40051;',
		"\xF9\x79" => '&#40049;',
		"\xF9\x7A" => '&#40053;',
		"\xF9\x7B" => '&#40468;',
		"\xF9\x7C" => '&#40467;',
		"\xF9\x7D" => '&#40694;',
		"\xF9\x7E" => '&#40714;',
		"\xF9\xA1" => '&#40868;',
		"\xF9\xA2" => '&#28776;',
		"\xF9\xA3" => '&#28773;',
		"\xF9\xA4" => '&#31991;',
		"\xF9\xA5" => '&#34410;',
		"\xF9\xA6" => '&#34878;',
		"\xF9\xA7" => '&#34877;',
		"\xF9\xA8" => '&#34879;',
		"\xF9\xA9" => '&#35742;',
		"\xF9\xAA" => '&#35996;',
		"\xF9\xAB" => '&#36521;',
		"\xF9\xAC" => '&#36553;',
		"\xF9\xAD" => '&#38731;',
		"\xF9\xAE" => '&#39027;',
		"\xF9\xAF" => '&#39028;',
		"\xF9\xB0" => '&#39116;',
		"\xF9\xB1" => '&#39265;',
		"\xF9\xB2" => '&#39339;',
		"\xF9\xB3" => '&#39524;',
		"\xF9\xB4" => '&#39526;',
		"\xF9\xB5" => '&#39527;',
		"\xF9\xB6" => '&#39716;',
		"\xF9\xB7" => '&#40469;',
		"\xF9\xB8" => '&#40471;',
		"\xF9\xB9" => '&#40776;',
		"\xF9\xBA" => '&#25095;',
		"\xF9\xBB" => '&#27422;',
		"\xF9\xBC" => '&#29223;',
		"\xF9\xBD" => '&#34380;',
		"\xF9\xBE" => '&#36520;',
		"\xF9\xBF" => '&#38018;',
		"\xF9\xC0" => '&#38016;',
		"\xF9\xC1" => '&#38017;',
		"\xF9\xC2" => '&#39529;',
		"\xF9\xC3" => '&#39528;',
		"\xF9\xC4" => '&#39726;',
		"\xF9\xC5" => '&#40473;',
		"\xF9\xC6" => '&#29225;',
		"\xF9\xC7" => '&#34379;',
		"\xF9\xC8" => '&#35743;',
		"\xF9\xC9" => '&#38019;',
		"\xF9\xCA" => '&#40057;',
		"\xF9\xCB" => '&#40631;',
		"\xF9\xCC" => '&#30325;',
		"\xF9\xCD" => '&#39531;',
		"\xF9\xCE" => '&#40058;',
		"\xF9\xCF" => '&#40477;',
		"\xF9\xD0" => '&#28777;',
		"\xF9\xD1" => '&#28778;',
		"\xF9\xD2" => '&#40612;',
		"\xF9\xD3" => '&#40830;',
		"\xF9\xD4" => '&#40777;',
		"\xF9\xD5" => '&#40856;'
);

    $string = str_replace(array_keys($big5tounicode), array_values($big5tounicode), $string);

    return $string;
}

?>