<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 151405 -->
<!-- French Translation by Vincent Deffontaines, review by alain B -->

<!--
 Copyright 2005 The Apache Software Foundation or its licensors, as
 applicable.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="custom-error.xml.meta">

  <title>Personnalisation des Messages d'Erreurs</title>

  <summary>
    <p>Il est possible  un administrateur Apache de configurer les rponses
    d'Apache dans les cas o des erreurs ou problmes se prsentent.</p>

    <p>Des rponses paramtrables peuvent tre dfinies pour tre actives au
    cas o le serveur dtecterait une erreur ou un problme.</p>

    <p>Quand un script plante et gnre une rponse "500 Server Error", sa
    rponse peut tre remplace par un message plus convivial, ou par une
    redirection vers une autre URL (locale, ou sur un autre serveur).</p>
  </summary>

  <section id="behavior">
    <title>Fonctionnement</title>

    <section>
      <title>Fonctionnement antrieur</title>

      <p>NCSA httpd 1.3 renvoyait un message d'erreur insipide qui ne
      prsentait le plus souvent aucun sens ni  l'utilisateur, ni 
      dans les journaux d'enregistrement sur des symptmes causant 
      le plantage.</p>
    </section>

    <section>
      <title>Fonctionnement des versions plus rcentes</title>

      <p>Le serveur peut tre paramtr pour&nbsp;:</p>

      <ol>
        <li>Afficher un autre message que celui cod dans NCSA, ou bien</li>

        <li>procder  une redirection sur une URL locale, ou bien</li>

        <li>procder  une redirection vers un autre serveur.</li>
      </ol>

      <p>La redirection vers une autre URL peut tre utile, mais seulement 
      si des informations peuvent tre envoyes pour expliquer/enregistrer 
      l'erreur ou le problme plus clairement.</p>

      <p>Pour y parvenir, Apache dfinit de nouvelles variables
      d'environnement CGI&nbsp;:</p>

      <example>
        REDIRECT_HTTP_ACCEPT=*/*, image/gif, image/x-xbitmap, 
            image/jpeg<br />
        REDIRECT_HTTP_USER_AGENT=Mozilla/1.1b2 (X11; I; HP-UX A.09.05 
            9000/712)<br />
        REDIRECT_PATH=.:/bin:/usr/local/bin:/etc<br />
        REDIRECT_QUERY_STRING=<br />
        REDIRECT_REMOTE_ADDR=121.345.78.123<br />
        REDIRECT_REMOTE_HOST=ooh.ahhh.com<br />
        REDIRECT_SERVER_NAME=crash.bang.edu<br />
        REDIRECT_SERVER_PORT=80<br />
        REDIRECT_SERVER_SOFTWARE=Apache/0.8.15<br />
        REDIRECT_URL=/cgi-bin/buggy.pl
      </example>

      <p>Notez que le prfixe <code>REDIRECT_</code> est prsent pour toutes
      ces variables d'environnement.</p>

      <p>Au minimum, <code>REDIRECT_URL</code> et
      <code>REDIRECT_QUERY_STRING</code> seront passes  la nouvelle 
      URL (en supposant qu'il s'agisse d'un script CGI ou d'un 
      include CGI). Les autres variables ne sont dfinies que si 
      elles existaient avant l'apparition du problme ou de l'erreur. 
      <strong>Aucune</strong> de ces variables ne sera
      dfinie si votre directive <directive module="core">ErrorDocument</directive>
      entrane une redirection vers un serveur <em>externe</em>&nbsp;; 
      tout ce qui commence par <code>http:</code> est considr comme 
      une redirection externe, y compris si cela pointe vers le 
      serveur local.</p>
    </section>
  </section>

  <section id="configuration">
    <title>Configuration</title>

    <p>Il est possible d'utiliser la directive 
    <directive module="core">ErrorDocument</directive> dans les fichiers
    .htaccess si <directive module="core">AllowOverride</directive> est
    paramtre pour le permettre.</p>

    <p>Voici quelques exemples&nbsp;:</p>

    <example>
      ErrorDocument 500 /cgi-bin/crash-recover <br />
      ErrorDocument 500 "Sorry, our script crashed. Oh dear" <br />
      ErrorDocument 500 http://xxx/ <br />
      ErrorDocument 404 /Lame_excuses/not_found.html <br />
      ErrorDocument 401 /Subscription/how_to_subscribe.html
    </example>

    <p>La syntaxe  utiliser est&nbsp;:</p>

    <example>
      ErrorDocument &lt;code--3-chiffres&gt; &lt;action&gt;
    </example>

    <p>o l'action peut dsigner&nbsp;:</p>

    <ol>
      <li>Un message  afficher. Le message doit tre prcd par 
      des guillemets ("). Tout ce qui suit ces guillemets est affich. 
      <em>Notez que le prfixe (") n'est pas affich.</em></li>

      <li>Une URL vers un serveur externe, vers lequel la redirection 
      sera effectue.</li>

      <li>Une URL locale vers laquelle la redirection sera effectue.</li>
    </ol>
  </section>

  <section id="custom">
    <title>Messages d'Erreurs Personnaliss et Redirections</title>

    <p>Le fonctionnement d'Apache vis--vis des redirections a t 
    modifi afin que les nouvelles variables d'environnement soient 
    disponibles pour un script ou un server-include.</p>

    <section>
      <title>Fonctionnement antrieur</title>

      <p>Les variables CGI standard taient passes au script sur 
      lequel pointe la redirection. Aucune indication sur la 
      provenance de la redirection n'tait fournie.</p>
    </section>

    <section>
      <title>Fonctionnement pour les nouvelles versions</title>

      <p>Une srie de nouvelles variables d'environnement est 
      initialise pour tre passe au script sur lequel pointe 
      la redirection. Chacune de ces variables est munie du prfixe 
      <code>REDIRECT_</code>. Les variables d'environnement 
      <code>REDIRECT_</code> sont cres  partir des variables 
      d'environnement "normales", telles qu'existant avant la 
      redirection, mais simplement renommes au moyen du prfixe 
      <code>REDIRECT_</code>&nbsp;; ainsi par exemple <code>HTTP_USER_AGENT</code> 
      devient <code>REDIRECT_HTTP_USER_AGENT</code>. En plus de ces 
      nouvelles variables, Apache dfinit <code>REDIRECT_URL</code> 
      et <code>REDIRECT_status</code> pour aider le script  
      comprendre d'o il a t appel. L'URL d'origine et l'URL 
      redirige sont toutes deux ajoutes dans le journal "access".</p>
      
      <p>Si <code>ErrorDocument</code> prcise une redirection 
      locale vers un script CGI, ce script devrait inclure un 
      champ  "<code>Status:</code>" dans son en-tte de transmission 
      afin d'assurer que le client reoive bien le code d'erreur et 
      puisse comprendre ce qui l'a caus. Par exemple, un script 
      Perl ErrorDocument pourrait inclure quelque chose comme&nbsp;:</p>

      <example>
        ... <br />
        print  "Content-type: text/html\n"; <br />
        printf "Status: %s Condition Intercepted\n", $ENV{"REDIRECT_STATUS"}; <br />
        ...
      </example>

      <p>Un script ddi  la gestion d'une erreur donne,
      telle que <code>404&nbsp;Not&nbsp;Found</code>, peut bien sr
      utiliser le code spcifique d'erreur et le texte associ.</p>

      <p>Notez que le script <em>doit</em> envoyer l'en-tte
      <code>Status:</code> approprie (comme par exemple
      <code>302&nbsp;Found</code>), si la rponse contient un en-tte
      <code>Location:</code> (pour gnrer la redirection cot client). 
      Sans cet en-tte <code>Status:</code>, <code>Location:</code> n'aura 
      pas d'effet.</p>
    </section>
  </section>
</manualpage>
