/* Generated by re2c 0.5 on Tue Aug 14 00:26:32 2001 */
#line 1 "/home/sas/fos/php4/ext/ircg/ircg_scanner.re"
/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2001 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Sascha Schumann <sascha@schumann.cx>                        |
   +----------------------------------------------------------------------+
 */

/* $Id: ircg_scanner.c,v 1.1.1.2 2001/12/14 22:12:30 zarzycki Exp $ */

#include <ext/standard/php_smart_str.h>
#include <stdio.h>
#include <string.h>

static const char *color_list[] = {
    "white",
    "black",
    "blue",
    "green",
    "red",
    "brown",
    "purple",
    "orange",
    "yellow",
    "lightgreen",
    "teal",
    "lightcyan",
    "lightblue",
    "pink",
    "gray",
    "lightgrey"
};


enum {
	STATE_PLAIN,
	STATE_URL,
	STATE_COLOR_FG,
	STATE_COLOR_COMMA,
	STATE_COLOR_BG
};

typedef struct {
	int bg_code;
	int fg_code;
	int font_tag_open;
	int bold_tag_open;
	int underline_tag_open;
	int italic_tag_open;
	
	smart_str scheme;
	smart_str *result;
} ircg_msg_scanner;

#line 78


#define YYFILL(n) do { } while (0)
#define YYCTYPE unsigned char
#define YYCURSOR xp
#define YYLIMIT end
#define YYMARKER q

#define STD_PARA ircg_msg_scanner *ctx, const char *start, const char *YYCURSOR
#define STD_ARGS ctx, start, YYCURSOR

static inline void passthru(STD_PARA)
{
	smart_str_appendl_ex(ctx->result, start, YYCURSOR - start, 1);
}

static inline void handle_scheme(STD_PARA)
{
	ctx->scheme.len = 0;
	smart_str_appendl_ex(&ctx->scheme, start, YYCURSOR - start, 1);
	smart_str_0(&ctx->scheme);
}

static inline void handle_url(STD_PARA)
{
	smart_str_appends_ex(ctx->result, "<a target=blank href=\"", 1);
	smart_str_append_ex(ctx->result, &ctx->scheme, 1);
	smart_str_appendl_ex(ctx->result, start, YYCURSOR - start, 1);
	smart_str_appends_ex(ctx->result, "\">", 1);
	smart_str_append_ex(ctx->result, &ctx->scheme, 1);
	smart_str_appendl_ex(ctx->result, start, YYCURSOR - start, 1);
	smart_str_appends_ex(ctx->result, "</a>", 1);
}

static void handle_color_digit(STD_PARA, int mode)
{
	int len;
	int nr;

	len = YYCURSOR - start;
	switch (len) {
		case 2:
			nr = (start[0] - '0') * 10 + (start[1] - '0');
			break;
		case 1:
			nr = start[0] - '0';
			break;
	}
	
	switch (mode) {
		case 0: ctx->fg_code = nr; break;
		case 1: ctx->bg_code = nr; break;
	}
}

#define IS_VALID_CODE(n) (n >= 0 && n <= 15)

static void finish_color_stuff(STD_PARA)
{
	if (ctx->font_tag_open) {
		smart_str_appends_ex(ctx->result, "</font>", 1);
		ctx->font_tag_open = 0;
	}
}

static void handle_bold(STD_PARA, int final)
{
	switch (ctx->bold_tag_open) {
	case 0:
		if (!final) smart_str_appends_ex(ctx->result, "<b>", 1);
		break;
	case 1:
		smart_str_appends_ex(ctx->result, "</b>", 1);
		break;
	}

	ctx->bold_tag_open = 1 - ctx->bold_tag_open;
}

static void handle_underline(STD_PARA, int final)
{
	switch (ctx->underline_tag_open) {
	case 0:
		if (!final) smart_str_appends_ex(ctx->result, "<u>", 1);
		break;
	case 1:
		smart_str_appends_ex(ctx->result, "</u>", 1);
		break;
	}

	ctx->underline_tag_open = 1 - ctx->underline_tag_open;
}

static void handle_italic(STD_PARA, int final)
{
	switch (ctx->italic_tag_open) {
	case 0:
		if (!final) smart_str_appends_ex(ctx->result, "<i>", 1);
		break;
	case 1:
		smart_str_appends_ex(ctx->result, "</i>", 1);
		break;
	}

	ctx->italic_tag_open = 1 - ctx->italic_tag_open;
}

static void commit_color_stuff(STD_PARA)
{
	finish_color_stuff(STD_ARGS);

	if (IS_VALID_CODE(ctx->fg_code)) {
		smart_str_appends_ex(ctx->result, "<font color=\"", 1);
		smart_str_appends_ex(ctx->result, color_list[ctx->fg_code], 1);
		smart_str_appends_ex(ctx->result, "\">", 1);
		ctx->font_tag_open = 1;
	}
}

static void add_entity(STD_PARA, const char *entity)
{
	smart_str_appends_ex(ctx->result, entity, 1);
}

void ircg_mirc_color(const char *msg, smart_str *result, size_t msg_len, int auto_links, int gen_br) 
{
	const char *end, *xp, *q, *start;
	ircg_msg_scanner mctx, *ctx = &mctx;

	mctx.result = result;
	mctx.scheme.c = NULL;
	mctx.italic_tag_open = mctx.font_tag_open = mctx.bold_tag_open = mctx.underline_tag_open = 0;
	
	if (msg_len == -1)
		msg_len = strlen(msg);
	end = msg + msg_len;
	xp = msg;
	

state_plain:
	if (xp >= end) goto stop;
	start = YYCURSOR;
{
	YYCTYPE yych;
	unsigned int yyaccept;
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	goto yy0;
yy1:	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if(yych <= '%'){
		if(yych <= '\025'){
			if(yych <= '\001'){
				if(yych >= '\001')	goto yy21;
			} else {
				if(yych <= '\002')	goto yy15;
				if(yych <= '\003')	goto yy5;
				goto yy21;
			}
		} else {
			if(yych <= '\035'){
				if(yych <= '\026')	goto yy19;
				goto yy21;
			} else {
				if(yych <= '\036')	goto yy13;
				if(yych <= '\037')	goto yy17;
				goto yy21;
			}
		}
	} else {
		if(yych <= '>'){
			if(yych <= ';'){
				if(yych <= '&')	goto yy11;
				goto yy21;
			} else {
				if(yych <= '<')	goto yy7;
				if(yych <= '=')	goto yy21;
				goto yy9;
			}
		} else {
			if(yych <= 'Z'){
				if(yych <= '@')	goto yy21;
				goto yy3;
			} else {
				if(yych <= '`')	goto yy21;
				if(yych <= 'z')	goto yy3;
				goto yy21;
			}
		}
	}
yy2:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy4;
	}
yy3:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '/')	goto yy4;
		if(yych <= ':')	goto yy23;
	} else {
		if(yych <= 'Z')	goto yy23;
		if(yych <= '`')	goto yy4;
		if(yych <= 'z')	goto yy23;
	}
yy4:
#line 230
	{ passthru(STD_ARGS); goto state_plain; }
yy5:	yych = *++YYCURSOR;
yy6:
#line 222
	{ mctx.fg_code = mctx.bg_code = -1; goto state_color_fg; }
yy7:	yych = *++YYCURSOR;
yy8:
#line 223
	{ add_entity(STD_ARGS, "&lt;"); goto state_plain; }
yy9:	yych = *++YYCURSOR;
yy10:
#line 224
	{ add_entity(STD_ARGS, "&gt;"); goto state_plain; }
yy11:	yych = *++YYCURSOR;
yy12:
#line 225
	{ add_entity(STD_ARGS, "&amp;"); goto state_plain; }
yy13:	yych = *++YYCURSOR;
yy14:
#line 226
	{ if (gen_br) smart_str_appendl_ex(ctx->result, "<br>", 4, 1); goto state_plain; }
yy15:	yych = *++YYCURSOR;
yy16:
#line 227
	{ handle_bold(STD_ARGS, 0); goto state_plain; }
yy17:	yych = *++YYCURSOR;
yy18:
#line 228
	{ handle_underline(STD_ARGS, 0); goto state_plain; }
yy19:	yych = *++YYCURSOR;
yy20:
#line 229
	{ handle_italic(STD_ARGS, 0); goto state_plain; }
yy21:	yych = *++YYCURSOR;
	goto yy4;
yy22:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy23:	if(yybm[0+yych] & 128)	goto yy22;
	if(yych != ':')	goto yy2;
yy24:	yych = *++YYCURSOR;
	if(yych != '/')	goto yy2;
yy25:	yych = *++YYCURSOR;
	if(yych != '/')	goto yy2;
yy26:	yych = *++YYCURSOR;
yy27:
#line 221
	{ if (auto_links) { handle_scheme(STD_ARGS); goto state_url; } else { passthru(STD_ARGS); goto state_plain; } }
}
#line 231


state_url:		
	start = YYCURSOR;
{
	YYCTYPE yych;
	unsigned int yyaccept;
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0, 128,   0, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128,   0, 128,   0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0, 128, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0, 128,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	goto yy28;
yy29:	++YYCURSOR;
yy28:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '>'){
		if(yych <= '"'){
			if(yych != '!')	goto yy32;
		} else {
			if(yych == '<')	goto yy32;
			if(yych >= '>')	goto yy32;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy30;
			if(yych != '_')	goto yy32;
		} else {
			if(yych <= 'z')	goto yy30;
			if(yych != '~')	goto yy32;
		}
	}
yy30:	yych = *++YYCURSOR;
	goto yy35;
yy31:
#line 236
	{ handle_url(STD_ARGS); goto state_plain; }
yy32:	yych = *++YYCURSOR;
yy33:
#line 237
	{ passthru(STD_ARGS); goto state_plain; }
yy34:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy35:	if(yybm[0+yych] & 128)	goto yy34;
	goto yy31;
}
#line 238



state_color_fg:		
	start = YYCURSOR;
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy36;
yy37:	++YYCURSOR;
yy36:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '/')	goto yy40;
	if(yych >= ':')	goto yy40;
yy38:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy39;
	if(yych <= '9')	goto yy42;
yy39:
#line 244
	{ handle_color_digit(STD_ARGS, 0); goto state_color_comma; }
yy40:	yych = *++YYCURSOR;
yy41:
#line 245
	{ finish_color_stuff(STD_ARGS); passthru(STD_ARGS); goto state_plain; }
yy42:	yych = *++YYCURSOR;
	goto yy39;
}
#line 246


		
state_color_comma:	
	start = YYCURSOR;
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy43;
yy44:	++YYCURSOR;
yy43:
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych != ',')	goto yy47;
yy45:	yych = *++YYCURSOR;
yy46:
#line 252
	{ goto state_color_bg; }
yy47:	yych = *++YYCURSOR;
yy48:
#line 253
	{ YYCURSOR--; commit_color_stuff(STD_ARGS); goto state_plain; }
}
#line 254



state_color_bg:
	start = YYCURSOR;
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy49;
yy50:	++YYCURSOR;
yy49:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
yy51:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy52;
	if(yych <= '9')	goto yy55;
yy52:
#line 260
	{ handle_color_digit(STD_ARGS, 1); commit_color_stuff(STD_ARGS); goto state_plain; }
yy53:	yych = *++YYCURSOR;
yy54:
#line 261
	{ commit_color_stuff(STD_ARGS); goto state_plain; }
yy55:	yych = *++YYCURSOR;
	goto yy52;
}
#line 262


stop:
	smart_str_free_ex(&ctx->scheme, 1);

	finish_color_stuff(STD_ARGS);
	handle_bold(STD_ARGS, 1);
	handle_underline(STD_ARGS, 1);
	handle_italic(STD_ARGS, 1);
}
