/**
 * Contains:   Inline administration plug-in for blojsom.
 * Written by: John Anderson (for addtl writers check CVS comments).
 * Copyright:  © 2004 Apple Computer, Inc., all rights reserved.
 * Note:       When editing this file set PB to "Editor uses tabs/width=4".
 *
 * $Id: EscapeTagsPlugin.java,v 1.1 2004/07/09 16:52:28 johnan Exp $
 */ 
package com.apple.blojsom.plugin.escapetags;

import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * Escape Tags plug-in
 *
 * @author John Anderson
 * @version $Id: EscapeTagsPlugin.java,v 1.1 2004/07/09 16:52:28 johnan Exp $
 */

public class EscapeTagsPlugin implements BlojsomPlugin {

	// constants
	private static final String[] ALLOWED_TAGS = {
		"a", "b", "blockquote", "br", "code", "dd", "dl", "div", "em", "h1", "h2", "h3",
		"h4", "h5", "h6", "i", "img", "ol", "li", "p", "pre", "span", "strong", "sub", "sup",
		"table", "td", "th", "tr", "u", "ul"
	};
	
	private static final String VALID_TAG_SEARCH = "<(/*)([Aa]|[Bb]|[Bb][Ll][Oo][Cc][Kk][Qq][Uu][Oo][Tt][Ee]|[Bb][Rr]|[Cc][Oo][Dd][Ee]|[Dd][Dd]|[Dd][Ll]|[Dd][Ii][Vv]|[Ee][Mm]|[Hh]1|[Hh]2|[Hh]3|[Hh]4|[Hh]5|[Hh]6|[Ii]|[Ii][Mm][Gg]|[Oo][Ll]|[Ll][Ii]|[Pp]|[Pp][Rr][Ee]|[Ss][Pp][Aa][Nn]|[Ss][Tt][Rr][Oo][Nn][Gg]|[Ss][Uu][Bb]|[Ss][Uu][Pp]|[Tt][Aa][Bb][Ll][Ee]|[Tt][Dd]|[Tt][Hh]|[Tt][Rr]|[Uu]|[Uu][Ll])( [^>]+>|>)";
	private static final String VALID_TAG_REPLACE = "«$1$2$3»";
	private static final String EXTRA_BRACKET_SEARCH = ">»";
	private static final String EXTRA_BRACKET_REPLACE = "»";
	private static final String REMAINING_LEFTBRACKET_SEARCH = "<";
	private static final String REMAINING_LEFTBRACKET_REPLACE = "&lt;";
	private static final String REMAINING_RIGHTBRACKET_SEARCH = ">";
	private static final String REMAINING_RIGHTBRACKET_REPLACE = "&gt;";
	private static final String LEFT_CHEVRON_SEARCH = "«";
	private static final String LEFT_CHEVRON_REPLACE = "<";
	private static final String RIGHT_CHEVRON_SEARCH = "»";
	private static final String RIGHT_CHEVRON_REPLACE = ">";
	
    /**
     * Default constructor.
     */
    public EscapeTagsPlugin() {
    }
	
    /**
     * Initialize this plugin. This method only called when the plugin is instantiated.
     *
     * @param servletConfig Servlet config object for the plugin to retrieve any initialization parameters
     * @param blojsomConfiguration {@link org.blojsom.blog.BlojsomConfiguration} information
     * @throws BlojsomPluginException If there is an error initializing the plugin
     */
    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    /**
     * Process the blog entries
     *
     * @param httpServletRequest Request
     * @param httpServletResponse Response
     * @param user {@link BlogUser} instance
     * @param context Context
     * @param entries Blog entries retrieved for the particular request
     * @return Modified set of blog entries
     * @throws org.blojsom.plugin.BlojsomPluginException If there is an error processing the blog entries
     */
    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
		String currentEntryDescription;
		
        for (int i = 0; i < entries.length; i++) {
            BlogEntry entry = entries[i];
			currentEntryDescription = entry.getDescription();
			
			// first, replace the valid tags with «tag>»
			currentEntryDescription = currentEntryDescription.replaceAll(VALID_TAG_SEARCH, VALID_TAG_REPLACE);
			
			// now replace «tag>» with «tag» (easier to do it afterward)
			currentEntryDescription = currentEntryDescription.replaceAll(EXTRA_BRACKET_SEARCH, EXTRA_BRACKET_REPLACE);
			
			// now eradicate any remaining < and > symbols...
			currentEntryDescription = currentEntryDescription.replaceAll(REMAINING_LEFTBRACKET_SEARCH, REMAINING_LEFTBRACKET_REPLACE);
			currentEntryDescription = currentEntryDescription.replaceAll(REMAINING_RIGHTBRACKET_SEARCH, REMAINING_RIGHTBRACKET_REPLACE);
			
			// and turn the tags back to normal brackets
			currentEntryDescription = currentEntryDescription.replaceAll(LEFT_CHEVRON_SEARCH, LEFT_CHEVRON_REPLACE);
			currentEntryDescription = currentEntryDescription.replaceAll(RIGHT_CHEVRON_SEARCH, RIGHT_CHEVRON_REPLACE);

            entry.setDescription(currentEntryDescription);
        }
		
		return entries;
	}
	
    /**
     * Perform any cleanup for the plugin. Called after {@link #process}.
     *
     * @throws org.blojsom.plugin.BlojsomPluginException If there is an error performing cleanup for this plugin
     */
    public void cleanup() throws BlojsomPluginException {
    }

    /**
     * Called when BlojsomServlet is taken out of service
     *
     * @throws org.blojsom.plugin.BlojsomPluginException If there is an error in finalizing this plugin
     */
    public void destroy() throws BlojsomPluginException {
    }
}
