.\"
.\" "$Id: backend.man,v 1.1.1.8 2003/04/11 21:07:46 jlovell Exp $"
.\"
.\"   backend man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2003 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3111 USA
.\"
.\"       Voice: (301) 373-9603
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH backend 1 "Common UNIX Printing System" "22 June 2000" "Easy Software Products"
.SH NAME
backend \- cups backend transmission interfaces
.SH SYNOPSIS
.B backend
job user title num-copies options [
.I filename
]
.SH DESCRIPTION
The CUPS backend interface provides a standard method for sending document
files to different physical interfaces.
.LP
Backends must be capable of reading from a filename on the command-line
or from the standard input, copying the standard input to a temporary file
if required by the physical interface.
.LP
The command name (argv[0]) is set to the device URI of the destination printer.
.SH ENVIRONMENT VARIABLES
The following environment variables are defined by the CUPS server when
executing the backend:
.TP 5
CHARSET
.br
The default text character set (typically us-ascii or iso-8859-1).
.TP 5
CLASS
.br
When a job is submitted to a printer class, contains the name of
the destination printer class. Otherwise this environment
variable will not be set.
.TP 5
CONTENT_TYPE
.br
The MIME type associated with the file (e.g. application/postscript).
.TP 5
CUPS_DATADIR
.br
The directory where data files can be found.
.TP 5
CUPS_SERVERROOT
.br
The root directory of the server.
.TP 5
DEVICE_URI
.br
The device-uri associated with the printer; this is provided for shell
scripts which may not be able to get the passed argv[0] string.
.TP 5
LANG
.br
The default language locale (typically C or en).
.TP 5
PATH
.br
The standard execution path for external programs that may be run by
the backend.
.TP 5
PPD
.br
The full pathname of the PostScript Printer Description (PPD) file for
this printer.
.TP 5
PRINTER
.br
The name of the printer.
.TP 5
RIP_CACHE
.br
The recommended amount of memory to use for Raster Image Processors (RIPs).
.TP 5
SOFTWARE
.br
The name and version number of the server (typically CUPS/1.1).
.TP 5
TZ
.br
The timezone of the server.
.TP 5
USER
.br
The user executing the backend, typically root; consult the cupsd.conf file for
the current setting.
.SH SEE ALSO
cupsd(8), filter(1)
CUPS Interface Design Description,
CUPS Software Administrators Manual,
CUPS Software Programmers Manual,
http://localhost:631/documentation.html
.SH COPYRIGHT
Copyright 1993-2003 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: backend.man,v 1.1.1.8 2003/04/11 21:07:46 jlovell Exp $".
.\"
