.\"
.\" "$Id: cupstestppd.man,v 1.1.1.3 2003/04/29 00:15:16 jlovell Exp $"
.\"
.\"   cupstestppd man page for the Common UNIX Printing System (CUPS).
.\"   Based on cvs revision 1.4
.\"
.\"   Copyright 1997-2003 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3111 USA
.\"
.\"       Voice: (301) 373-9603
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH cupstestppd 1 "Common UNIX Printing System" "14 Fvrier 2003" "Easy Software Products"
.SH NOM
cupstestppd \- Teste la conformit des fichiers PPD
.SH SYNOPSIS
.B cupstestppd
[ -q ] [ -v[v] ] nom_fichier.ppd[.gz] [ ... nom_fichierN.ppd[.gz] ]
.br
.B cupstestppd
[ -v[v] ] -
.SH DESCRIPTION
\fIcupstestppd\fR teste la conformit des fichiers PPD envers la
spcification de format de fichier dicte par Adobe, dans sa version
4.3. Cette commande peut galement tre utilise pour voir la
liste des options reconnues et des polices disponibles d'un
fichier PPD. Toutes les sorties sont effectues sur la sortie standard.
.LP
Le premier mode d'appel de \fIcupstestppd\fR ncessite la prsence
d'un ou plusieurs fichiers PPD dans la ligne de commandes. Le second
mode d'appel affiche les caractristiques des fichiers PPD fournis sur
l'entre standard.
.LP
L'option \fB-q\fR indique qu'aucune information ne doit tre affiche
 l'cran.
.LP
L'option \fI-v\fR indique qu'il faut afficher toutes les informations d'un fichier
PPD  la place du statut PASS/FAILED/ERROR (conforme/non conforme/erreur).
.LP
L'option \fI-vv\fR indique qu'il faut afficher toutes les informations d'un fichier
PPD en plus du rsultat des tests de conformit.
.LP
Les options \fB-q\fR, \fI-v\fR et \fI-vv\fR sont mutuellement exclusives.
.SH CODE DE RETOUR
\fIcupstestppd\fR renvoie 0 en cas de russite aux tests et une valeur diffrente de 0
en cas d'chec. Les codes d'erreur sont les suivants\ :
.TP 5
1
.br
Arguments de la ligne de commandes incorrects ou fichier PPD non trouv.
.TP 5
2
.br
Impossible d'ouvrir ou de lire le fichier PPD.
.TP 5
3
.br
Le fichier PPD contient des erreurs de format ne pouvant tre ignores.
.TP 5
4
.br
Le fichier PPD n'est pas conforme  la spcification Adobe.
.SH EXEMPLES
La commande suivante teste tous les fichiers PPD du rpertoire courant, et
affiche le nom de tous les fichiers non conformes\ :
.nf

    find . -name \\*.ppd \\! -exec cupstestppd -q '{}' \\; print

.fi
La commande suivante teste tous les fichiers PPD du rpertoire courant, et
affiche les rsultats dtailles des fichiers non conformes\ :
.nf

    find . -name \\*.ppd \\! -exec cupstestppd -q '{}' \\; \\
        -exec cupstestppd -v '{}' \\;

.fi
.SH VOIR AUSSI
CUPS Software Administrators Manual,
CUPS Software Programmers Manual,
http://localhost:631/documentation.html,
Spcification du format de fichier Adobe Postscript Printer, version 4.3
.SH COPYRIGHT
Copyright 1993-2003 Easy Software Products, All Rights Reserved.
.SH TRADUCTION
Gilles QUERRET <gilles.querret@nerim.net>
.\"
.\" End of "$Id: cupstestppd.man,v 1.1.1.3 2003/04/29 00:15:16 jlovell Exp $".
.\"
