;; Scheduling description for z900 (cpu 2064).
;;   Copyright (C) 2003 Free Software Foundation, Inc.
;;   Contributed by Hartmut Penner (hpenner@de.ibm.com) and
;;                  Ulrich Weigand (uweigand@de.ibm.com).

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 2, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the Free
;; Software Foundation, 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;
;; References:
;;   The microarchitecture of the IBM eServer z900 processor. 
;;   E.M. Schwarz et al.
;;   IBM Journal of Research and Development Vol. 46 No 4/5, 2002.
;; 
;;            z900 (cpu 2064) pipeline
;;     
;;                 dec
;;              --> | <---
;;  LA bypass  |  agen    |
;;             |    |     | 
;;              --- c1    |  Load bypass
;;                  |     | 
;;                  c2----
;;                  |
;;                  e1 
;;                  | 
;;                  wr

;; This scheduler description is also used for the g5 and g6.

(define_automaton "z_ipu")
(define_cpu_unit "z_e1"   "z_ipu")
(define_cpu_unit "z_wr"   "z_ipu")


(define_insn_reservation "z_la" 1 
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "la"))
  "z_e1,z_wr")

(define_insn_reservation "z_larl" 1 
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "larl"))
  "z_e1,z_wr")

(define_insn_reservation "z_load" 1
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "load"))
  "z_e1,z_wr")

(define_insn_reservation "z_store" 1
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "store"))
  "z_e1,z_wr")

(define_insn_reservation "z_call" 5
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "jsr"))
  "z_e1*5,z_wr")

(define_insn_reservation "z_o2" 2
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "o2"))
  "z_e1*2,z_wr")

(define_insn_reservation "z_o3" 3
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "type" "o3"))
  "z_e1*3,z_wr")

;
; Insn still not mentioned are check for
; the usage of the agen unit 
;

(define_insn_reservation "z_int" 1
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "atype" "reg"))
  "z_e1,z_wr")

(define_insn_reservation "z_agen" 1
  (and (eq_attr "cpu" "z900,g5,g6")
       (eq_attr "atype" "agen"))
  "z_e1,z_wr")


;;
;; s390_agen_dep_p returns 1, if a register is set in the 
;; first insn and used in the dependent insn to form a address.
;;

;;
;; If an instruction uses a register to address memory, it needs
;; to be set 5 cycles in advance.
;; 

(define_bypass 5 "z_int,z_agen" 
	       "z_agen,z_la,z_call,z_load,z_store" "s390_agen_dep_p")

;;
;; A load type instruction uses a bypass to feed the result back	
;; to the address generation pipeline stage. 
;;

(define_bypass 3 "z_load"    
	         "z_agen,z_la,z_call,z_load,z_store" "s390_agen_dep_p")

;;
;; A load address type instruction uses a bypass to feed the 
;; result back to the address generation pipeline stage. 
;;

(define_bypass 2 "z_larl,z_la" 
	         "z_agen,z_la,z_call,z_load,z_store" "s390_agen_dep_p")





